/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.modeler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.wizards.reports.CLIReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReports;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfigurationsPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplatesPersistence;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.ToStringComparator;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.AbstractModelerGenerator;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.Messages;

public class ModelerReportGenerator
extends AbstractModelerGenerator {
    private String reportType = null;
    private String reportFileName = null;
    private String outputPath = null;
    private String reportTitle = null;
    private String standardReportTemplate = null;
    private String customReportTemplate = null;
    private String reportConfTemplate = null;
    private String reportCompanyName = null;
    private boolean createDiagram = true;
    private ToStringComparator toStringComparator = new ToStringComparator();

    public ModelerReportGenerator(ScriptRunnerContext ctx, Map<String, String> arguments) {
        super(ctx, arguments);
        this.reportType = arguments.get("-TYPE");
        this.reportFileName = arguments.get("-FILENAME");
        this.outputPath = arguments.get("-OUTPUTPATH");
        this.reportTitle = arguments.get("-TITLE");
        this.standardReportTemplate = arguments.get("-STANDARDTEMPLATE");
        this.customReportTemplate = arguments.get("-CUSTOMTEMPLATE");
        this.reportConfTemplate = arguments.get("-REPORTCONFTEMPLATE");
        this.reportCompanyName = arguments.get("-COMPANYNAME");
        File op = new File(this.outputPath);
        if (!op.exists()) {
            try {
                op.mkdirs();
            }
            catch (Exception e) {
                ctx.getErrWriter().write(e.getLocalizedMessage());
            }
        }
    }

    public void generateReport() {
        HashMap<String, Object> extraParams = new HashMap<String, Object>();
        extraParams.put("out_format", "HTML");
        extraParams.put("reports_path", this.outputPath);
        extraParams.put("reportCustomFilenName", this.reportFileName);
        extraParams.put("cssFiles", "css/osddm_main.css css/osddm_tree.css");
        extraParams.put("show", false);
        extraParams.put("pattern", "");
        if ("EntitiesAndViews".equalsIgnoreCase(this.reportType) || "Entities".equalsIgnoreCase(this.reportType) || "EntityViews".equalsIgnoreCase(this.reportType)) {
            this.generateLogicalModelReport(extraParams);
        } else if ("TablesAndViews".equalsIgnoreCase(this.reportType) || "Tables".equalsIgnoreCase(this.reportType) || "TableViews".equalsIgnoreCase(this.reportType)) {
            this.generateRelationalModelReport(extraParams);
        } else if ("Domains".equalsIgnoreCase(this.reportType)) {
            this.generateDomainsReport(extraParams);
        } else {
            this.ctx.write(Messages.getString("UNSUPPORTED_REPORT_TYPE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateLogicalModelReport(HashMap<String, Object> extraParams) {
        try {
            Design design = this.openDesign(this.designFileName, null, false);
            LogicalDesign logicalModel = design.getLogicalDesign();
            if (this.reportTitle == null) {
                this.reportTitle = design.getName() + ":" + logicalModel.getName() + " " + this.reportType + " Report";
            }
            extraParams.put("reportCaption", this.reportTitle);
            StandardReportConfiguration srct = this.getReportConfigurationTemplate();
            if (srct != null && !srct.getDesignID().equalsIgnoreCase(design.getDesignID()) && !srct.getDesignID().equalsIgnoreCase(logicalModel.getObjectID())) {
                this.ctx.write(MessageFormat.format(Messages.getString("REPORT_CONF_TEMPLATE_NOT_FOR_LOGICAL_MODEL"), this.customReportTemplate));
                return;
            }
            CustomReportTemplate crt = this.getCustomReportTemplate();
            if (crt != null) {
                if (!crt.getClazz().getName().startsWith("oracle.dbtools.crest.model.design.logical")) {
                    this.ctx.write(MessageFormat.format(Messages.getString("CUSTOM_TEMPLATE_NOT_FOR_LOGICAL_MODEL"), this.customReportTemplate));
                    return;
                }
                extraParams.put("custom_report_template", crt);
            } else {
                StandardReportTemplate srt = this.getStandardReportTemplate();
                if (srt != null) {
                    if (!srt.getClazz().getName().startsWith("oracle.dbtools.crest.model.design.logical")) {
                        this.ctx.write(MessageFormat.format(Messages.getString("STANDARD_TEMPLATE_NOT_FOR_LOGICAL_MODEL"), this.standardReportTemplate));
                        return;
                    }
                } else {
                    srt = new StandardReportTemplate(" ", null, "0", true);
                    srt.setUseDescriptionInfo(true);
                    srt.setUseQuantitativeInfo(true);
                    srt.setUseEntityAttributes(true);
                    srt.setUseEntityAttributesComments(true);
                    srt.setUseEntityConstraints(true);
                    srt.setUseEntityIdentifiers(true);
                    srt.setUseEntityRelationships(true);
                }
                extraParams.put("report_template", srt);
            }
            File outputFile = new File(this.outputPath, this.reportFileName + ".html");
            FileOutputStream fou = new FileOutputStream(outputFile);
            try {
                CLIReportsGenerator rg = new CLIReportsGenerator();
                design.getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
                design.getSettings().setIncludeSelectStatementInViewReport(true);
                if (this.reportCompanyName != null) {
                    design.getSettings().setReportsCompanyName(this.reportCompanyName);
                }
                DPVLogical dpv = null;
                if (this.createDiagram) {
                    DiagramToSVG.initNumIDs((DesignPart)logicalModel);
                    dpv = (DPVLogical)logicalModel.getMainView();
                    this.addLogicalObjectsToDPV(logicalModel, dpv, "EntitiesAndViews".equalsIgnoreCase(this.reportType), "Entities".equalsIgnoreCase(this.reportType), "EntityViews".equalsIgnoreCase(this.reportType));
                    XMLTransformationManager.getInstance().loadMainDPV((DesignPart)logicalModel);
                    if (srct != null) {
                        extraParams.put("subviews", this.getSubViewsMap((DesignPart)logicalModel, srct));
                    } else {
                        extraParams.put("subviews", new HashMap());
                    }
                }
                List<DesignObject> list = new ArrayList<DesignObject>();
                Class<SearchResultsReports> clazz = null;
                if ("Entities".equalsIgnoreCase(this.reportType)) {
                    extraParams.put("addTables", true);
                    extraParams.put("addViews", false);
                    if (crt != null) {
                        clazz = SearchResultsReports.class;
                        List<DesignObject> temp = new ArrayList<DesignObject>();
                        logicalModel.getEntitySet().addAllElementsTo(temp);
                        if (srct != null) {
                            temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                        }
                        for (Object e : temp) {
                            SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                            list.add((DesignObject)sro);
                        }
                    } else {
                        clazz = Entity.class;
                        logicalModel.getEntitySet().addAllElementsTo(list);
                        if (srct != null) {
                            list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                        }
                    }
                } else if ("EntityViews".equalsIgnoreCase(this.reportType)) {
                    extraParams.put("addViews", true);
                    extraParams.put("addTables", false);
                    if (crt != null) {
                        List<DesignObject> temp = new ArrayList<DesignObject>();
                        logicalModel.getEntityViewSet().addAllElementsTo(temp);
                        if (srct != null) {
                            temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                        }
                        for (Object e : temp) {
                            SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                            list.add((DesignObject)sro);
                        }
                        clazz = SearchResultsReports.class;
                    } else {
                        clazz = EntityView.class;
                        logicalModel.getEntityViewSet().addAllElementsTo(list);
                        if (srct != null) {
                            list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                        }
                    }
                } else if ("EntitiesAndViews".equalsIgnoreCase(this.reportType)) {
                    extraParams.put("addViews", true);
                    extraParams.put("addTables", true);
                    if (crt != null) {
                        clazz = SearchResultsReports.class;
                        List<DesignObject> temp = new ArrayList<DesignObject>();
                        logicalModel.getEntitySet().addAllElementsTo(temp);
                        logicalModel.getEntityViewSet().addAllElementsTo(temp);
                        if (srct != null) {
                            temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                        }
                        for (Object e : temp) {
                            SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                            list.add((DesignObject)sro);
                        }
                    } else {
                        clazz = Label.class;
                        logicalModel.getEntitySet().addAllElementsTo(list);
                        logicalModel.getEntityViewSet().addAllElementsTo(list);
                        if (srct != null) {
                            list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                        }
                    }
                }
                rg.createReport(clazz, (ModelIDObject)logicalModel, list, extraParams, (OutputStream)fou, (DesignPartView)dpv, crt == null);
                this.copyResourceFiles();
            }
            finally {
                fou.flush();
                fou.close();
            }
        }
        catch (Exception e) {
            this.ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRelationalModelReport(HashMap<String, Object> extraParams) {
        block38: {
            try {
                RelationalDesign relModel = this.loadRelationalModel(this.designFileName, this.relModelName);
                if (relModel != null) {
                    if (this.reportTitle == null) {
                        this.reportTitle = relModel.getDesign().getName() + ":" + relModel.getName() + " " + this.reportType + " Report";
                    }
                    extraParams.put("reportCaption", this.reportTitle);
                    StandardReportConfiguration srct = this.getReportConfigurationTemplate();
                    if (srct != null && !srct.getDesignID().equalsIgnoreCase(relModel.getDesign().getDesignID()) && !srct.getDesignID().equalsIgnoreCase(relModel.getObjectID())) {
                        this.ctx.write(MessageFormat.format(Messages.getString("REPORT_CONF_TEMPLATE_NOT_FOR_RELATIONAL_MODEL"), this.customReportTemplate));
                        return;
                    }
                    CustomReportTemplate crt = this.getCustomReportTemplate();
                    if (crt != null) {
                        if (!crt.getClazz().getName().startsWith("oracle.dbtools.crest.model.design.relational")) {
                            this.ctx.write(MessageFormat.format(Messages.getString("CUSTOM_TEMPLATE_NOT_FOR_RELATIONAL_MODEL"), this.customReportTemplate));
                            return;
                        }
                        extraParams.put("custom_report_template", crt);
                    } else {
                        StandardReportTemplate srt = this.getStandardReportTemplate();
                        if (srt != null) {
                            if (!srt.getClazz().getName().startsWith("oracle.dbtools.crest.model.design.relational")) {
                                this.ctx.write(MessageFormat.format(Messages.getString("STANDARD_TEMPLATE_NOT_FOR_RELATIONAL_MODEL"), this.standardReportTemplate));
                                return;
                            }
                        } else {
                            srt = new StandardReportTemplate(" ", null, "0", true);
                            srt.setUseDescriptionInfo(true);
                            srt.setUseQuantitativeInfo(true);
                            srt.setUseTableColumns(true);
                            srt.setUseTableColumnsComments(true);
                            srt.setUseTableConstraints(true);
                            srt.setUseTableFKReferredFrom(true);
                            srt.setUseTableFKReferringTo(true);
                            srt.setUseTableIndexes(true);
                        }
                        extraParams.put("report_template", srt);
                    }
                    File outputFile = new File(this.outputPath, this.reportFileName + ".html");
                    FileOutputStream fou = new FileOutputStream(outputFile);
                    try {
                        CLIReportsGenerator rg = new CLIReportsGenerator();
                        relModel.getDesign().getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
                        relModel.getDesign().getSettings().setIncludeSelectStatementInViewReport(true);
                        if (this.reportCompanyName != null) {
                            relModel.getDesign().getSettings().setReportsCompanyName(this.reportCompanyName);
                        }
                        DPVRelational dpv = null;
                        if (this.createDiagram) {
                            DiagramToSVG.initNumIDs((DesignPart)relModel);
                            dpv = (DPVRelational)relModel.getMainView();
                            this.addObjectsToDPV(relModel, dpv, "TablesAndViews".equalsIgnoreCase(this.reportType), "Tables".equalsIgnoreCase(this.reportType), "TableViews".equalsIgnoreCase(this.reportType));
                            XMLTransformationManager.getInstance().loadMainDPV((DesignPart)relModel);
                            if (srct != null) {
                                extraParams.put("subviews", this.getSubViewsMap((DesignPart)relModel, srct));
                            } else {
                                extraParams.put("subviews", new HashMap());
                            }
                        }
                        List<DesignObject> list = new ArrayList<DesignObject>();
                        Class<SearchResultsReports> clazz = null;
                        if ("Tables".equalsIgnoreCase(this.reportType)) {
                            extraParams.put("addTables", true);
                            extraParams.put("addViews", false);
                            if (crt != null) {
                                clazz = SearchResultsReports.class;
                                List<DesignObject> temp = new ArrayList<DesignObject>();
                                relModel.getTableSet().addAllElementsTo(temp);
                                if (srct != null) {
                                    temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                                }
                                for (Object e : temp) {
                                    SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                                    list.add((DesignObject)sro);
                                }
                            } else {
                                clazz = Table.class;
                                relModel.getTableSet().addAllElementsTo(list);
                                if (srct != null) {
                                    list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                                }
                            }
                        } else if ("TableViews".equalsIgnoreCase(this.reportType)) {
                            extraParams.put("addViews", true);
                            extraParams.put("addTables", false);
                            if (crt != null) {
                                List<DesignObject> temp = new ArrayList<DesignObject>();
                                relModel.getTableViewSet().addAllElementsTo(temp);
                                if (srct != null) {
                                    temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                                }
                                for (Object e : temp) {
                                    SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                                    list.add((DesignObject)sro);
                                }
                                clazz = SearchResultsReports.class;
                            } else {
                                clazz = TableView.class;
                                relModel.getTableViewSet().addAllElementsTo(list);
                                if (srct != null) {
                                    list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                                }
                            }
                        } else if ("TablesAndViews".equalsIgnoreCase(this.reportType)) {
                            extraParams.put("addViews", true);
                            extraParams.put("addTables", true);
                            if (crt != null) {
                                clazz = SearchResultsReports.class;
                                List<DesignObject> temp = new ArrayList<DesignObject>();
                                relModel.getTableSet().addAllElementsTo(temp);
                                relModel.getTableViewSet().addAllElementsTo(temp);
                                if (srct != null) {
                                    temp = this.getDesignObjectsForObjectsIDs(temp, srct.getObjects());
                                }
                                for (Object e : temp) {
                                    SearchResultObject sro = new SearchResultObject(e, clazz, "", "", "", "");
                                    list.add((DesignObject)sro);
                                }
                            } else {
                                clazz = Label.class;
                                relModel.getTableSet().addAllElementsTo(list);
                                relModel.getTableViewSet().addAllElementsTo(list);
                                if (srct != null) {
                                    list = this.getDesignObjectsForObjectsIDs(list, srct.getObjects());
                                }
                            }
                        }
                        rg.createReport(clazz, (ModelIDObject)relModel, list, extraParams, (OutputStream)fou, (DesignPartView)dpv, true);
                        this.copyResourceFiles();
                        break block38;
                    }
                    finally {
                        fou.flush();
                        fou.close();
                    }
                }
                this.ctx.write(Messages.getString("RELATIONAL_MODEL_NOT_EXISTS"));
            }
            catch (Exception e) {
                this.ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDomainsReport(HashMap<String, Object> extraParams) {
        try {
            Design design = this.openDesign(this.designFileName, null, true);
            LogicalDesign logicalModel = design.getLogicalDesign();
            if (this.reportTitle == null) {
                this.reportTitle = design.getName() + " Domains Report";
            }
            extraParams.put("reportCaption", this.reportTitle);
            StandardReportTemplate srt = this.getStandardReportTemplate();
            if (srt != null) {
                if (!srt.getClazz().getName().equalsIgnoreCase("oracle.dbtools.crest.model.design.Domain")) {
                    this.ctx.write(MessageFormat.format(Messages.getString("STANDARD_TEMPLATE_NOT_FOR_DOMAINS"), this.standardReportTemplate));
                    return;
                }
            } else {
                srt = new StandardReportTemplate(" ", null, "0", true);
                srt.setUseDomainConstraints(true);
                srt.setUseDomainUsedInTables(true);
                srt.setUseDomainUsedInEntities(true);
            }
            extraParams.put("report_template", srt);
            File outputFile = new File(this.outputPath, this.reportFileName + ".html");
            FileOutputStream fou = new FileOutputStream(outputFile);
            try {
                CLIReportsGenerator rg = new CLIReportsGenerator();
                design.getSettings().setGenerateHTMLReportTOCInSeparateFile(false);
                design.getSettings().setIncludeSelectStatementInViewReport(true);
                if (this.reportCompanyName != null) {
                    design.getSettings().setReportsCompanyName(this.reportCompanyName);
                }
                rg.createReport(Domain.class, (ModelIDObject)logicalModel, null, extraParams, (OutputStream)fou, null, false);
                this.copyResourceFiles();
            }
            finally {
                fou.flush();
                fou.close();
            }
        }
        catch (Exception e) {
            this.ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
        }
    }

    private void addObjectsToDPV(RelationalDesign rm, DPVRelational dpv, boolean all, boolean addTables, boolean addViews) {
        TopView tv;
        if (all || addTables) {
            for (FKContainer cont : rm.getTableSet()) {
                dpv.createTopViewFor((DesignObject)cont);
            }
        }
        if (all || addViews) {
            for (FKContainer cont : rm.getTableViewSet()) {
                dpv.createTopViewFor((DesignObject)cont);
            }
        }
        for (FKIndexAssociation fk : rm.getFKIndexAssociationSet()) {
            TopView stv = dpv.getFirstViewFor(fk.getSourceObject());
            TopView ttv = dpv.getFirstViewFor(fk.getTargetObject());
            if (stv == null || ttv == null) continue;
            try {
                fk.setSourceTVTable((ContainerView)stv);
                fk.setTargetTVTable((ContainerView)ttv);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            if ((tv = fk.getViewFor((DesignPartView)dpv)) == null || dpv.getTopviewsList().contains(tv)) continue;
            dpv.add(tv);
        }
        for (TypeSubstitution ts : rm.getTypeSubstitutionSet()) {
            ContainerView childTV = (ContainerView)dpv.getFirstViewFor((DesignObject)ts.getChildContainerObject());
            ContainerView parentTV = (ContainerView)dpv.getFirstViewFor((DesignObject)ts.getParentContainerObject());
            ts.setChildCV(childTV);
            ts.setParentCV(parentTV);
            tv = ts.getViewFor((DesignPartView)dpv);
            if (tv == null || dpv.getTopviewsList().contains(tv)) continue;
            dpv.add(tv);
        }
    }

    private void addLogicalObjectsToDPV(LogicalDesign lm, DPVLogical dpv, boolean all, boolean addEntities, boolean addViews) {
        TopView tv;
        if (all || addEntities) {
            for (ContainerWithKeyObject cont : lm.getEntitySet()) {
                dpv.createTopViewFor((DesignObject)cont);
            }
        }
        if (all || addViews) {
            for (ContainerWithKeyObject cont : lm.getEntityViewSet()) {
                dpv.createTopViewFor((DesignObject)cont);
            }
        }
        for (Relation relation : lm.getRelationSet()) {
            TopView stv = dpv.getFirstViewFor(relation.getSourceObject());
            TopView ttv = dpv.getFirstViewFor(relation.getTargetObject());
            if (stv == null || ttv == null) continue;
            try {
                relation.setSourceTV((TVEntity)stv);
                relation.setTargetTV((TVEntity)ttv);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            if ((tv = relation.getViewFor((DesignPartView)dpv)) == null || dpv.getTopviewsList().contains(tv)) continue;
            dpv.add(tv);
        }
        for (TypeSubstitution ts : lm.getTypeSubstitutionSet()) {
            ContainerView childTV = (ContainerView)dpv.getFirstViewFor((DesignObject)ts.getChildContainerObject());
            ContainerView parentTV = (ContainerView)dpv.getFirstViewFor((DesignObject)ts.getParentContainerObject());
            ts.setChildCV(childTV);
            ts.setParentCV(parentTV);
            tv = ts.getViewFor((DesignPartView)dpv);
            if (tv == null || dpv.getTopviewsList().contains(tv)) continue;
            dpv.add(tv);
        }
    }

    private void copyResourceFiles() {
        try {
            File cssFolder = new File(this.outputPath, "css");
            cssFolder.mkdirs();
            File cssFile = new File(cssFolder, "osddm_main.css");
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("datamodeler/reports/css/osddm_main.css");
            Files.copy(is, cssFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            cssFile = new File(cssFolder, "osddm_tree.css");
            is = this.getClass().getClassLoader().getResourceAsStream("datamodeler/reports/css/osddm_tree.css");
            Files.copy(is, cssFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File imgFolder = new File(this.outputPath, "img");
            imgFolder.mkdirs();
            File imgFile = new File(imgFolder, "disclosecollapsed_ena.png");
            is = this.getClass().getClassLoader().getResourceAsStream("datamodeler/reports/img/disclosecollapsed_ena.png");
            Files.copy(is, imgFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            imgFile = new File(imgFolder, "discloseexpanded_ena.png");
            is = this.getClass().getClassLoader().getResourceAsStream("datamodeler/reports/img/discloseexpanded_ena.png");
            Files.copy(is, imgFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
        }
    }

    private StandardReportTemplate getStandardReportTemplate() {
        if (this.standardReportTemplate != null) {
            List list = StandardReportTemplatesPersistence.loadReportTemplates();
            for (StandardReportTemplate srt : list) {
                if (!srt.getName().equalsIgnoreCase(this.standardReportTemplate)) continue;
                return srt;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("TEMPLATE_NOT_FOUND"), this.standardReportTemplate));
        }
        return null;
    }

    private CustomReportTemplate getCustomReportTemplate() {
        if (this.customReportTemplate != null) {
            List list = CustomReportTemplatesPersistence.loadCustomReportTemplates();
            for (CustomReportTemplate crt : list) {
                if (!crt.getName().equalsIgnoreCase(this.customReportTemplate)) continue;
                return crt;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("TEMPLATE_NOT_FOUND"), this.customReportTemplate));
        }
        return null;
    }

    private StandardReportConfiguration getReportConfigurationTemplate() {
        if (this.reportConfTemplate != null) {
            List list = StandardReportConfigurationsPersistence.loadStandardReportConfigurations();
            for (StandardReportConfiguration srct : list) {
                if (!srct.getName().equalsIgnoreCase(this.reportConfTemplate)) continue;
                return srct;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("TEMPLATE_NOT_FOUND"), this.reportConfTemplate));
        }
        return null;
    }

    private List<DesignObject> getDesignObjectsForObjectsIDs(List<DesignObject> allObjects, List<String> objectsIDsList) {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        block0: for (String objId : objectsIDsList) {
            for (DesignObject o : allObjects) {
                if (!o.getObjectID().equals(objId)) continue;
                list.add(o);
                continue block0;
            }
        }
        return list;
    }

    private HashMap<DesignPartViewPlaceHolder, List<String>> getSubViewsMap(DesignPart model, StandardReportConfiguration src) {
        HashMap<DesignPartViewPlaceHolder, List<String>> subviews = new HashMap<DesignPartViewPlaceHolder, List<String>>();
        List subviewsIDsList = src.getSubviews();
        block0: for (DesignPartViewPlaceHolder ph : model.getDesignSubviews()) {
            for (String swId : subviewsIDsList) {
                if (!ph.getObjectID().equals(swId)) continue;
                ArrayList<DesignObject> objectsList = new ArrayList<DesignObject>();
                for (TopView tv : ph.getDesignPartView().getTopviewsList()) {
                    DesignObject desObj = tv.getModel();
                    for (String objId : src.getObjects()) {
                        if (!desObj.getObjectID().equals(objId)) continue;
                        objectsList.add(desObj);
                    }
                }
                Collections.sort(objectsList, this.toStringComparator);
                subviews.put(ph, objectsList);
                ArrayList list = new ArrayList();
                ((DesignPartView)ph.getObject()).getDisplays().addAllElementsTo(list);
                for (DesignPartViewPlaceHolder dph : list) {
                    subviews.put(dph, objectsList);
                }
                continue block0;
            }
        }
        return subviews;
    }
}

