/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.ClientListener;
import oracle.dbtools.raptor.ssh.core.ConfigFile;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.KnownHosts;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;

public abstract class Client {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_SSH_PORT = 22;
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Class<? extends Client> sImplementationClass;
    private int timeout = 15000;
    private boolean strict = true;
    private Store mStore;
    private final SshClient sshClient;
    private Map<String, HostConnection> mConns = new HashMap<String, HostConnection>();
    private Map<Path, KeyIdentityProvider> keys = new HashMap<Path, KeyIdentityProvider>();
    private final KeyIdentityProvider defaultIdentityProvider;
    private List<ClientListener> listeners = new CopyOnWriteArrayList<ClientListener>();
    private ConfigFile cfgFile = ConfigFile.DEFAULT;
    private KnownHosts knownHosts = KnownHosts.DEFAULT_LENIENT;

    public static synchronized void setImplementationClass(Class<? extends Client> cls) {
        if (sImplementationClass != null) {
            throw new IllegalStateException("Client implementation already set: " + sImplementationClass.getName());
        }
        sImplementationClass = cls;
    }

    private static Path convertFileURLToPath(URL url) {
        Path p = null;
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            String path = url.getPath();
            try {
                URI uri = new URI("file", null, path, null);
                p = Paths.get(uri);
            }
            catch (URISyntaxException e) {
                Logger.severe(Client.class, (Throwable)e);
            }
        }
        return p;
    }

    public static Client getInstance() {
        return Holder.INSTANCE;
    }

    protected Client() {
        this.sshClient = SshClient.setUpDefaultClient();
        this.defaultIdentityProvider = this.sshClient.getKeyIdentityProvider();
    }

    public Store getStore() {
        return this.mStore;
    }

    protected abstract Store createStore();

    private void init() {
        this.mStore = this.createStore();
        this.mStore.addStoreListener(new StoreListener(){

            @Override
            public void hostRemoved(StoreEvent event) {
                HostDescriptor desc = event.getHostDescriptor();
                Client.this.closeConnection(desc);
            }

            @Override
            public void hostChanged(StoreEvent event) {
                HostDescriptor desc = (HostDescriptor)event.getOldDescriptor();
                Client.this.closeConnection(desc);
            }

            @Override
            public void tunnelRemoved(StoreEvent event) {
                TunnelDescriptor desc = event.getTunnelDescriptor();
                try {
                    Client.this.closeTunnel(desc);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void tunnelChanged(StoreEvent event) {
                TunnelDescriptor desc = (TunnelDescriptor)event.getOldDescriptor();
                try {
                    Client.this.closeTunnel(desc);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.initSSHClient();
        this.sshClient.setServerKeyVerifier(this.knownHosts.getServerKeyVerifier());
        this.sshClient.setHostConfigEntryResolver(this.cfgFile.getHostConfigEntryResolver());
        this.sshClient.start();
    }

    protected abstract URL getStoreURL();

    protected abstract void initSSHClient();

    public final SshClient getSSHClient() {
        return this.sshClient;
    }

    private final ClientSession createSession(HostDescriptor desc) throws IOException {
        int timeout = 15000;
        ClientSession session = (ClientSession)((ConnectFuture)this.sshClient.connect(desc.getUsername(), desc.getHostname(), desc.getPort()).verify((long)timeout)).getSession();
        KeyIdentityProvider kip = KeyIdentityProvider.EMPTY_KEYS_PROVIDER;
        URL keyfile = desc.getKeyfile();
        if (keyfile != null) {
            Path p = Client.convertFileURLToPath(keyfile);
            if (p != null) {
                kip = new ClientIdentitiesWatcher(Collections.singletonList(p), () -> ((SshClient)this.sshClient).getClientIdentityLoader(), () -> ((SshClient)this.sshClient).getFilePasswordProvider(), this.strict);
            }
        } else {
            kip = this.defaultIdentityProvider;
        }
        session.setKeyIdentityProvider(kip);
        this.initSession(session, desc);
        return session;
    }

    protected KnownHosts getKnownHosts() {
        return this.knownHosts;
    }

    protected void setKnownHosts(KnownHosts file) {
        if (this.knownHosts != file) {
            this.knownHosts = file;
            this.sshClient.setServerKeyVerifier(file.getServerKeyVerifier());
        }
    }

    protected ConfigFile getConfigFile() {
        return this.cfgFile;
    }

    protected void setConfigFile(ConfigFile cfg) {
        if (this.cfgFile != null) {
            this.cfgFile = cfg;
            this.sshClient.setHostConfigEntryResolver(cfg.getHostConfigEntryResolver());
        }
    }

    protected final void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected final int getTimeout() {
        return this.timeout;
    }

    protected final void setStrictKeyfilePermissions(boolean strict) {
        this.strict = strict;
    }

    protected final boolean isStrictKeyfilePermissions() {
        return this.strict;
    }

    protected abstract void initSession(ClientSession var1, HostDescriptor var2);

    public final synchronized HostConnection openConnection(HostDescriptor host) throws IOException {
        String name = host.getName();
        HostConnection conn = this.mConns.get(name);
        if (conn == null) {
            ClientSession session = this.createSession(host);
            session.auth().verify((long)this.timeout);
            conn = new HostConnection(this, session, host);
            this.fireConnectionOpened(conn);
            this.mConns.put(name, conn);
        }
        return conn;
    }

    public final synchronized void closeConnection(HostDescriptor host) {
        String name = host.getName();
        HostConnection conn = this.mConns.remove(name);
        if (conn != null) {
            conn.disconnect();
            this.fireConnectionClosed(conn);
        }
    }

    public final boolean isConnectionOpen(HostDescriptor host) {
        String name = host.getName();
        return this.mConns.containsKey(name);
    }

    public final synchronized Tunnel openTunnel(TunnelDescriptor tunnelDesc) throws IOException {
        HostDescriptor host = tunnelDesc.getHost();
        HostConnection conn = this.openConnection(host);
        return conn != null ? conn.openTunnel(tunnelDesc) : null;
    }

    public final void closeTunnel(TunnelDescriptor tunnelDesc) throws IOException {
        HostDescriptor host = tunnelDesc.getHost();
        String connName = host.getName();
        HostConnection conn = this.mConns.get(connName);
        if (conn != null) {
            conn.closeTunnel(tunnelDesc);
        }
    }

    public final boolean isTunnelOpen(TunnelDescriptor desc) {
        HostDescriptor host = desc.getHost();
        String connName = host.getName();
        HostConnection conn = this.mConns.get(connName);
        return conn != null && conn.isTunnelOpen(desc);
    }

    public final void testConnection(HostDescriptor host) throws IOException {
        ClientSession session = this.createSession(host);
        session.auth().verify((long)this.timeout);
        session.close();
    }

    public final void addListener(ClientListener l) {
        this.listeners.add(l);
    }

    public final void removeListener(ClientListener l) {
        this.listeners.remove(l);
    }

    final void fireConnectionOpened(HostConnection conn) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.SESSION_OPENED, conn);
            }
            l.connectionOpened(e);
        }
    }

    final void fireConnectionClosed(HostConnection conn) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.SESSION_CLOSED, conn);
            }
            l.connectionClosed(e);
        }
    }

    final void fireTunnelOpened(Tunnel tunnel) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.TUNNEL_OPENED, tunnel);
            }
            l.tunnelOpened(e);
        }
    }

    final void fireTunnelClosed(Tunnel tunnel) {
        ClientEvent e = null;
        for (ClientListener l : this.listeners) {
            if (e == null) {
                e = new ClientEvent(this, ClientEvent.EventType.TUNNEL_CLOSED, tunnel);
            }
            l.tunnelClosed(e);
        }
    }

    private static final class Holder {
        static final Client INSTANCE;

        private Holder() {
        }

        static {
            if (sImplementationClass == null) {
                throw new IllegalStateException("SSH Client Implementation not set.");
            }
            try {
                INSTANCE = sImplementationClass.newInstance();
                INSTANCE.init();
            }
            catch (Exception ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

