/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.OracleDataSources;
import oracle.dbtools.core.oci.OCIDBToolsConnection;
import oracle.dbtools.core.oci.OCIDatabaseClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.core.proxy.ProxyChecker;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.net.commands.OCICommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagValue;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RestProperty;

public class OCIConnector
extends AbstractConnector {
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";

    public OCIConnector(ConnectorArgs args) {
        super(args);
    }

    public Connection connect() {
        String ocid;
        Object conn = null;
        ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
        if (sqlcl != null && sqlcl.getConn() != null) {
            this.OCIConnClear(this.ctx);
        }
        OCIProfiles profiles = null;
        try {
            OCIProfiles.Builder builder = OCIProfiles.builder();
            profiles = builder.build();
        }
        catch (IOException e) {
            this.ctx.writeln(e.getLocalizedMessage());
            return null;
        }
        String profile = (String)this.ctx.getProperty("oci.profile.name");
        if (profile == null) {
            this.ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
            return null;
        }
        OCIProfile ociProfile = profiles.getProfile(profile);
        if (ociProfile == null) {
            this.ctx.writeln("Profile " + profile + " does not exist");
            return null;
        }
        String region = (String)this.ctx.getProperty(OCI_REGION_NAME);
        if (region == null) {
            region = OCICommand.set_region_home(ociProfile, this.ctx);
        }
        if (!this.isDatabaseToolsConnectionOCID(ocid = this.connectionSpec.toLowerCase(), this.ctx)) {
            return null;
        }
        if (!this.validateOCID(ocid, this.ctx)) {
            return null;
        }
        if (this.properties.getValueOf((Property)RestProperty.REST) != FlagValue.PRESENT) {
            OCIDatabaseClient.Builder dbClientBuilder = (OCIDatabaseClient.Builder)OCIDatabaseClient.builder((OCIProfile)ociProfile).region(region);
            ProxyChecker.Builder proxyBuilder = ProxyChecker.builder();
            URI proxy = (URI)this.properties.getValueOf((Property)ProxyProperty.PROXY);
            if (proxy != null) {
                proxyBuilder.proxy(proxy);
                proxyBuilder.nonProxyHosts(System.getProperty("dbtools.system_http_non_proxy_hosts"));
            }
            dbClientBuilder.proxy(proxyBuilder.build());
            OCIDatabaseClient dbClient = dbClientBuilder.build();
            try {
                OCIDBToolsConnection dbToolsConn = dbClient.createDBToolsConnection(ocid);
                if (dbToolsConn.getDatabaseType() == OCIDBToolsConnection.DatabaseType.ORACLE) {
                    DataSource dataSource = dbClient.createDataSource((DataSourceBuilder)OracleDataSources.instance().builder(), dbToolsConn);
                    return dataSource.getConnection();
                }
                this.ctx.writeln("Unsupported database type: " + String.valueOf(dbToolsConn.getDatabaseType()));
                return null;
            }
            catch (IOException | SQLException e) {
                this.ctx.writeln(e.getLocalizedMessage());
                return null;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                this.ctx.writeln(t.getLocalizedMessage());
                return null;
            }
        }
        String config_filepath = this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) != null ? (String)this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) : "~/.oci/config";
        Properties props = new Properties();
        props.put("oci_config_filepath", config_filepath);
        props.put("oci_profile", profile);
        props.put("region", region);
        try {
            Connection restConnection = DriverManager.getConnection(ocid, props);
            this.setConnection(this.ctx, props, restConnection);
            return restConnection;
        }
        catch (SQLException e) {
            this.ctx.write(e.getMessage());
            return null;
        }
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }

    private boolean validateOCID(String ocid, ScriptRunnerContext ctx) {
        String[] parts = ocid.replace("\n", "").split("\\.");
        return parts[0].contains("ocid");
    }

    private boolean isDatabaseToolsConnectionOCID(String ocid, ScriptRunnerContext ctx) {
        if (ocid.contains(":") && ocid.substring(0, 4).equalsIgnoreCase("ocid")) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_OCID"));
            return false;
        }
        String[] parts = ocid.replace("\n", "").split("\\.");
        if (!parts[1].equalsIgnoreCase("databasetoolsconnection")) {
            try {
                throw new SQLException(CommandMessages.getString("OCI_INCORRECT_OCID") + CommandMessages.format("OCI_INCORRECT_PROVIDED_OCID", parts[1]));
            }
            catch (SQLException e) {
                ctx.write(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void setConnection(ScriptRunnerContext ctx, Properties props, Connection conn) throws SQLException {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        if (sqlcl != null) {
            if (conn != null) {
                sqlcl.setConn(conn);
                sqlcl.getScriptRunnerContext().setCurrentConnection(conn);
                sqlcl.getScriptRunnerContext().setBaseConnection(conn);
                sqlcl.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", (Object)Boolean.FALSE);
                ctx.putProperty("cli.conn.props", (Object)props);
            } else {
                ctx.write(CommandMessages.getString("OCI_CONN_FAILED"));
            }
        }
    }
}

