/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.messages;

import com.google.common.base.Throwables;
import java.io.IOException;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.sdks.config.SDKSConfig;
import oracle.dbtools.sdks.installer.help.SDKSMessages;
import oracle.dbtools.sdks.installer.utils.ConsoleColors;
import oracle.dbtools.util.SpinningWheel;

public class SDKSMessenger {
    private ScriptRunnerContext ctx;

    public SDKSMessenger(ScriptRunnerContext ctx) {
        this.ctx = ctx;
    }

    private void sdkNotFoundMsg(ConsoleColors clr, String sdkName) {
        this.ctx.writeln(SDKSMessages.format("SDK_NOT_FOUND", clr.code, sdkName, ConsoleColors.RESET.code));
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sdkNotFoundMsg(String sdkName) {
        this.sdkNotFoundMsg(ConsoleColors.RED_BOLD_BRIGHT, sdkName);
    }

    private void sdkFoundMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("SDK_FOUND", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sdkFoundMsg(String sdkName) {
        this.sdkFoundMsg(ConsoleColors.BLUE_BOLD_BRIGHT, sdkName);
    }

    private void directoryCreationMsg(ConsoleColors clr, String dir) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("DIRECTORY_CREATED", clr.code, ConsoleColors.RESET.code, dir));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void directoryCreationMsg(String dir) {
        this.directoryCreationMsg(ConsoleColors.WHITE_UNDERLINED, dir);
    }

    private void directoryUsageMsg(ConsoleColors clr, String dir) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("EXISTING_DIR_FOUND", clr.code, ConsoleColors.RESET.code, dir));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void directoryUsageMsg(String dir) {
        this.directoryUsageMsg(ConsoleColors.WHITE_UNDERLINED, dir);
    }

    private void downloadingSdkAndDepsMsg(ConsoleColors clr, String sdkName) {
        this.ctx.writeln(SDKSMessages.format("DOWNLOADING_SDK_AND_DEPS", clr.code, sdkName, ConsoleColors.RESET.code));
        this.startSpinningWheel();
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void downloadingSdkAndDepsMsg(String sdkName) {
        this.downloadingSdkAndDepsMsg(ConsoleColors.BLUE_BOLD_BRIGHT, sdkName);
    }

    private void sdkDownloadedMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("SDK_DOWNLOADED", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sdkDownloadedMsg(String sdkName) {
        this.sdkDownloadedMsg(ConsoleColors.GREEN_BOLD_BRIGHT, sdkName);
    }

    private void downloadingPomMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("DOWNLOADING_POM", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void downloadingPomMsg(String sdkName) {
        this.downloadingPomMsg(ConsoleColors.BLUE_BOLD_BRIGHT, sdkName);
    }

    private void pomDownloadedMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("POM_DOWNLOADED", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pomDownloadedMsg(String sdkName) {
        this.pomDownloadedMsg(ConsoleColors.CYAN_BOLD_BRIGHT, sdkName);
    }

    private void downloadingDepsMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("DOWNLOADING_DEPS", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void downloadingDepsMsg(String sdkName) {
        this.downloadingDepsMsg(ConsoleColors.WHITE_BOLD_BRIGHT, sdkName);
    }

    private void downloadingSpecDepMsg(ConsoleColors clr, String depName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("DOWNLOADING_DEP_SPEC", clr.code, depName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void downloadingSpecDepMsg(String depName) {
        this.downloadingSpecDepMsg(ConsoleColors.YELLOW_BOLD_BRIGHT, depName);
    }

    private void specDepDownloadedMsg(ConsoleColors clr, String depName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("DEP_DOWNLOADED", clr.code, depName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void specDepDownloadedMsg(String depName) {
        this.specDepDownloadedMsg(ConsoleColors.CYAN_BOLD_BRIGHT, depName);
    }

    private void allDepsDownloadedMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("ALL_DEPS_DOWNLOADED", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void allDepsDownloadedMsg(String sdkName) {
        this.allDepsDownloadedMsg(ConsoleColors.GREEN_BOLD, sdkName);
    }

    private void sdkInstalledMsg(ConsoleColors clr, String sdkName) {
        this.ctx.writeln(SDKSMessages.format("SDK_INSTALLED_SUCCESSFULLY", clr.code, sdkName, ConsoleColors.RESET.code));
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sdkInstalledMsg(String sdkName) {
        this.stopSpinningWheel();
        this.sdkInstalledMsg(ConsoleColors.GREEN_BOLD_BRIGHT, sdkName);
    }

    private boolean updatePromptMsg(ConsoleColors clr, String sdkName) {
        ConsoleService consoleReader = (ConsoleService)this.ctx.getProperty("script.runner.jline");
        String input = consoleReader.readInput(SDKSMessages.format("UPDATE_PROMPT", clr.code, sdkName, ConsoleColors.RESET.code));
        return input.equalsIgnoreCase("y");
    }

    public boolean updatePromptMsg(String sdkName) {
        return this.updatePromptMsg(ConsoleColors.WHITE_BOLD_BRIGHT, sdkName);
    }

    private void removingDirectoryMsg(ConsoleColors clr, String sdkName) {
        if (SDKSConfig.isVerbose()) {
            this.ctx.writeln(SDKSMessages.format("REMOVING_DIR", clr.code, sdkName, ConsoleColors.RESET.code));
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removingDirectoryMsg(String sdkName) {
        this.removingDirectoryMsg(ConsoleColors.YELLOW_BOLD_BRIGHT, sdkName);
    }

    private void sdkRemovedMsg(ConsoleColors clr, String sdkName) {
        this.ctx.writeln(SDKSMessages.format("SDK_REMOVED", clr.code, sdkName, ConsoleColors.RESET.code));
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sdkRemovedMsg(String sdkName) {
        this.sdkRemovedMsg(ConsoleColors.GREEN_BOLD_BRIGHT, sdkName);
    }

    private void invalidRmSdkMsg(ConsoleColors clr) {
        this.ctx.writeln(SDKSMessages.format("RM_SDK_INVALID", clr.code, ConsoleColors.RESET.code));
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void invalidRmSdkMsg() {
        this.invalidRmSdkMsg(ConsoleColors.RED_BOLD_BRIGHT);
    }

    private void debugStackTraceException(ConsoleColors clr, Throwable e) {
        if (SDKSConfig.isDebug()) {
            this.ctx.writeln(clr.code + Throwables.getStackTraceAsString((Throwable)e) + ConsoleColors.RESET.code);
        }
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void debugStackTraceException(Throwable e) {
        SpinningWheel.stop();
        this.debugStackTraceException(ConsoleColors.BLUE_BOLD, e);
    }

    private void errorMsg(ConsoleColors clr, String err) {
        this.ctx.writeln(clr.code + err + ConsoleColors.RESET.code);
        try {
            this.ctx.getOutputStream().getMainStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void errorMsg(String err) {
        SpinningWheel.stop();
        this.errorMsg(ConsoleColors.RED_BOLD, err);
    }

    private void startSpinningWheel() {
        SpinningWheel.start((ScriptRunnerContext)this.ctx);
    }

    private void stopSpinningWheel() {
        SpinningWheel.stop();
    }
}

