/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import oracle.dbtools.sdks.exceptions.DependenciesTxtNotFoundException;
import oracle.dbtools.sdks.installer.help.SDKSMessages;

public class DependenciesTxtLoader {
    public static BufferedReader loadDependencies() throws DependenciesTxtNotFoundException {
        String SQL_HOME = System.getenv("SQL_HOME") == null ? "../../sqlcl" : System.getenv("SQL_HOME");
        Object dependenciesTxtPath = SQL_HOME + "/bin/dependencies.txt";
        if (System.getenv("SQL_HOME") == null) {
            Path filePath = Paths.get((String)dependenciesTxtPath, new String[0]);
            Path absolutePath = filePath.toAbsolutePath().normalize();
            dependenciesTxtPath = absolutePath.toString();
        }
        File dependenciesFile = new File((String)dependenciesTxtPath);
        try {
            FileInputStream dependenciesStream = new FileInputStream(dependenciesFile);
            InputStreamReader inputStreamReader = new InputStreamReader(dependenciesStream);
            return new BufferedReader(inputStreamReader);
        }
        catch (FileNotFoundException e) {
            throw new DependenciesTxtNotFoundException(SDKSMessages.getString("DEPENDENCIES_TXT_NOT_FOUND_EXCEPTION"));
        }
    }
}

