/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.commands;

import java.sql.Connection;
import java.util.Optional;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.sdks.config.SDKSConfig;
import oracle.dbtools.sdks.installer.commands.SDKSManager;
import oracle.dbtools.sdks.installer.commands.SDKSOptions;
import oracle.dbtools.sdks.installer.help.SDKSMessages;
import oracle.dbtools.sdks.messages.SDKSMessenger;

public class SDKSCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected {
    private final SDKSManager sdksManager = new SDKSManager();
    private static final String COMMAND_HELP_PATH = "oracle.dbtools.sdks.installer.help.Help";

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, SDKSOptions.getType()).get(pagePath);
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        return new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).enableColorCode(ctx.isCommandLine()).addHelpContainer(new HelpBundleBuilder(COMMAND_HELP_PATH).build()).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith("sdk") && !cmd.getLoweredTrimmedSQL().startsWith("sd")) {
            return false;
        }
        SDKSMessenger sdksmessenger = new SDKSMessenger(ctx);
        Parser parser = new Parser(SDKSOptions.getType(), ctx.getEnvironment());
        Optional parsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
        boolean correctlyParsed = parsedCommand.isPresent();
        if (correctlyParsed) {
            SDKSConfig.setupDebugVerbose((ParsedCommand)parsedCommand.get());
            try {
                Id type = ((ParsedCommand)parsedCommand.get()).getType().getId();
                if (type.equals((Object)SDKSOptions.Symbol.SDK)) {
                    ctx.write(this.getHelp(ctx, SDKSOptions.Symbol.SDK.toString()).get() + "\n");
                } else if (type.equals((Object)SDKSOptions.Symbol.LIST)) {
                    this.sdksManager.listAvailable(ctx);
                } else if (type.equals((Object)SDKSOptions.Symbol.INSTALL)) {
                    String sdkName = (String)((ParsedCommand)parsedCommand.get()).getParameterValue((Id)SDKSOptions.Symbol.SDK_NAME);
                    this.sdksManager.install(ctx, sdkName);
                } else if (type.equals((Object)SDKSOptions.Symbol.UPDATE)) {
                    String sdkName = (String)((ParsedCommand)parsedCommand.get()).getParameterValue((Id)SDKSOptions.Symbol.SDK_NAME);
                    this.sdksManager.update(ctx, sdkName);
                } else if (type.equals((Object)SDKSOptions.Symbol.REMOVE)) {
                    String sdkName = (String)((ParsedCommand)parsedCommand.get()).getParameterValue((Id)SDKSOptions.Symbol.SDK_NAME);
                    this.sdksManager.remove(ctx, sdkName);
                }
            }
            catch (Exception e) {
                sdksmessenger.errorMsg(e.getCause() != null ? e.getCause().getMessage() : SDKSMessages.getString("UNKNOWN_ERROR"));
                sdksmessenger.debugStackTraceException(e);
            }
        }
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "sdk";
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return SDKSMessages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "sdk";
    }

    public String getExtensionVersion() {
        return SDKSMessages.getString("SQLclVersion.VERSION");
    }

    public boolean needsConnection() {
        return false;
    }
}

