/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class TreeUtil {
    private static final Pattern RTRIM_PATTERN = Pattern.compile("\\s+$");
    private static final Pattern ANSI_COLOR_ESCAPES_PATTERN = Pattern.compile("\\x1b\\[[0-9;]*m");

    private TreeUtil() {
    }

    public static String rtrim(@Nullable String pString) {
        String result = null;
        if (pString != null) {
            result = RTRIM_PATTERN.matcher(pString).replaceAll("");
        }
        return result;
    }

    public static int lengthWithoutEsc(@Nullable String pString) {
        int result = 0;
        if (pString != null) {
            result = pString.length();
            Matcher matcher = ANSI_COLOR_ESCAPES_PATTERN.matcher(pString);
            while (matcher.find()) {
                result -= matcher.end() - matcher.start();
            }
        }
        return result;
    }

    public static boolean containsEscapes(@Nullable String pString) {
        if (pString != null) {
            return ANSI_COLOR_ESCAPES_PATTERN.matcher(pString).find();
        }
        return false;
    }
}

