/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.generators;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.DataPumpQuery;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.commands.DataPumpOptions;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpGenOptions;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.common.DataPumpOption;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.http.CloudStorageUrl;

public class DataPumpPreprocessor {
    private static final String DQ = "\"";
    private static final String SQ = "'";
    private static final String NL = "\n";
    private DataPumpModel _model;
    private DataPumpArguments _args;
    private boolean _isCloudCopy;

    public DataPumpPreprocessor(DataPumpModel model) {
        this._model = model;
        this._args = this._model.getArgs();
    }

    public boolean check() {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_PREPROCESS"));
        }
        this._isCloudCopy = this._model.isArgTrue("copycloud");
        if (this.validateRequiredArguments() && this.validateConflictingArguments() && this.checkArgumentValues()) {
            this.checkAccess();
        }
        this.handleArgConversions();
        return this._model.isValid();
    }

    public boolean validateRequiredArguments() {
        if (!this._model.isExport() && !this._model.isImport()) {
            this._model.isValid(false);
            this._model.getToolLogger().logError(DataPumpResources.getString("DPPRE_OPERATION"));
        }
        if (!this._model.isArgTrue("includemetadata") && !this._model.isArgTrue("includerows")) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INCLUDE_ERROR", "dumpfile", "dumpuri"));
            this._model.isValid(false);
        }
        return this._model.isValid();
    }

    public boolean validateConflictingArguments() {
        if (!this._isCloudCopy && this._args.getString("dumpfile") != null && this._args.getString("dumpuri") != null) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_OPTS_CONFLICT", "dumpfile", "dumpuri"));
            this._model.isValid(false);
        }
        if (this._model.isExport() && this._args.getString("estimate") != null && !this._model.isArgTrue("includerows")) {
            this._model.getToolLogger().logError(DataPumpResources.getString("DPPRE_EST_ERROR"));
            this._model.isValid(false);
        }
        String value = this._args.getString("tableexists");
        if (this._model.isImport() && value != null && value.equalsIgnoreCase(DataPumpOptions.TABLEEXISTS_VALUES.SKIP.toString()) && !this._model.isArgTrue("includemetadata")) {
            this._model.getToolLogger().logError(DataPumpResources.getString("DPPRE_INVALID_TABLE_EXIST"));
            this._model.isValid(false);
        }
        return this._model.isValid();
    }

    public boolean checkArgumentValues() {
        String argVal = this._args.getString("filesize");
        try {
            if (argVal != null) {
                String[] parts = argVal.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
                if (parts.length != 2) {
                    this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "filesize", argVal));
                }
                Integer.parseInt(parts[0]);
                DataPumpOption opt = DataPumpGenOptions.getOption("filesize");
                if (DataPumpOption.getEnumFromString(FILESIZE_VALUES.class, parts[1]) == null) {
                    this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "filesize", argVal));
                    this._model.isValid(false);
                }
            } else {
                this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_MISSING_OPT_VALUE", "filesize", argVal));
                this._model.isValid(false);
            }
        }
        catch (NumberFormatException e) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "filesize", argVal));
            this._model.isValid(false);
        }
        catch (Exception e) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "filesize", argVal));
            this._model.getToolLogger().log(NL + e.getLocalizedMessage());
            this._model.isValid(false);
        }
        argVal = this._args.getString("version");
        try {
            if (argVal != null) {
                if (!argVal.matches("[0-9.]*") && DataPumpOption.getEnumFromString(VERSION_VALUES.class, argVal) == null) {
                    this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "version", argVal));
                    this._model.isValid(false);
                }
            } else {
                this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_MISSING_OPT_VALUE", "version", argVal));
                this._model.isValid(false);
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "filesize", argVal));
            this._model.getToolLogger().log(NL + e.getLocalizedMessage());
            this._model.isValid(false);
        }
        argVal = this._args.getString("jobname");
        try {
            argVal = argVal != null && !argVal.isEmpty() ? this.generateJobName(argVal) : this.generateJobName(this._model.isExport() ? "ESQL_" : "ISQL_");
            this._args.put("jobname", argVal);
        }
        catch (Exception e) {
            this._model.getToolLogger().log(e.getLocalizedMessage());
            this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "version", argVal));
            this._model.isValid(false);
        }
        String en = this._args.getString("encryption");
        String ena = this._args.getString("encryptionalgorithm");
        String enm = this._args.getString("encryptionmode");
        Boolean enp = this._args.has("encryptionpassword");
        if (en == null && (ena != null || enm != null)) {
            this._args.put("encryption", DataPumpOptions.ENCRYPTION_VALUES.ALL.toString());
            en = this._args.getString("encryption");
        }
        if (en != null && en.equalsIgnoreCase(DataPumpOptions.ENCRYPTION_VALUES.NONE.toString()) && enp.booleanValue()) {
            this.currentSettingsInvalid(new String[]{"encryption", "encryptionpassword"});
            this._model.isValid(false);
        } else if (enp.booleanValue() && !this._args.contains("encryption")) {
            this._args.put("encryption", DataPumpOptions.ENCRYPTION_VALUES.ALL.toString());
        } else if (en != null && en.equalsIgnoreCase(DataPumpOptions.ENCRYPTION_VALUES.NONE.toString())) {
            if (enm != null) {
                this.currentSettingsInvalid(new String[]{"encryptionmode", "encryption"});
                this._model.isValid(false);
            }
        } else if (!(en == null || en.equalsIgnoreCase(DataPumpOptions.ENCRYPTION_VALUES.NONE.toString()) || enp.booleanValue() || enm != null && enm.equalsIgnoreCase(DataPumpOptions.ENCRYPTIONMODE_VALUES.TRANSPARENT.toString()) || enm == null)) {
            this.currentSettingsInvalid(new String[]{"encryption", "encryptionmode", "encryptionpassword"});
            this._model.isValid(false);
        } else if (enm != null && enm.equalsIgnoreCase(DataPumpOptions.ENCRYPTIONMODE_VALUES.TRANSPARENT.toString()) && enp.booleanValue()) {
            this.currentSettingsInvalid(new String[]{"encryptionmode", "encryptionpassword"});
            this._model.isValid(false);
        } else if (enm != null && (enm.equalsIgnoreCase(DataPumpOptions.ENCRYPTIONMODE_VALUES.DUAL.toString()) || enm.equalsIgnoreCase(DataPumpOptions.ENCRYPTIONMODE_VALUES.PASSWORD.toString())) && !enp.booleanValue()) {
            this.currentSettingsInvalid(new String[]{"encryptionmode", "encryptionpassword"});
            this._model.isValid(false);
        } else if (!(enp.booleanValue() || enm == null || enm != null && enm.equalsIgnoreCase(DataPumpOptions.ENCRYPTIONMODE_VALUES.TRANSPARENT.toString()) || ena == null)) {
            this.currentSettingsInvalid(new String[]{"encryptionmode", "encryptionpassword", "encryptionalgorithm"});
            this._model.isValid(false);
        }
        if (this._model.isValid() && this._args.has("encryptionpassword") && this._args.getString("encryptionpassword") == null) {
            String thepassword = this._model.getCtx().getPromptedFieldProvider().getPromptedField(this._model.getCtx(), "encryptionpassword ", true);
            if (thepassword == null || thepassword.equals("")) {
                this._model.getToolLogger().logError(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", "encryptionpassword", DataPumpResources.get("DPPRE_NULL")));
                this._model.isValid(false);
            } else {
                this._args.put("encryptionpassword", thepassword);
            }
        }
        if ((argVal = this._args.getString("encryptionpassword")) != null && argVal.startsWith(DQ) && argVal.endsWith(DQ) && argVal.length() > 1) {
            argVal = argVal.substring(1, argVal.length() - 1);
            this._args.put("encryptionpassword", argVal);
        }
        if (this._model.isValid() && enm == null && en != null && !en.equalsIgnoreCase(DataPumpOptions.ENCRYPTION_VALUES.NONE.toString()) && enp != null && !enp.booleanValue()) {
            this._model.getToolLogger().log(DataPumpResources.get("DPTDE"));
        }
        return this._model.isValid();
    }

    public void currentSettingsInvalid(String[] settings) {
        Object buildUp = new String();
        for (String setting : settings) {
            String val = null;
            if (setting.equals("encryptionpassword")) {
                if (this._args.contains("encryptionpassword")) {
                    buildUp = (String)buildUp + DataPumpResources.format("DPPRE_NAME_VALUE", setting, DataPumpResources.get("DPPRE_VALUE")) + NL;
                    continue;
                }
                buildUp = (String)buildUp + DataPumpResources.format("DPPRE_NAME_VALUE", setting, DataPumpResources.get("DPPRE_NULL")) + NL;
                continue;
            }
            val = this._args.getString(setting);
            buildUp = val == null ? (String)buildUp + DataPumpResources.format("DPPRE_NAME_VALUE", setting, DataPumpResources.get("DPPRE_NULL")) + NL : (String)buildUp + DataPumpResources.format("DPPRE_NAME_VALUE", setting, val) + NL;
        }
        this._model.getToolLogger().logError(DataPumpResources.get("DPPRE_OPTION_SETTINGS") + NL + (String)buildUp);
    }

    public boolean checkAccess() {
        String arg;
        this.handleSchemas();
        this.handleRemapSchema();
        this.handleRemapTablespace();
        ArrayList<String> defaultFiles = this.handleListArg("dumpfile", true);
        if (defaultFiles == null) {
            defaultFiles = new ArrayList();
            defaultFiles.add(this._args.getString("jobname") + ".DMP");
            this._args.put("dumpfile", defaultFiles);
        }
        if ((arg = this._args.getString("dumpuri")) != null && arg.equalsIgnoreCase("false")) {
            this._args.remove("dumpuri");
        } else if (this._model.isArgTrue("dumpuri")) {
            this._args.put("dumpuri", null);
        }
        if (this._model.isArgTrue("copycloud")) {
            this.handleDirectory("dumpdirectory");
            this.handleProfile();
            this.handleUri(defaultFiles);
        } else if (!this._args.contains("dumpuri")) {
            this.handleDirectory("dumpdirectory");
        } else {
            this.handleCredential("credential");
            this.handleUri(defaultFiles);
        }
        this.handleDirectory("logdirectory");
        return this._model.isValid();
    }

    public boolean handleMultipleFiles() {
        String[] fileArray;
        String uri = (String)this._args.get("dumpuri");
        Object defaultFile = (String)this._args.get("dumpfile");
        if (defaultFile == null) {
            defaultFile = this._args.getString("jobname") + ".DMP";
        }
        if ((fileArray = this.utilSplit((String)defaultFile, ",")) != null) {
            if (!this._args.contains("dumpuri")) {
                ArrayList<String> putBackFiles = new ArrayList<String>();
                for (String oneFile : fileArray) {
                    putBackFiles.add(this.unquote(oneFile));
                }
                this._args.put("dumpfile", putBackFiles);
                if (this._args.getString("dumpdirectory") == null && this._args.getString("directory") != null) {
                    this._args.put("dumpdirectory", this.cleanName(this._args.getString("directory")));
                }
            } else {
                System.out.println("Not coded yet 'uri side'");
            }
        }
        return this._model.isValid();
    }

    public boolean handleSupport() {
        String cloudService = this.getCloudService();
        if (cloudService != null) {
            this._model.setCloudService(cloudService);
            if (this._model.isDWCS()) {
                this._model.getArgs().put("trace", "167144-96");
                this._model.getArgs().put("dwcscvtiots", "TRUE");
                this._model.getArgs().put("dwcscvtconstraints", "TRUE");
                this._model.getArgs().put("excludedwcs", "IN (CLUSTER, CLUSTERING, DB_LINK, INDEXTYPE)");
                this._model.getArgs().put("partitionoptions", "MERGE");
                this._model.getArgs().put("segmentattributes", "FALSE");
            } else if (this._model.isOLTP()) {
                this._model.getArgs().put("trace", "167144-96");
                this._model.getArgs().put("dwcscvtiots", "TRUE");
                this._model.getArgs().put("dwcscvtconstraints", "TRUE");
                this._model.getArgs().put("excludedwcs", "IN (CLUSTER, CLUSTERING, DB_LINK, INDEXTYPE)");
            }
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessEnd();
        }
        return this._model.isValid();
    }

    private void handleDirectory(String dirKey) {
        String defaultDir = this.cleanName(this._args.getString("directory"));
        String dir = this.cleanName(this._args.getString(dirKey));
        if (dir != null && !dir.isEmpty()) {
            if (!this.existsDirectory(dir)) {
                this._model.isValid(false);
                this._model.getToolLogger().log(DataPumpResources.format("DPPRE_DIR_ERROR", dir));
            }
            this._args.put(dirKey, dir);
        } else if (defaultDir != null && !defaultDir.isEmpty()) {
            if (!this.existsDirectory(defaultDir)) {
                this._model.isValid(false);
                this._model.getToolLogger().log(DataPumpResources.format("DPPRE_DIR_ERROR", defaultDir));
            } else {
                this._args.put(dirKey, defaultDir);
            }
        }
    }

    private void handleCredential(String credKey) {
        String defaultCred = this.cleanName(this._args.getString("credential"));
        if (defaultCred != null && !defaultCred.isEmpty()) {
            if (this.existsCredential(defaultCred)) {
                this._args.put(credKey, defaultCred);
            } else {
                this._model.getToolLogger().log(DataPumpResources.format("DPPRE_CRED_ERROR", defaultCred));
                this._model.isValid(false);
            }
        } else {
            String csCred = this.checkCredential();
            if (csCred != null && !csCred.isEmpty()) {
                this._args.put(credKey, csCred);
            } else {
                this._model.getToolLogger().log(DataPumpResources.getString("DPPRE_NO_CRED"));
                this._model.isValid(false);
            }
        }
    }

    private void handleProfile() {
        Map csProps = (Map)this._model.getCtx().getProperty("cloud.storage");
        if (csProps != null) {
            String profile = (String)csProps.get("oci.profile.name");
            if (profile == null || profile.isEmpty()) {
                this._model.isValid(false);
                this._model.getToolLogger().log(DataPumpResources.getString("DPPRE_PROFILE_ERR") + NL);
            }
            this._args.put("oci.profile.name", profile);
        } else {
            this._model.isValid(false);
            this._model.getToolLogger().log(DataPumpResources.getString("DPPRE_PROFILE_ERR") + NL);
        }
    }

    private void handleUri(ArrayList<String> defaultNames) {
        block8: {
            Map csProps = (Map)this._model.getCtx().getProperty("cloud.storage");
            CloudStorageUrl csUrl = null;
            ArrayList<String> fileUris = null;
            if (this._args.getString("dumpuri") != null) {
                fileUris = this.handleListArg("dumpuri");
            }
            Object defaultName = null;
            if (csProps != null) {
                csUrl = (CloudStorageUrl)csProps.get("cloud_url");
            }
            try {
                if (fileUris != null) {
                    boolean i = false;
                    if (fileUris.size() == 1 && defaultNames.size() > 1) {
                        this._args.put("dumpuri", this.handleUriBucketSpec(fileUris, defaultNames, csUrl));
                    } else {
                        this._args.put("dumpuri", this.handleUriMultiSpec(fileUris, defaultNames, csUrl));
                    }
                    break block8;
                }
                if (csUrl != null) {
                    fileUris = new ArrayList();
                    this._args.put("dumpuri", this.handleUriNoUriSpec(fileUris, defaultNames, csUrl));
                    break block8;
                }
                throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_MISSING", "dumpuri"));
            }
            catch (MalformedURLException e) {
                this._model.isValid(false);
                this._model.getToolLogger().log(e.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> handleUriBucketSpec(List<String> fileUris, List<String> defaultNames, CloudStorageUrl csUrl) throws MalformedURLException {
        CloudStorageUrl csFinalUrl = null;
        ArrayList<String> newFileUris = new ArrayList<String>();
        String fileUri = fileUris.get(0);
        if (fileUri.startsWith("https://")) {
            try {
                csFinalUrl = new CloudStorageUrl(fileUri);
                csFinalUrl.validateUrlAsBucket();
            }
            catch (MalformedURLException e) {
                throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
            }
        }
        if (csUrl == null) throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
        try {
            csFinalUrl = new CloudStorageUrl(csUrl.getFinalUrl());
            if (!fileUri.isEmpty()) {
                csFinalUrl.qualifiedUrl(fileUri);
            }
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
        }
        int i = 0;
        for (String defaultName : defaultNames) {
            csFinalUrl.qualifiedUrl(csFinalUrl.isSwiftUrl() ? "/" + defaultName : "/o/" + defaultName);
            newFileUris.add(i, csFinalUrl.getFinalUrl().toString());
            ++i;
        }
        return newFileUris;
    }

    private List<String> handleUriMultiSpec(List<String> fileUris, List<String> defaultNames, CloudStorageUrl csUrl) throws MalformedURLException {
        CloudStorageUrl csFinalUrl = null;
        String nameSpace = null;
        ArrayList<String> newFileUris = new ArrayList<String>();
        URL baseUrl = null;
        int i = 0;
        for (String fileUri : fileUris) {
            String defaultName;
            String string = defaultName = i + 1 > defaultNames.size() ? "" : defaultNames.get(i);
            if (fileUri.startsWith("https://")) {
                try {
                    csFinalUrl = new CloudStorageUrl(fileUri);
                    csFinalUrl.validateUrlAsObject();
                    newFileUris.add(i, csFinalUrl.getFinalUrl().toString());
                }
                catch (MalformedURLException e) {
                    try {
                        csFinalUrl.validateUrlAsBucket();
                        csFinalUrl.qualifiedUrl(csFinalUrl.isSwiftUrl() ? "/" + defaultName : "/o/" + defaultName);
                        newFileUris.add(i, csFinalUrl.getFinalUrl().toString());
                    }
                    catch (MalformedURLException e2) {
                        throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
                    }
                }
            } else if (csUrl != null) {
                try {
                    if (baseUrl == null) {
                        baseUrl = csUrl.getFinalUrl();
                    }
                    csFinalUrl = new CloudStorageUrl(baseUrl);
                    if (!fileUri.isEmpty()) {
                        csFinalUrl.qualifiedUrl(fileUri);
                    }
                    csFinalUrl.validateUrlAsObject();
                    newFileUris.add(i, csFinalUrl.getFinalUrl().toString());
                }
                catch (MalformedURLException e) {
                    throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
                }
            } else {
                throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", fileUri));
            }
            if (nameSpace == null) {
                nameSpace = csFinalUrl.getNameSpace();
            }
            if (!csFinalUrl.getNameSpace().equals(nameSpace)) {
                throw new MalformedURLException(DataPumpResources.getString("DPPRE_URI_NAMESPACE_ERR"));
            }
            ++i;
        }
        return newFileUris;
    }

    private List<String> handleUriNoUriSpec(List<String> fileUris, List<String> defaultNames, CloudStorageUrl csUrl) throws MalformedURLException {
        CloudStorageUrl csFinalUrl = null;
        URL baseUrl = null;
        ArrayList<String> newFileUris = new ArrayList<String>();
        try {
            baseUrl = csUrl.getFinalUrl();
            csFinalUrl = new CloudStorageUrl(baseUrl);
            csFinalUrl.validateUrlAsObject();
            newFileUris.add(0, csFinalUrl.getFinalUrl().toString());
        }
        catch (MalformedURLException e) {
            int i = 0;
            for (String defaultName : defaultNames) {
                String objectName = csFinalUrl.isSwiftUrl() ? "/" + defaultName : "/o/" + defaultName;
                try {
                    csFinalUrl = new CloudStorageUrl(baseUrl);
                    csFinalUrl.validateUrlAsBucket();
                    csFinalUrl.qualifiedUrl(objectName);
                    newFileUris.add(i, csFinalUrl.getFinalUrl().toString());
                }
                catch (MalformedURLException e2) {
                    throw new MalformedURLException(DataPumpResources.format("DPPRE_URI_ERROR", "dumpuri", String.valueOf(csFinalUrl.getFinalUrl()) + objectName));
                }
                ++i;
            }
        }
        return newFileUris;
    }

    private ArrayList<String> handleListArg(String option) {
        return this.handleListArg(option, false);
    }

    private ArrayList<String> handleListArg(String option, boolean isUnquote) {
        String listArg = this._args.getString(option);
        try {
            if (listArg != null && !listArg.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                String[] objects = this.utilSplit(listArg, ",");
                if (objects != null) {
                    for (String object : objects) {
                        list.add(isUnquote ? this.unquote(object) : object);
                    }
                }
                this._args.put(option, list);
                return list;
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
        return null;
    }

    private ArrayList<String> handleListSetArg(String option) {
        String listArg = this._args.getString(option);
        try {
            if (listArg != null && !listArg.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                String[] sets = this.utilSplit(listArg, ";");
                if (sets != null) {
                    for (String set : sets) {
                        String[] objects = this.utilSplit(set, ",");
                        if (objects == null) continue;
                        for (String object : objects) {
                            list.add(object);
                        }
                    }
                }
                this._args.put(option, list);
                return list;
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
        return null;
    }

    private void handleFilterName() {
        String[] values;
        boolean count;
        HashMap<String, Object> nameMap;
        String[] sets;
        String nameArg = this._args.getString("nameexpr");
        try {
            if (nameArg != null && !nameArg.isEmpty()) {
                sets = this.utilSplit(nameArg, ";");
                nameMap = new HashMap<String, Object>();
                count = false;
                if (sets != null) {
                    for (String typeName : sets) {
                        values = typeName.split("=", 2);
                        if (values.length != 2) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_NAME_EXPR", nameArg));
                            this._model.isValid(false);
                            continue;
                        }
                        nameMap.put(this.cleanObjectType(values[0]), this.unquote(values[1]));
                    }
                }
                this._args.put("nameexpr", nameMap);
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
        nameArg = this._args.getString("namelist");
        try {
            if (nameArg != null && !nameArg.isEmpty()) {
                sets = this.utilSplit(nameArg, ";");
                nameMap = new HashMap();
                if (sets != null) {
                    count = false;
                    for (String typeName : sets) {
                        values = typeName.split("=", 2);
                        if (values.length != 2) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_NAME_LIST", nameArg));
                            this._model.isValid(false);
                            continue;
                        }
                        String[] names = this.utilSplit(values[1], ",");
                        ArrayList<String> list = new ArrayList<String>();
                        if (names != null) {
                            for (String name : names) {
                                String cleanSource = this.cleanName(name);
                                list.add(cleanSource);
                            }
                        }
                        nameMap.put(this.cleanObjectType(values[0]), list);
                    }
                }
                this._args.put("namelist", nameMap);
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
    }

    private void handleRemapSchema() {
        String remapArg = this._args.getString("remapschemas");
        try {
            if (remapArg != null && !remapArg.isEmpty()) {
                String[] mappings = this.utilSplit(remapArg, ",");
                HashMap<String, String> reMap = new HashMap<String, String>();
                if (mappings != null) {
                    boolean count = false;
                    for (String mapping : mappings) {
                        String[] values = mapping.split("=");
                        if (values.length != 2) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_MAP_SCHEMA", remapArg));
                            this._model.isValid(false);
                            continue;
                        }
                        String cleanSource = this.cleanName(values[0]);
                        String cleanTarget = this.cleanName(values[1]);
                        if (!this.assertName(cleanSource)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_SCHEMA_NAME", cleanSource));
                            this._model.isValid(false);
                        }
                        if (!this.assertName(cleanTarget)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_SCHEMA_NAME", cleanTarget));
                            this._model.isValid(false);
                        }
                        reMap.put(cleanSource, cleanTarget);
                    }
                }
                this._args.put("remapschemas", reMap);
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
    }

    private void handleRemapTablespace() {
        String remapArg = this._args.getString("remaptablespaces");
        try {
            if (remapArg != null && !remapArg.isEmpty()) {
                String[] mappings = this.utilSplit(remapArg, ",");
                HashMap<String, String> reMap = new HashMap<String, String>();
                if (mappings != null) {
                    boolean count = false;
                    for (String mapping : mappings) {
                        String[] values = mapping.split("=");
                        if (values.length != 2) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_MAP_TABLESPACE", remapArg));
                            this._model.isValid(false);
                            continue;
                        }
                        String cleanSource = this.cleanName(values[0]);
                        String cleanTarget = this.cleanName(values[1]);
                        if (!this.assertName(cleanSource)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_TABLESPACE_NAME", cleanSource));
                            this._model.isValid(false);
                        }
                        if (!this.assertName(cleanTarget)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_TABLESPACE_NAME", cleanTarget));
                            this._model.isValid(false);
                        } else if (this._model.isImport() && !this.existsTablespace(cleanTarget)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_TABLESPACE", cleanTarget));
                            this._model.isValid(false);
                        }
                        reMap.put(cleanSource, cleanTarget);
                    }
                }
                this._args.put("remaptablespaces", reMap);
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSchemas() {
        List schemasArg = (List)this._args.get("schemas");
        ArrayList<String> schemasList = new ArrayList<String>();
        try {
            this._args.put("jobmode", "SCHEMA");
            if (schemasArg == null || schemasArg.isEmpty()) {
                if (!this._model.isExport()) {
                    this._args.put("jobmode", "FULL");
                    return;
                }
                schemasList.add(this._model.getSchema());
            } else {
                String[] schemas = (String[])schemasArg.toArray(String[]::new);
                if (schemas != null) {
                    for (String schema : schemas) {
                        String cleanName = this.cleanName(schema);
                        if (this._model.isExport() && !this.existsSchema(cleanName)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_SCHEMA", schema));
                            this._model.isValid(false);
                        } else if (!this.assertName(schema)) {
                            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_SCHEMA_NAME", schema));
                            this._model.isValid(false);
                        }
                        schemasList.add(cleanName);
                    }
                }
            }
            this._args.put("schemas", schemasList);
            return;
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
    }

    private void handleArgConversions() {
        if (this._model.isArgTrue("columnencryption")) {
            this._args.remove("columnencryption");
        } else {
            this._args.put("columnencryption", "TRUE");
        }
        if (this._model.isArgTrue("flashbackscn")) {
            this._args.put("flashbackscn", "dbms_flashback.get_system_change_number");
        } else {
            this._args.remove("flashbackscn");
        }
        if (this._model.isArgTrue("tablecompression")) {
            this._args.remove("tablecompression");
        } else {
            this._args.put("tablecompression", "NONE");
        }
        Map<String, DataPumpOption> options = DataPumpGenOptions.getGenBooleanOptions();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            String key = entry.getKey();
            if (opt.getGenBoolean().equals("t")) {
                if (this._model.isArgTrue(key)) continue;
                this._args.remove(key);
                continue;
            }
            if (!this._model.isArgTrue(key)) continue;
            this._args.remove(key);
        }
        this._args.put("excludeexpr", this.unquote(this._args.getString("excludeexpr")));
        this.handleListArg("excludelist");
        this._args.put("excludelist", this.cleanObjectTypeList("excludelist"));
        this._args.put("includeexpr", this.unquote(this._args.getString("includeexpr")));
        this.handleListArg("includelist");
        this._args.put("includelist", this.cleanObjectTypeList("includelist"));
        this.handleFilterName();
    }

    private String cleanName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.startsWith(DQ) && name.endsWith(DQ)) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    private String cleanObjectType(String type) {
        if (type.startsWith(DQ) && type.endsWith(DQ) && type.length() > 1) {
            return type.substring(1, type.length() - 1).toUpperCase();
        }
        return type;
    }

    private List<String> cleanObjectTypeList(String arg) {
        List<String> types = this._args.getList(arg);
        if (types == null || types.isEmpty()) {
            return null;
        }
        ArrayList<String> cleanTypes = new ArrayList<String>();
        for (String type : types) {
            if (type.startsWith(DQ) && type.endsWith(DQ) && type.length() > 1) {
                cleanTypes.add(type.substring(1, type.length() - 1).toUpperCase());
                continue;
            }
            cleanTypes.add(type.toUpperCase());
        }
        return cleanTypes;
    }

    private String unquote(String string) {
        if (string != null && !string.isEmpty() && string.startsWith(DQ) && string.endsWith(DQ) && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean existsCredential(String name) {
        String value = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpExistsCredential", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("CREDENTIAL_NAME", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean existsDirectory(String name) {
        String value = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpExistsDirectory", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("DIRECTORY", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean existsSchema(String name) {
        String value = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpExistsSchema", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("SCHEMA", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean existsTablespace(String name) {
        String value = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpExistsTablespace", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("TABLESPACE", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean assertName(String name) {
        String value = null;
        try {
            String query = DataPumpQuery.getQuery("datapumpAssertName", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("NAME", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null;
    }

    private String checkCredential() {
        Map props = (Map)this._model.getCtx().getProperty("cloud.storage");
        if (props != null) {
            return (String)props.get("dbms.cloud.credential");
        }
        return null;
    }

    private String generateJobName(String name) throws SQLException {
        String value = null;
        String cleanName = this.cleanName(name);
        if (cleanName != null && cleanName.length() > 1 && Character.isDigit(cleanName.charAt(cleanName.length() - 1)) && !Character.isDigit(cleanName.charAt(0))) {
            value = cleanName;
        } else {
            String query = DataPumpQuery.getQuery("datapumpGenerateJobName", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("NAME", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        return value;
    }

    private String getCloudService() {
        String cloudService = null;
        try {
            String query = DataPumpQuery.getQuery("datapump_cloudService", this._model.getConn());
            if (query != null) {
                cloudService = (String)this.executeOneCol(query);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return cloudService;
    }

    private Object executeOneCol(String query) throws SQLException {
        return this.executeOneCol(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOneCol(String query, Map<String, Object> binds) throws SQLException {
        String rtn = null;
        if (LockManager.lock((Connection)this._model.getConn())) {
            try {
                DBUtil dbUtil = DBUtil.getInstance((Connection)this._model.getConn());
                rtn = dbUtil.executeReturnOneCol(query, binds);
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            finally {
                LockManager.unlock((Connection)this._model.getConn());
            }
        }
        return rtn;
    }

    private String[] utilSplit(String baseString, String separator) {
        String[] retVal = null;
        String nullBase = baseString;
        String nullSeparator = separator;
        if (baseString == null) {
            nullBase = "";
        }
        if (separator == null) {
            nullSeparator = "";
        }
        if (baseString == null || separator == null) {
            retVal = null;
        } else {
            retVal = baseString.split(separator, -1);
            boolean isNull = false;
            for (String val : retVal) {
                if (!val.isEmpty()) continue;
                isNull = true;
            }
            if (retVal == null || retVal.length == 0) {
                isNull = true;
            }
            if (isNull) {
                retVal = null;
            }
        }
        if (retVal == null) {
            this._model.getToolLogger().logError(DataPumpResources.format("DPPRE_INVALID_LIST", nullBase, nullSeparator));
            this._model.isValid(false);
        }
        return retVal;
    }

    protected static enum FILESIZE_VALUES {
        B,
        KB,
        MB,
        GB,
        TB;

    }

    protected static enum VERSION_VALUES {
        COMPATIBLE,
        LATEST;

    }
}

