/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

public class DataPumpOption {
    private Operation _operation = null;
    private SubProgram _subProgram = null;
    private String _subProgramId = null;
    private ParameterType _type = ParameterType.STRING;
    private String _genBoolean = null;
    private Class _validValues = null;

    public DataPumpOption(Operation operation, SubProgram subProgram, String subProgramId) {
        this(operation, subProgram, subProgramId, ParameterType.STRING, null, null);
    }

    public DataPumpOption(Operation operation, SubProgram subProgram, String subProgramId, ParameterType type) {
        this(operation, subProgram, subProgramId, type, null, null);
    }

    public DataPumpOption(Operation operation, SubProgram subProgram, String subProgramId, ParameterType type, String genBoolean) {
        this(operation, subProgram, subProgramId, type, genBoolean, null);
    }

    public DataPumpOption(Operation operation, SubProgram subProgram, String subProgramId, ParameterType type, String genBoolean, Class validValues) {
        this._operation = operation;
        this._subProgram = subProgram;
        this._subProgramId = subProgramId;
        this._type = type;
        this._validValues = validValues;
        this._genBoolean = genBoolean;
    }

    public Operation getOperation() {
        return this._operation;
    }

    public SubProgram getSubProgram() {
        return this._subProgram;
    }

    public String getSubProgramId() {
        return this._subProgramId;
    }

    public Class getValidValuesClass() {
        return this._validValues;
    }

    public boolean isValidValue(String value) {
        if (this._validValues == null) {
            return true;
        }
        return DataPumpOption.getEnumFromString(this._validValues, value) != null;
    }

    public String getGenBoolean() {
        return this._genBoolean;
    }

    public ParameterType getParameterType() {
        return this._type;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static enum ParameterType {
        BOOLEAN,
        NUMBER,
        PLSQL,
        STRING;

    }

    public static enum Operation {
        EXPORT,
        IMPORT,
        BOTH;

    }

    public static enum SubProgram {
        FILE,
        FILTER,
        LOGFILE,
        OPEN,
        PARALLEL,
        PARAMETER,
        DATA_FILTER,
        DUMPFILE,
        METADATA_TRANSFORM,
        REMAP,
        SCHEMAS,
        START,
        UNKNOWN,
        WAIT;

    }
}

