/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.arbori.util.Array;
import oracle.arbori.util.IntegerMap;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.js.JavaScript;

public class SqlEarley
extends Earley
implements Parseable {
    private static SqlEarley fullRecInst = null;
    private static final String fname = "allRules.txt";
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static Set<RuleTuple> origRules = null;
    private int as;
    private int aliased_dml_table_expression_clause;
    private int basic_decl_item;
    private int basic_decl_item_list;
    private int begin;
    private int body;
    private int boolean_primary;
    private int column;
    private int compound_expression;
    private int condition;
    public int CONNECT;
    private int dbtools_lexeme;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int ELSE;
    private int expr;
    private int function_expression;
    private int grouping_expression_list;
    private int json_object_arg_list;
    private int model_expression;
    private int arg_list;
    private int arg_star_list;
    public int multiset_except;
    private int name_wo_function_call;
    private int pkg_spec;
    private int pls_expr;
    public int query_block;
    public int REPLACE;
    public int select;
    public int simple_expression;
    public int sim_stmt;
    public int sql_statement;
    public int sql_statements;
    public int sqlplus_lexeme;
    public int sqlplus_command;
    public int sqlplus_command1;
    private int start;
    public int stmt;
    public int subquery;
    public int table;
    public int table_reference;
    private int unlabeled_nonblock_stmt;
    private int user_defined_types;
    private int where_gby_hier;
    private int HEX_LITERAL;
    private int RegExpLiteral;
    private int StringLiteral;
    private int TemplateLiteral;
    private int[] whatToRecognize = new int[0];
    int END = this.getSymbol("'END'");
    int RPAREN = this.getSymbol("')'");
    int semi = this.getSymbol("';'");
    String[] matchingTerminals = new String[this.allSymbols.length];
    private int[] notOptimizableHeadSymbols;
    boolean isAsc;
    public static String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'NATURAL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'VARCHAR2'", "'INTEGER'", "'WHEN'"};
    private Set<Integer> _keywords;
    private Set<Integer> _JSkeywords;

    public static void amendGrammar() throws IOException {
        String input = Service.readFile(SqlEarley.class, "amended.grammar");
        List<LexerToken> src = Lexer.parse(input);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, rules);
        SqlEarley.extendGrammar(rules);
    }

    @Deprecated
    public static SqlEarley partialRecognizer() {
        return SqlEarley.getInstance();
    }

    public static synchronized SqlEarley getInstance() {
        if (fullRecInst == null) {
            fullRecInst = SqlEarley.newFullRecognizer();
        }
        return fullRecInst;
    }

    private static SqlEarley newFullRecognizer() {
        SqlEarley ret = new SqlEarley();
        ret.addSymbol2Recognize("sql_statements");
        ret.addSymbol2Recognize("subprg_body");
        ret.addSymbol2Recognize("expr");
        return ret;
    }

    public SqlEarley grammarExtension(Set<RuleTuple> additionalRules) {
        Set<RuleTuple> originalRules = SqlEarley.getRules();
        this.extractSymbols(additionalRules);
        this.rules = Arrays.copyOf(this.rules, originalRules.size() + additionalRules.size());
        int p = originalRules.size();
        for (RuleTuple t : additionalRules) {
            if (t.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t.toString()));
            }
            int h = (Integer)this.symbolIndexes.get(t.head);
            int[] rhs = new int[t.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = (Integer)this.symbolIndexes.get(t.rhs[i]);
            }
            this.rules[p++] = new Parser.Tuple(h, rhs);
        }
        return this;
    }

    public static void extendGrammar(Set<RuleTuple> additionalRules) {
        fullRecInst = SqlEarley.newFullRecognizer().grammarExtension(additionalRules);
    }

    public static Set<RuleTuple> extractRules() throws Exception {
        Class<SqlEarley> refClass = SqlEarley.class;
        URL u = refClass.getResource("/oracle/dbtools/parser/plsql/allRules.txt");
        if (u == null) {
            u = Service.fileNameGitResource(refClass, fname);
        }
        InputStream is = u.openStream();
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.trim();
            int colonPos = token.indexOf(": ");
            String head = token.substring(0, colonPos);
            StringTokenizer st1 = new StringTokenizer(token.substring(colonPos + ": ".length()), " ");
            LinkedList<String> rhs = new LinkedList<String>();
            while (st1.hasMoreTokens()) {
                rhs.add(st1.nextToken());
            }
            rules.add(new RuleTuple(head, rhs));
        }
        is.close();
        return rules;
    }

    static synchronized Set<RuleTuple> getRules() {
        if (origRules == null) {
            try {
                origRules = SqlEarley.extractRules();
                origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
                origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("function_call", new String[]{"name", "'('", "')'"}));
                origRules.add(new RuleTuple("function_call", new String[]{"dotted_name", "'('", "')'"}));
                origRules.remove(new RuleTuple("function_call", new String[]{"name", "'('", "call_arg", "')'"}));
                origRules.remove(new RuleTuple("function_call", new String[]{"name", "'('", "call_arg", "call_arg_list", "')'"}));
                origRules.remove(new RuleTuple("inline_constraint___0", new String[]{"references_clause"}));
                origRules.add(new RuleTuple("call_statement", new String[]{"call_statement", "'.'", "procedure_call"}));
                origRules.add(new RuleTuple("call_statement", new String[]{"call_statement", "'.'", "procedure_call", "'INTO'", "name"}));
                origRules.remove(new RuleTuple("condition", new String[]{"expr"}));
                origRules.remove(new RuleTuple("arg_list", new String[]{"arg_list", "arg"}));
                origRules.add(new RuleTuple("cast_expression_arg", new String[]{"expr"}));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return origRules;
    }

    public SqlEarley() {
        this(SqlEarley.getRules());
    }

    private SqlEarley(Set<RuleTuple> rules) {
        super(rules, false);
        for (int i = 0; i < this.allSymbols.length; ++i) {
            String symbol = this.allSymbols[i];
            if (symbol.charAt(0) != '\'') continue;
            this.matchingTerminals[i] = symbol.substring(1, symbol.length() - 1);
        }
        this.notOptimizableHeadSymbols = null;
        this.isAsc = false;
        this._keywords = new TreeSet<Integer>();
        this._JSkeywords = new TreeSet<Integer>();
        this.initKeywords();
        this.as = this.getSymbol("'AS'");
        this.aliased_dml_table_expression_clause = this.getSymbol("aliased_dml_table_expression_clause");
        this.basic_decl_item = this.getSymbol("basic_decl_item");
        this.basic_decl_item_list = this.getSymbol("basic_decl_item_list");
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.boolean_primary = this.getSymbol("boolean_primary");
        this.column = this.getSymbol("column");
        this.compound_expression = this.getSymbol("compound_expression");
        this.condition = this.getSymbol("condition");
        this.CONNECT = this.getSymbol("CONNECT");
        this.dbtools_lexeme = this.getSymbol("dbtools_lexeme");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.ELSE = this.getSymbol("'ELSE'");
        this.expr = this.getSymbol("expr");
        this.function_expression = this.getSymbol("function_expression");
        this.grouping_expression_list = this.getSymbol("grouping_expression_list");
        this.json_object_arg_list = this.getSymbol("json_object_arg_list");
        this.model_expression = this.getSymbol("model_expression");
        this.arg_list = this.getSymbol("arg_list");
        this.arg_star_list = this.getSymbol("arg_star_list");
        this.multiset_except = this.getSymbol("multiset_except");
        this.name_wo_function_call = this.getSymbol("name_wo_function_call");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.pls_expr = this.getSymbol("pls_expr");
        this.query_block = this.getSymbol("query_block");
        this.REPLACE = this.getSymbol("'REPLACE'");
        this.select = this.getSymbol("select");
        this.simple_expression = this.getSymbol("simple_expression");
        this.sim_stmt = this.getSymbol("sim_stmt");
        this.sql_statement = this.getSymbol("sql_statement");
        this.sql_statements = this.getSymbol("sql_statements");
        this.sqlplus_lexeme = this.getSymbol("sqlplus_lexeme");
        this.sqlplus_command = this.getSymbol("sqlplus_command");
        this.sqlplus_command1 = this.getSymbol("sqlplus_command#");
        this.start = this.getSymbol("'START'");
        this.stmt = this.getSymbol("stmt");
        this.subquery = this.getSymbol("subquery");
        this.table = this.getSymbol("table");
        this.table_reference = this.getSymbol("table_reference");
        this.unlabeled_nonblock_stmt = this.getSymbol("unlabeled_nonblock_stmt");
        this.user_defined_types = this.getSymbol("user_defined_types");
        this.where_gby_hier = this.getSymbol("\"where,gby,hier\"");
        this.HEX_LITERAL = this.getSymbol("HEX_LITERAL");
        this.RegExpLiteral = this.getSymbol("RegExpLiteral");
        this.StringLiteral = this.getSymbol("string_literal");
        this.TemplateLiteral = this.getSymbol("TemplateLiteral");
        this.prioritizeRules();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("adt_field"), new int[]{this.getSymbol("method_specification"), this.getSymbol("field")});
        this.prioritizeRules(this.getSymbol("\"alter_pluggable_database_clause\""), new int[]{this.getSymbol("pdb_datafile_clause"), this.getSymbol("pdb_change_state_from_root")});
        this.prioritizeRules(this.getSymbol("alter_table___0#"), new int[]{this.getSymbol("constraint_clauses"), this.getSymbol("column_clauses"), this.getSymbol("alter_external_table")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("lag"), this.getSymbol("lead"), this.getSymbol("a_f")});
        this.prioritizeRules(this.getSymbol("arg"), new int[]{this.getSymbol("pls_expr"), this.getSymbol("expr#")});
        String plsRule = "assoc_arg:  assoc_name_list  '='  '>'  pls_expr;";
        String sqlRule = "assoc_arg:  sim_expr  '='  '>'  expr;";
        this.swapRules(plsRule, sqlRule);
        this.prioritizeRules(this.getSymbol("basic_d"), new int[]{this.getSymbol("subprg_i"), this.getSymbol("object_d")});
        this.prioritizeRules(this.basic_decl_item, new int[]{this.getSymbol("pragma"), this.getSymbol("basic_d")});
        this.prioritizeRules(this.boolean_primary, new int[]{this.getSymbol("'TRUE'"), this.getSymbol("'FALSE'"), this.getSymbol("sim_expr"), this.condition, this.function_expression});
        String simExprRule = "boolean_primary:  sim_expr;";
        String boolPriRule = "boolean_primary:  condition;";
        this.swapRules(simExprRule, boolPriRule);
        this.prioritizeRules(this.getSymbol("cell_assignment___0"), new int[]{this.getSymbol("multi_column_for_loop"), this.getSymbol("cell_assignment___1")});
        this.prioritizeRules(this.getSymbol("col_properties___0"), new int[]{this.getSymbol("out_of_line_ref_constraint"), this.getSymbol("out_of_line_constraint"), this.getSymbol("column_definition")});
        this.prioritizeRules(this.getSymbol("column_definition___0#"), new int[]{this.getSymbol("inline_ref_constraint"), this.getSymbol("inline_constraint")});
        this.prioritizeRules(this.getSymbol("column_definition___2"), new int[]{this.getSymbol("expr"), this.getSymbol("condition")});
        String condExprRule = "\"cond_or_expr\":  expr;";
        String condModelRule = "\"cond_or_expr\":  model_condition;";
        this.swapRules(condExprRule, condModelRule);
        String rule2 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause;";
        String rule3 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause  insert_into_clause___0;";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.compound_expression, new int[]{this.getSymbol("expr"), this.getSymbol("compound_expression___1")});
        this.prioritizeRules(this.condition, new int[]{this.getSymbol("compound_condition"), this.getSymbol("comparison_condition"), this.getSymbol("null_condition"), this.getSymbol("JSON_condition"), this.getSymbol("simple_expression"), this.function_expression});
        this.prioritizeRules(this.getSymbol("datetime_expression___1"), new int[]{this.getSymbol("'DBTIMEZONE'"), this.getSymbol("string_literal"), this.expr});
        this.prioritizeRules(this.getSymbol("expr#"), new int[]{this.simple_expression, this.compound_expression, this.function_expression, this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression"), this.getSymbol("JSON_object_access_expr"), this.getSymbol("model_expression"), this.getSymbol("compound_condition")});
        this.prioritizeRules(this.getSymbol("\"expr|Dexpr|condition\""), new int[]{this.expr, this.condition});
        this.prioritizeRules(this.function_expression, new int[]{this.getSymbol("function"), this.getSymbol("function_call")});
        rule2 = "function_expression:  function_call;";
        rule3 = "function_expression:  function_expression  '.'  function_call;";
        this.swapRules(rule2, rule3);
        rule3 = "function_expression:  function_expression  '.'  identifier;";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("analytic_function"), this.getSymbol("aggregate_function"), this.getSymbol("timebucket_function"), this.getSymbol("single_row_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("group_by_col"), new int[]{this.getSymbol("rollup_cube_clause"), this.getSymbol("expr")});
        this.prioritizeRules(this.getSymbol("modify_column_clauses___1"), new int[]{this.getSymbol("modify_col_visibility"), this.getSymbol("modify_col_properties"), this.getSymbol("virtual_column_definition")});
        this.prioritizeRules(this.getSymbol("pdb_change_state"), new int[]{this.getSymbol("pdb_change_state___0"), this.identifier});
        this.prioritizeRules(this.pls_expr, new int[]{this.getSymbol("pls_expr"), this.getSymbol("and_expr")});
        this.prioritizeRules(this.getSymbol("procedure_call"), new int[]{this.getSymbol("pseudocol"), this.getSymbol("name")});
        this.prioritizeRules(this.getSymbol("query_table_expression"), new int[]{this.getSymbol("xmltable"), this.getSymbol("table_collection_expression"), this.function_expression});
        this.prioritizeRules(this.getSymbol("select_term"), new int[]{this.expr, this.getSymbol("\"aliased_expr\""), this.getSymbol("\"aliased_condition\"")});
        this.prioritizeRules(this.simple_expression, new int[]{this.getSymbol("literal"), this.getSymbol("pseudocol"), this.getSymbol("'CONNECT_BY_ROOT'"), this.getSymbol("'CONNECT_BY_ISCYCLE'"), this.getSymbol("'CONNECT_BY_ISLEAF'"), this.getSymbol("identifier"), this.getSymbol("column")});
        this.prioritizeRules(this.sim_stmt, new int[]{this.getSymbol("null_stmt"), this.getSymbol("exit_stmt"), this.getSymbol("continue_stmt"), this.getSymbol("raise_stmt"), this.getSymbol("return_stmt"), this.getSymbol("procedure_call")});
        rule2 = "subquery:  subquery  SET_OPER  subquery;";
        rule3 = "subquery:  subquery  \"where,gby,hier\";";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("ty_def"), new int[]{this.getSymbol("array_ty_def"), this.getSymbol("tbl_ty_def")});
        this.prioritizeRules(this.getSymbol("unconstrained_type_wo_datetime_wo_national"), new int[]{this.getSymbol("pls_number_datatypes"), this.getSymbol("link_expanded_n")});
        this.prioritizeRules(this.unlabeled_nonblock_stmt, new int[]{this.getSymbol("sql_stmt"), this.sim_stmt});
        this.prioritizeRules(this.getSymbol("values_clause___0"), new int[]{this.getSymbol("par_expr_list"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___3"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___6"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
    }

    private void prioritizeRules(int head, int[] symbols) {
        int[] ruleNumbers = new int[symbols.length];
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t = this.rules[i];
            if (t.head != head || t.rhs.length != 1 && t.head != this.boolean_primary && t.head != this.basic_decl_item && t.head != this.compound_expression && t.head != this.function_expression && t.head != this.simple_expression && t.head != this.pls_expr && t.head != this.unlabeled_nonblock_stmt && t.head != this.sim_stmt) continue;
            for (int j = 0; j < symbols.length; ++j) {
                if (t.rhs[0] != symbols[j]) continue;
                ruleNumbers[j] = i;
                continue block0;
            }
        }
        Parser.Tuple[] tuples = new Parser.Tuple[symbols.length];
        for (int j = 0; j < symbols.length; ++j) {
            tuples[j] = this.rules[ruleNumbers[j]];
        }
        Arrays.sort(ruleNumbers);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            this.rules[ruleNumbers[i]] = tuples[i];
        }
    }

    public void addSymbol2Recognize(String additionalSymbol) {
        this.addSymbol2Recognize(this.getSymbol(additionalSymbol));
    }

    public void addSymbol2Recognize(int additionalSymbol) {
        int[] tmp = new int[this.whatToRecognize.length + 1];
        for (int i = 0; i < this.whatToRecognize.length; ++i) {
            if (this.whatToRecognize[i] == additionalSymbol) {
                return;
            }
            tmp[i] = this.whatToRecognize[i];
        }
        tmp[this.whatToRecognize.length] = additionalSymbol;
        this.whatToRecognize = tmp;
    }

    public void nullifySymbol2Recognize() {
        this.whatToRecognize = new int[0];
    }

    @Override
    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        matrix.initCells(src.size());
        if (src.size() == 0) {
            return;
        }
        this.initCell(matrix, this.whatToRecognize, 0, null);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(t2 - t1));
        }
        LexerToken LAtoken = src.get(0);
    }

    protected boolean scan(Matrix matrix, List<LexerToken> src, long[] deletedXs) {
        int x;
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        if (deletedXs != null) {
            for (long range : deletedXs) {
                for (x = Service.lX(range); x < Service.lY(range); ++x) {
                    matrix.allXs = Array.delete(matrix.allXs, x);
                }
            }
            deletedXs = null;
        }
        LexerToken token = src.get(y);
        String tokUpper = token.content.toUpperCase();
        Integer suspect = (Integer)this.symbolIndexes.get("'" + tokUpper + "'");
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect, deletedXs)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect, deletedXs)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect, long[] deletedXs) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        Parser.EarleyCell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        String lookahead = null;
        if (y < src.size() - 2) {
            lookahead = src.get((int)(y + 1)).content.toUpperCase();
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Parser.Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || pos < t.size() - 2 && !this.lookaheadOK(t.rhs[pos + 1], lookahead)) continue;
            long cellElem = SqlEarley.makeMatrixCellElem(ruleNo, pos + 1, t);
            content = Array.insert(content, cellElem);
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[x];
            int n = y + 1;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        return true;
    }

    @Override
    protected boolean lookaheadOK(int s, String lookahead) {
        if (lookahead == null) {
            return true;
        }
        String terminal = this.matchingTerminals[s];
        if (terminal == null) {
            return true;
        }
        return terminal.startsWith(lookahead);
    }

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect, boolean isJsRule) {
        LexerToken next;
        LexerToken token = src.get(y);
        if (symbol == this.RegExpLiteral && token.type == Token.REGEXP) {
            return true;
        }
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken prior = null;
        if (!isJsRule && suspect != null && this._keywords.contains(suspect)) {
            if (0 < y) {
                prior = src.get(y - 1);
            }
            if (prior == null || !":".equals(prior.content)) {
                return false;
            }
        }
        if (isJsRule && suspect != null && this._JSkeywords.contains(suspect)) {
            return false;
        }
        if (!isJsRule && token.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (token.type != Token.IDENTIFIER) {
            return false;
        }
        if (suspect == null) {
            return true;
        }
        if (prior == null && 0 < y) {
            prior = src.get(y - 1);
        }
        if ("TO".equalsIgnoreCase(token.content) && prior != null && ("YEAR".equalsIgnoreCase(prior.content) || "HOUR".equalsIgnoreCase(prior.content) || "MINUTE".equalsIgnoreCase(prior.content))) {
            return false;
        }
        if ("IF".equalsIgnoreCase(token.content) && prior != null && "TABLE".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("BY".equalsIgnoreCase(token.content) && prior != null && "CONNECT".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("CASE".equalsIgnoreCase(token.content) && y + 1 < src.size() && "WHEN".equalsIgnoreCase(src.get((int)(y + 1)).content)) {
            return false;
        }
        if (("LEFT".equalsIgnoreCase(token.content) || "CROSS".equalsIgnoreCase(token.content) || "FULL".equalsIgnoreCase(token.content)) && y < src.size() - 1) {
            LexerToken next2 = src.get(y + 1);
            return !"JOIN".equalsIgnoreCase(next2.content);
        }
        if ("INNER".equalsIgnoreCase(token.content) && y < src.size() - 1) {
            LexerToken next3 = src.get(y + 1);
            if ("JOIN".equalsIgnoreCase(next3.content)) {
                return false;
            }
            return prior == null || !"NATURAL".equalsIgnoreCase(prior.content);
        }
        if (prior != null && "FROM".equalsIgnoreCase(prior.content) && ("FIRST".equalsIgnoreCase(token.content) || "LAST".equalsIgnoreCase(token.content))) {
            next = null;
            if (y + 1 < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && ("OVER".equalsIgnoreCase(next.content) || "IGNORE".equalsIgnoreCase(next.content) || "RESPECT".equalsIgnoreCase(next.content))) {
                return false;
            }
        }
        if ("AS".equalsIgnoreCase(token.content) && prior != null && "@".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("BETWEEN".equalsIgnoreCase(token.content)) {
            next = null;
            if (y < src.size() - 1) {
                next = src.get(y + 1);
            }
            if (next != null && "-".equalsIgnoreCase(next.content)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Parser.Tuple t, Integer suspect) {
        boolean isJsRule;
        LexerToken token = src.get(y);
        int symbol = t.content(pos);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.BQUOTED_STRING) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        if (symbol == this.dbtools_lexeme && token.type == Token.DBTOOLS_COMMAND) {
            return true;
        }
        if (symbol == this.sqlplus_lexeme && token.type == Token.SQLPLUS_COMMAND) {
            return true;
        }
        String head = this.allSymbols[t.head];
        boolean bl = isJsRule = 3 < head.length() && Character.isUpperCase(head.charAt(0)) && Character.isLowerCase(head.charAt(1));
        if (isJsRule && symbol == this.string_literal && token.type == Token.DQUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect, isJsRule) && (suspect == null || this.notConfusedAsId(suspect, t.head, pos));
    }

    @Override
    protected boolean notConfusedAsId(int suspect, int head, int pos) {
        return !(suspect == this.begin && (head == this.dotted_name || head == this.decl_id) && pos == 0 || suspect == this.start && head == this.table_reference && pos == 1 || suspect == this.distinct && head == this.multiset_except && pos == 3 || suspect == this.body && head == this.pkg_spec && pos == 1 || suspect == this.as && head == this.table_reference && pos == 1 || suspect == this.ELSE && head == this.aliased_dml_table_expression_clause && pos == 1 || suspect == this.REPLACE && head == this.user_defined_types && pos == 0);
    }

    @Override
    protected boolean isOptimizable(Parser.Tuple tuple, int preSym, int mid, int y) {
        int headSym;
        int i;
        if (preSym == this.sql_statement && y < mid + 3) {
            return false;
        }
        if (this.notOptimizableHeadSymbols == null) {
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.grouping_expression_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.json_object_arg_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.model_expression);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.arg_star_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.compound_expression);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("alter_system___0"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("alter_system___1"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("column"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("column_definition___0#"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("dotted_expr"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("elsif_clause_opt"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("member_condition"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("object_access_expression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("opaque_format_spec"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("physical_properties"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("pivot_clause___0#"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("table_properties___0"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("function_call"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("duality_subquery"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("LabeledStatement"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("MemberExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("FunctionExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("AssignmentExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("IfStatement"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("Statement_List1"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("MethodDefinition_List1"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("BinaryExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("default_clause"));
        }
        if (this.notOptimizableHeadSymbols[i = Array.indexOf(this.notOptimizableHeadSymbols, headSym = tuple.head)] == headSym) {
            return false;
        }
        if (this.subquery == headSym && tuple.rhs.length == 2 && tuple.rhs[1] == this.getSymbol("row_limiting_clause")) {
            return false;
        }
        return super.isOptimizable(headSym, preSym, mid, y);
    }

    @Override
    protected boolean isAsc(int ruleHead) {
        return ruleHead == this.getSymbol("sql_statements") || ruleHead == this.getSymbol("subquery");
    }

    public int recognize(List<LexerToken> src) {
        Matrix matrix = new Matrix(SqlEarley.getInstance());
        this.parse(src, matrix);
        for (int i = src.size(); 0 < i; --i) {
            Parser.EarleyCell top = matrix.get(0, i);
            if (top == null) continue;
            return i;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    void initKeywords() {
        for (String k : keywords) {
            this._keywords.add(this.getSymbol(k));
        }
        for (String k : JavaScript.keywords) {
            this._JSkeywords.add(this.getSymbol("'" + k.toUpperCase() + "'"));
        }
    }

    public void reInitKeywords(String[] replacement) {
        this._keywords.clear();
        for (String k : replacement) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    protected void postprocess(ParseNode ret, Parser.EarleyCell cell) {
        if (ret.contains(this.subquery) && !ret.contains(this.query_block)) {
            for (ParseNode child : ret.children()) {
                if (!child.contains(this.query_block)) continue;
                child.deleteContent(this.query_block);
            }
            ret.addContent(this.query_block);
        }
        if (ret.contains(this.arg_star_list)) {
            ret.addContent(this.arg_list);
        }
        if (cell != null && !ret.contains(this.name_wo_function_call) && !ret.contains(this.table)) {
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                int pos = cell.getPosition(i);
                Parser.Tuple tuple = this.rules[rule];
                if (pos < tuple.rhs.length || tuple.head != this.column) continue;
                ret.addContent("column");
                break;
            }
        }
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Parser.Tuple t = this.rules[rule];
            if (t.head != this.sql_statements && t.head != this.select || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        return super.treeForACell(src, m, cell, x, y);
    }

    @Override
    public boolean isAuxNode(int symbol) {
        return this.where_gby_hier == symbol;
    }

    public static SqlEarley newPartialRecognizer(String[] strings) {
        throw new AssertionError((Object)"Deprecated");
    }

    @Override
    protected ParseNode tree(List<LexerToken> src, Matrix m, int X, int Y, int Rule, int Pos) {
        LinkedList<Invocation> invocations = new LinkedList<Invocation>();
        Stack<Invocation> stack = new Stack<Invocation>();
        Invocation first = new Invocation(X, Y, Rule, Pos, null, null);
        stack.add(first);
        block0: while (stack.size() != 0) {
            Parser.EarleyCell pre;
            Invocation current = (Invocation)stack.pop();
            invocations.add(current);
            int x = current.x;
            int y = current.y;
            int rule = current.rule;
            int pos = current.pos;
            int h = this.rules[rule].head;
            if (pos != 0 && (pre = m.get(x, y - 1)) != null) {
                long demotedRule = SqlEarley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
                int indexOfDemotedRule = Array.indexOf(pre.getContent(), 0, pre.size() - 1, demotedRule);
                long ruleAtTheIndex = pre.content[indexOfDemotedRule];
                if (ruleAtTheIndex == demotedRule) {
                    Parser.Tuple t = this.rules[rule];
                    LexerToken token = src.get(y - 1);
                    Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
                    if (this.isScannedSymbol(y - 1, src, pos - 1, t, suspect)) {
                        ParseNode branch = new ParseNode(y - 1, y, this.rules[rule].rhs[pos - 1], this);
                        if (x + 1 == y) {
                            if (this.rules[rule].rhs.length == 1) {
                                branch.addContent(h);
                            }
                            current.node = branch;
                            continue;
                        }
                        int head = h;
                        if (pos != this.rules[rule].rhs.length) {
                            head = -1;
                        }
                        ParseNode ret = new ParseNode(x, y, head, this);
                        ret.rgt = branch;
                        ret.rgt.parent = ret;
                        current.node = ret;
                        stack.add(new Lft(x, y - 1, rule, pos - 1, current, null));
                        continue;
                    }
                }
            }
            if (pos != 0) {
                long demotedRule = SqlEarley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
                IntegerMap cellsAtY = m.getXRange(y);
                for (int mid : this.isAsc(h) ? cellsAtY.keySet() : cellsAtY.descendingKeySet()) {
                    Parser.EarleyCell post;
                    Parser.EarleyCell pre2 = m.get(x, mid);
                    if (pre2 == null || (post = m.get(mid, y)) == null || pre2.content[Array.indexOf(pre2.content, 0, pre2.size() - 1, demotedRule)] != demotedRule) continue;
                    for (int j = 0; j <= post.size() - 1; ++j) {
                        int rJ = post.getRule(j);
                        int pJ = post.getPosition(j);
                        if (this.rules[rJ].rhs.length != pJ || this.rules[rJ].head != this.rules[rule].rhs[pos - 1]) continue;
                        if (x != mid) {
                            ParseNode ret;
                            current.node = ret = new ParseNode(x, y, this.rules[rule].rhs.length != pos ? -1 : h, this);
                            stack.add(new Lft(x, mid, rule, pos - 1, current, m.get(x, mid)));
                            stack.add(new Rgt(mid, y, rJ, pJ, current, m.get(mid, y)));
                            continue block0;
                        }
                        if (rJ == rule && pJ == pos) continue;
                        this.diagnose(m, x, y);
                        stack.add(new Ret(mid, y, rJ, pJ, current, m.get(x, y)));
                        continue block0;
                    }
                }
            }
            throw new AssertionError((Object)("unwind " + this.rules[rule].toString(pos) + " @[" + x + "," + y + ")"));
        }
        Iterator iterator = invocations.descendingIterator();
        Invocation current = null;
        while (iterator.hasNext()) {
            current = (Invocation)iterator.next();
            current.finish();
        }
        return current.node;
    }

    class Invocation {
        int x;
        int y;
        int rule;
        int pos;
        Invocation caller;
        ParseNode node;
        Parser.EarleyCell cell;

        public Invocation(int x, int y, int rule, int pos, Invocation caller, Parser.EarleyCell cell) {
            this.cell = cell;
            this.rule = rule;
            this.pos = pos;
            this.x = x;
            this.y = y;
            this.caller = caller;
        }

        public String toString() {
            Parser.Tuple t = SqlEarley.this.rules[this.rule];
            return this.getClass().getName() + "  [" + this.x + "," + this.y + ")  " + t.toString(this.pos);
        }

        void finish() {
            if (SqlEarley.this.rules[this.rule].rhs.length == this.pos) {
                int h = SqlEarley.this.rules[this.rule].head;
                this.node.addContent(h);
            }
            SqlEarley.this.postprocess(this.node, this.cell);
        }
    }

    class Lft
    extends Invocation {
        public Lft(int x, int y, int rule, int pos, Invocation parent, Parser.EarleyCell cell) {
            super(x, y, rule, pos, parent, cell);
        }

        @Override
        void finish() {
            this.caller.node.lft = this.node;
            this.node.parent = this.caller.node;
            super.finish();
        }
    }

    class Rgt
    extends Invocation {
        public Rgt(int x, int y, int rule, int pos, Invocation parent, Parser.EarleyCell cell) {
            super(x, y, rule, pos, parent, cell);
        }

        @Override
        void finish() {
            this.caller.node.rgt = this.node;
            this.node.parent = this.caller.node;
            super.finish();
        }
    }

    class Ret
    extends Invocation {
        public Ret(int x, int y, int rule, int pos, Invocation parent, Parser.EarleyCell cell) {
            super(x, y, rule, pos, parent, cell);
        }

        @Override
        void finish() {
            this.caller.node = this.node;
            super.finish();
        }
    }
}

