/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;

public class ParsedSql
extends Parsed {
    static SqlEarley partialRecognizer = SqlEarley.getInstance();
    static int library_unit = partialRecognizer.getSymbol("library_unit");
    static int create_plsql = partialRecognizer.getSymbol("create_plsql");
    static int call_statement = partialRecognizer.getSymbol("call_statement");
    static int sqlplus_command = partialRecognizer.getSymbol("sqlplus_command");
    static int sql_statement = partialRecognizer.getSymbol("sql_statement");
    static int sql_stmt = partialRecognizer.getSymbol("sql_stmt");
    static int unlabeled_nonblock_stmt = partialRecognizer.getSymbol("unlabeled_nonblock_stmt");

    public ParsedSql(String input) {
        this(input, false);
    }

    public ParsedSql(String input, boolean partialRecognizer) {
        super(input, partialRecognizer ? SqlEarley.partialRecognizer() : SqlEarley.getInstance(), "sql_statements");
        this.lexer = new Lexer();
    }

    @Override
    public synchronized List<LexerToken> getSrc() {
        if (this.src != null) {
            return this.src;
        }
        this.src = this.lexer.doParse(this.input, false, 1087);
        return this.src;
    }

    public synchronized ParseNode parse() {
        if (this.earley == null) {
            throw new AssertionError((Object)"earley == null");
        }
        if (this.root == null) {
            this.getSrc();
            Visual visual = null;
            if (this.debug) {
                visual = new Visual(this.src, this.earley);
            }
            this.matrix = new Matrix(this.earley);
            try {
                ((SqlEarley)this.earley).doParse(this.src, this.matrix);
            }
            catch (ParsingCancelled e) {
                this.src = null;
                throw new AssertionError((Object)"getSrc(): parse cancelled");
            }
            if (this.debug) {
                visual.draw(this.matrix);
            }
            this.root = this.earley.forest(this.src, this.matrix);
        }
        return this.root;
    }

    @Override
    public synchronized ParseNode getRoot() {
        return this.parse();
    }

    public boolean contains(String symbol) {
        for (ParseNode desc : this.getRoot().descendants()) {
            String ddl;
            ParsedSql parsed;
            boolean ret;
            if (desc.contains(symbol)) {
                return true;
            }
            if (!desc.contains("string_literal") || desc.parent() == null || !desc.parent().contains("exec_immediate_statement") || !(ret = (parsed = new ParsedSql(ddl = this.getInput().substring(this.getSrc().get((int)desc.from).begin + 1, this.getSrc().get((int)(desc.to - 1)).end - 1))).contains(symbol))) continue;
            return ret;
        }
        return false;
    }

    public static Language partialRecognize(String input) {
        List<LexerToken> src = Lexer.parse(input);
        if (src.size() == 0) {
            throw new AssertionError((Object)("empty input: `" + input + "`"));
        }
        SqlEarley earley = partialRecognizer;
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        int symbol = ParsedSql.leftBottomSymbol(matrix);
        return ParsedSql.crawlRulesDependency(symbol);
    }

    private static int leftBottomSymbol(Matrix matrix) {
        block0: for (int i = matrix.lastY(); 0 < i; --i) {
            Parser.EarleyCell cell = matrix.get(0, i);
            if (cell == null) continue;
            int bestRule = 0;
            int advanced = 0;
            for (int j = 0; j < cell.size(); ++j) {
                int rule = cell.getRule(j);
                int pos = cell.getPosition(j);
                Parser.Tuple tuple = ParsedSql.partialRecognizer.rules[rule];
                if (advanced < pos || pos == tuple.rhs.length) {
                    bestRule = rule;
                    advanced = pos;
                }
                if (pos != tuple.rhs.length) continue;
                if (tuple.head == ParsedSql.partialRecognizer.sql_statements || tuple.head == sql_statement || tuple.head == library_unit) continue block0;
                return tuple.head;
            }
            Parser.Tuple tuple = ParsedSql.partialRecognizer.rules[bestRule];
            return tuple.head;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    private static Language crawlRulesDependency(int symbol) {
        if (symbol == sql_stmt) {
            return Language.SQL;
        }
        if (symbol == create_plsql || symbol == call_statement || symbol == unlabeled_nonblock_stmt) {
            return Language.PLSQL;
        }
        if (symbol == sqlplus_command) {
            return Language.SQLPLUS;
        }
        if (symbol == sql_statement) {
            return Language.SQL;
        }
        for (int i = 0; i < SqlEarley.getInstance().rules.length; ++i) {
            Parser.Tuple tuple = SqlEarley.getInstance().rules[i];
            if (tuple.head == tuple.rhs[0] || tuple.rhs[0] != symbol) continue;
            try {
                return ParsedSql.crawlRulesDependency(tuple.head);
            }
            catch (AssertionError e) {
                // empty catch block
            }
        }
        throw new AssertionError((Object)("failed to follow dependency chain for " + SqlEarley.getInstance().allSymbols[symbol]));
    }

    public static void main(String[] args) throws Exception {
        ParsedSql.test("begin\n execute immediate 'drop materialized view x';end;", true);
        ParsedSql.test("drop materialized view x", true);
        ParsedSql.test("begin\n execute immediate 'create table x ( i integer );end;", false);
        ParsedSql.test("create table x ( i integer );", false);
        System.out.println("4 tests are OK");
    }

    private static void test(String input, Language cmp) {
        if (ParsedSql.partialRecognize(input) != cmp) {
            System.out.println("**** Failed on\n" + input + "\nRecognized " + String.valueOf((Object)ParsedSql.partialRecognize(input)));
        } else {
            System.out.println(input + " -- OK");
        }
    }

    private static boolean test(String input, boolean expected) {
        boolean cmp = new ParsedSql(input).contains("'DROP'");
        if (cmp != expected) {
            throw new AssertionError((Object)(input + "\n expected = " + expected + "\n actual = " + cmp));
        }
        return true;
    }

    public static String[] embeddedSelects(String input) {
        List<LexerToken> src = Lexer.parse(input);
        LinkedList<String> ret = new LinkedList<String>();
        int pos = 0;
        while (pos < src.size()) {
            LexerToken candidate = src.get(pos);
            if (!"SELECT".equals(candidate.content.toUpperCase())) {
                ++pos;
                continue;
            }
            int begin = pos;
            if ((pos = ParsedSql.embeddedSelectEndPos(src, begin)) == -1) break;
            ret.add(input.substring(src.get((int)begin).begin, src.get((int)(pos - 1)).end));
        }
        return ret.toArray(new String[0]);
    }

    public static int embeddedSelectEndPos(List<LexerToken> input, int startPos) {
        List<LexerToken> src = input.subList(startPos, input.size());
        SqlEarley earley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        ParseNode root = earley.forest(src, matrix);
        ParseNode select = ParsedSql.firstSelect(root);
        if (select != null) {
            return startPos + select.to;
        }
        return -1;
    }

    private static ParseNode firstSelect(ParseNode node) {
        if (node.contains("select")) {
            return node;
        }
        Iterator iterator = node.children().iterator();
        if (iterator.hasNext()) {
            ParseNode child = (ParseNode)iterator.next();
            return ParsedSql.firstSelect(child);
        }
        return null;
    }

    public static enum Language {
        SQL,
        PLSQL,
        SQLPLUS;

    }
}

