/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.script.ScriptEngine;
import oracle.arbori.scripting.GlobalMap;
import oracle.arbori.util.Service;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.parser.plsql.SqlEarley;

public class SqlProgram
extends Program {
    public SqlProgram(Class<?> dir, String file) throws IOException {
        this(dir, file, null);
    }

    public SqlProgram(Class<?> dir, String file, Object struct) throws IOException {
        this(Service.readFile(dir, file), struct);
    }

    public SqlProgram(String programText) throws IOException {
        this(programText, null);
    }

    public SqlProgram(String programText, Object struct) throws IOException {
        super(SqlEarley.getInstance(), struct);
        try {
            this.compile(programText, struct);
        }
        catch (javax.script.ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SqlProgram(String programText, Object struct, ScriptEngine engine, GlobalMap globals, boolean allowJS) throws IOException {
        super(SqlEarley.getInstance(), struct, engine, globals, allowJS);
        try {
            this.compile(programText, struct);
        }
        catch (javax.script.ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, Object callback) throws IOException, ScriptException {
        return this.run(input, src, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, String[] rootSyntax, Object callback) throws IOException, ScriptException {
        return this.run(input, src, rootSyntax, callback, SqlEarley.getInstance());
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, String[] rootSyntax, Object callback, Earley parser) throws IOException, ScriptException {
        if (src == null) {
            src = Lexer.parse(input);
        }
        Parsed target = new Parsed(input, src, parser, rootSyntax);
        Map<String, MaterializedPredicate> predicateVectors = this.eval(target, callback);
        return predicateVectors;
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src) throws IOException, ScriptException {
        return this.run(input, src, null);
    }

    public Map<String, MaterializedPredicate> run(String input, Object callback) throws IOException, ScriptException {
        return this.run(input, null, callback);
    }

    public Map<String, MaterializedPredicate> run(String input) throws IOException, ScriptException {
        return this.run(input, null, null);
    }

    static void visitor(String sql, String condition, final BiFunction<Parsed, ParseNode, Object> callback) throws Exception {
        ParsedSql target = new ParsedSql(sql);
        String prg = "visitor: " + condition + " ->";
        SqlProgram program = new SqlProgram(prg);
        program.compile(prg);
        program.eval(target, new Object(){

            public void visitor(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode node = tuple.get("node");
                callback.apply(target, node);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        String sql = "select 1,2 from dual";
        String condition = "[node) select_term";
        BiFunction<Parsed, ParseNode, Object> callback = (target, node) -> {
            System.out.println(node.toString() + " :::: " + node.content(target.getSrc()));
            return null;
        };
        SqlProgram.visitor(sql, condition, callback);
    }
}

