/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.locks.ReentrantLock;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.SessionCloseHandler;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationEngine;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.util.Logger;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.StatusLine;

public class Session {
    private static final String AUTH_HEADER = "Authorization";
    private static final String PATH_SEPARATOR = "/";
    private SessionInfo m_info;
    private URI m_root;
    private transient State m_state = State.CLOSED;
    private Authentication m_auth;
    private transient ReentrantLock m_lock;
    private URI m_baseURI;
    private Client m_client;
    private SessionCloseHandler mCloseHandler;

    Session(SessionInfo info, Client client, Authentication auth) {
        this.m_info = info;
        this.m_root = info.getServerRoot();
        this.m_auth = auth;
        this.m_client = client;
        this.m_lock = new ReentrantLock();
        this.m_baseURI = info.getServiceRoot();
    }

    public URI getRoot() {
        return this.m_root;
    }

    public URI getDefaultServiceURI() {
        return this.m_baseURI;
    }

    public boolean isOpen() {
        return this.m_state == State.OPEN;
    }

    void setCloseHandler(SessionCloseHandler h) {
        this.mCloseHandler = h;
    }

    void open() throws SessionException {
        if (this.m_state == State.OPEN) {
            return;
        }
        this.m_lock.lock();
        try {
            this.m_state = State.OPEN;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.m_lock.lock();
            try {
                this.m_auth = null;
                this.m_state = State.CLOSED;
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    private static void signRequest(HttpRequest request, Authentication auth) {
        request.removeHeaders(AUTH_HEADER);
        String authToken = auth.getToken();
        BasicHeader header = new BasicHeader(AUTH_HEADER, (Object)("Bearer " + authToken));
        request.addHeader((Header)header);
    }

    public <V> V executeQuery(String path, HttpClientResponseHandler<V> handler) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        return this.executeQueryImpl(path, handler);
    }

    public <V> V executeQuery(URI uri, HttpClientResponseHandler<V> handler) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        HttpGet request = new HttpGet(uri);
        return this.executeImpl(handler, (HttpUriRequest)request);
    }

    private <V> V executeQueryImpl(String path, HttpClientResponseHandler<V> handler) throws SessionException {
        HttpGet request = new HttpGet(this.getURI(path));
        return this.executeImpl(handler, (HttpUriRequest)request);
    }

    public CloseableHttpResponse executeQuery(String path) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        return this.executeQueryImpl(path);
    }

    public CloseableHttpResponse executeQuery(URI uri) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        HttpGet request = new HttpGet(uri);
        return this.executeImpl((HttpUriRequest)request);
    }

    private CloseableHttpResponse executeQueryImpl(String path) throws SessionException {
        HttpGet request = new HttpGet(this.getURI(path));
        return this.executeImpl((HttpUriRequest)request);
    }

    private <V> V executeImpl(HttpClientResponseHandler<V> handler, HttpUriRequest request) throws SessionException {
        Session.signRequest((HttpRequest)request, this.m_auth);
        try {
            try {
                Logger.info(Session.class, (String)("HTTP Request: " + request.getMethod() + "; URI: " + String.valueOf(request.getUri())));
                return this.m_client.executeRequest(request, new ResponseHandlerWrapper<V>(handler));
            }
            catch (AuthenticationFailedException e) {
                StatusLine line = e.getStatusLine();
                int code = line.getStatusCode();
                switch (code) {
                    case 401: {
                        AuthenticationEngine engine = this.m_client.getAuthenticationEngine();
                        try {
                            Authentication newAuth = null;
                            try {
                                newAuth = engine.reauthenticate(this.m_auth, this.m_info);
                            }
                            catch (AuthenticationFailedException afe) {
                                newAuth = engine.authenticate(this.m_info);
                            }
                            if (newAuth != null) {
                                this.m_auth = newAuth;
                                Session.signRequest((HttpRequest)request, this.m_auth);
                                V result = this.m_client.executeRequest(request, new ResponseHandlerWrapper<V>(handler));
                                return result;
                            }
                        }
                        catch (AuthenticationFailedException afe) {
                            this.mCloseHandler.connectionClosed(this.m_info.getName());
                            Throwable cause = afe.getCause();
                            if (cause instanceof IOException) {
                                throw (IOException)cause;
                            }
                            if (cause instanceof ClientProtocolException) {
                                throw (ClientProtocolException)cause;
                            }
                            throw afe;
                        }
                        return null;
                    }
                }
                throw e;
            }
        }
        catch (ClientProtocolException e) {
            Logger.warn(Session.class, (Throwable)e);
            throw new SessionException(e);
        }
        catch (IOException | URISyntaxException e) {
            Logger.warn(Session.class, (Throwable)e);
            throw new SessionException(e);
        }
    }

    private CloseableHttpResponse executeImpl(HttpUriRequest request) throws SessionException {
        try {
            CloseableHttpResponse response = null;
            try {
                response = this.executeImplCheckAuthorization(request);
            }
            catch (AuthenticationFailedException e) {
                StatusLine line = e.getStatusLine();
                int code = line.getStatusCode();
                switch (code) {
                    case 401: {
                        AuthenticationEngine engine = this.m_client.getAuthenticationEngine();
                        try {
                            Authentication newAuth = null;
                            try {
                                newAuth = engine.reauthenticate(this.m_auth, this.m_info);
                            }
                            catch (AuthenticationFailedException afe) {
                                newAuth = engine.authenticate(this.m_info);
                            }
                            if (newAuth == null) break;
                            this.m_auth = newAuth;
                            Session.signRequest((HttpRequest)request, this.m_auth);
                            response = this.executeImplCheckAuthorization(request);
                            break;
                        }
                        catch (AuthenticationFailedException afe) {
                            this.mCloseHandler.connectionClosed(this.m_info.getName());
                            Throwable cause = afe.getCause();
                            if (cause instanceof IOException) {
                                throw (IOException)cause;
                            }
                            if (cause instanceof ClientProtocolException) {
                                throw (ClientProtocolException)cause;
                            }
                            throw afe;
                        }
                    }
                }
                throw e;
            }
            return response;
        }
        catch (ClientProtocolException e) {
            Logger.warn(Session.class, (Throwable)e);
            throw new SessionException(e);
        }
        catch (IOException | URISyntaxException e) {
            Logger.warn(Session.class, (Throwable)e);
            throw new SessionException(e);
        }
    }

    private CloseableHttpResponse executeImplCheckAuthorization(HttpUriRequest request) throws ClientProtocolException, IOException, AuthenticationFailedException, URISyntaxException {
        Session.signRequest((HttpRequest)request, this.m_auth);
        Logger.info(Session.class, (String)("HTTP Request: " + request.getMethod() + "; URI: " + String.valueOf(request.getUri())));
        CloseableHttpResponse result = this.m_client.executeRequest(request);
        int code = result.getCode();
        Logger.info(Session.class, (String)("HTTP Response code: " + code));
        if (code == 401) {
            try {
                result.close();
            }
            catch (IOException io) {
                Logger.warn(Session.class, (Throwable)io);
            }
            throw new AuthenticationFailedException(new StatusLine((HttpResponse)result));
        }
        return result;
    }

    public <V> V executeRequest(HttpUriRequest post, HttpClientResponseHandler<V> handler) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        return this.executeImpl(handler, post);
    }

    public CloseableHttpResponse executeRequest(HttpUriRequest request) throws SessionException {
        if (!this.isOpen()) {
            throw new SessionException("connection closed");
        }
        return this.executeImpl(request);
    }

    public HttpPost createPost(String path) {
        URI uri = this.getURI(path);
        return this.createPost(uri);
    }

    public HttpPost createPost(URI uri) {
        return new HttpPost(uri);
    }

    public HttpPut createPut(URI uri) {
        return new HttpPut(uri);
    }

    public HttpPut createPut(String path) {
        URI uri = this.getURI(path);
        return this.createPut(uri);
    }

    public HttpDelete createDelete(URI uri) {
        return new HttpDelete(uri);
    }

    public HttpDelete createDelete(String path) {
        URI uri = this.getURI(path);
        return this.createDelete(uri);
    }

    private URI getURI(String path) {
        String realPath = path.startsWith(PATH_SEPARATOR) ? path.substring(1) : path;
        return this.m_baseURI.resolve(realPath);
    }

    private static enum State {
        OPEN,
        CLOSED;

    }

    private static class ResponseHandlerWrapper<V>
    implements HttpClientResponseHandler<V> {
        private final HttpClientResponseHandler<V> m_handler;

        ResponseHandlerWrapper(HttpClientResponseHandler<V> handler) {
            this.m_handler = handler;
        }

        public V handleResponse(ClassicHttpResponse response) throws ClientProtocolException, IOException, HttpException {
            int code = response.getCode();
            Logger.info(Session.class, (String)("HTTP Response code: " + code));
            switch (code) {
                case 401: {
                    throw new AuthenticationFailedException(new StatusLine((HttpResponse)response));
                }
            }
            return (V)this.m_handler.handleResponse(response);
        }
    }

    private static final class ExpiredTokenException
    extends AuthenticationFailedException {
        ExpiredTokenException() {
            super("Expired authentication token");
        }
    }
}

