/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.generators;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.cpat.CpatResources;
import oracle.dbtools.cpat.common.CpatModel;
import oracle.dbtools.cpat.templates.HtmlTemplate;
import oracle.dbtools.cpat.utilities.CpatJsonUtils;

public class HtmlReportGenerator {
    public static final String util_dir_name = "utils";
    public static final String detail_dir_name = "details";
    public static final String js_name = "scripts.js";
    public static final String css_name = "style.css";
    public static final String root_file_name = "premigration_advisor_report.html";
    private Path _jsonPath;
    private Path root_dir;
    private Path detail_dir;
    private Path util_dir;
    private CpatModel _model;
    private IOException err;

    public HtmlReportGenerator(CpatModel model) throws Exception {
        if (model == null) {
            throw new Exception("Must supply model.");
        }
        this._model = model;
        this._jsonPath = model.getJsonFile().toPath();
    }

    private String getDetailReport(Map<String, Object> map) throws JSONObjectException, IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(HtmlTemplate.DETAIL_HEADER);
        sb.append(" <table class=\"table-rounded shadow table-fixed table-horizontal\">" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_NAME") + "</th>                <td>" + String.valueOf(map.get("title")) + "</td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_TARGET") + "</th>                <td> " + CpatJsonUtils.listToString(CpatJsonUtils.getList("targetCloud", map)) + "</td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_SCOPE") + "</th>                <td>" + String.valueOf(map.get("scope")) + "</td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_SQL") + "</th>                <td>                 <details class=\"ShowSql\">                  <summary><span class=\"ShowSql-title\">" + CpatResources.getString("HTML_DETAIL_SQL_SHOW") + "                   </span></summary>                  <pre>" + String.valueOf(map.get("executedSQL")) + "</pre>                </td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_RESULT") + "</th>                <td><span class=\"Badge bg-" + String.valueOf(map.get("result")) + "\">" + this.mapStatus((String)map.get("result")) + "<span></td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_ISSUE") + "</th>                <td>" + String.valueOf(map.get("description")) + "</td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_IMPACT") + "</th>                <td>" + String.valueOf(map.get("failureImpact")) + "</td>            </tr>" + System.lineSeparator() + "            <tr>                <th>" + CpatResources.getString("HTML_DETAIL_ACTION") + "</th>                <td>" + String.valueOf(map.get("action")) + "</td>            </tr>" + System.lineSeparator() + "        </table> " + System.lineSeparator() + "<h2>Objects</h2>" + System.lineSeparator() + "        <div class=\"pad\">" + System.lineSeparator() + "            <table id=\"details\" class=\"table-rounded shadow\"><thead>" + System.lineSeparator());
        List<?> objects = CpatJsonUtils.getList("relevantObjectsData", map);
        boolean addTableHeader = true;
        for (Object o : objects) {
            Map<String, Object> oMap = CpatJsonUtils.toMap(o);
            if (addTableHeader) {
                sb.append("<tr>" + System.lineSeparator());
                for (String key : oMap.keySet()) {
                    sb.append("<th class=\"center pad border\">" + key + "</th>" + System.lineSeparator());
                }
                sb.append("</tr>" + System.lineSeparator() + "</thead>" + System.lineSeparator() + "<tbody>" + System.lineSeparator());
                addTableHeader = false;
            }
            sb.append("<tr>");
            for (String key : oMap.keySet()) {
                sb.append("<td class=\"center pad border\">" + String.valueOf(oMap.get(key)) + "</td>");
            }
            sb.append("</tr>" + System.lineSeparator());
        }
        sb.append("</tbody>" + System.lineSeparator() + "</table>" + System.lineSeparator() + "        </div>" + System.lineSeparator() + "        <footer>" + System.lineSeparator() + "            <a class=\"Button\" href=\"#top\">Go to the Top</a>" + System.lineSeparator() + "        </footer>" + System.lineSeparator() + "    </body>" + System.lineSeparator() + "</html>" + System.lineSeparator());
        String ret = CpatJsonUtils.toPrettyString(sb.toString(), 4);
        if (ret == null) {
            ret = sb.toString();
        }
        return ret;
    }

    private String mapStatus(String status) {
        try {
            List<?> rows = CpatJsonUtils.getList("checkResultDescriptions", CpatJsonUtils.getRoot(this._jsonPath));
            for (Object row : rows) {
                Map<String, Object> map = CpatJsonUtils.toMap(row);
                if (!map.get("resultName").equals(status)) continue;
                return (String)map.get("resultDisplayName");
            }
            return status;
        }
        catch (IOException e) {
            return status;
        }
    }

    public HashMap<String, String> getReports() throws JSONObjectException, IOException {
        HashMap<String, String> reports = new HashMap<String, String>();
        ClassLoader classLoader = HtmlTemplate.class.getClassLoader();
        InputStream jsSource = classLoader.getResourceAsStream("oracle/dbtools/cpat/templates/scripts.js");
        InputStream cssSource = classLoader.getResourceAsStream("oracle/dbtools/cpat/templates/style.css");
        reports.put(util_dir_name + File.separator + js_name, new String(jsSource.readAllBytes()));
        reports.put(util_dir_name + File.separator + css_name, new String(cssSource.readAllBytes()));
        StringBuilder sb = new StringBuilder();
        Map<String, Object> map = CpatJsonUtils.getRoot(this._jsonPath);
        sb.append(HtmlTemplate.MAIN_HEADER);
        sb.append("<tr><th>" + CpatResources.getString("HTML_VERSION") + "</th><td>" + String.valueOf(map.get("appVersion")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_REPORT_DATE") + "</th><td>" + String.valueOf(map.get("reportDate")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_HOST") + "</th><td>" + String.valueOf(map.get("srcDataBaseHostName")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_SID") + "</th><td>" + String.valueOf(map.get("srcOracleSID")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_CREATED") + "</th><td>" + String.valueOf(map.get("srcDatabaseCreatedDate")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_NAME") + "</th><td>" + String.valueOf(map.get("srcDatabaseName")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_USER") + "</th><td>" + String.valueOf(map.get("srcDatabaseUser")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_VERSION") + "</th><td>" + String.valueOf(map.get("srcDatabaseVersion")) + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_SOURCE_SCHEMAS") + "</th><td>" + String.valueOf(map.get("srcNumSchemasPresent")) + "</td></tr>" + System.lineSeparator());
        String analyzed = (String)CpatJsonUtils.getElement("analyzedSchemaSummary", CpatJsonUtils.getMap("checksSummary", CpatJsonUtils.getRoot(this._jsonPath)));
        String[] split = analyzed.split(":");
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)split[1]));
        Object schemas = "";
        sb.append("<tr><th>" + CpatResources.format("HTML_ANALYZED", list.size()) + "</th><td>");
        for (String s : list) {
            schemas = (String)schemas + s + ",<wbr>";
        }
        schemas = ((String)schemas).substring(0, ((String)schemas).length() - 6);
        sb.append((String)schemas + "</td></tr>" + System.lineSeparator());
        sb.append("<tr><th>" + CpatResources.getString("HTML_COMMAND_LINE") + "</th><td><pre>");
        if (this._model != null) {
            sb.append(this._model.getSQLCommand().getSql());
        } else {
            sb.append(map.get("commandLineOptions"));
        }
        sb.append("</pre></td></tr>" + System.lineSeparator() + "</table>" + System.lineSeparator());
        sb.append("<h2>" + CpatResources.getString("HTML_CHECKS_TITLE") + "</h2>" + System.lineSeparator());
        sb.append("<p>" + CpatResources.getString("HTML_CHECK_SUMMARY") + "</p>" + System.lineSeparator() + "<section>");
        for (String key : CpatJsonUtils.getSummary(CpatJsonUtils.getRoot(this._jsonPath)).keySet()) {
            if (Integer.valueOf(CpatJsonUtils.getSummary(CpatJsonUtils.getRoot(this._jsonPath)).get(key)) <= 0) continue;
            sb.append("<details class=\"Checks-item\">" + System.lineSeparator());
            sb.append(" <summary class=\"Checks-item-header bg-" + key.toLowerCase() + "\">" + System.lineSeparator());
            sb.append("   <span class=\"Checks-item-name\">" + this.mapStatus(key) + "</span>" + System.lineSeparator());
            sb.append("   <span class=\"Checks-item-badge\">" + String.valueOf(CpatJsonUtils.getSummary(CpatJsonUtils.getRoot(this._jsonPath)).get(key)) + "</span>" + System.lineSeparator());
            sb.append(" </summary>" + System.lineSeparator());
            if (Integer.valueOf(CpatJsonUtils.getSummary(CpatJsonUtils.getRoot(this._jsonPath)).get(key)) > 0) {
                sb.append("<section class=\"Checks-item-content\">" + System.lineSeparator());
                sb.append("<table><tr>" + System.lineSeparator());
                sb.append("<th>" + CpatResources.getString("HTML_CHECK_NAME_TITLE") + "</th>" + System.lineSeparator());
                sb.append("<th style=\"width: 0;\">" + CpatResources.getString("HTML_CHECK_OBJECT_TITLE") + "</th>" + System.lineSeparator() + "</tr>");
                List<?> checkListRows = CpatJsonUtils.getList("checkList", CpatJsonUtils.getRoot(this._jsonPath));
                for (Object row : checkListRows) {
                    Map<String, Object> rowMap = CpatJsonUtils.toMap(row);
                    if (!rowMap.get("result").toString().equals(key)) continue;
                    sb.append("<tr>");
                    sb.append("<td><a href=\"details" + File.separator + String.valueOf(rowMap.get("name")) + ".html\">" + String.valueOf(rowMap.get("title")) + "</a></td>");
                    sb.append("<td>" + CpatJsonUtils.getList("relevantObjectsData", rowMap).size() + "</td>");
                    sb.append("</tr>" + System.lineSeparator());
                    reports.put(detail_dir_name + File.separator + String.valueOf(rowMap.get("name")) + ".html", this.getDetailReport(rowMap));
                }
                sb.append("</table></section>" + System.lineSeparator());
            } else {
                sb.append("<section class=\"Checks-item-content\"></section>" + System.lineSeparator());
            }
            sb.append("</details>" + System.lineSeparator());
        }
        sb.append(HtmlTemplate.MAIN_FOOTER);
        String ret = CpatJsonUtils.toPrettyString(sb.toString(), 4);
        if (ret == null) {
            ret = sb.toString();
        }
        reports.put(root_file_name, ret);
        return reports;
    }

    public void writeReport(Path path) throws JSONObjectException, IOException, URISyntaxException {
        this.root_dir = Paths.get(path.toString(), new String[0]);
        Files.createDirectory(this.root_dir, new FileAttribute[0]);
        this.detail_dir = Paths.get(this.root_dir.toString() + File.separator + detail_dir_name, new String[0]);
        Files.createDirectory(this.detail_dir, new FileAttribute[0]);
        this.util_dir = Paths.get(this.root_dir.toString() + File.separator + util_dir_name, new String[0]);
        Files.createDirectory(this.util_dir, new FileAttribute[0]);
        HashMap<String, String> report = this.getReports();
        report.forEach((key, value) -> {
            try {
                Files.writeString(Paths.get(this.root_dir.toString() + File.separator + key, new String[0]), (CharSequence)value, new OpenOption[0]);
            }
            catch (IOException e) {
                this.err = e;
                return;
            }
        });
        if (this.err != null) {
            throw this.err;
        }
    }
}

