/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.executors;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.cpat.PostProcessorResources;
import oracle.dbtools.cpat.common.CpatModel;
import oracle.dbtools.cpat.utilities.CpatJsonUtils;

public class CpatPostProcessor {
    private Path _jsonPath;
    private final CpatJsonUtils jUtil = new CpatJsonUtils();
    private HashMap<Integer, String> nToString = new HashMap();
    private HashMap<String, Integer> stringToN = new HashMap();
    private Properties internalProperties = new Properties();
    private static String one = "one";
    private static String REPORT_RESULT = "REPORT_RESULT";
    private static String CHECKS_RUN = "CHECKS_RUN";
    private static String SCHEMAS_ANALYSED_NUM = "SCHEMAS_ANALYSED_NUM";
    private static String SCHEMA_IN_SOURCEDB = "SCHEMA_IN_SOURCEDB";
    private static String SCHEMAS_ANALYSED_LIST = "SCHEMAS_ANALYSED_LIST";
    private static String FATAL = "FATAL";
    private static String BLOCKING = "BLOCKING";
    private static String WARNING = "WARNING";
    private static String INFO = "INFO";
    private static String PASSING = "PASSING";
    private static String FILES = "FILES";
    private static String REPORT_DESC = "REPORT_DESC";
    private static String FATAL_REPORT = "FATAL_REPORT";
    private static String BLOCKING_REPORT = "BLOCKING_REPORT";
    private static String INDENT_THREE_EXTRA = "   ";
    private static String INDENT_TWICE = INDENT_THREE_EXTRA + " " + INDENT_THREE_EXTRA + " ";
    private static String NL = System.lineSeparator();
    private CpatModel _model;

    public CpatPostProcessor(CpatModel model) throws Exception {
        this._model = model;
        if (model == null) {
            throw new Exception(this.prop("POST_SUPPLY_MODEL"));
        }
        this._jsonPath = model.getJsonFile().toPath();
    }

    public String p(String val) {
        if (this.internalProperties.getProperty(val) == null) {
            return "";
        }
        return this.internalProperties.getProperty(val);
    }

    public void pset(String key, String val) {
        this.internalProperties.setProperty(key, val);
    }

    public void run() throws IOException {
        this.process(this.getjson());
    }

    private File getjson() throws IOException {
        return this._model.getJsonFile();
    }

    private void setNonArray() throws IOException {
        this.pset(CHECKS_RUN, this.intToString(CpatJsonUtils.getList("checkList", CpatJsonUtils.getRoot(this._jsonPath)).size()));
        this.pset(SCHEMAS_ANALYSED_NUM, CpatJsonUtils.getElement("srcNumSchemasAnalyzed", CpatJsonUtils.getRoot(this._jsonPath)).toString());
        this.pset(SCHEMA_IN_SOURCEDB, CpatJsonUtils.getElement("srcNumSchemasPresent", CpatJsonUtils.getRoot(this._jsonPath)).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void getTotals() throws IOException {
        void var11_22;
        Object tmp;
        List<?> checkResultDescriptions = CpatJsonUtils.getList("checkResultDescriptions", CpatJsonUtils.getRoot(this._jsonPath));
        for (Object row : checkResultDescriptions) {
            Map<String, Object> rowMap = CpatJsonUtils.toMap(row);
            int num = Integer.parseInt(rowMap.get("resultSeverity").toString());
            String str = rowMap.get("resultName").toString();
            this.nToString.put(num, str);
            this.stringToN.put(str, num);
        }
        List srcSchemas = CpatJsonUtils.getList("srcSchemasAnalyzed", CpatJsonUtils.getRoot(this._jsonPath));
        Object allSchemas = "";
        boolean theelipse = false;
        Object allSchemasAL = new ArrayList<String>();
        for (Object schema : srcSchemas) {
            ((ArrayList)allSchemasAL).add(schema.toString());
        }
        ((ArrayList)allSchemasAL).sort(String.CASE_INSENSITIVE_ORDER);
        if (((ArrayList)allSchemasAL).size() > 10) {
            tmp = new ArrayList();
            for (int ii = 0; ii < 10; ++ii) {
                ((ArrayList)tmp).add((String)((ArrayList)allSchemasAL).get(ii));
            }
            allSchemasAL = tmp;
            ((ArrayList)allSchemasAL).add("...");
        }
        tmp = ((ArrayList)allSchemasAL).iterator();
        while (tmp.hasNext()) {
            String schema = (String)tmp.next();
            allSchemas = (String)allSchemas + ", " + schema.toString();
        }
        if (!((String)allSchemas).equals("")) {
            allSchemas = ((String)allSchemas).substring(2);
        }
        this.pset(SCHEMAS_ANALYSED_LIST, (String)allSchemas);
        ArrayList<CallSite> fatal = new ArrayList<CallSite>();
        ArrayList<CallSite> blocking = new ArrayList<CallSite>();
        List<Object> checkList = CpatJsonUtils.getList("checkList", CpatJsonUtils.getRoot(this._jsonPath));
        for (Iterator row : checkList) {
            String interrum;
            Map<String, Object> map = CpatJsonUtils.toMap(row);
            String value = map.get("result").toString();
            if (value.equals(this.nToString.get(3))) {
                interrum = map.get("title").toString();
                blocking.add((CallSite)((Object)(interrum + this.propOneArgNoExtraIndent("POST_RELEVANT_OBJECTS", Integer.valueOf(((List)map.get("relevantObjectsData")).size()).toString()))));
            }
            if (!value.equals(this.nToString.get(4))) continue;
            interrum = map.get("title").toString();
            fatal.add((CallSite)((Object)(interrum + this.propOneArgNoExtraIndent("POST_RELEVANT_OBJECTS", Integer.valueOf(((List)map.get("relevantObjectsData")).size()).toString()))));
        }
        Object total = "";
        fatal.sort(String.CASE_INSENSITIVE_ORDER);
        for (String string : fatal) {
            total = (String)total + INDENT_TWICE + string + NL;
        }
        this.pset(FATAL_REPORT, (String)total);
        total = "";
        blocking.sort(String.CASE_INSENSITIVE_ORDER);
        for (String string : blocking) {
            total = (String)total + INDENT_TWICE + string + NL;
        }
        this.pset(BLOCKING_REPORT, (String)total);
        LinkedHashMap<String, Integer> summary = CpatJsonUtils.getSummary(CpatJsonUtils.getRoot(this._jsonPath));
        this.pset(FATAL, summary.get("FATAL").toString());
        this.pset(BLOCKING, summary.get("BLOCKER").toString());
        this.pset(WARNING, summary.get("WARNING").toString());
        this.pset(INFO, summary.get("INFORMATIONAL").toString());
        this.pset(PASSING, summary.get("PASS").toString());
        String string = "";
        for (String location : this._model.getUserFileLocations()) {
            String string2 = (String)var11_22 + INDENT_THREE_EXTRA + " " + location + NL;
        }
        this.pset(FILES, (String)var11_22);
        int exitCode = this._model.getExitCode();
        switch (exitCode) {
            case 0: {
                this.pset(REPORT_RESULT, this.prop("POST_PASS"));
                this.pset(REPORT_DESC, this.prop("POST_PASS_REPORT_DESC"));
                break;
            }
            case 1: {
                this.pset(REPORT_RESULT, this.prop("POST_INFO"));
                this.pset(REPORT_DESC, this.prop("POST_INFO_REPORT_DESC"));
                break;
            }
            case 2: {
                this.pset(REPORT_RESULT, this.prop("POST_WARN"));
                this.pset(REPORT_DESC, this.prop("POST_WARN_REPORT_DESC"));
                break;
            }
            case 3: {
                this.pset(REPORT_RESULT, this.prop("POST_BLOCK"));
                this.pset(REPORT_DESC, this.prop("POST_BLOCK_REPORT_DESC"));
                break;
            }
            case 255: {
                this.pset(REPORT_RESULT, this.prop("POST_FATAL"));
                this.pset(REPORT_DESC, this.prop("POST_FATAL_REPORT_DESC"));
                break;
            }
            default: {
                this.pset(REPORT_RESULT, this.prop("POST_FATAL"));
                this.pset(REPORT_DESC, this.prop("POST_FATAL_REPORT_DESC"));
            }
        }
    }

    private String intToString(int i) {
        return "" + i;
    }

    private String prop(String in) {
        return PostProcessorResources.get(in);
    }

    private String propOneArgNoExtraIndent(String in, String singleArg) {
        return PostProcessorResources.format(in, singleArg);
    }

    private String propOneArg(String in, String singleArg) {
        return INDENT_THREE_EXTRA + PostProcessorResources.format(in, singleArg);
    }

    private String propTwoArgNoExtraIndent(String in, String singleArg, String secondArg) {
        return PostProcessorResources.format(in, singleArg, secondArg);
    }

    private String propTwoArg(String in, String singleArg, String secondArg) {
        return INDENT_THREE_EXTRA + PostProcessorResources.format(in, singleArg, secondArg);
    }

    private void process(File thePath) throws IOException {
        if (this._model.isProperties()) {
            Object files = "";
            for (String location : this._model.getUserFileLocations()) {
                files = (String)files + INDENT_THREE_EXTRA + " " + location + NL;
            }
            this.pset(FILES, (String)files);
            this._model.getCtx().write(this.prop("POST_BANNER_NO_VERSION") + this.propOneArgNoExtraIndent("POST_PROPERTY_FILE_LOCATION", this.p(FILES)));
        } else if (this._model.isAdvise()) {
            this.setNonArray();
            this.getTotals();
            Object theFatal = this.propOneArg("POST_FATAL_CHECKS", this.p(FATAL)) + this.p(FATAL_REPORT);
            if (this.p(FATAL).equals("0")) {
                theFatal = "";
            }
            this._model.getCtx().write(this.propOneArgNoExtraIndent("POST_BANNER", CpatJsonUtils.getElement("appVersion", CpatJsonUtils.getRoot(this._jsonPath)).toString()) + this.prop("POST_BANNER_CHECKS") + this.propOneArgNoExtraIndent("POST_OVERALL2", this.p(REPORT_RESULT)) + this.propOneArg("POST_NUM_CHECKS_RUN", this.p(CHECKS_RUN)) + this.propOneArg("POST_NUM_SOURCE_SCHEMAS_IN_DB", this.p(SCHEMA_IN_SOURCEDB)) + this.propTwoArg("POST_ANALYSED_REP", this.p(SCHEMAS_ANALYSED_NUM), this.p(SCHEMAS_ANALYSED_LIST)) + (String)theFatal + this.propOneArg("POST_BLOCKING_CHECKS", this.p(BLOCKING)) + this.p(BLOCKING_REPORT) + this.propOneArg("POST_WARNING_CHECKS", this.p(WARNING)) + this.propOneArg("POST_INFO_CHECKS", this.p(INFO)) + this.propOneArg("POST_PASSING_CHECKS", this.p(PASSING)) + this.propOneArgNoExtraIndent("POST_REPORT_LOCATIONS", this.p(FILES)));
        }
        this._model.getCtx().getOutputStream().flush();
    }
}

