/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import java.util.List;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.mle_js.MLEConstants;

public class MLEModule
extends PropertiesObject
implements MLEConstants {
    @Override
    public String getName() {
        return this.getProperty("MODULE_NAME");
    }

    @Override
    public String getOwner() {
        return this.getProperty("MODULE_OWNER");
    }

    @Override
    public boolean isMinimumDefined() {
        return false;
    }

    @Override
    public void initPropsList() {
        this.propsList.add("MODULE_OWNER");
        this.propsList.add("MODULE_NAME");
        this.propsList.add("VERSION");
        this.propsList.add("MODULE");
        this.propsList.add("METADATA");
    }

    @Override
    public String toJSONString(boolean excludeNulls) {
        Object res = "{";
        boolean first = true;
        for (String prop : this.propsList) {
            String value = this.getProperty(prop);
            if (value == null) {
                if (excludeNulls) continue;
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + "\n\"" + prop.toLowerCase() + "\":";
                res = (String)res + "null";
                continue;
            }
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + prop.toLowerCase() + "\":";
            if (!prop.equalsIgnoreCase("metadata")) {
                res = (String)res + "\"" + StringUtilities.encodeAttributeValueJSON(value) + "\"";
                continue;
            }
            res = (String)res + value;
        }
        for (PropertiesObject.CollectionDescriptor cd : this.getCollectionDescriptors()) {
            List list = cd.coll.getCollection();
            String name = cd.name;
            if (name == null || name.isEmpty() || list == null || list.size() <= 0) continue;
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + name + "\":[\n";
            boolean ofirst = true;
            for (Object obj : list) {
                if (!ofirst) {
                    res = (String)res + ",";
                } else {
                    ofirst = false;
                }
                if (obj instanceof PropertiesObject) {
                    res = (String)res + ((PropertiesObject)obj).toJSONString(excludeNulls);
                    continue;
                }
                res = (String)res + "\"" + obj.toString() + "\"";
            }
            res = (String)res + "\n]";
        }
        res = (String)res + "\n}";
        return res;
    }
}

