/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.ddl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.jdv.ddl.GQLProcessor;
import oracle.dbtools.jdv.ddl.Quoting;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.graphql.GQLParser;
import oracle.dbtools.parser.plsql.SqlEarley;

public class SQLProcessor {
    private static final String _ID = "_id";
    private static final String EXPR = "expr";
    private static final String TABLE = "table";
    private static final String JSON_OBJ_TAGS = "json_obj_tags";
    private static final String COMPOUND_CONDITION = "compound_condition";
    private static final String WHERE_CLAUSE = "where_clause";
    private static final String KEEP_NESTED = "KEEP_NESTED";
    private static final String KEEP = "KEEP";
    private static final String FLEX_COLUMN = "flex_column";
    private static final String JSON_COL_TAGS = "json_col_tags";
    private static final String COLUMN_TAGS_CLAUSE = "column_tags_clause";
    private static final String WHERE_TAGS_CLAUSE_OPTION = "where_tags_clause_option";
    private static final String TABLE_TAGS_CLAUSE = "table_tags_clause";
    public static final String FROM_CLAUSE = "from_clause";
    public static final String OBJECT_TYPE_COLUMN = "COLUMN";
    public static final String TRUE = "true";
    public static final String NESTED = "nested";
    public static final String SINGLETON = "singleton";
    public static final String OBJECT_GEN_CLAUSE = "object_gen_clause";
    public static final String OBJECT_TYPE_TABLE = "TABLE";
    public static final String SUBQUERY = "subquery";
    public static final String QUERY_BLOCK = "query_block";
    public static final String KEY_VALUE_CLAUSE = "key_value_clause";
    public static final String STRING_LITERAL = "string_literal";
    public static final String DUALITY_SUBQUERY = "duality_subquery";
    public static final String SCALAR_SUBQUERY_EXPRESSION = "scalar_subquery_expression";
    public static final String ENTRY = "entry";
    public static final String COMPARISON_CONDITION = "comparison_condition";
    public static final String COLUMN = "column";
    public static final String JSON_COLUMN_REF = "json_column_ref";
    public static final String IDENTIFIER = "identifier";
    public static final String SELECTION_SET = "selectionSet";
    public static final String ARGUMENT = "argument";
    public static final String ARGUMENTS = "arguments";
    public static final String GENERATED_VALUE = "generated_value";
    public static final String COMPOUND_EXPRESSION = "compound_expression";
    public static final String JSON_BASIC_PATH_EXPRESSION = "JSON_basic_path_expression";
    public static final String HIDDEN_CLAUSE = "'HIDDEN'";
    public static final String JSON_FUNCION = "JSON_function";

    public static JDVElement getDVRootDefinition(String definition, String owner, String name) throws IOException {
        SqlEarley earley = null;
        Object input = definition;
        Object viewName = name;
        if (owner != null && !owner.isEmpty()) {
            viewName = owner + "." + (String)viewName;
        }
        if (!definition.trim().toUpperCase(Locale.ROOT).startsWith("CREATE ")) {
            input = "CREATE EDITIONABLE JSON RELATIONAL DUALITY VIEW " + (String)viewName + " as \n" + definition;
        }
        input = SQLProcessor.cleanString((String)input);
        List<String> lines = SQLProcessor.stringToList((String)input);
        earley = SqlEarley.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, matrix);
        ParseNode node = earley.forest(src, matrix);
        JDVElement root = null;
        JDVElement current = null;
        boolean rootFound = false;
        Stack<JDVElement> stack = new Stack<JDVElement>();
        ArrayList<String> createTokens = new ArrayList<String>();
        JDVElement el = null;
        boolean unnested = false;
        int object_gen_clause_end = 1000000;
        int rootFromIndex = 0;
        HashMap<String, JDVElement> elementsMap = new HashMap<String, JDVElement>();
        boolean from = false;
        int fromIndex = 0;
        boolean where = false;
        ParseNode gen_clause_node = null;
        for (ParseNode pn : node.descendants()) {
            if (rootFound && pn.to <= object_gen_clause_end) {
                if (pn.contains("'UNNEST'")) {
                    unnested = true;
                }
                if (SQLProcessor.isRealEntry(pn)) {
                    el = SQLProcessor.createColumn(pn);
                    if (current != null) {
                        current.getElements().add(el);
                    }
                    elementsMap.put(pn.toString(), el);
                    String nestedKey = SQLProcessor.getNestedKey(pn, elementsMap);
                    if (nestedKey != null) {
                        el.setNestedKey(nestedKey);
                    }
                }
                if (el != null && pn.to <= el.getParseTo()) {
                    SQLProcessor.processAlias(el, src, pn);
                    SQLProcessor.processHidden(el, pn);
                    SQLProcessor.processColumnName(el, src, pn);
                    SQLProcessor.processFlexColumn(el, src, pn);
                    SQLProcessor.processColumnTagsClause(el, src, pn);
                    SQLProcessor.processColumnGeneratedClause(el, src, pn, (String)input, lines);
                }
                if (pn.contains(DUALITY_SUBQUERY) && pn != gen_clause_node || pn.contains(SCALAR_SUBQUERY_EXPRESSION)) {
                    if (pn.from >= el.getParseFrom() && pn.to <= el.getParseTo()) {
                        el.setObjectType(OBJECT_TYPE_TABLE);
                        stack.push(current);
                        current = el;
                    } else {
                        JDVElement table = SQLProcessor.createTable(pn);
                        current.getElements().add(table);
                        stack.push(current);
                        current = table;
                    }
                    if (unnested) {
                        current.setUnnested(TRUE);
                        unnested = false;
                    }
                    if (pn.contains(SCALAR_SUBQUERY_EXPRESSION)) {
                        current.setRelationship(SINGLETON);
                    } else if (current != root && pn.contains(DUALITY_SUBQUERY)) {
                        ParseNode braket;
                        if (unnested || current.isUnnested()) {
                            current.setRelationship(SINGLETON);
                        } else if (current.getRelationship() == null && pn.parent != null && (braket = pn.parent.locate(pn.from - 1, pn.from)) != null) {
                            String cont = SQLProcessor.getContent(braket, src);
                            if (cont.contains("(")) {
                                current.setRelationship(SINGLETON);
                            } else if (cont.contains("[")) {
                                current.setRelationship(NESTED);
                            }
                        }
                    }
                }
                if (pn.to - pn.from == 1) {
                    if (pn.contains("'FROM'")) {
                        from = true;
                    } else if (pn.contains(WHERE_CLAUSE)) {
                        where = true;
                    }
                }
                if (from && !where) {
                    fromIndex = SQLProcessor.processTableIdentifier(current, src, pn, fromIndex);
                    SQLProcessor.processTableTagsClause(current, src, pn);
                }
                SQLProcessor.processWhereClause(current, src, pn, (String)input);
            } else if (pn.contains(IDENTIFIER)) {
                String token = SQLProcessor.getContent(pn, src);
                createTokens.add(token);
            } else if (!rootFound && (pn.contains(OBJECT_GEN_CLAUSE) || pn.contains(JSON_FUNCION))) {
                rootFound = true;
                root = SQLProcessor.createTable(pn);
                root.setRootTable(true);
                current = root;
                object_gen_clause_end = pn.to;
                gen_clause_node = pn;
            }
            if (current != null && pn.to - pn.from == 1 && pn.to == current.getParseTo() && current != root) {
                current = (JDVElement)stack.pop();
                from = false;
                fromIndex = 0;
                where = false;
                continue;
            }
            if (current == null || current != root || pn.from < current.getParseTo()) continue;
            if (pn.contains("'FROM'")) {
                from = true;
            }
            rootFromIndex = SQLProcessor.processTableIdentifier(root, src, pn, rootFromIndex);
            if (!from) continue;
            SQLProcessor.processTableTagsClause(current, src, pn);
            if (!pn.contains(COMPOUND_CONDITION) && (!pn.contains(COMPARISON_CONDITION) || SQLProcessor.hasParentWithTerm(pn, COMPOUND_CONDITION))) continue;
            String filter = SQLProcessor.getSource(pn, src, (String)input);
            root.setTableFilter(filter);
        }
        if (root != null) {
            root.synchPropsToVarsForTree();
            SQLProcessor.removeIntermediateColumns(root);
            SQLProcessor.setPKColumnsForRoot(root);
            Map<String, JDVElement> aliasesMap = SQLProcessor.getAliasesMap(root);
            SQLProcessor.processJoinsAndFilters(root, aliasesMap);
        }
        return root;
    }

    static int processTableIdentifier(JDVElement table, List<LexerToken> src, ParseNode pn, int identifierIndex) {
        int ind = identifierIndex;
        if (pn.contains(IDENTIFIER) && !SQLProcessor.hasParentWithTerm(pn, COMPARISON_CONDITION)) {
            String name = SQLProcessor.getContent(pn, src);
            if (++ind == 1) {
                table.setTable_name(name);
            } else if (ind == 2) {
                table.setTableAlias(name);
            } else {
                table.setTable_owner(table.getTable_name());
                table.setTable_name(table.getTableAlias());
                table.setTableAlias(name);
            }
        }
        return ind;
    }

    static void processTableTagsClause(JDVElement el, List<LexerToken> src, ParseNode pn) {
        if (el != null && pn.contains(TABLE_TAGS_CLAUSE) && !SQLProcessor.hasParentWithTerm(pn, WHERE_TAGS_CLAUSE_OPTION)) {
            for (ParseNode n : pn.descendants()) {
                String clause;
                if (!n.contains(JSON_OBJ_TAGS) || (clause = SQLProcessor.getContent(n, src)) == null) continue;
                GQLProcessor.setSimpleClause(el, clause);
            }
        }
    }

    static void processColumnTagsClause(JDVElement el, List<LexerToken> src, ParseNode pn) {
        if (el != null && pn.contains(COLUMN_TAGS_CLAUSE)) {
            for (ParseNode n : pn.descendants()) {
                String clause;
                if (n.contains(ENTRY) || n.contains(KEY_VALUE_CLAUSE)) {
                    return;
                }
                if (!n.contains(JSON_COL_TAGS) || (clause = SQLProcessor.getContent(n, src)) == null) continue;
                GQLProcessor.setSimpleClause(el, clause);
            }
        }
    }

    static void processColumnGeneratedClause(JDVElement el, List<LexerToken> src, ParseNode pn, String statement, List<String> statementLines) {
        if (el != null && pn.contains(GENERATED_VALUE)) {
            SQLProcessor.getSource(pn, src, statement);
            boolean par = false;
            for (ParseNode n : pn.descendants()) {
                Object clause;
                if (n.contains("'('")) {
                    par = true;
                }
                if (n.contains(QUERY_BLOCK) || n.contains(COMPOUND_EXPRESSION) || n.contains(EXPR)) {
                    clause = SQLProcessor.getSource(n, src, statement);
                    if (clause == null) continue;
                    if (n.contains(QUERY_BLOCK) && !((String)clause).trim().startsWith("(") && par) {
                        clause = "(" + (String)clause + ")";
                    }
                    clause = SQLProcessor.normalizeExpression((String)clause, pn, src, statementLines);
                    el.setGenerateType("sql");
                    el.setGeneratedExpression((String)clause);
                    return;
                }
                if (!n.contains(JSON_BASIC_PATH_EXPRESSION) || (clause = SQLProcessor.getSource(n, src, statement)) == null) continue;
                el.setGenerateType("path");
                el.setGeneratedExpression(Quoting.removeSingleQuotes((String)clause));
                return;
            }
        }
    }

    static String normalizeExpression(String expr, ParseNode pn, List<LexerToken> src, List<String> lines) {
        List<String> exprLlines = SQLProcessor.stringToList(expr);
        if (exprLlines.size() > 1) {
            int start = 0;
            int current = 0;
            start = src.get((int)pn.from).begin;
            Object res = "";
            for (String line : lines) {
                int posInLine;
                if (current + line.length() >= start && (posInLine = start - current + 1) > 0) {
                    for (int i = 0; i < exprLlines.size(); ++i) {
                        int strl2;
                        int strl;
                        String str = exprLlines.get(i);
                        if (i > 0 && (strl = str.length()) - (strl2 = str.stripLeading().length()) >= posInLine) {
                            str = str.substring(posInLine);
                        }
                        res = (String)res + str;
                    }
                }
                current += line.length();
            }
            return res;
        }
        return expr;
    }

    static void processWhereClause(JDVElement el, List<LexerToken> src, ParseNode pn, String statement) {
        if (el != null && pn.contains(WHERE_CLAUSE)) {
            for (ParseNode n : pn.children()) {
                if (n.contains(COMPOUND_CONDITION)) {
                    CompoundCondition comp = new CompoundCondition(n);
                    String cont = SQLProcessor.getSource(n, src, statement);
                    if (cont != null) {
                        comp.setContent(cont);
                    }
                    el.setCondition(comp);
                    SQLProcessor.processCompoundCondition(el, src, n, comp, statement);
                    return;
                }
                if (!n.contains(COMPARISON_CONDITION)) continue;
                ComparisonCondition comp = new ComparisonCondition(n);
                String cont = SQLProcessor.getSource(n, src, statement);
                if (cont != null) {
                    comp.setContent(cont);
                }
                el.setCondition(comp);
                SQLProcessor.processComparisonCondition(el, src, n, comp);
                return;
            }
        }
    }

    static void processCompoundCondition(JDVElement el, List<LexerToken> src, ParseNode pn, CompoundCondition comp, String statement) {
        if (el != null && pn.contains(COMPOUND_CONDITION)) {
            Condition currentCondition = null;
            for (ParseNode n : pn.children()) {
                String cont;
                if (currentCondition == null) {
                    currentCondition = SQLProcessor.createAndProcessComparisonCondition(el, src, n, comp, statement);
                    if (currentCondition != null) continue;
                    currentCondition = SQLProcessor.createAndProcessCompoundCondition(el, src, n, comp, statement);
                    continue;
                }
                if (n.from < currentCondition.to()) continue;
                ComparisonCondition condition = SQLProcessor.createAndProcessComparisonCondition(el, src, n, comp, statement);
                if (condition == null) {
                    SQLProcessor.createAndProcessCompoundCondition(el, src, n, comp, statement);
                }
                if (condition != null) {
                    currentCondition = condition;
                }
                if (n.to - n.from != 1 || (cont = SQLProcessor.getContent(n, src)) == null || ")".equals(cont) || "(".equals(cont)) continue;
                if (currentCondition.compoundOperator == null) {
                    currentCondition.compoundOperator = cont;
                    continue;
                }
                currentCondition.compoundOperator = currentCondition.compoundOperator + cont;
            }
        }
    }

    static CompoundCondition createAndProcessCompoundCondition(JDVElement el, List<LexerToken> src, ParseNode pn, CompoundCondition comp, String statement) {
        if (el != null && pn.contains(COMPOUND_CONDITION)) {
            String cont = SQLProcessor.getSource(pn, src, statement);
            CompoundCondition condition = new CompoundCondition(pn);
            comp.conditions.add(condition);
            if (cont != null) {
                condition.setContent(cont);
            }
            SQLProcessor.processCompoundCondition(el, src, pn, condition, statement);
        }
        return null;
    }

    static ComparisonCondition createAndProcessComparisonCondition(JDVElement el, List<LexerToken> src, ParseNode pn, CompoundCondition comp, String statement) {
        if (el != null && pn.contains(COMPARISON_CONDITION)) {
            String cont = SQLProcessor.getSource(pn, src, statement);
            ComparisonCondition condition = new ComparisonCondition(pn);
            comp.conditions.add(condition);
            if (cont != null) {
                condition.setContent(cont);
            }
            SQLProcessor.processComparisonCondition(el, src, pn, condition);
            return condition;
        }
        return null;
    }

    static void processComparisonCondition(JDVElement el, List<LexerToken> src, ParseNode pn, ComparisonCondition comp) {
        if (el != null && pn.contains(COMPARISON_CONDITION)) {
            int colNum = 0;
            int colEnd = 999999;
            for (ParseNode n : pn.descendants()) {
                String cont;
                if (n.contains(COLUMN)) {
                    ++colNum;
                    colEnd = n.to;
                } else if (n.contains(IDENTIFIER)) {
                    cont = SQLProcessor.getContent(n, src);
                    if (n.contains(TABLE)) {
                        if (colNum == 1) {
                            comp.leftAlias = cont;
                        } else {
                            comp.rightAlias = cont;
                        }
                    } else if (colNum == 1) {
                        comp.leftColumn = cont;
                    } else {
                        comp.rightColumn = cont;
                    }
                }
                if (n.from < colEnd || n.to - n.from != 1 || n.contains(EXPR) || SQLProcessor.hasParentWithTerm(n, EXPR, pn)) continue;
                cont = SQLProcessor.getContent(n, src);
                comp.comparisonOperator = comp.comparisonOperator + cont;
            }
        }
    }

    static void processFlexColumn(JDVElement el, List<LexerToken> src, ParseNode pn) {
        if (el != null && pn.contains("'FLEX'") && SQLProcessor.hasParentWithTerm(pn, FLEX_COLUMN)) {
            String cont;
            el.setIs_flex_col(TRUE);
            ParseNode flex = SQLProcessor.getParentWithTerm(pn, FLEX_COLUMN);
            ParseNode descrim = flex.locate(pn.from + 2, pn.from + 3);
            if (descrim != null && (cont = SQLProcessor.getContent(descrim, src)) != null) {
                if (KEEP.equals(cont = cont.toUpperCase(Locale.ROOT))) {
                    cont = KEEP_NESTED;
                }
                el.setConflictResolutionOnFlex(cont);
            }
        }
    }

    static String getNestedKey(ParseNode pn, Map<String, JDVElement> elementsMap) {
        ParseNode parent = pn.parent();
        if (parent != null) {
            if (parent.contains(DUALITY_SUBQUERY) || parent.contains(SCALAR_SUBQUERY_EXPRESSION) || parent.contains(QUERY_BLOCK) || parent.contains(SUBQUERY)) {
                return null;
            }
            if (parent.contains(ENTRY) || parent.contains(KEY_VALUE_CLAUSE)) {
                JDVElement el = elementsMap.get(parent.toString());
                if (el != null) {
                    return el.getJson_key_name();
                }
            } else {
                return SQLProcessor.getNestedKey(parent, elementsMap);
            }
        }
        return null;
    }

    static boolean isRealEntry(ParseNode pn) {
        if (pn.contains(ENTRY) || pn.contains(KEY_VALUE_CLAUSE)) {
            return !pn.contains(DUALITY_SUBQUERY) && !pn.contains(SCALAR_SUBQUERY_EXPRESSION) && !pn.contains(QUERY_BLOCK) && !pn.contains(SUBQUERY);
        }
        return false;
    }

    static JDVElement createTable(ParseNode pn) {
        JDVElement el = new JDVElement();
        el.setObjectType(OBJECT_TYPE_TABLE);
        el.setParseFrom(pn.from);
        el.setParseTo(pn.to);
        return el;
    }

    static JDVElement createColumn(ParseNode pn) {
        JDVElement el = new JDVElement();
        el.setObjectType(OBJECT_TYPE_COLUMN);
        el.setParseFrom(pn.from);
        el.setParseTo(pn.to);
        return el;
    }

    static void removeIntermediateColumns(JDVElement root) {
        ArrayList<JDVElement> source = new ArrayList<JDVElement>(root.getElements());
        for (JDVElement el : source) {
            if (el.isTable()) {
                SQLProcessor.removeIntermediateColumns(el);
                continue;
            }
            if (!el.isColumn() || el.getColumn_name() != null || el.isGenerated()) continue;
            root.getElements().remove(el);
        }
    }

    static Map<String, JDVElement> getAliasesMap(JDVElement root) {
        HashMap<String, JDVElement> map = new HashMap<String, JDVElement>();
        SQLProcessor.addToAliasesMap(root, map);
        return map;
    }

    static void addToAliasesMap(JDVElement table, Map<String, JDVElement> map) {
        if (table.isTable()) {
            String alias = table.getTableAlias();
            if (alias != null && !alias.isEmpty()) {
                map.put(alias, table);
            }
            for (JDVElement el : table.getElements()) {
                if (!el.isTable()) continue;
                SQLProcessor.addToAliasesMap(el, map);
            }
        }
    }

    static void processJoinsAndFilters(JDVElement table, Map<String, JDVElement> map) {
        if (table.isTable()) {
            String filter;
            Condition cond;
            if (!table.isRootTable()) {
                cond = table.getCondition();
                if (cond != null) {
                    cond.removeEmptyCompoundConditions();
                    SQLProcessor.processJoins(table, map, cond);
                    filter = cond.getfilter();
                    if (filter != null && !filter.isEmpty()) {
                        table.setTableFilter(filter);
                    }
                }
            } else if (table.getTableFilter() == null && (cond = table.getCondition()) != null) {
                cond.removeEmptyCompoundConditions();
                filter = cond.getfilter();
                if (filter != null && !filter.isEmpty()) {
                    table.setTableFilter(filter);
                }
            }
            for (JDVElement el : table.getElements()) {
                if (!el.isTable()) continue;
                SQLProcessor.processJoinsAndFilters(el, map);
            }
        }
    }

    static void processJoins(JDVElement table, Map<String, JDVElement> map, Condition condition) {
        for (Condition cond : condition.getJoinConditions()) {
            SQLProcessor.processJoin(table, map, cond);
        }
    }

    static void processJoin(JDVElement table, Map<String, JDVElement> map, Condition cond) {
        String alias = table.getTableAlias();
        String tabCol = null;
        String joinCol = null;
        JDVElement joinTable = null;
        if (alias != null) {
            if (alias.equals(cond.leftAlias)) {
                joinTable = map.get(cond.rightAlias);
                if (joinTable != null) {
                    tabCol = cond.leftColumn;
                    joinCol = cond.rightColumn;
                }
            } else if (alias.equals(cond.rightAlias) && (joinTable = map.get(cond.leftAlias)) != null) {
                tabCol = cond.rightColumn;
                joinCol = cond.leftColumn;
            }
            if (joinTable != null && joinCol != null && tabCol != null) {
                if (NESTED.equalsIgnoreCase(table.getRelationship())) {
                    String fkCols = table.getFkColumns();
                    if (fkCols == null || fkCols.isEmpty()) {
                        table.setFkColumns(tabCol);
                        JDVElement col = joinTable.getColumnElementByName(joinCol);
                        if (col != null) {
                            col.setPrimary_key_pos("1");
                        }
                    } else {
                        long count = fkCols.chars().filter(ch -> ch == 44).count() + 2L;
                        table.setFkColumns(fkCols + "," + tabCol);
                        JDVElement col = joinTable.getColumnElementByName(joinCol);
                        if (col != null) {
                            col.setPrimary_key_pos(String.valueOf(count));
                        }
                    }
                } else {
                    String fkCols = table.getOther_FkColumns();
                    if (fkCols == null || fkCols.isEmpty()) {
                        table.setOther_FkColumns(joinCol);
                        JDVElement col = table.getColumnElementByName(tabCol);
                        if (col != null) {
                            col.setPrimary_key_pos("1");
                        }
                    } else {
                        long count = fkCols.chars().filter(ch -> ch == 44).count() + 2L;
                        table.setOther_FkColumns(fkCols + "," + joinCol);
                        JDVElement col = table.getColumnElementByName(tabCol);
                        if (col != null) {
                            col.setPrimary_key_pos(String.valueOf(count));
                        }
                    }
                }
            }
        }
    }

    static void setPKColumnsForRoot(JDVElement root) {
        ArrayList<JDVElement> source = new ArrayList<JDVElement>(root.getElements());
        int ind = 1;
        Object pkColumns = "";
        for (JDVElement el : source) {
            if (!el.isColumn() || !_ID.equals(el.getJsonAlias()) && !_ID.equals(el.getNestedKey())) continue;
            el.setPrimary_key_pos(String.valueOf(ind));
            pkColumns = ind > 1 ? (String)pkColumns + "," + el.getColumn_name() : el.getColumn_name();
            ++ind;
        }
    }

    static void changeNested(JDVElement parent, JDVElement el) {
        List<JDVElement> list = parent.getElements();
        int ind = list.indexOf(el);
        String nested_key = el.getJson_key_name();
        for (int i = el.getElements().size() - 1; i >= 0; --i) {
            JDVElement column = el.getElements().get(i);
            column.setNestedKey(nested_key);
            list.add(ind, column);
        }
    }

    static boolean isTableField(ParseNode pn) {
        for (ParseNode n : pn.children()) {
            if (!n.contains(SCALAR_SUBQUERY_EXPRESSION) && !n.contains(DUALITY_SUBQUERY)) continue;
            return true;
        }
        return false;
    }

    static void processAlias(JDVElement el, List<LexerToken> src, ParseNode pn) {
        String name;
        if (el != null && pn.contains(STRING_LITERAL) && SQLProcessor.hasParentWithTerm(pn, KEY_VALUE_CLAUSE, pn.parent()) && (name = SQLProcessor.getContent(pn, src)) != null) {
            el.setJson_key_name(Quoting.removeSingleQuotes(name));
        }
    }

    static void processHidden(JDVElement el, ParseNode pn) {
        if (el != null && pn.contains(HIDDEN_CLAUSE)) {
            el.setHidden(TRUE);
        }
    }

    static void processColumnName(JDVElement el, List<LexerToken> src, ParseNode pn) {
        if (el != null && SQLProcessor.isEntryColumn(pn)) {
            int ind = 0;
            for (ParseNode n : pn.descendants()) {
                if (!n.contains(IDENTIFIER)) continue;
                String name = SQLProcessor.getContent(n, src);
                if (++ind == 1) {
                    el.setTableAlias(name);
                    continue;
                }
                el.setColumn_name(name);
            }
        }
    }

    static boolean isEntryColumn(ParseNode pn) {
        return pn.contains(JSON_COLUMN_REF) || pn.contains(COLUMN) && !pn.contains("'JSON'") && !SQLProcessor.hasParentWithTerm(pn, COMPARISON_CONDITION) && SQLProcessor.hasParentWithTerm(pn, ENTRY);
    }

    static boolean hasParentWithTerm(ParseNode pn, String term) {
        ParseNode parent = pn.parent();
        if (parent != null) {
            if (parent.contains(term)) {
                return true;
            }
            return SQLProcessor.hasParentWithTerm(parent, term);
        }
        return false;
    }

    static boolean hasParentWithTerm(ParseNode pn, String term, ParseNode topParent) {
        ParseNode parent = pn.parent();
        if (parent != null) {
            if (parent.contains(term)) {
                return true;
            }
            if (parent == topParent) {
                return false;
            }
            return SQLProcessor.hasParentWithTerm(parent, term, topParent);
        }
        return false;
    }

    static ParseNode getParentWithTerm(ParseNode pn, String term) {
        ParseNode parent = pn.parent();
        if (parent != null) {
            if (parent.contains(term)) {
                return parent;
            }
            return SQLProcessor.getParentWithTerm(parent, term);
        }
        return null;
    }

    public static ParseNode parseInput(String input) throws IOException {
        Object earley = null;
        earley = input.toUpperCase(Locale.ROOT).indexOf("SELECT ") > -1 ? SqlEarley.getInstance() : GQLParser.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        return earley.forest(src, matrix);
    }

    public static void printParsed(String input) throws IOException {
        Object earley = null;
        earley = input.toUpperCase(Locale.ROOT).indexOf("SELECT ") > -1 ? SqlEarley.getInstance() : GQLParser.getInstance();
        List src = Lexer.parse((String)input);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src, matrix);
        ParseNode node = earley.forest(src, matrix);
        for (ParseNode n : node.descendants()) {
            SQLProcessor.printNode(n, src);
        }
    }

    static void printNode(ParseNode n, List<LexerToken> src) {
        Object desc = n.toString();
        String cont = SQLProcessor.getContent(n, src);
        desc = (String)desc;
        if (n.contains(IDENTIFIER)) {
            desc = (String)desc + " - " + cont;
        }
        System.out.print("\n" + (String)desc);
    }

    public static String getContent(ParseNode pn, List<LexerToken> src) {
        StringBuilder sb = new StringBuilder();
        try {
            if (pn.to - pn.from == 1) {
                return src.get((int)pn.from).content;
            }
            for (int i = pn.from; i < pn.to; ++i) {
                sb.append(src.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
        }
        return sb.toString();
    }

    private static String getSource(ParseNode pn, List<LexerToken> src, String statement) {
        int start = 0;
        int end = 1;
        start = src.get((int)pn.from).begin;
        end = src.get((int)(pn.to - 1)).end;
        return statement.substring(start, end);
    }

    public static void main(String[] args) {
    }

    public static String cleanString(String input) {
        return input.replace("\t", "    ").replaceAll("\r?\n", "\n");
    }

    public static List<String> stringToList(String input) {
        String temp = SQLProcessor.cleanString(input);
        String[] parts = temp.split("\\n");
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String s : parts) {
            list.add(s + "\n");
        }
        return list;
    }

    public static String indentString(String input, int indent) {
        Object pref = "";
        Object res = "";
        for (int i = 0; i < indent; ++i) {
            pref = (String)pref + " ";
        }
        for (String s : SQLProcessor.stringToList(input)) {
            res = (String)res + (String)pref + s;
        }
        return res;
    }

    static class CompoundCondition
    extends Condition {
        List<Condition> conditions = new ArrayList<Condition>();

        CompoundCondition(ParseNode pn) {
            super(pn);
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        List<Condition> removeEmptyCompoundConditions(List<Condition> inputConditions) {
            if (inputConditions.size() > 1) {
                return inputConditions;
            }
            Condition cond = inputConditions.get(0);
            if (!cond.isCompound()) {
                return inputConditions;
            }
            CompoundCondition comp = (CompoundCondition)cond;
            return comp.removeEmptyCompoundConditions(comp.conditions);
        }

        @Override
        public void removeEmptyCompoundConditions() {
            this.conditions = this.removeEmptyCompoundConditions(this.conditions);
        }

        @Override
        public List<Condition> getJoinConditions() {
            if (this.conditions.size() > 0) {
                ArrayList<Condition> list = new ArrayList<Condition>();
                for (Condition cond : this.conditions) {
                    if (cond.isJoinCondition()) {
                        list.add(cond);
                        continue;
                    }
                    if (!cond.isCompound()) continue;
                    list.addAll(cond.getJoinConditions());
                }
                return list;
            }
            return Collections.emptyList();
        }

        @Override
        public String getfilter() {
            Object res = "";
            Condition last = null;
            for (Condition cond : this.conditions) {
                String join = null;
                if (last != null) {
                    join = last.compoundOperator;
                }
                if (!cond.isCompound()) {
                    if (cond.isJoinCondition()) continue;
                    res = ((String)res).isEmpty() ? cond.getContent() : (String)res + (String)(join != null ? " " + join + " " : " ") + cond.getContent();
                    last = cond;
                    continue;
                }
                if (cond.getJoinConditions().size() == 0) {
                    res = ((String)res).isEmpty() ? cond.getContent() : (String)res + (String)(join != null ? " " + join + " " : " ") + cond.getContent();
                    last = cond;
                    continue;
                }
                res = cond.getfilter();
            }
            return res;
        }
    }

    public static class Condition {
        String content = null;
        String compoundOperator = null;
        String comparisonOperator = "";
        String leftAlias = null;
        String rightAlias = null;
        String leftColumn = null;
        String rightColumn = null;
        ParseNode parseNode;

        public Condition(ParseNode pn) {
            this.parseNode = pn;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isJoinCondition() {
            if (!this.isCompound() && this.leftAlias != null && this.rightAlias != null && this.leftColumn != null && this.rightColumn != null && !this.leftAlias.equalsIgnoreCase(this.rightAlias)) {
                return this.comparisonOperator != null && "=".equals(this.comparisonOperator);
            }
            return false;
        }

        boolean isCompound() {
            return false;
        }

        public int to() {
            if (this.parseNode != null) {
                return this.parseNode.to;
            }
            return 0;
        }

        public void removeEmptyCompoundConditions() {
        }

        public List<Condition> getJoinConditions() {
            if (this.isJoinCondition()) {
                ArrayList<Condition> list = new ArrayList<Condition>();
                list.add(this);
                return list;
            }
            return Collections.emptyList();
        }

        public String getfilter() {
            if (!this.isJoinCondition()) {
                return this.content;
            }
            return null;
        }
    }

    static class ComparisonCondition
    extends Condition {
        ComparisonCondition(ParseNode pn) {
            super(pn);
        }
    }
}

