/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap;

import java.lang.reflect.Method;
import oracle.dbtools.crest.util.logging.Logger;

public class PropertyWrapper {
    private static final Logger LOGGER = new Logger(PropertyWrapper.class);
    private String name;
    protected Object obj;
    private String getter;
    private String setter;
    private boolean selected = true;
    private Class parameter;

    public PropertyWrapper(String name, Object obj, String getter, String setter, Class parameter) {
        this.name = name;
        this.obj = obj;
        this.getter = getter;
        this.setter = setter;
        this.parameter = parameter;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getValueString() {
        Object value = this.getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public Object getValue() {
        try {
            Method method = this.obj.getClass().getMethod(this.getter, new Class[0]);
            Object result = method.invoke(this.obj, new Object[0]);
            return result;
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public void setValue(Object toObj) {
        try {
            Method method = toObj.getClass().getMethod(this.setter, this.parameter);
            method.invoke(toObj, this.getValue());
        }
        catch (Exception e1) {
            LOGGER.warn(e1.getMessage(), e1);
        }
    }

    public void init() {
    }
}

