/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class DPVLogicalSubView
extends DPVLogical {
    private DesignObjectCollection tvEntities = new DesignObjectCollection(true);
    private DesignObjectCollection tvViews = new DesignObjectCollection(true);
    private DesignObjectCollection tvRelations = new DesignObjectCollection(true);
    private DesignObjectCollection tvInhRelations = new DesignObjectCollection(true);

    public DPVLogicalSubView(DesignPart desPart) {
        super(desPart);
        ((LogicalDesign)desPart).getEntitySet().addSetListener(this.tvEntities);
        ((LogicalDesign)desPart).getEntityViewSet().addSetListener(this.tvViews);
        ((LogicalDesign)desPart).getRelationSet().addSetListener(this.tvRelations);
        ((LogicalDesign)desPart).getInheritanceRelationSet().addSetListener(this.tvInhRelations);
        this.tvEntities.setElementDescriptor(Entity.class);
        this.tvEntities.setName(Messages.getString("DPVLogicalSubView.Entities"));
        this.tvViews.setElementDescriptor(EntityView.class);
        this.tvViews.setName(Messages.getString("DPVLogicalSubView.Views"));
        this.tvRelations.setElementDescriptor(Relation.class);
        this.tvRelations.setName(Messages.getString("DPVLogicalSubView.Relations"));
        this.tvInhRelations.setElementDescriptor(InheritanceRelation.class);
        this.tvInhRelations.setName(Messages.getString("DPVLogicalSubView.Hierarchies"));
    }

    public void clearDPV() {
        ((LogicalDesign)this.getDesignPart()).getEntitySet().removeSetListener(this.tvEntities);
        ((LogicalDesign)this.getDesignPart()).getEntityViewSet().removeSetListener(this.tvViews);
        ((LogicalDesign)this.getDesignPart()).getRelationSet().removeSetListener(this.tvRelations);
        ((LogicalDesign)this.getDesignPart()).getInheritanceRelationSet().removeSetListener(this.tvInhRelations);
    }

    public void sortCollections() {
        this.tvEntities.sort();
        this.tvViews.sort();
        this.tvRelations.sort();
        this.tvInhRelations.sort();
    }

    public void objectAdded(DesignPart designPart, DesignObject object) {
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
        }
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setPlaceHolder(PlaceHolder host) {
        super.setPlaceHolder(host);
        this.tvEntities.setParent(this.getPlaceHolder());
        this.tvViews.setParent(this.getPlaceHolder());
        this.tvRelations.setParent(this.getPlaceHolder());
        this.tvInhRelations.setParent(this.getPlaceHolder());
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    public Collection getTVEnities() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntity)) continue;
            col.add(tv);
        }
        return col;
    }

    @Override
    public Collection getTVEntityViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntityView)) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVRelations() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVRelation)) continue;
            col.add(tv);
        }
        return col;
    }

    @Override
    public DesignPartView createSubordinateView(DesignPart desPart) {
        return new DPVLogicalSubView(this.getDesignPart());
    }
}

