/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TVLabel
extends ContainerView {
    public TVLabel(DesignPartView dpv) {
        super(dpv);
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setModel(DesignObject object) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = object;
        object.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignObject getModel() {
        return this.model;
    }

    public ContainerView createViewSynonim(DesignPartView dpv) {
        return new TVLabel(dpv);
    }

    @Override
    protected void doPrivateActions() {
    }

    @Override
    protected void hideRelations() {
    }

    @Override
    public String toString() {
        int i = this.getModel().getViewNumber(this);
        Object s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + (String)s;
    }

    @Override
    public boolean useCustomFormat() {
        return true;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public Rectangle2D getLabelBounds() {
        Label label = (Label)this.getModel();
        if (label.getSite() != 1) {
            return this.getBounds();
        }
        TVConnector connectior = label.getTVConnector();
        Rectangle rec = connectior.getLabelBounds();
        int pc = connectior.getEdgePoints().size();
        if (pc % 2 != 0) {
            Point2D p = (Point2D)connectior.getEdgePoints().get(pc / 2);
            double x = p.getX() - ((RectangularShape)rec).getWidth() / 2.0;
            double y = p.getY() - ((RectangularShape)rec).getHeight() / 2.0;
            return new Rectangle2D.Double(x, y, ((RectangularShape)rec).getWidth(), ((RectangularShape)rec).getHeight());
        }
        Point2D p1 = (Point2D)connectior.getEdgePoints().get(pc / 2 - 1);
        Point2D p2 = (Point2D)connectior.getEdgePoints().get(pc / 2);
        double xc = (p1.getX() + p2.getX()) / 2.0;
        double yc = (p1.getY() + p2.getY()) / 2.0;
        double x = xc - ((RectangularShape)rec).getWidth() / 2.0;
        double y = yc - ((RectangularShape)rec).getHeight() / 2.0;
        return new Rectangle2D.Double(x, y, ((RectangularShape)rec).getWidth(), ((RectangularShape)rec).getHeight());
    }

    @Override
    public Color getBackgroundColor() {
        return this.getModel().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        return this.getModel().getForegroundColor();
    }

    @Override
    public FontObject getFontObject(String type) {
        DefaultFontAndColor dfc;
        FontObject fo = null;
        if (!this.useDefaultColor()) {
            for (FontObject next : this.getEditableFonts()) {
                if (!type.equalsIgnoreCase(next.getType())) continue;
                fo = next;
                break;
            }
            if (fo != null) {
                return fo;
            }
            DefaultFontAndColor dfc2 = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType());
            if (dfc2 != null && (fo = dfc2.getFontObject(type)) != null) {
                fo = fo.copy();
                this.getEditableFonts().add(fo);
                return fo;
            }
        }
        if (this.getModel() instanceof EditableFonts && (dfc = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType())) != null) {
            return dfc.getFontObject(type);
        }
        return null;
    }
}

