/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.JobArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;

public class SchedulerJob
extends SchedulerObject {
    static Map<String, Integer> eventsValues = new TreeMap<String, Integer>();
    public static String JOB_STARTED = "JOB_STARTED";
    public static String JOB_SUCCEEDED = "JOB_SUCCEEDED";
    public static String JOB_FAILED = "JOB_FAILED";
    public static String JOB_BROKEN = "JOB_BROKEN";
    public static String JOB_COMPLETED = "JOB_COMPLETED";
    public static String JOB_STOPPED = "JOB_STOPPED";
    public static String JOB_SCH_LIM_REACHED = "JOB_SCH_LIM_REACHED";
    public static String JOB_DISABLED = "JOB_DISABLED";
    public static String JOB_CHAIN_STALLED = "JOB_CHAIN_STALLED";
    public static String JOB_ALL_EVENTS = "JOB_ALL_EVENTS";
    public static String JOB_OVER_MAX_DUR = "JOB_OVER_MAX_DUR";
    public static String JOB_RUN_COMPLETED = "JOB_RUN_COMPLETED";
    public static String DBMS_SCHEDULER_LOGGING_OFF = "DBMS_SCHEDULER.LOGGING_OFF";
    public static String DBMS_SCHEDULER_LOGGING_FULL = "DBMS_SCHEDULER.LOGGING_FULL";
    public static String DBMS_SCHEDULER_LOGGING_FAILED_RUNS = "DBMS_SCHEDULER.LOGGING_FAILED_RUNS";
    public static String DBMS_SCHEDULER_LOGGING_RUNS = "DBMS_SCHEDULER.LOGGING_FAILED_RUNS";
    public static String DBMS_SCHEDULER_LOGGING_PREFIX = "DBMS_SCHEDULER.LOGGING_";
    List<SchedulerArgument> arguments = new ArrayList<SchedulerArgument>();
    public static HashMap<String, String> LOGIING_MAP = new HashMap();

    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("JOB_NAME");
        this.propsList.add("JOB_STYLE");
        this.propsList.add("PROGRAM_OWNER");
        this.propsList.add("PROGRAM_NAME");
        this.propsList.add("JOB_TYPE");
        this.propsList.add("JOB_ACTION");
        this.propsList.add("NUMBER_OF_ARGUMENTS");
        this.propsList.add("SCHEDULE_OWNER");
        this.propsList.add("SCHEDULE_NAME");
        this.propsList.add("SCHEDULE_TYPE");
        this.propsList.add("START_DATE");
        this.propsList.add("REPEAT_INTERVAL");
        this.propsList.add("EVENT_QUEUE_OWNER");
        this.propsList.add("EVENT_QUEUE_NAME");
        this.propsList.add("EVENT_QUEUE_AGENT");
        this.propsList.add("EVENT_CONDITION");
        this.propsList.add("FILE_WATCHER_OWNER");
        this.propsList.add("FILE_WATCHER_NAME");
        this.propsList.add("END_DATE");
        this.propsList.add("JOB_CLASS");
        this.propsList.add("ENABLED");
        this.propsList.add("AUTO_DROP");
        this.propsList.add("RESTART_ON_RECOVERY");
        this.propsList.add("RESTART_ON_FAILURE");
        this.propsList.add("JOB_PRIORITY");
        this.propsList.add("MAX_RUNS");
        this.propsList.add("MAX_FAILURES");
        this.propsList.add("SCHEDULE_LIMIT");
        this.propsList.add("MAX_RUN_DURATION");
        this.propsList.add("LOGGING_LEVEL");
        this.propsList.add("STORE_OUTPUT");
        this.propsList.add("STOP_ON_WINDOW_CLOSE");
        this.propsList.add("INSTANCE_STICKINESS");
        this.propsList.add("RAISE_EVENTS");
        this.propsList.add("NLS_ENV");
        this.propsList.add("DESTINATION_OWNER");
        this.propsList.add("DESTINATION");
        this.propsList.add("CREDENTIAL_OWNER");
        this.propsList.add("CREDENTIAL_NAME");
        this.propsList.add("INSTANCE_ID");
        this.propsList.add("ALLOW_RUNS_IN_RESTRICTED_MODE");
        this.propsList.add("COMMENTS");
        this.propsList.add("HAS_CONSTRAINTS");
        this.propsList.add("CONNECT_CREDENTIAL_OWNER");
        this.propsList.add("CONNECT_CREDENTIAL_NAME");
        this.propsList.add("FAIL_ON_SCRIPT_ERROR");
        this.propsList.add("PARALLEL_INSTANCES");
        this.excludeFromCompare.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("JOB_NAME", "VARCHAR2");
        this.dataTypes.put("JOB_SUBNAME", "VARCHAR2");
        this.dataTypes.put("JOB_STYLE", "VARCHAR2");
        this.dataTypes.put("JOB_CREATOR", "VARCHAR2");
        this.dataTypes.put("CLIENT_ID", "VARCHAR2");
        this.dataTypes.put("GLOBAL_UID", "VARCHAR2");
        this.dataTypes.put("PROGRAM_OWNER", "VARCHAR2");
        this.dataTypes.put("PROGRAM_NAME", "VARCHAR2");
        this.dataTypes.put("JOB_TYPE", "VARCHAR2");
        this.dataTypes.put("JOB_ACTION", "VARCHAR2");
        this.dataTypes.put("NUMBER_OF_ARGUMENTS", "NUMBER");
        this.dataTypes.put("SCHEDULE_OWNER", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_NAME", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_TYPE", "VARCHAR2");
        this.dataTypes.put("START_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("REPEAT_INTERVAL", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_OWNER", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_NAME", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_AGENT", "VARCHAR2");
        this.dataTypes.put("EVENT_CONDITION", "VARCHAR2");
        this.dataTypes.put("EVENT_RULE", "VARCHAR2");
        this.dataTypes.put("FILE_WATCHER_OWNER", "VARCHAR2");
        this.dataTypes.put("FILE_WATCHER_NAME", "VARCHAR2");
        this.dataTypes.put("END_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("JOB_CLASS", "VARCHAR2");
        this.dataTypes.put("ENABLED", "BOOLEAN");
        this.dataTypes.put("AUTO_DROP", "BOOLEAN");
        this.dataTypes.put("RESTART_ON_RECOVERY", "BOOLEAN");
        this.dataTypes.put("RESTART_ON_FAILURE", "BOOLEAN");
        this.dataTypes.put("STATE", "VARCHAR2");
        this.dataTypes.put("JOB_PRIORITY", "NUMBER");
        this.dataTypes.put("RUN_COUNT", "NUMBER");
        this.dataTypes.put("UPTIME_RUN_COUNT", "NUMBER");
        this.dataTypes.put("MAX_RUNS", "NUMBER");
        this.dataTypes.put("FAILURE_COUNT", "NUMBER");
        this.dataTypes.put("UPTIME_FAILURE_COUNT", "NUMBER");
        this.dataTypes.put("MAX_FAILURES", "NUMBER");
        this.dataTypes.put("RETRY_COUNT", "NUMBER");
        this.dataTypes.put("LAST_START_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("LAST_RUN_DURATION", "INTERVAL DAY(9) TO SECOND(6)");
        this.dataTypes.put("NEXT_RUN_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("SCHEDULE_LIMIT", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("MAX_RUN_DURATION", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("LOGGING_LEVEL", "NUMBER");
        this.dataTypes.put("STORE_OUTPUT", "BOOLEAN");
        this.dataTypes.put("STOP_ON_WINDOW_CLOSE", "BOOLEAN");
        this.dataTypes.put("INSTANCE_STICKINESS", "BOOLEAN");
        this.dataTypes.put("RAISE_EVENTS", "NUMBER");
        this.dataTypes.put("SYSTEM", "VARCHAR2");
        this.dataTypes.put("JOB_WEIGHT", "NUMBER");
        this.dataTypes.put("NLS_ENV", "VARCHAR2");
        this.dataTypes.put("SOURCE", "VARCHAR2");
        this.dataTypes.put("NUMBER_OF_DESTINATIONS", "NUMBER");
        this.dataTypes.put("DESTINATION_OWNER", "VARCHAR2");
        this.dataTypes.put("DESTINATION", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_OWNER", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_NAME", "VARCHAR2");
        this.dataTypes.put("INSTANCE_ID", "NUMBER");
        this.dataTypes.put("DEFERRED_DROP", "BOOLEAN");
        this.dataTypes.put("ALLOW_RUNS_IN_RESTRICTED_MODE", "BOOLEAN");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
        this.dataTypes.put("FLAGS", "NUMBER");
        this.dataTypes.put("RESTARTABLE", "BOOLEAN");
        this.dataTypes.put("HAS_CONSTRAINTS", "VARCHAR2");
        this.dataTypes.put("CONNECT_CREDENTIAL_OWNER", "VARCHAR2");
        this.dataTypes.put("CONNECT_CREDENTIAL_NAME", "VARCHAR2");
        this.dataTypes.put("FAIL_ON_SCRIPT_ERROR", "BOOLEAN");
        this.dataTypes.put("PARALLEL_INSTANCES", "BOOLEAN");
    }

    @Override
    public void initdefaults() {
        this.defaults.put("JOB_STYLE", "REGULAR");
        this.defaults.put("NUMBER_OF_ARGUMENTS", "0");
        this.defaults.put("JOB_CLASS", "DEFAULT_JOB_CLASS");
        this.defaults.put("ENABLED", "FALSE");
        this.defaults.put("AUTO_DROP", "TRUE");
        this.defaults.put("JOB_PRIORITY", "3");
        this.defaults.put("LOGGING_LEVEL", "DBMS_SCHEDULER.LOGGING_OFF");
        this.defaults.put("STORE_OUTPUT", "FALSE");
        this.defaults.put("STOP_ON_WINDOW_CLOSE", "FALSE");
        this.defaults.put("INSTANCE_STICKINESS", "TRUE");
        this.defaults.put("RAISE_EVENTS", "0");
        this.defaults.put("JOB_WEIGHT", "1");
        this.defaults.put("ALLOW_RUNS_IN_RESTRICTED_MODE", "FALSE");
        this.defaults.put("FLAGS", "NUMBER");
        this.defaults.put("RESTARTABLE", "FALSE");
        this.defaults.put("RESTART_ON_FAILURE", "FALSE");
        this.defaults.put("RESTART_ON_RECOVERY", "FALSE");
        this.defaults.put("FAIL_ON_SCRIPT_ERROR", "VARCHAR2");
        this.defaults.put("PARALLEL_INSTANCES", "FALSE");
    }

    @Override
    public void initNames() {
    }

    public static void main(String[] args) {
    }

    @Override
    public String getName() {
        return this.getProperty("JOB_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("PROGRAM_NAME");
        if (value != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("JOB_ACTION");
        return value != null && !value.isEmpty() && (value = this.getProperty("JOB_TYPE")) != null && !value.isEmpty();
    }

    public String getJobAction() {
        return this.getProperty("JOB_ACTION");
    }

    public String getJobType() {
        return this.getProperty("JOB_TYPE");
    }

    public String getProgramName() {
        return this.getProperty("PROGRAM_NAME");
    }

    public String getProgramOwner() {
        return this.getProperty("PROGRAM_OWNER");
    }

    public String getFileWatcherName() {
        return this.getProperty("FILE_WATCHER_NAME");
    }

    public String getFileWatcherOwner() {
        return this.getProperty("FILE_WATCHER_OWNER");
    }

    public String getEnabled() {
        return this.getProperty("ENABLED");
    }

    public String getProgramNameFormatted() {
        String name = this.getProgramName();
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProgramOwner();
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerJob.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerJob.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getFileWatcherNameFormatted() {
        String name = this.getFileWatcherName();
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getFileWatcherOwner();
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerJob.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerJob.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getScheduleNameFormatted() {
        String name = this.getProperty("SCHEDULE_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("SCHEDULE_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerJob.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerJob.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getConnectCredentialNameFormatted() {
        String name = this.getProperty("CONNECT_CREDENTIAL_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("CONNECT_CREDENTIAL_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerJob.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerJob.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getEventQueueSpecNameFormatted() {
        String name = this.getProperty("EVENT_QUEUE_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("EVENT_QUEUE_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerJob.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerJob.getFormatedSimpleName(name);
            String agent = this.getProperty("EVENT_QUEUE_AGENT");
            if (agent != null && !agent.isEmpty()) {
                res = (String)res + "," + SchedulerJob.getFormatedSimpleName(agent);
            }
            return res;
        }
        return null;
    }

    public static int getRaiseEventsNumber(String events) {
        int res = 0;
        if (events != null) {
            String[] parts;
            String ev = events.toUpperCase();
            if (JOB_OVER_MAX_DUR.equals(ev)) {
                return 0;
            }
            for (String part : parts = ev.split(",")) {
                String p = part.trim();
                Integer val = eventsValues.get(p);
                if (val == null) continue;
                res += val.intValue();
            }
        }
        return res;
    }

    public List<SchedulerArgument> getArguments() {
        return this.arguments;
    }

    public List<SchedulerArgument> getSortedArguments() {
        try {
            Collections.sort(this.arguments, SchedulerProgram.POSITION_COMPARATOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.arguments;
    }

    public boolean addArgument(String name, int position, String type, String metadataAttribute, String defaultValue) {
        int num = this.getNumberOfArguments();
        if (num > 0 && position > 0 && position <= num) {
            SchedulerArgument arg = this.getArgumentByPosition(position);
            if (arg == null) {
                arg = new SchedulerArgument();
                this.arguments.add(arg);
            }
            arg.setProperty("ARGUMENT_NAME", name);
            arg.setProperty("ARGUMENT_POSITION", String.valueOf(position));
            arg.setProperty("METADATA_ATTRIBUTE", metadataAttribute);
            arg.setProperty("DEFAULT_VALUE", "DEFAULT_VALUE");
        }
        return false;
    }

    public int getNumberOfArguments() {
        String num = this.getProperty("NUMBER_OF_ARGUMENTS");
        if (num != null && !num.isEmpty()) {
            try {
                return Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public SchedulerArgument getArgumentByPosition(int position) {
        for (SchedulerArgument arg : this.arguments) {
            if (position != arg.getPosition()) continue;
            return arg;
        }
        return null;
    }

    public boolean addArgument(SchedulerArgument arg) {
        int position = arg.getPosition();
        if (position > 0) {
            SchedulerArgument targ = this.getArgumentByPosition(position);
            if (targ == null) {
                targ = new JobArgument();
                this.arguments.add(targ);
            }
            arg.copyProperties(targ);
        }
        return false;
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        if (this.arguments.size() > 0) {
            ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
            PropertiesObject.CollectionDescriptor cd = new PropertiesObject.CollectionDescriptor();
            cd.name = SchedulerProgram.ARGUMENTS;
            cd.coll = this::getSortedArguments;
            list.add(cd);
            return list;
        }
        return super.getCollectionDescriptors();
    }

    @Override
    public SchedulerObject createObjectForCollection(String collName) {
        if (collName != null && SchedulerProgram.ARGUMENTS.equalsIgnoreCase(collName)) {
            return new JobArgument();
        }
        return super.createObjectForCollection(collName);
    }

    @Override
    public void addObject(String collName, PropertiesObject obj) {
        if (collName != null && SchedulerProgram.ARGUMENTS.equalsIgnoreCase(collName) && obj instanceof JobArgument) {
            this.addArgument((JobArgument)obj);
            return;
        }
        super.addObject(collName, obj);
    }

    public void convertLoggingLevel() {
        String nval;
        String val = this.getProperty("LOGGING_LEVEL");
        if (val != null && !val.isEmpty() && !val.toUpperCase().startsWith(DBMS_SCHEDULER_LOGGING_PREFIX) && (nval = LOGIING_MAP.get(val)) != null) {
            this.setProperty("LOGGING_LEVEL", nval);
        }
    }

    public String getLoggingLevelForDefinition(String propValue) {
        String val;
        if (propValue != null && !propValue.isEmpty() && (val = LOGIING_MAP.get(propValue)) != null) {
            return val;
        }
        return DBMS_SCHEDULER_LOGGING_OFF;
    }

    @Override
    public void validate() {
        String name;
        this.convertLoggingLevel();
        String type = this.getProperty("SCHEDULE_TYPE");
        if (type != null && "FILE_WATCHER".equalsIgnoreCase(type) && (name = this.getEventQueueSpecNameFormatted()) != null && !name.isEmpty()) {
            this.removeProperty("EVENT_QUEUE_OWNER");
            this.removeProperty("EVENT_QUEUE_NAME");
            this.removeProperty("EVENT_QUEUE_AGENT");
        }
    }

    static {
        eventsValues.put(JOB_STARTED, 1);
        eventsValues.put(JOB_SUCCEEDED, 2);
        eventsValues.put(JOB_FAILED, 4);
        eventsValues.put(JOB_BROKEN, 8);
        eventsValues.put(JOB_COMPLETED, 16);
        eventsValues.put(JOB_STOPPED, 32);
        eventsValues.put(JOB_SCH_LIM_REACHED, 64);
        eventsValues.put(JOB_DISABLED, 128);
        eventsValues.put(JOB_CHAIN_STALLED, 256);
        eventsValues.put(JOB_ALL_EVENTS, 511);
        eventsValues.put(JOB_OVER_MAX_DUR, 0);
        eventsValues.put(JOB_RUN_COMPLETED, 38);
        LOGIING_MAP.put("OFF", DBMS_SCHEDULER_LOGGING_OFF);
        LOGIING_MAP.put("FAILED_RUNS", DBMS_SCHEDULER_LOGGING_FAILED_RUNS);
        LOGIING_MAP.put("RUNS", DBMS_SCHEDULER_LOGGING_RUNS);
        LOGIING_MAP.put("FULL", DBMS_SCHEDULER_LOGGING_FULL);
    }
}

