/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.JSONToObjectTransformer;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLMapToObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStringBuilderTransformer;
import oracle.dbtools.crest.model.metadata.XMLToMapTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectSAXTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.io.FolderFilesListing;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XMLTransformationManager
implements MDXMLConstants {
    public static final String COMPRESSED_FILE_SUFIX = "z";
    public static final String EXTENSION_LOCAL_FILES = ".local";
    public static final String EXTENSION_LOCAL_FILES_COMPRESSED = ".localz";
    public static final String EXTENSION_XML_FILES = ".xml";
    public static final String EXTENSION_XML_FILES_COMPRESSED = ".xmlz";
    public static boolean JDOM_PARSING = false;
    public static final String OBJECT_LIST = "Objects.local";
    public static final String CHANGE_REQUEST_LIST = "ChangeRequests.local";
    public static final String SENSITIVE_TYPES_LIST = "SensitiveTypes.local";
    public static final String DIAGRAM_LIST = "Diagrams.local";
    public static final String DDL_SELECTION_LIST = "DDLSelection.local";
    public static final String SITE_TYPE = "siteType";
    public static final String SITE_ID = "siteID";
    public static final String SITE_NAME = "siteName";
    public static final String MARKED_GENERATE = "markedGenerate";
    public static boolean lazy_loading = false;
    public static final String PRESERVED_DDL_SELECTION_LIST = "Preserved_DDLSelection.local";
    public static boolean REBUILD_OBJECT_LIST = true;
    public static final String PERSISTED_DDL_SELECTION = "DatamodelerPersistedDDLSelection";
    public static final String DESIGN_NAME = "designName";
    public static final String SELECTED_SUBVIEW = "selectedSubView";
    public static final String SUBVIEW_NAME = "subviewName";
    public static final String INCLUDE_COMMENTS = "IncludeComments";
    public static final String GENERATE_DDL_IN_FILES = "generateDDLInFiles";
    public static final String GENERATE_REST_SERVICES = "generateRESTServices";
    public static final String APPLY_NAME_SUBSTITUTION = "applyNameSubstitution";
    public static final String INCLUDE_TABLE_SCRIPTS = "includeTableScripts";
    public static final String TABLE_SCRIPT = "tableScript";
    public static final String TABLE_NAME = "tableName";
    public static final String SD_OBJECT = "storageDesignObject";
    public static final String SD_CLASS = "storageDesignClass";
    public static final String SD_NAME = "storageDesignName";
    public static final String NAMES_SUBSTITUTION = "namesSubstitution";
    public static final String NAME_SUBSTITUTION = "nameSubstitution";
    public static final String IS_CASE_SENSITIVE = "isCaseSensitive";
    public static final String OLD_NAME = "oldName";
    public static final String NEW_NAME = "newName";
    public static final String COMMENTS = "comments";
    public static final String OBJECT_TYPES = "objectTypes";
    public static final String TYPE = "type";
    public static final String KEY = "OSDDM_DDLPP";
    public static final String TABLE_LEVEL_CONSTRAINTS = "tableLevelConstraints";
    public static final String TABLE_LEVEL_CONSTRAINT = "tableLevelConstraint";
    public static final String CONSTRAINT_NAME = "constraintName";
    public static final String CONSTRAINT_RULE = "constraintRule";
    public static final String TABLE_COLUMNS = "tableColumns";
    public static final String TABLE_COLUMN = "tableColumn";
    public static final String COLUMN_ID = "columnID";
    public static final String CONSTRAINT_MARKED_GENERATE = "constraintMarkedGenerate";
    public static final String EXISTENCE_DEPENDENCIES = "existenceDependencies";
    public static final String EXISTENCE_DEPENDENCY = "existenceDependency";
    public static final String EXISTENCE_DEPENDENCY_NAME = "existenceDependencyName";
    public static final String FK_DEP_COLUMN_CONSTRAINT_IN_DDL = "dependantColConstrInDDL";
    public static final String DROP_SELECTION = "dropSelection";
    public static final String DROP_GENERATED_OBJECTS_ONLY = "dropGeneratedObjectsOnly";
    public static final String USE_DROP_DEPENDENCIES = "useDropDependencies";
    public static final String DROPABLE_OBJECT = "dropableObject";
    private MDTransformationManager mdtManager = null;
    private boolean checkDirty = true;
    private static boolean saveFailed = false;
    private MDTransformationManager xmlMapManager = null;
    private MDTransformationManager objectMapTransManager = null;
    private MetaDataManager metaDataManager = new MetaDataManager();
    private String persistedDDLSelectionPath = null;
    private IncludeCommentsAndApplyNameSubstitutionHelper icansHelper;
    private boolean saveSelectionsBLPS = false;
    private boolean DDLGenerated = false;
    private boolean DDLSelectionLoaded = false;
    private boolean selectedSubViewChanged = false;
    private XMLToObjectSAXTransformer xMLToObjectSAXTransformer;
    private static final Logger LOGGER = new Logger(XMLTransformationManager.class);
    private static XMLTransformationManager xmlTransformationManager = null;
    FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES) || name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES_COMPRESSED) || file.isDirectory();
        }
    };

    public static XMLTransformationManager getInstance() {
        if (xmlTransformationManager == null) {
            xmlTransformationManager = new XMLTransformationManager();
        }
        return xmlTransformationManager;
    }

    private XMLTransformationManager() {
    }

    public boolean isCheckDirty() {
        return this.checkDirty;
    }

    public void setCheckDirty(boolean checkDirty) {
        this.checkDirty = checkDirty;
    }

    public String fixFilePath(String path) {
        int pos = path.indexOf(92);
        if (pos == -1) {
            return path;
        }
        return path.replaceAll("[\\\\]", "/");
    }

    public boolean designExists(String location, String fileNameNoExt) {
        for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
            String ext = XMLConstants.DESIGN_EXTENSIONS[i];
            File file = new File(location, fileNameNoExt + ext);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public boolean deleteDesign(String location, String fileNameNoExt) {
        File file = null;
        boolean result = true;
        if (fileNameNoExt != null) {
            for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
                String ext = XMLConstants.DESIGN_EXTENSIONS[i];
                file = new File(location, fileNameNoExt + ext);
                if (!file.exists()) continue;
                result = file.delete();
            }
            file = new File(location, fileNameNoExt);
            if (file.exists() && file.isDirectory()) {
                result = this.deleteDirectory(file);
            }
        }
        return result;
    }

    public boolean deleteFiles(List files) {
        boolean result = false;
        System.gc();
        for (int i = 0; i < files.size(); ++i) {
            File file;
            String filePath = (String)files.get(i);
            if (filePath == null || !(file = new File(this.fixFilePath(filePath))).exists()) continue;
            if (file.isDirectory()) {
                result = this.deleteDirectory(file);
                continue;
            }
            result = file.delete();
            if (result) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            result = file.delete();
        }
        return result;
    }

    public boolean deleteDirectory(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            return dir.delete();
        }
        return false;
    }

    private void addObjectsToLists(DesignPart dp, List<StorableObject> list, Map pdMap, boolean multi, boolean single) {
        boolean partial = dp.getDesign().shouldExportPartial(dp);
        if (pdMap != null) {
            Boolean shouldSave = this.shouldSave(dp);
            pdMap.put(dp, shouldSave);
        }
        for (ModelIDObject obj : dp.getStorableDesignObjects()) {
            if (!multi && !obj.isUsedAsRemoteObject() || (dp instanceof LogicalDesign || dp instanceof RelationalDesign) && partial && !dp.getDesign().shouldExport((DesignObject)obj)) continue;
            list.add(obj);
        }
    }

    public boolean saveDesignFile(Design design) {
        return XMLTransformationManager.saveContent(design.getStorageName(), design, design.isCompressedDesign(), this.getMDTransformationManager());
    }

    public boolean saveDesign(Design design) {
        try {
            DataTypesDesign dataTypesDesign;
            saveFailed = false;
            int oper = design.getCurrentOperation();
            if (oper == 4 || oper == 5) {
                this.checkDirty = false;
            }
            int pers = design.getModelPersistence();
            boolean multi = design.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES;
            boolean single = !design.isVersioned() && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE);
            HashMap<StorageDesign, Boolean> dpMap = new HashMap<StorageDesign, Boolean>();
            this.saveRDBMSSites(design);
            this.saveDomains(design);
            if (oper == 4) {
                this.saveAdditionalFiles(design);
            }
            ArrayList<StorableObject> list = new ArrayList<StorableObject>();
            list.add(design);
            if (this.isCheckDirty()) {
                // empty if block
            }
            if ((dataTypesDesign = design.getDataTypesDesign()).isLoaded() && (design.shouldExportFull(dataTypesDesign) || design.shouldExportPartial(dataTypesDesign))) {
                list.add(dataTypesDesign);
                this.addObjectsToLists(dataTypesDesign, list, dpMap, multi, single);
                this.saveObjectList(dataTypesDesign);
                if (multi) {
                    // empty if block
                }
            }
            if (design.getLogicalDesign().isLoaded() && (design.shouldExportFull(design.getLogicalDesign()) || design.shouldExportPartial(design.getLogicalDesign()))) {
                list.add(design.getLogicalDesign());
                this.addObjectsToLists(design.getLogicalDesign(), list, dpMap, multi, single);
                this.saveObjectList(design.getLogicalDesign());
                if (multi) {
                    // empty if block
                }
            }
            for (DesignPart model : design.getRelationalDesigns()) {
                if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model)) continue;
                RelationalDesign relationalDesign = (RelationalDesign)model;
                list.add(model);
                if (this.isCheckDirty()) {
                    // empty if block
                }
                this.addObjectsToLists(model, list, dpMap, multi, single);
                this.saveObjectList(model);
                if (multi) {
                    // empty if block
                }
                StorageDesign[] storageDesigns = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                for (int i = 0; i < storageDesigns.length; ++i) {
                    List sol;
                    StorageDesign stDes = storageDesigns[i];
                    if (!stDes.isOpen()) continue;
                    Boolean shouldSave = stDes.isOpen() && (!this.isCheckDirty() || this.isCheckDirty() && (stDes.isDirty() || stDes.hasDirtyStorableObjects()));
                    dpMap.put(stDes, shouldSave);
                    list.add(stDes);
                    if (this.isCheckDirty()) {
                        if (stDes.isDirty() || stDes.hasDirtyStorableObjects()) {
                            if (design.isOldRepositoryType()) {
                                this.clearPropertyMap(stDes.getStorableObjects());
                            }
                            if (multi) {
                                if (design.shouldExportPartial(model)) {
                                    sol = stDes.getStorableObjects();
                                    for (Object obj : sol) {
                                        if (!(obj instanceof RelationalObjectProxy)) continue;
                                    }
                                } else {
                                    list.addAll(stDes.getStorableObjects());
                                }
                            }
                        }
                    } else {
                        if (design.isOldRepositoryType()) {
                            this.clearPropertyMap(stDes.getStorableObjects());
                        }
                        if (multi) {
                            if (design.shouldExportPartial(model)) {
                                sol = stDes.getStorableObjects();
                                for (Object obj : sol) {
                                    if (!(obj instanceof RelationalObjectProxy)) continue;
                                }
                            } else {
                                list.addAll(stDes.getStorableObjects());
                            }
                        }
                    }
                    this.saveObjectList(stDes);
                }
            }
            ArrayList<StorableObject> dpList = new ArrayList<StorableObject>();
            for (StorableObject obj : list) {
                if (obj instanceof DesignPart || obj instanceof StorageDesign) {
                    dpList.add(obj);
                    continue;
                }
                this.saveObject(obj);
            }
            for (ModelIDObject modelIDObject : dpList) {
                this.saveObject(modelIDObject);
                if (modelIDObject instanceof DesignPart) {
                    DesignPart dp = (DesignPart)modelIDObject;
                    try {
                        if (single) {
                            this.saveDesignPartSingleFile(dp);
                        }
                        if (design.getCurrentOperation() == 5) continue;
                        dp.doAfterSave();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + dp.getName(), e);
                    }
                    continue;
                }
                if (!(modelIDObject instanceof StorageDesign)) continue;
                StorageDesign sd = (StorageDesign)modelIDObject;
                try {
                    if (single) {
                        this.savePhysicalModelSingleFile(sd);
                    }
                    if (design.getCurrentOperation() == 5) continue;
                    sd.doAfterSave();
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning files in physical model: " + sd.getName(), e);
                }
            }
            design.setLoadedModelPersistence(design.getModelPersistence());
            return !saveFailed;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the design: " + design.getName(), ex);
            return false;
        }
    }

    private boolean shouldSave(DesignPart designPart) {
        boolean shouldSave = designPart.isLoaded() && (!this.isCheckDirty() || this.isCheckDirty() && (designPart.isDirty() || designPart.hasDirtyStorableObjects()));
        return shouldSave;
    }

    public boolean saveDesignPart(DesignPart designPart) {
        boolean shouldSave;
        boolean result = false;
        Design des = designPart.getDesign();
        int pers = des.getModelPersistence();
        boolean bl = shouldSave = designPart.isLoaded() && (!this.isCheckDirty() || this.isCheckDirty() && (designPart.isDirty() || designPart.hasDirtyStorableObjects()));
        if (des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES) {
            result = this.saveDesignPartMultiFiles(designPart);
            if (result && shouldSave && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE)) {
                result = this.saveDesignPartSingleFile(designPart);
            }
        } else if (pers == Design.PERS_MODEL_IN_ONE_FILE) {
            result = this.saveDesignPartSingleFile(designPart);
            this.saveDesignPartSFAdditionalObjects(designPart);
        }
        return result;
    }

    private void addSFAdditionalObjectsToLists(DesignPart dp, List<StorableObject> list, boolean multi, boolean single) {
        boolean partial = dp.getDesign().shouldExportPartial(dp);
        for (ModelIDObject obj : dp.getStorableDesignObjects()) {
            if (multi || !single || !obj.isUsedAsRemoteObject() || (dp instanceof LogicalDesign || dp instanceof RelationalDesign) && partial && !dp.getDesign().shouldExport((DesignObject)obj)) continue;
            list.add(obj);
        }
    }

    public boolean saveDesignPartSFAdditionalObjects(DesignPart designPart) {
        if (designPart.isLoaded()) {
            try {
                Design des = designPart.getDesign();
                int pers = des.getModelPersistence();
                boolean multi = des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES;
                boolean single = !des.isVersioned() && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE);
                ArrayList<StorableObject> list = new ArrayList<StorableObject>();
                this.addSFAdditionalObjectsToLists(designPart, list, multi, single);
                if (!this.isCheckDirty() || designPart instanceof RelationalDesign) {
                    // empty if block
                }
                for (StorableObject obj : list) {
                    this.saveObject(obj);
                }
            }
            catch (Exception e) {
                Logger.error(e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveDesignPartSingleFile(DesignPart designPart) {
        if (designPart.isLoaded()) {
            String storageName = designPart.getStoragePath() + "/" + designPart.getShortObjectID() + ".model.local";
            TimeLog.log("start save operation");
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                saveFailed = false;
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    if (designPart instanceof RelationalDesign) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("rmExtendedMap");
                        list.add("StorageDesigns");
                        XMLTransformationManager.writeContentAsStream(designPart, bs, trMan, true, list);
                    } else {
                        XMLTransformationManager.writeContentAsStream(designPart, bs, trMan, true, null);
                    }
                    bs.flush();
                    bs.close();
                    if (designPart.isDirty()) {
                        this.saveObject(designPart);
                    }
                    try {
                        int pers = designPart.getDesign().getModelPersistence();
                        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
                            designPart.synchronizeFilesMap(true);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + designPart.getName(), e);
                    }
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return !saveFailed;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
            }
        }
        return false;
    }

    public boolean saveDesignPartMultiFiles(DesignPart designPart) {
        try {
            saveFailed = false;
            ArrayList<DesignPart> list = new ArrayList<DesignPart>();
            list.add(designPart);
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    list.addAll(designPart.getStorableDesignObjects());
                }
                if (designPart instanceof RelationalDesign) {
                    // empty if block
                }
            } else if (designPart.isLoaded()) {
                list.addAll(designPart.getStorableDesignObjects());
                if (designPart instanceof RelationalDesign) {
                    // empty if block
                }
            }
            ArrayList<StorableObject> dpList = new ArrayList<StorableObject>();
            for (StorableObject storableObject : list) {
                if (storableObject instanceof DesignPart) {
                    dpList.add(storableObject);
                    continue;
                }
                this.saveObject(storableObject);
            }
            if (this.isCheckDirty()) {
                if (designPart.isLoaded() && (designPart.isDirty() || designPart.hasDirtyStorableObjects())) {
                    this.saveObjectList(designPart);
                }
            } else if (designPart.isLoaded()) {
                this.saveObjectList(designPart);
            }
            for (DesignPart designPart2 : dpList) {
                try {
                    this.saveObject(designPart2);
                    designPart2.synchronizeFilesMap(true);
                }
                catch (Exception e) {
                    LOGGER.error("Error in cleaning files in model: " + designPart2.getName(), e);
                }
            }
            return !saveFailed;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the Design Part: " + designPart.getName(), ex);
            return false;
        }
    }

    public MDTransformationManager getMDTransformationManager() {
        if (this.mdtManager == null) {
            this.mdtManager = new MDTransformationManager(this.metaDataManager);
            this.mdtManager.registerTransformer(ModelIDObject.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            this.mdtManager.registerTransformer(Object.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            MDTransformer.SKP_DEFAULTS = false;
        }
        return this.mdtManager;
    }

    public Document getXMLContent(Object object) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectTransformer() != null) {
            return ((XMLFromObjTransformer)trs.getFromObjectTransformer()).transformFromObject(object);
        }
        return null;
    }

    public String getContentAsString(Object object) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectTransformer() != null) {
            return ((XMLObjToStringBuilderTransformer)trs.getFromObjectTransformer()).transformFromObjectToString(object, null);
        }
        return null;
    }

    private boolean saveObject(StorableObject object) {
        if (object instanceof StorageObject && ((StorageObject)object).isNullInstance() && !((StorageObject)object).isStorableNullInstance()) {
            return false;
        }
        Design design = object.getDesign();
        int oper = design.getCurrentOperation();
        if (!this.isCheckDirty() || this.isCheckDirty() && this.hasDirtyStatus(object)) {
            String storageName = object.getStorageName();
            if (object instanceof ModelIDObject) {
                if (!this.isCheckDirty()) {
                    ((ModelIDObject)object).setSegmentedStorageName(null);
                }
                storageName = ((ModelIDObject)object).getSegmentedStorageName();
                if (design.isVersioned() && ((ModelIDObject)object).isRestoredFromSavedDelete()) {
                    ((ModelIDObject)object).setRestoredFromSavedDelete(false);
                }
            }
            if (storageName != null) {
                try {
                    XMLTransformationManager.saveContent(storageName, object, false, this.getMDTransformationManager());
                    if (oper != 5) {
                        this.clearDirtyStatus(object);
                    }
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Can not write data! Location: " + object.getStorageName() + " - Name: " + object.getName(), e);
                    saveFailed = true;
                }
            }
        }
        return false;
    }

    public boolean transformFromXMLToObject(Object object, String fileName) {
        return this.transformFromXMLToObject(object, new File(fileName), false);
    }

    public boolean transformFromXMLToObject(Object object, File file, boolean useCompressedFiles) {
        return this.transformFromXMLToObject(object, file, useCompressedFiles, true, null);
    }

    public boolean transformFromXMLToObjectSAX(Object object, File file, List excludeProps) {
        XMLToObjectSAXTransformer tr = this.getXMLToObjectSAXTransformer();
        try {
            tr.transformToObject(object, file, false, excludeProps);
            return true;
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean transformFromXMLToObject(Object object, File file, boolean useCompressedFiles, boolean clearDirtyFlag, List excludeProps) {
        MDTransformationManager.TrObjects trs = this.getMDTransformationManager().getTransformersFor(object.getClass());
        if (trs == null) return false;
        if (trs.getToObjectTransformer() == null) return false;
        try {
            Object fileName = file.getAbsolutePath();
            if (useCompressedFiles) {
                Document doc;
                if (!((String)fileName).endsWith(COMPRESSED_FILE_SUFIX)) {
                    fileName = (String)fileName + COMPRESSED_FILE_SUFIX;
                    File zFile = new File((String)fileName);
                    doc = XMLTransformationManager.getDocument(zFile);
                } else {
                    doc = XMLTransformationManager.getDocument(file);
                }
                if (doc == null) return false;
                ((XMLToObjectTransformer)trs.getToObjectTransformer()).transformToObject(object, doc, excludeProps);
            } else {
                MDTransformer tr = trs.getToObjectTransformer();
                if (tr instanceof XMLToObjectTransformer) {
                    ((XMLToObjectTransformer)trs.getToObjectTransformer()).transformToObject(object, file, excludeProps);
                }
            }
            if (!clearDirtyFlag) return true;
            this.clearDirtyStatus(object);
            return true;
        }
        catch (Exception e) {
            boolean log = true;
            if (e instanceof FileNotFoundException && object instanceof ModelIDObject) {
                ModelIDObject mobj = (ModelIDObject)object;
                String id = mobj.getObjectID();
                if ("47E390DE-0671-C4B1-8428-0F45CBEE18F8".equals(id)) return false;
                if ("F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1".equals(id)) {
                    return false;
                }
            }
            if (!log) return false;
            LOGGER.error("Unable to load object from XML: " + file.getAbsolutePath(), e);
        }
        return false;
    }

    public void transformFromXMLToObject(Object object, Document doc) {
        XMLToObjectTransformer tr = (XMLToObjectTransformer)this.getMDTransformationManager().getToObjectTransformerFor(object.getClass());
        if (tr != null && doc != null) {
            tr.transformToObject(object, doc, null);
        }
    }

    public Map transformFromObjectToMap(Object object) {
        return this.transformFromObjectToMap(object, null, null);
    }

    public Map transformFromObjectToMap(Object object, List inludeProps, List includeCollections) {
        return this.transformFromObjectToMap(object, inludeProps, includeCollections, null);
    }

    public Map transformFromObjectToMap(Object object, List inludeProps, List includeCollections, List excludeProperties) {
        XMLObjToMapTransformer tr = (XMLObjToMapTransformer)this.getObjectMapTransformationManager().getFromObjectTransformerFor(object.getClass());
        if (tr != null) {
            return tr.transformFromObject(object, null, null, false, false, inludeProps, includeCollections, excludeProperties);
        }
        return null;
    }

    public void transformFromMapToObject(Object object, Map map) {
        this.transformFromMapToObject(object, map, null, null);
    }

    public void transformFromMapToObject(Object object, Map map, List inludeProps, List includeCollections) {
        XMLMapToObjTransformer tr = (XMLMapToObjTransformer)this.getObjectMapTransformationManager().getToObjectTransformerFor(object.getClass());
        if (tr != null) {
            tr.transformFromMap(object, map, false, inludeProps, includeCollections);
        }
    }

    protected void saveObjectList(DesignPart designPart) {
        if (this.saveObjectList(designPart.getClass().getName(), designPart.getStoragePath(), designPart.getStorableDesignObjects().iterator(), OBJECT_LIST, designPart.getDesign().isCompressedDesign(), new String[0])) {
            designPart.setObjectListChanged(false);
        }
    }

    public void saveObjectsAndDiagramsList(DesignPart designPart) {
        this.saveObjectList(designPart);
    }

    protected void saveObjectList(StorageDesign storageDesign) {
        if ((!this.isCheckDirty() || this.isCheckDirty() && storageDesign.isObjectListChanged()) && this.saveObjectList(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getStorableObjects().iterator(), OBJECT_LIST, false, new String[0])) {
            storageDesign.setObjectListChanged(false);
        }
    }

    protected boolean saveObjectList(String className, String storagePath, Iterator objects, String fileName, boolean useCompressedFiles, String ... additionalAttributes) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(className);
            doc.appendChild(rootElement);
            while (objects.hasNext()) {
                String parentID;
                Object obj = objects.next();
                if (obj instanceof DesignObject) {
                    DesignObject desObj = (DesignObject)obj;
                    DesignPart dp = desObj.getDesignPart();
                    if ((dp instanceof LogicalDesign || dp instanceof RelationalDesign) && dp.getDesign().shouldExportPartial(dp) && !dp.getDesign().shouldExport(desObj)) {
                        continue;
                    }
                } else if (obj instanceof RelationalObjectProxy) {
                    // empty if block
                }
                if (obj instanceof StorageObject && ((StorageObject)obj).isNullInstance() && !((StorageObject)obj).isStorableNullInstance()) continue;
                Element child = doc.createElement("object");
                rootElement.appendChild(child);
                if (obj instanceof DesignObject) {
                    DesignObject desObj = (DesignObject)obj;
                    child.setAttribute("objectType", desObj.getObjectTypeName());
                    child.setAttribute("objectID", desObj.getObjectID());
                    child.setAttribute("name", StringUtilities.encodeAttributeValue(desObj.getName()));
                    child.setAttribute("seqName", desObj.getDirectorySegmentName());
                    if (obj instanceof FKIndexAssociation) {
                        String refCID;
                        FKIndexAssociation fk = (FKIndexAssociation)obj;
                        String cid = fk.getContainerID();
                        if (cid != null) {
                            child.setAttribute("containerID", cid);
                        }
                        if ((refCID = fk.getReferredTableID()) != null) {
                            child.setAttribute("refContainerID", refCID);
                        }
                    }
                    parentID = desObj.getDesignPartId();
                    String sourceObjectID = null;
                    String targetObjectID = null;
                    child.setAttribute("propertyClassName", desObj.getClass().getName());
                    child.setAttribute("propertyParentId", parentID);
                    child.setAttribute("propertySourceId", sourceObjectID);
                    child.setAttribute("propertyTargetId", targetObjectID);
                } else if (obj instanceof StorageObject) {
                    StorageObject storObj = (StorageObject)obj;
                    child.setAttribute("objectType", storObj.getObjectTypeName());
                    child.setAttribute("objectID", storObj.getObjectID());
                    child.setAttribute("name", storObj.getName());
                    child.setAttribute("seqName", storObj.getDirectorySegmentName());
                    parentID = storObj.getStorageDesign().getRDBMSSite().getShortObjectID();
                    child.setAttribute("propertyClassName", storObj.getClass().getName());
                    child.setAttribute("propertyParentId", parentID);
                }
                if (additionalAttributes == null) continue;
                for (int i = 0; i < additionalAttributes.length; i += 2) {
                    child.setAttribute(additionalAttributes[i], additionalAttributes[i + 1]);
                }
            }
            XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Can not save Object List for: " + className, e);
            return false;
        }
    }

    private List<DesignPartHelper> getModels(Design design) {
        ArrayList<DesignPartHelper> list = new ArrayList<DesignPartHelper>();
        try {
            File md = new File(design.getStoragePath(), "businessinfo");
            String modelFileName = null;
            File mf = null;
            md = new File(design.getStoragePath(), "datatypes");
            modelFileName = design.getDataTypesDesign().getName() + EXTENSION_XML_FILES;
            mf = new File(md, modelFileName);
            DesignPartHelper dph = XMLTransformationManager.getDesignPartHelperFor(mf, design.isCompressedDesign(), "Data Types");
            if (dph != null) {
                list.add(dph);
            }
            md = new File(design.getStoragePath(), "logical");
            modelFileName = design.getLogicalDesign().getName() + EXTENSION_XML_FILES;
            if (design.isCompressedDesign()) {
                modelFileName = modelFileName + COMPRESSED_FILE_SUFIX;
            }
            if ((dph = XMLTransformationManager.getDesignPartHelperFor(mf = new File(md, modelFileName), design.isCompressedDesign(), "LogicalDesign")) != null) {
                list.add(dph);
            }
            if ((md = new File(design.getStoragePath(), "rel")).exists()) {
                File[] files = md.listFiles(this.filter);
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    dph = XMLTransformationManager.getDesignPartHelperFor(file, design.isCompressedDesign(), "RelationalModel");
                    if (dph == null) continue;
                    list.add(dph);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load Models from Design: " + design.getStoragePath(), e);
        }
        return list;
    }

    public static DesignPartHelper getDesignPartHelperFor(File file, boolean useCompressedFiles, String type) {
        if (file.exists() && file.isFile()) {
            try {
                Document doc = null;
                if (useCompressedFiles) {
                    doc = XMLTransformationManager.getDocument(file);
                } else {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
                if (doc != null) {
                    DesignPartHelper dph = new DesignPartHelper();
                    Element elm = doc.getDocumentElement();
                    dph.type = type;
                    dph.name = elm.getAttribute("name");
                    dph.id = elm.getAttribute("id");
                    String parent_id = elm.getAttribute("parentDFD_ID");
                    if (parent_id != null && !"".equals(parent_id)) {
                        dph.parent_id = parent_id;
                    }
                    dph.main_view_id = elm.getAttribute("mainViewID");
                    String topLevel = elm.getAttribute("topLevel");
                    dph.top_level_dfd_design = "true".equalsIgnoreCase(topLevel);
                    return dph;
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), e);
            }
        }
        return null;
    }

    private static DesignPartHelper getDesignPartInfo(File file, boolean useCompressedFiles) {
        if (file.exists()) {
            try {
                Document doc = null;
                if (useCompressedFiles) {
                    doc = XMLTransformationManager.getDocument(file);
                } else {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
                if (doc != null) {
                    DesignPartHelper dph = new DesignPartHelper();
                    Element elm = doc.getDocumentElement();
                    dph.name = elm.getAttribute("name");
                    dph.id = elm.getAttribute("id");
                    return dph;
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not parse file: " + file.getAbsolutePath(), e);
            }
        }
        return null;
    }

    public void createObjectList(String className, Map f2tMap, String storagePath, String fileName, boolean useCompressedFiles) {
        File objList = useCompressedFiles ? new File(storagePath, fileName + COMPRESSED_FILE_SUFIX) : new File(storagePath, fileName);
        if (!objList.exists() || REBUILD_OBJECT_LIST) {
            try {
                if (objList.exists()) {
                    objList.delete();
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element rootElement = doc.createElement(className);
                doc.appendChild(rootElement);
                for (String key : f2tMap.keySet()) {
                    String value = (String)f2tMap.get(key);
                    File dir = new File(storagePath, key);
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    File[] files = dir.listFiles(this.filter);
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) {
                            File[] subFiles = file.listFiles(this.filter);
                            for (int j = 0; j < subFiles.length; ++j) {
                                File subFile = subFiles[j];
                                if (subFile.isDirectory()) continue;
                                Element child = doc.createElement("object");
                                rootElement.appendChild(child);
                                child.setAttribute("objectType", value);
                                child.setAttribute("objectID", FileUtils.removeExt(subFile.getName()));
                                child.setAttribute("name", "");
                                child.setAttribute("seqName", file.getName());
                            }
                            continue;
                        }
                        Element child = doc.createElement("object");
                        rootElement.appendChild(child);
                        if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                            DesignPartHelper dph = XMLTransformationManager.getDesignPartInfo(file, useCompressedFiles);
                            child.setAttribute("objectType", dph.type);
                            child.setAttribute("objectID", dph.id);
                            child.setAttribute("name", dph.name);
                            child.setAttribute("visible", dph.visible ? "true" : "false");
                            continue;
                        }
                        child.setAttribute("objectType", value);
                        child.setAttribute("objectID", FileUtils.removeExt(file.getName()));
                        child.setAttribute("name", "");
                        child.setAttribute("seqName", "");
                    }
                }
                XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            }
            catch (Exception e) {
                LOGGER.error("Can not create ObjectList: " + storagePath + "/" + fileName, e);
            }
        }
    }

    public List recreateObjectList(List<ObjectHelper> objects, String className, Map f2tMap, String storagePath, String fileName, boolean useCompressedFiles) {
        ArrayList<ObjectHelper> newList = new ArrayList<ObjectHelper>();
        File objList = useCompressedFiles ? new File(storagePath, fileName + COMPRESSED_FILE_SUFIX) : new File(storagePath, fileName);
        if (!objList.exists() || REBUILD_OBJECT_LIST) {
            try {
                HashMap<String, ObjectHelper> map = new HashMap<String, ObjectHelper>();
                HashMap<String, ObjectHelper> processed = new HashMap<String, ObjectHelper>();
                if (objList.exists()) {
                    objList.delete();
                }
                for (ObjectHelper oh : objects) {
                    map.put(oh.id, oh);
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element rootElement = doc.createElement(className);
                doc.appendChild(rootElement);
                for (String key : f2tMap.keySet()) {
                    String value = (String)f2tMap.get(key);
                    File dir = new File(storagePath, key);
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    File[] files = dir.listFiles(this.filter);
                    for (int i = 0; i < files.length; ++i) {
                        int ind;
                        ObjectHelper oht;
                        String path;
                        String name;
                        String text;
                        ObjectHelper temp;
                        ObjectHelper oh;
                        File file = files[i];
                        if (file.isDirectory()) {
                            File[] subFiles = file.listFiles(this.filter);
                            for (int j = 0; j < subFiles.length; ++j) {
                                int ind2;
                                File subFile = subFiles[j];
                                if (subFile.isDirectory()) continue;
                                Element child = doc.createElement("object");
                                rootElement.appendChild(child);
                                String id = FileUtils.removeExt(subFile.getName());
                                ObjectHelper temp2 = (ObjectHelper)processed.get(id);
                                ObjectHelper oh2 = (ObjectHelper)map.get(id);
                                if (temp2 == null) {
                                    child.setAttribute("objectType", value);
                                    child.setAttribute("objectID", id);
                                    if (oh2 != null) {
                                        child.setAttribute("name", oh2.name);
                                        if (oh2.contID != null) {
                                            child.setAttribute("containerID", oh2.contID);
                                        }
                                        if (oh2.refContID != null) {
                                            child.setAttribute("refContainerID", oh2.refContID);
                                        }
                                    } else {
                                        child.setAttribute("name", "");
                                    }
                                    child.setAttribute("seqName", file.getName());
                                    if (oh2 != null) {
                                        if (oh2.propertyClassname != null) {
                                            child.setAttribute("propertyClassName", oh2.propertyClassname);
                                        }
                                        if (oh2.propertyParentid != null) {
                                            child.setAttribute("propertyParentId", oh2.propertyParentid);
                                        }
                                        if (oh2.propertySourceid != null) {
                                            child.setAttribute("propertySourceId", oh2.propertySourceid);
                                        }
                                        if (oh2.propertyTargetid != null) {
                                            child.setAttribute("propertyTargetId", oh2.propertyTargetid);
                                        }
                                    }
                                    if (oh2 == null) {
                                        oh2 = new ObjectHelper();
                                        oh2.type = value;
                                        oh2.id = id;
                                    }
                                    oh2.seq_name = file.getName();
                                    oh2.file = subFile;
                                    newList.add(oh2);
                                    processed.put(id, oh2);
                                    continue;
                                }
                                Design.openFailed();
                                String text2 = "Duplicated file for ";
                                String name2 = "";
                                if (oh2 != null) {
                                    name2 = oh2 != null ? oh2.name : "";
                                } else {
                                    oh2 = new ObjectHelper();
                                }
                                oh2.file = subFile;
                                oh2.seq_name = file.getName();
                                String path2 = " ID - " + id + " \npath - " + subFile.getCanonicalPath();
                                LOGGER.error(text2 + name2 + path2);
                                ObjectHelper oht2 = this.getHelperWithBiggerFile(temp2, oh2);
                                if (oht2 == temp2 || (ind2 = newList.indexOf(temp2)) <= -1) continue;
                                newList.set(ind2, oht2);
                                processed.put(id, oht2);
                            }
                            continue;
                        }
                        Element child = doc.createElement("object");
                        rootElement.appendChild(child);
                        if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                            DesignPartHelper dph = XMLTransformationManager.getDesignPartInfo(file, useCompressedFiles);
                            if (dph == null) {
                                Design.openFailed();
                                continue;
                            }
                            oh = (ObjectHelper)map.get(dph.id);
                            child.setAttribute("objectType", dph.type);
                            child.setAttribute("objectID", dph.id);
                            child.setAttribute("name", dph.name);
                            if (oh != null) {
                                child.setAttribute("visible", oh.visible ? "true" : "false");
                            } else {
                                child.setAttribute("visible", dph.visible ? "true" : "false");
                                oh = new ObjectHelper();
                                oh.type = dph.type;
                                oh.id = dph.id;
                                oh.name = dph.name;
                                oh.file = file;
                                oh.visible = dph.visible;
                            }
                            temp = (ObjectHelper)processed.get(dph.id);
                            if (temp == null) {
                                newList.add(oh);
                                processed.put(dph.id, oh);
                                continue;
                            }
                            Design.openFailed();
                            text = "Duplicated file for ";
                            name = oh != null ? oh.name : "";
                            path = " ID - " + dph.id + " \npath - " + file.getCanonicalPath();
                            LOGGER.error(text + name + (String)path);
                            oht = this.getHelperWithBiggerFile(temp, oh);
                            processed.put(dph.id, oht);
                            if (oht == temp || (ind = newList.indexOf(temp)) <= -1) continue;
                            newList.set(ind, oht);
                            processed.put(dph.id, oht);
                            continue;
                        }
                        String id = FileUtils.removeExt(file.getName());
                        oh = (ObjectHelper)map.get(id);
                        child.setAttribute("objectType", value);
                        child.setAttribute("objectID", id);
                        if (oh != null) {
                            child.setAttribute("name", oh.name);
                        } else {
                            child.setAttribute("name", "");
                            oh = new ObjectHelper();
                            oh.type = value;
                            oh.id = id;
                        }
                        child.setAttribute("seqName", "");
                        if (oh != null) {
                            if (oh.propertyClassname != null) {
                                child.setAttribute("propertyClassName", oh.propertyClassname);
                            }
                            if (oh.propertyParentid != null) {
                                child.setAttribute("propertyParentId", oh.propertyParentid);
                            }
                            if (oh.propertySourceid != null) {
                                child.setAttribute("propertySourceId", oh.propertySourceid);
                            }
                            if (oh.propertyTargetid != null) {
                                child.setAttribute("propertyTargetId", oh.propertyTargetid);
                            }
                        }
                        if ((temp = (ObjectHelper)processed.get(id)) == null) {
                            newList.add(oh);
                            processed.put(id, oh);
                            continue;
                        }
                        Design.openFailed();
                        text = "Duplicated file for ";
                        name = oh != null ? oh.name : "";
                        path = " ID - " + id + " \npath - " + file.getCanonicalPath();
                        LOGGER.error(text + name + path);
                        oht = this.getHelperWithBiggerFile(temp, oh);
                        processed.put(id, oht);
                        if (oht == temp || (ind = newList.indexOf(temp)) <= -1) continue;
                        newList.set(ind, oht);
                        processed.put(id, oht);
                    }
                }
                XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            }
            catch (Exception e) {
                LOGGER.error("Can not create ObjectList: " + storagePath + "/" + fileName, e);
            }
        } else {
            return objects;
        }
        return newList;
    }

    private ObjectHelper getHelperWithBiggerFile(ObjectHelper oh1, ObjectHelper oh2) {
        if (oh1.file != null && oh2.file != null) {
            if (oh1.file.length() > oh2.file.length()) {
                return oh1;
            }
            return oh2;
        }
        if (oh1.file != null) {
            return oh1;
        }
        if (oh2.file != null) {
            return oh2;
        }
        return oh1;
    }

    public static List<ObjectHelper> getObjects(String storagePath, String fileName, boolean useCompressedFiles) {
        ArrayList<ObjectHelper> list = new ArrayList<ObjectHelper>();
        try {
            Document doc = null;
            if (useCompressedFiles) {
                doc = XMLTransformationManager.getDocument(new File(storagePath, fileName + COMPRESSED_FILE_SUFIX));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(storagePath, fileName);
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                NodeList nodeList = doc.getElementsByTagName("object");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element node = (Element)nodeList.item(i);
                    ObjectHelper helper = new ObjectHelper();
                    helper.type = node.getAttribute("objectType");
                    helper.id = node.getAttribute("objectID");
                    helper.markedGenerate = Boolean.valueOf(node.getAttribute(MARKED_GENERATE));
                    helper.name = StringUtilities.decodeAttributeValue(node.getAttribute("name"));
                    helper.seq_name = node.getAttribute("seqName");
                    helper.propertyClassname = node.getAttribute("propertyClassName");
                    helper.propertyParentid = node.getAttribute("propertyParentId");
                    helper.propertySourceid = node.getAttribute("propertySourceId");
                    helper.propertyTargetid = node.getAttribute("propertyTargetId");
                    if ("FKIndexAssociation".equals(helper.type)) {
                        helper.contID = node.getAttribute("containerID");
                        helper.refContID = node.getAttribute("refContainerID");
                    }
                    if (DIAGRAM_LIST.equalsIgnoreCase(fileName)) {
                        String visible = node.getAttribute("visible");
                        helper.visible = "true".equalsIgnoreCase(visible);
                    }
                    list.add(helper);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse Object List: " + storagePath + "/" + fileName, e);
        }
        return list;
    }

    public boolean openDesign(Design design, File file) {
        boolean compr;
        if (file.exists() && this.transformFromXMLToObject(design, file, compr = design.isCompressedDesign())) {
            design.setLoadedModelPersistence(design.getModelPersistence());
            this.loadRDBMSSites(design);
            List<DesignPartHelper> list = this.getModels(design);
            design.getRelationalDesigns().removeAll();
            for (DesignPartHelper helper : list) {
                String mainViewId = helper.main_view_id;
                if (helper.type.equalsIgnoreCase("Data Types")) {
                    DataTypesDesign dtDesign = design.getDataTypesDesign();
                    dtDesign.setName(helper.name);
                    dtDesign.setObjectID(helper.id);
                    this.transformFromXMLToObject(dtDesign, new File(dtDesign.getStorageName()), compr);
                    dtDesign.setLoaded(false);
                    continue;
                }
                if (helper.type.equalsIgnoreCase("LogicalDesign")) {
                    LogicalDesign logical = design.getLogicalDesign();
                    logical.setName(helper.name);
                    logical.setObjectID(helper.id);
                    if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                        logical.getMainView().setDPVId(mainViewId);
                    }
                    this.transformFromXMLToObject(logical, new File(logical.getStorageName()), compr);
                    logical.setLoaded(false);
                    continue;
                }
                if (!helper.type.equalsIgnoreCase("RelationalModel")) continue;
                RelationalDesign relModel = design.addRelationalDesign(helper.name);
                relModel.setObjectID(helper.id);
                if (mainViewId != null && !"".equalsIgnoreCase(mainViewId) && !"null".equalsIgnoreCase(mainViewId)) {
                    relModel.getMainView().setDPVId(mainViewId);
                }
                this.transformFromXMLToObject(relModel, new File(relModel.getStorageName()), compr);
                relModel.setShouldBeOpen(true);
                relModel.setLoaded(false);
            }
            return true;
        }
        return false;
    }

    public void openDesignPart(DesignPart designPart) {
        Design des = designPart.getDesign();
        designPart.getErrorDescriptionList().clear();
        int pers = des.getLoadedModelPersistence();
        if ((pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.modelFileExists(designPart)) {
            this.openDesignPartSingleFile(designPart);
            return;
        }
        this.openDesignPartManyFiles(designPart);
    }

    private boolean modelFileExists(ModelIDObject dp) {
        String storageName = dp.getStoragePath() + "/" + dp.getShortObjectID() + ".model.local";
        File file = new File(storageName);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDesignPartSingleFile(DesignPart designPart) {
        block10: {
            if (!designPart.isLoaded()) {
                String storageName = designPart.getStoragePath() + "/" + designPart.getShortObjectID() + ".model.local";
                TimeLog.log("start open model operation");
                if (designPart instanceof LogicalDesign) {
                    // empty if block
                }
                try {
                    File file = new File(storageName);
                    if (!file.exists()) {
                        return;
                    }
                    if (storageName == null) break block10;
                    boolean pkchanges = designPart.getDesign().isPropagatePKChahges();
                    try {
                        designPart.getDesign().setPropagatePKChahges(false);
                        this.transformFromXMLToObjectSAX(designPart, file, null);
                        designPart.executeTasks();
                        designPart.doAfterLoad();
                        this.clearDirtyStatusForObjectsIn(designPart);
                    }
                    catch (Exception e) {
                        String message = "Error in open model " + designPart.getName() + "\n file " + storageName;
                        LOGGER.error(message, e);
                    }
                    finally {
                        designPart.getDesign().setPropagatePKChahges(pkchanges);
                        TimeLog.log("end load operation");
                    }
                }
                catch (Exception e) {
                    String message = "Error in open model " + designPart.getName() + "\n file " + storageName;
                    LOGGER.error(message, e);
                }
            }
        }
    }

    private void clearDirtyStatusForObjectsIn(DesignPart dp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openDesignPartManyFiles(DesignPart designPart) {
        designPart.getDesign().setPropagatePKChahges(false);
        boolean ftemp = FKAttributeManager.CAN_SYNCHRONIZE;
        if (designPart instanceof LogicalDesign) {
            FKAttributeManager.CAN_SYNCHRONIZE = false;
        }
        try {
            designPart.doBeforeLoad();
            List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign());
            List objects = this.recreateObjectList(objects0, designPart.getClass().getName(), designPart.getFolderToTypeMap(), designPart.getStoragePath(), OBJECT_LIST, designPart.getDesign().isCompressedDesign());
            Iterator oit = objects.iterator();
            try {
                while (oit.hasNext()) {
                    FKIndexAssociation fk;
                    ObjectHelper oh = (ObjectHelper)oit.next();
                    StorableObject stObject = designPart.getDesign().getDesignObject(oh.id);
                    if (stObject == null) {
                        stObject = designPart.createObject(oh.type, oh.id, oh.name);
                    }
                    boolean fk_need_load = false;
                    if ("FKIndexAssociation".equals(oh.type) && stObject instanceof FKIndexAssociation) {
                        if (oh.contID != null && !"".equals(oh.contID) && oh.refContID != null && !"".equals(oh.refContID)) {
                            fk = (FKIndexAssociation)stObject;
                            fk.setContainerID(oh.contID);
                            fk.setReferredTableID(oh.refContID);
                        } else {
                            fk_need_load = true;
                        }
                    }
                    if (stObject != null) {
                        if (!lazy_loading || fk_need_load) {
                            String storageName = stObject.getStorageName();
                            if (stObject instanceof ModelIDObject) {
                                ((ModelIDObject)stObject).setDirectorySegmentName(oh.seq_name, true);
                                storageName = ((ModelIDObject)stObject).getSegmentedStorageName();
                            }
                            try {
                                if (designPart.getDesign().isDmDesktopDesign()) {
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add("mandatory");
                                    this.transformFromXMLToObject(stObject, new File(storageName), designPart.getDesign().isCompressedDesign(), true, list);
                                } else {
                                    this.transformFromXMLToObject(stObject, new File(storageName), designPart.getDesign().isCompressedDesign());
                                }
                                stObject.setLoadedCompletely(true);
                            }
                            catch (Exception ex) {
                                Design.openFailed();
                                LOGGER.error("Error in loading of " + storageName, ex);
                            }
                            if (stObject instanceof FKIndexAssociation) {
                                FKIndexAssociation fk2 = (FKIndexAssociation)stObject;
                                try {
                                    fk2.setDirectorySegmentName(oh.seq_name, true);
                                }
                                catch (Exception ex) {
                                    Design.openFailed();
                                    LOGGER.error("Error in adding foreign key " + fk2.getName() + "  for table " + fk2.getTable().getName(), ex);
                                }
                            }
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        if (stObject instanceof FKIndexAssociation) {
                            fk = (FKIndexAssociation)stObject;
                            try {
                                fk.setDirectorySegmentName(oh.seq_name, true);
                                designPart.getDesign().addDesignObject(fk);
                                if (designPart instanceof RelationalDesign) {
                                    ((RelationalDesign)designPart).getFKIndexAssociationSet().add(fk);
                                }
                                fk.setDirectorySegmentName(oh.seq_name, true);
                                continue;
                            }
                            catch (Exception ex) {
                                Design.openFailed();
                                LOGGER.error("Error in adding foreign key " + fk.getName() + "  for table " + fk.getTable().getName(), ex);
                                continue;
                            }
                        }
                        if (!(stObject instanceof ModelIDObject)) continue;
                        ((ModelIDObject)stObject).setDirectorySegmentName(oh.seq_name, true);
                        continue;
                    }
                    LOGGER.error("Can not create Object : " + oh.type + " - " + oh.id);
                }
            }
            catch (Throwable e) {
                Logger.error(e);
            }
            designPart.executeTasks();
            if (designPart instanceof RelationalDesign) {
                this.loadExistingPhysicalModels((RelationalDesign)designPart);
            } else if (designPart instanceof DataTypesDesign) {
                // empty if block
            }
            if (designPart instanceof LogicalDesign) {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
            }
            designPart.doAfterLoad();
            return;
        }
        finally {
            if (designPart instanceof LogicalDesign) {
                FKAttributeManager.CAN_SYNCHRONIZE = ftemp;
            }
            designPart.getDesign().setPropagatePKChahges(true);
        }
    }

    public void loadMainDPV(DesignPart designPart) {
        List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
        List objects = this.recreateObjectList(objects0, designPart.getClass().getName(), designPart.getDiagramFolderMap(), designPart.getStoragePath(), DIAGRAM_LIST, designPart.getDesign().isCompressedDesign());
        for (ObjectHelper oh : objects) {
            DesignPartView dpv = null;
            dpv = "main_view".equalsIgnoreCase(oh.type) || designPart.getMainView().getDPVId().equalsIgnoreCase(oh.id) ? designPart.getMainView() : designPart.createDesignPartSubView();
            if (dpv == null) continue;
            dpv.setDPVId(oh.id);
            this.transformFromXMLToObject(dpv, new File(dpv.getStorageName()), designPart.getDesign().isCompressedDesign());
        }
    }

    private Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    public void loadExistingPhysicalModels(RelationalDesign relModel) {
        String storagePath = "phys";
        File rmDir = new File(relModel.getStoragePath(), storagePath);
        if (rmDir.exists()) {
            File[] rdbmsTypes = rmDir.listFiles();
            for (int i = 0; i < rdbmsTypes.length; ++i) {
                StorageDesign stoDes;
                File file = rdbmsTypes[i];
                if (!file.isDirectory()) continue;
                String siteID = file.getName();
                RDBMSSite site = relModel.getDesign().getRDBMSSiteSet().getByShortObjectIDString(siteID);
                if (site == null) {
                    File sdFile;
                    String sdFileName = file.getName() + EXTENSION_XML_FILES;
                    if (relModel.getDesign().isCompressedDesign()) {
                        sdFileName = sdFileName + COMPRESSED_FILE_SUFIX;
                    }
                    if ((sdFile = new File(file, sdFileName)).exists()) {
                        Element siteTypeElm;
                        Document doc = null;
                        if (relModel.getDesign().isCompressedDesign()) {
                            doc = XMLTransformationManager.getDocument(sdFile);
                        } else {
                            try {
                                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                                DocumentBuilder db = dbf.newDocumentBuilder();
                                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(sdFile), "UTF-8");
                                doc = db.parse(new InputSource(reader));
                                reader.close();
                            }
                            catch (Exception e) {
                                LOGGER.warn(e.getMessage(), e);
                            }
                        }
                        if (doc != null && (siteTypeElm = this.getFirstElementByTagName(SITE_TYPE, doc.getDocumentElement())) != null) {
                            String siteType = siteTypeElm.getTextContent();
                            Element siteTypeID = this.getFirstElementByTagName(SITE_ID, doc.getDocumentElement());
                            String siteOID = siteTypeID.getTextContent();
                            Element siteTypeName = this.getFirstElementByTagName(SITE_NAME, doc.getDocumentElement());
                            String siteName = siteTypeName.getTextContent();
                            site = relModel.getDesign().getRDBMSSiteSet().createSite(siteName, relModel.getDesign());
                            int type = 9;
                            try {
                                type = Integer.parseInt(siteType);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
                            site.setType(rdbmsType);
                            site.setObjectID(siteOID);
                            site.setPathID(relModel.getDesign().getRDBMSSiteSet().nextIndex());
                        }
                    }
                }
                if (site == null || (stoDes = relModel.getStorageDesign(site)) == null) continue;
                stoDes.setOpen(false);
                stoDes.setTempModel(false);
                this.clearDirtyStatus(stoDes);
                stoDes.setAllStorableObjectsDirty(false);
            }
        }
    }

    private boolean supportStorageDesignInSingleFile(StorageDesign sd) {
        return sd instanceof StorageDesignOracle;
    }

    public void openPhysicalModel(StorageDesign physicalModel) {
        this.openPhysicalModel(physicalModel, true);
    }

    public void openPhysicalModel(StorageDesign physicalModel, boolean clearDirtyFlag) {
        Design des = physicalModel.getDesign();
        int pers = des.getLoadedModelPersistence();
        if ((pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.supportStorageDesignInSingleFile(physicalModel) && this.modelFileExists(physicalModel)) {
            this.openPhysicalModelSingleFile(physicalModel, clearDirtyFlag);
            return;
        }
        this.openPhysicalModelManyFiles(physicalModel, clearDirtyFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPhysicalModelSingleFile(StorageDesign physicalModel, boolean clearDirtyFlag) {
        if (physicalModel.getStorageName() != null) {
            try {
                ArrayList<ModelIDObject> withWrongSegment = new ArrayList<ModelIDObject>();
                physicalModel.setLoading(true);
                String mstorageName = physicalModel.getStoragePath() + "/" + physicalModel.getShortObjectID() + ".model.local";
                File file = new File(mstorageName);
                if (file.exists()) {
                    List<ObjectHelper> objects = XMLTransformationManager.getObjects(physicalModel.getStoragePath(), OBJECT_LIST, false);
                    for (ObjectHelper oh : objects) {
                        StorageObjectSet set = physicalModel.getStorageObjectSetForType(oh.type);
                        if (set != null) {
                            StorageObject stObject = physicalModel.getStorageObject(oh.id);
                            if (stObject == null) {
                                oh.object = set.createElement(oh.id);
                                continue;
                            }
                            oh.object = stObject;
                            continue;
                        }
                        oh.object = physicalModel.getStorageObject(oh.id);
                        if (oh.object != null) continue;
                    }
                    this.transformFromXMLToObjectSAX(physicalModel, file, null);
                    for (ObjectHelper oh : objects) {
                        ModelIDObject stObject = (ModelIDObject)oh.object;
                        if (stObject == null) continue;
                        String oldSegmentName = stObject.getDirectorySegmentName();
                        if (physicalModel.isCloneOperation()) {
                            stObject.setSegmentedStorageName(null);
                        }
                        stObject.setDirectorySegmentName(oh.seq_name, true);
                        boolean loaded = stObject.isLoadedCompletely();
                        boolean keepDirty = false;
                        if (physicalModel.isCloneOperation()) {
                            stObject.setDirectorySegmentName(oldSegmentName, true);
                            stObject.setSegmentedStorageName(null);
                        } else {
                            String seg = stObject.getDirectorySegmentName();
                            if (!seg.equals(oh.seq_name) && loaded) {
                                keepDirty = true;
                                stObject.setDirectorySegmentName(oh.seq_name, true);
                                withWrongSegment.add(stObject);
                            }
                        }
                        if (clearDirtyFlag && !keepDirty) {
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        stObject.setDirty(true);
                    }
                    ArrayList<ModelIDObject> dirtyObjects = null;
                    if (!clearDirtyFlag) {
                        dirtyObjects = physicalModel.getDirtyObjects();
                    } else {
                        physicalModel.doAfterLoad();
                    }
                    if (dirtyObjects == null) {
                        dirtyObjects = withWrongSegment;
                    }
                    if (dirtyObjects != null) {
                        for (ModelIDObject obj : dirtyObjects) {
                            obj.setDirty(true);
                        }
                    }
                }
                if (!clearDirtyFlag) {
                    physicalModel.setDirty(true);
                }
            }
            finally {
                physicalModel.setLoading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPhysicalModelManyFiles(StorageDesign physicalModel, boolean clearDirtyFlag) {
        if (physicalModel.getStorageName() != null) {
            try {
                ArrayList<ModelIDObject> withWrongSegment = new ArrayList<ModelIDObject>();
                physicalModel.setLoading(true);
                File file = new File(physicalModel.getStorageName());
                if (file.exists()) {
                    this.transformFromXMLToObject(physicalModel, file, false, clearDirtyFlag, null);
                    List<ObjectHelper> objects0 = XMLTransformationManager.getObjects(physicalModel.getStoragePath(), OBJECT_LIST, false);
                    List objects = this.recreateObjectList(objects0, physicalModel.getClass().getName(), physicalModel.getFolderToTypeMap(), physicalModel.getStoragePath(), OBJECT_LIST, physicalModel.getDesign().isCompressedDesign());
                    for (ObjectHelper oh : objects) {
                        StorageObjectSet set = physicalModel.getStorageObjectSetForType(oh.type);
                        if (set != null) {
                            StorageObject stObject = physicalModel.getStorageObject(oh.id);
                            if (stObject == null) {
                                oh.object = set.createElement(oh.id);
                                continue;
                            }
                            oh.object = stObject;
                            continue;
                        }
                        oh.object = physicalModel.getStorageObject(oh.id);
                        if (oh.object != null) continue;
                        physicalModel.getNotLoadedObjectHelpersMap().put(oh.id, oh);
                    }
                    for (ObjectHelper oh : objects) {
                        ModelIDObject stObject = (ModelIDObject)oh.object;
                        if (stObject == null) continue;
                        String storageName = stObject.getStorageName();
                        String oldSegmentName = stObject.getDirectorySegmentName();
                        if (physicalModel.isCloneOperation()) {
                            stObject.setSegmentedStorageName(null);
                        }
                        stObject.setDirectorySegmentName(oh.seq_name, true);
                        storageName = stObject.getSegmentedStorageName();
                        boolean loaded = this.transformFromXMLToObject(stObject, new File(storageName), physicalModel.getDesign().isCompressedDesign(), clearDirtyFlag, null);
                        boolean keepDirty = false;
                        if (physicalModel.isCloneOperation()) {
                            stObject.setDirectorySegmentName(oldSegmentName, true);
                            stObject.setSegmentedStorageName(null);
                        } else {
                            String seg = stObject.getDirectorySegmentName();
                            if (!seg.equals(oh.seq_name) && loaded) {
                                keepDirty = true;
                                stObject.setDirectorySegmentName(oh.seq_name, true);
                                withWrongSegment.add(stObject);
                            }
                            stObject.setLoadedCompletely(loaded);
                        }
                        if (clearDirtyFlag && !keepDirty) {
                            this.clearDirtyStatus(stObject);
                            continue;
                        }
                        stObject.setDirty(true);
                    }
                    ArrayList<ModelIDObject> dirtyObjects = null;
                    if (!clearDirtyFlag) {
                        dirtyObjects = physicalModel.getDirtyObjects();
                    } else {
                        physicalModel.doAfterLoad();
                    }
                    if (dirtyObjects == null) {
                        dirtyObjects = withWrongSegment;
                    }
                    if (dirtyObjects != null) {
                        for (ModelIDObject obj : dirtyObjects) {
                            obj.setDirty(true);
                        }
                    }
                }
                if (!clearDirtyFlag) {
                    physicalModel.setDirty(true);
                }
            }
            finally {
                physicalModel.setLoading(false);
            }
        }
    }

    private void clearPropertyMap(List list) {
        for (Object obj : list) {
            if (!(obj instanceof ModelIDObject)) continue;
            ((ModelIDObject)obj).clearProperties();
        }
    }

    public boolean savePhysicalModel(StorageDesign physicalModel) {
        boolean shouldSave;
        boolean result = false;
        Design des = physicalModel.getDesign();
        int pers = des.getModelPersistence();
        boolean bl = shouldSave = physicalModel.isOpen() && (!this.isCheckDirty() || this.isCheckDirty() && (physicalModel.isDirty() || physicalModel.hasDirtyStorableObjects()));
        if (des.isVersioned() || pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_MANY_FILES || !this.supportStorageDesignInSingleFile(physicalModel)) {
            result = this.savePhysicalModelMultiFiles(physicalModel);
            if (result && shouldSave && (pers == Design.PERS_MODEL_MIXED_MODE || pers == Design.PERS_MODEL_IN_ONE_FILE) && this.supportStorageDesignInSingleFile(physicalModel)) {
                result = this.savePhysicalModelSingleFile(physicalModel);
            }
        } else if (pers == Design.PERS_MODEL_IN_ONE_FILE) {
            result = this.savePhysicalModelSingleFile(physicalModel);
            try {
                physicalModel.synchronizeFilesMap(true);
            }
            catch (Exception e) {
                LOGGER.error("Error in cleaning files in model: " + physicalModel.getName(), e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePhysicalModelSingleFile(StorageDesign stDes) {
        if (stDes.isOpen()) {
            String storageName = stDes.getStoragePath() + "/" + stDes.getShortObjectID() + ".model.local";
            TimeLog.log("start save operation");
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    XMLTransformationManager.writeContentAsStream(stDes, bs, trMan, true, null);
                    bs.flush();
                    bs.close();
                    if (stDes.isDirty()) {
                        this.saveObject(stDes);
                    }
                    try {
                        stDes.synchronizeFilesMap(true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in cleaning files in model: " + stDes.getName(), e);
                    }
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
            }
        }
        return false;
    }

    public boolean savePhysicalModelMultiFiles(StorageDesign physicalModel) {
        try {
            saveFailed = false;
            ArrayList<StorageDesign> list = new ArrayList<StorageDesign>();
            if (physicalModel.isOpen()) {
                if (this.isCheckDirty()) {
                    if (physicalModel.isDirty() || physicalModel.hasDirtyStorableObjects()) {
                        list.addAll(physicalModel.getStorableObjects());
                    }
                } else {
                    list.addAll(physicalModel.getStorableObjects());
                }
                list.add(physicalModel);
                for (StorableObject storableObject : list) {
                    this.saveObject(storableObject);
                }
                this.saveObjectList(physicalModel);
                physicalModel.doAfterSave();
                if (saveFailed) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to save the Physical Model: " + physicalModel.getName(), ex);
            return false;
        }
    }

    public static Document getDocument(File compressedFile) {
        try {
            int cnt;
            FileInputStream fin = new FileInputStream(compressedFile);
            InflaterInputStream iis = new InflaterInputStream(fin);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int size = 1024;
            byte[] buffer = new byte[size];
            while ((cnt = iis.read(buffer)) != -1) {
                bos.write(buffer, 0, cnt);
            }
            String text = new String(bos.toByteArray(), "UTF-8");
            ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(text.trim())));
            iis.close();
            bos.close();
            ((InputStream)in).close();
            return doc;
        }
        catch (Exception e) {
            Design.openFailed();
            LOGGER.error("Can not parse file:" + compressedFile.getAbsolutePath(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDocument(String storageName, Document xmlContent, boolean useCompressedFiles) {
        if (storageName != null && xmlContent != null) {
            try {
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    File fPath = new File(storageName).getParentFile();
                    if (!fPath.exists()) {
                        fPath.mkdirs();
                    }
                    if (useCompressedFiles) {
                        TransformerFactory transformerFactory = MDTransformer.transformerFactory();
                        Transformer transformer = transformerFactory.newTransformer();
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("encoding", "UTF-8");
                        DOMSource source = new DOMSource(xmlContent);
                        StringWriter sw = new StringWriter();
                        StreamResult result = new StreamResult(sw);
                        transformer.transform(source, result);
                        String xmlData = sw.getBuffer().toString();
                        sw.close();
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        FileOutputStream outStream = new FileOutputStream(storageName + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                        LSSerializer writer = impl.createLSSerializer();
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        writer.setNewLine("\n");
                        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                        String result = writer.writeToString(xmlContent);
                        byte[] output = result.getBytes("UTF-8");
                        fs.write(output, 0, output.length - 1);
                        fs.flush();
                        fs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContent(String storageName, String content, boolean useCompressedFiles) {
        if (storageName != null && content != null) {
            try {
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (useCompressedFiles) {
                        String xmlData = content;
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        FileOutputStream outStream = new FileOutputStream(storageName + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        OutputStreamWriter bs = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                        bs.write(content);
                        bs.flush();
                        bs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveContent(String storageName, StorableObject object, boolean useCompressedFiles, MDTransformationManager trMan) {
        if (storageName != null) {
            try {
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    if (useCompressedFiles) {
                        StringWriter sw = new StringWriter(8192);
                        XMLTransformationManager.writeContentAsStream(object, sw, trMan);
                        String xmlData = sw.getBuffer().toString();
                        sw.close();
                        byte[] input = xmlData.getBytes("UTF-8");
                        byte[] output = new byte[input.length];
                        Deflater compresser = new Deflater();
                        compresser.setInput(input);
                        compresser.finish();
                        int compressedDataLength = compresser.deflate(output);
                        FileOutputStream outStream = new FileOutputStream(storageName + COMPRESSED_FILE_SUFIX);
                        ((OutputStream)outStream).write(output, 0, compressedDataLength);
                        outStream.flush();
                        ((OutputStream)outStream).close();
                    } else {
                        FileOutputStream fs = new FileOutputStream(new File(storageName));
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                        BufferedWriter bs = new BufferedWriter(osw, 8192);
                        XMLTransformationManager.writeContentAsStream(object, bs, trMan);
                        bs.flush();
                        bs.close();
                    }
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
                saveFailed = true;
            }
        }
        return false;
    }

    public static void writeContentAsStream(Object object, Writer writer, MDTransformationManager trMan) {
        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectToStreamTransformer() != null && trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, writer);
        }
    }

    private static void writeContentAsStream(Object object, Writer writer, MDTransformationManager trMan, boolean processExternals, List excludeProps_Collections) {
        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
        if (trs != null && trs.getFromObjectToStreamTransformer() != null && trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
            ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, writer, processExternals, excludeProps_Collections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveObjectWithExternals(String storageName, Object object) {
        TimeLog.log("start save operation");
        if (storageName != null) {
            try {
                MDTransformationManager trMan = this.getMDTransformationManager();
                File fPath = new File(storageName).getParentFile();
                if (!fPath.exists()) {
                    fPath.mkdirs();
                }
                String old_sep = System.getProperty("line.separator");
                try {
                    System.setProperty("line.separator", "\n");
                    FileOutputStream fs = new FileOutputStream(new File(storageName));
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    BufferedWriter bs = new BufferedWriter(osw, 8192);
                    XMLTransformationManager.writeContentAsStream(object, bs, trMan, true, null);
                    bs.flush();
                    bs.close();
                    TimeLog.log("end save operation");
                }
                finally {
                    System.setProperty("line.separator", old_sep);
                }
                return true;
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformObjectsToStreamXML(List objects, OutputStream outputStream, List excludePropsAndCollections, boolean closeTheStream) {
        TimeLog.log("start output operation");
        try {
            MDTransformationManager trMan = this.getMDTransformationManager();
            String old_sep = System.getProperty("line.separator");
            try {
                System.setProperty("line.separator", "\n");
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
                BufferedWriter bs = new BufferedWriter(osw, 8192);
                try {
                    bs.write(XMLObjToStreamTransformer.header);
                    bs.write("\n<objects>");
                }
                catch (IOException e) {
                    Logger.error(e);
                }
                for (Object object : objects) {
                    MDTransformationManager.TrObjects trs = trMan.getTransformersFor(object.getClass());
                    if (trs == null || trs.getFromObjectToStreamTransformer() == null || !(trs.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer)) continue;
                    ((XMLObjToStreamTransformer)trs.getFromObjectToStreamTransformer()).transformFromObject(object, null, (Writer)bs, false, excludePropsAndCollections);
                }
                bs.write("\n</objects>");
                bs.flush();
                if (closeTheStream) {
                    bs.close();
                }
                TimeLog.log("end output operation");
            }
            finally {
                System.setProperty("line.separator", old_sep);
            }
            return true;
        }
        catch (Exception e) {
            String message = Messages.getString("XMLPersistenceManager.SaveError in ") + " ";
            LOGGER.error(message, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadObjectWithExternals(String storageName, Object object) {
        TimeLog.log("start load operation");
        if (storageName != null) {
            try {
                File file;
                MDTransformationManager trMan;
                MDTransformationManager.TrObjects trs;
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(false);
                }
                if ((trs = (trMan = this.getMDTransformationManager()).getTransformersFor(object.getClass())) != null && trs.getToObjectTransformer() != null && (file = new File(storageName)).exists()) {
                    this.transformFromXMLToObjectSAX(object, file, null);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                String message = Messages.getString("XMLPersistenceManager.SaveError") + " " + storageName;
                LOGGER.error(message, e);
            }
            finally {
                if (object instanceof ModelIDObject) {
                    ((ModelIDObject)object).getDesign().setPropagatePKChahges(true);
                }
                TimeLog.log("end load operation");
                this.getMetaDataManager().printTagMap();
            }
        }
        return false;
    }

    public void saveDomains(Design design) {
        boolean oldSaveFailed = saveFailed;
        saveFailed = false;
        HashMap<String, Domain> domainFileNames = new HashMap<String, Domain>();
        Iterator it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            String fileName = domain.getFileName();
            if (domainFileNames.containsKey(fileName)) continue;
            domainFileNames.put(fileName, domain);
        }
        it = domainFileNames.keySet().iterator();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(XMLTransformationManager.EXTENSION_XML_FILES);
            }
        };
        FolderFilesListing domainFilesListing = new FolderFilesListing(design.getDomainSet().getStoragePath(), filter);
        ArrayList<String> domainFilesList = domainFilesListing.getFilesLis();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            if ("".equals(fileName)) continue;
            if (!"defaultdomains".equalsIgnoreCase(fileName)) {
                this.saveDomain(design, fileName);
                domainFilesList.remove(fileName + EXTENSION_XML_FILES);
                continue;
            }
            this.saveDefaultDomain(this.getDefaultDomainsFileName(), design);
        }
        for (int i = 0; i < domainFilesList.size(); ++i) {
            File fileToDelete = new File(design.getDomainSet().getStoragePath(), (String)domainFilesList.get(i));
            fileToDelete.delete();
        }
        if (saveFailed) {
            // empty if block
        }
        saveFailed = oldSaveFailed;
    }

    public void saveDomain(Design design, String fileName) {
        DomainFileWrapper dw = new DomainFileWrapper(design, fileName);
        Document xmlContent = this.getXMLContent(dw);
        XMLTransformationManager.saveDocument(design.getDomainSet().getStorageName(fileName), xmlContent, false);
    }

    public boolean saveDefaultDomain(String filePath, Design design) {
        DomainFileWrapper dw = new DomainFileWrapper(design, "defaultdomains");
        Document xmlContent = this.getXMLContent(dw);
        return XMLTransformationManager.saveDocument(filePath, xmlContent, false);
    }

    public String getDefaultDomainsFileName() {
        try {
            return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultdomains.xml").getCanonicalPath();
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    public String getDefaultMaskTemplatesFileName() {
        try {
            return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "maskTemplates.xml").getCanonicalPath();
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    public static File getDefaultRDBMSFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "defaultRDBMSSites.xml");
    }

    public static File getDefaultTypesFile() {
        return new File(XMLTransformationManager.getDefaultSystemTypesPath(), "types.xml");
    }

    public static String getDefaultSystemTypesPath() {
        return XMLTransformationManager.getDefaultSystemTypesPath(null);
    }

    public static String getDefaultSystemTypesPath(Settings settings) {
        String sysTypesPath;
        if (settings != null && !"".equals(sysTypesPath = settings.getDefaultSystemTypesPath())) {
            return sysTypesPath;
        }
        File fPath = new File(Design.dmInternalsDistDir);
        return fPath.getAbsolutePath() + "/" + MDConfiguration.getDefaultInstance().get("typesPath");
    }

    public void loadDomains(Design design) {
        File domainsDir = new File(design.getDomainSet().getStoragePath());
        if (domainsDir.exists()) {
            File[] domains = domainsDir.listFiles();
            for (int i = 0; i < domains.length; ++i) {
                File file = domains[i];
                if (file.isDirectory()) continue;
                this.loadDomainFile(file, design);
            }
        }
    }

    public void loadDomainFile(File file, Design design) {
        try {
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            doc = db.parse(new InputSource(reader));
            reader.close();
            if (doc != null) {
                String fname = file.getName();
                int ind = fname.lastIndexOf(46);
                if (ind > 0) {
                    fname = fname.substring(0, ind);
                }
                this.loadDomains(design, fname, doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load Domain file: " + file.getAbsolutePath(), e);
        }
    }

    public void loadDomains(Design design, String fileNameNoExt, Document doc) {
        DomainFileWrapper dw = new DomainFileWrapper(design, fileNameNoExt);
        MDTransformer tr = this.getMDTransformationManager().getToObjectTransformerFor(DomainFileWrapper.class);
        if (tr != null && tr instanceof XMLToObjectTransformer) {
            ((XMLToObjectTransformer)tr).transformToObject((Object)dw, doc, null);
        }
    }

    public MDTransformationManager getXMLMapTransformationManager() {
        if (this.xmlMapManager == null) {
            this.xmlMapManager = new MDTransformationManager(this.metaDataManager);
            this.xmlMapManager.registerTransformer(ModelIDObject.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLFromMapToSteramTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            this.xmlMapManager.registerTransformer(Object.class, XMLFromMapTransformer.class, XMLToMapTransformer.class, XMLFromMapToSteramTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.xmlMapManager;
    }

    public MDTransformationManager getObjectMapTransformationManager() {
        if (this.objectMapTransManager == null) {
            this.objectMapTransManager = new MDTransformationManager(this.metaDataManager);
            this.objectMapTransManager.registerTransformer(ModelIDObject.class, XMLObjToMapTransformer.class, XMLMapToObjTransformer.class, XMLObjToStreamTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            this.objectMapTransManager.registerTransformer(Object.class, XMLObjToMapTransformer.class, XMLMapToObjTransformer.class, XMLObjToStreamTransformer.class, JSONObjToStreamTransformer.class, JSONToObjectTransformer.class);
            MDTransformer.SKP_DEFAULTS = true;
        }
        return this.objectMapTransManager;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public boolean hasDirtyStatus(Object object) {
        if (object instanceof RepositoryObject && ((RepositoryObject)object).isDirty()) {
            return true;
        }
        if (object instanceof StorableObject && ((StorableObject)object).isDirty()) {
            return true;
        }
        boolean dirty = this.hasDirtyProperty(object);
        if (dirty) {
            return true;
        }
        dirty = this.hasDirtyStructure(object);
        return dirty;
    }

    private boolean hasDirtyProperty(Object object) {
        ClassDescription cd = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (cd != null) {
            List<ClassDescription.PropertyDescription> list = cd.getPropertiesList();
            for (ClassDescription.PropertyDescription pd : list) {
                boolean dirty;
                Object nested;
                if (pd.isReferred() || pd.isSimpleClass() || pd.isStringClass() || pd.isPropertyMap || pd.isMap || (nested = MDTransformer.getObjectForProperty(object, pd)) == null || !(dirty = this.hasDirtyStatus(nested))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasDirtyStructure(Object object) {
        ClassDescription cd = this.getMetaDataManager().getClassDescription(object.getClass().getName());
        if (cd != null) {
            List<ClassDescription.CollectionDescription> list = cd.getCollectionsList();
            for (ClassDescription.CollectionDescription cold : list) {
                if (cold.isExternalCollection || cold.itemIsRef || cold.isMapItem || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) continue;
                Iterator items = MDTransformer.getObjectsIterator(object, cold);
                while (items.hasNext()) {
                    Object nested = items.next();
                    boolean dirty = this.hasDirtyStatus(nested);
                    if (!dirty) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearDirtyStatus(Object object) {
        if (object instanceof RepositoryObject) {
            ((RepositoryObject)object).setDirty(false);
        }
        this.clearDirtyProperties(object);
        this.clearDirtyStructure(object);
    }

    private void clearDirtyProperties(Object object) {
        MDTransformer xmltr;
        ClassDescription cd;
        if (object != null && (cd = this.getMetaDataManager().getClassDescription(object.getClass().getName())) != null && (xmltr = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass())) != null) {
            List<ClassDescription.PropertyDescription> list = cd.getPropertiesList();
            for (ClassDescription.PropertyDescription pd : list) {
                Object nested;
                if (pd.isReferred() || pd.isSimpleClass() || pd.isStringClass() || pd.isPropertyMap || pd.isMap || pd.isExternalProperty || (nested = MDTransformer.getObjectForProperty(object, pd)) == null) continue;
                this.clearDirtyStatus(nested);
            }
        }
    }

    private boolean clearDirtyStructure(Object object) {
        ClassDescription cd;
        if (object != null && (cd = this.getMetaDataManager().getClassDescription(object.getClass().getName())) != null) {
            List<ClassDescription.CollectionDescription> list = cd.getCollectionsList();
            for (ClassDescription.CollectionDescription cold : list) {
                if (cold.isExternalCollection || cold.itemIsRef || cold.isMapItem || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem) continue;
                Iterator items = MDTransformer.getObjectsIterator(object, cold);
                while (items.hasNext()) {
                    Object nested = items.next();
                    this.clearDirtyStatus(nested);
                }
            }
        }
        return false;
    }

    public void loadRDBMSSites(Design design) {
        File rdbmsSites;
        File rdbmsDir = new File(design.getStoragePath(), "rdbms");
        if (rdbmsDir.exists() && (rdbmsSites = new File(rdbmsDir, design.getName() + "_RDBMSSites.xml")).exists()) {
            try {
                Document doc = null;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(rdbmsSites), "UTF-8");
                doc = db.parse(new InputSource(reader));
                reader.close();
                if (doc != null) {
                    RDBMSTypeSet typeSet = Design.getDefaultRDBMSTypeSet();
                    RDBMSSiteSet set = design.getRDBMSSiteSet();
                    NodeList siteList = doc.getDocumentElement().getElementsByTagName("site");
                    int length = siteList.getLength();
                    for (int i = 0; i < length; ++i) {
                        this.recreateSite((Element)siteList.item(i), set, typeSet);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Can not load RDBMS Sites: " + rdbmsSites.getAbsolutePath(), e);
            }
        }
    }

    private void recreateSite(Element siteElm, RDBMSSiteSet set, RDBMSTypeSet typeSet) {
        String name = StringUtilities.decodeAttributeValue(siteElm.getAttribute("name"));
        String siteID = siteElm.getAttribute("oid");
        boolean exists = false;
        if (siteID != null && siteID.length() > 0) {
            boolean bl = exists = set.getByObjectID(siteID) != null;
        }
        if (!exists && !set.exists(name)) {
            String typeStr = siteElm.getAttribute(TYPE);
            String pathIDStr = siteElm.getAttribute("pathid");
            RDBMSSite site = set.createSite(name, set.getDesign());
            site.setIsDefault(false);
            site.setDesignLevel(true);
            int type = 9;
            try {
                type = Integer.parseInt(typeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rdbmsType = typeSet.get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteID);
            int pathID = 0;
            try {
                pathID = Integer.parseInt(pathIDStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                type = Integer.parseInt(typeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pathID > 0) {
                site.setPathID(pathID);
                set.updateMaxIndex(pathID);
            } else {
                site.setPathID(set.nextIndex());
            }
            if (rdbmsType == null) {
                LOGGER.error("Unknown RDBMS type: " + type);
            }
        }
    }

    public void saveRDBMSSites(Design design) {
        try {
            RDBMSSiteSet set = design.getRDBMSSiteSet();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.getDocumentElement();
            root = doc.createElement("metadatadoc");
            root.setAttribute("version", "2.0");
            doc.appendChild(root);
            RDBMSSite[] array = (RDBMSSite[])set.toArray();
            for (int i = 0; i < array.length; ++i) {
                if (array[i].isDefault()) continue;
                this.appendSiteNode(root, array[i]);
            }
            XMLTransformationManager.saveDocument(new File(design.getStoragePath(), "rdbms/" + design.getName() + "_RDBMSSites.xml").getCanonicalPath(), doc, false);
        }
        catch (Exception e) {
            LOGGER.error("Can not save RDBMS Sites for Design: " + design.getName());
        }
    }

    public void saveAdditionalFiles(Design design) {
        Path sourcePath;
        File file;
        if (design.getOldDesignPath() != null && !"".equalsIgnoreCase(design.getOldDesignPath()) && (file = (sourcePath = Paths.get(design.getOldDesignPath(), "files")).toFile()).exists()) {
            Path destPath = Paths.get(design.getStoragePath(), "files");
            try {
                FileUtils.copyFolder(sourcePath, destPath);
            }
            catch (Exception e) {
                LOGGER.error("Can not save the Additional Files Directory.", e);
            }
        }
    }

    public void appendSiteNode(Element root, RDBMSSite site) {
        Document doc = root.getOwnerDocument();
        Element siteElm = doc.createElement("site");
        siteElm.setAttribute("name", StringUtilities.encodeAttributeValue(site.getLongName()));
        if (site.getType() != null) {
            siteElm.setAttribute(TYPE, String.valueOf(site.getType().getType()));
        }
        siteElm.setAttribute("oid", site.getObjectID());
        siteElm.setAttribute("pathid", site.getPathIDString());
        root.appendChild(siteElm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equal(Object object1, Object object2, boolean includeLoggingProps) {
        MDTransformer tr;
        if (object1.getClass().equals(object2.getClass()) && (tr = this.getMDTransformationManager().getFromObjectTransformerFor(object1.getClass())) != null) {
            try {
                MDTransformer.includeLoggingProps = includeLoggingProps;
                MDTransformer.includeID = false;
                String str1 = tr.transformFromObjectToString(object1, null);
                String str2 = tr.transformFromObjectToString(object2, null);
                if (str1.equals(str2)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilteredXMLString(Object object) {
        String str = null;
        MDTransformer tr = this.getMDTransformationManager().getFromObjectTransformerFor(object.getClass());
        if (tr != null) {
            try {
                MDTransformer.includeLoggingProps = false;
                MDTransformer.includeID = false;
                str = tr.transformFromObjectToString(object, null);
            }
            finally {
                MDTransformer.includeLoggingProps = true;
                MDTransformer.includeID = true;
            }
        }
        return str;
    }

    public void setSaveSelectionsBLPS(boolean saveSelectionsBLPS) {
        this.saveSelectionsBLPS = saveSelectionsBLPS;
    }

    public boolean getSaveSelectionsBLPS() {
        return this.saveSelectionsBLPS;
    }

    public void setDDLGenerated(boolean DDLGenerated) {
        this.DDLGenerated = DDLGenerated;
    }

    public boolean getDDLGenerated() {
        return this.DDLGenerated;
    }

    public boolean getDDLSelectionLoaded() {
        return this.DDLSelectionLoaded;
    }

    public void setDDLSelectionLoaded(boolean DDLSelectionLoaded) {
        this.DDLSelectionLoaded = DDLSelectionLoaded;
    }

    public boolean getSelectedSubViewChanged() {
        return this.selectedSubViewChanged;
    }

    public void setSelectedSubViewChanged(boolean selectedSubViewChanged) {
        this.selectedSubViewChanged = selectedSubViewChanged;
    }

    public boolean getPersistedIncludeCommentsSelection() {
        return this.icansHelper.includeComments;
    }

    public boolean getPersistedGenerateDDLInFilesSelection() {
        return this.icansHelper.generateDDLInFiles;
    }

    public boolean getPersistedGenerateRESTServicesSelection() {
        return this.icansHelper.generateRESTServices;
    }

    public boolean getPersistedApplyNamesSubstitutionSelection() {
        return this.icansHelper.applyNameSubstitution;
    }

    public boolean getPersistedDropGeneratedObjectsOnly() {
        return this.icansHelper.dropGeneratedObjectsOnly;
    }

    public boolean getPersistedUseDropDependencies() {
        return this.icansHelper.useDropDependencies;
    }

    public void setPersistedDDLSelectionPath(String persistedDDLSelectionPath) {
        this.persistedDDLSelectionPath = persistedDDLSelectionPath;
    }

    public String getPersistedDDLSelectionPath() {
        return this.persistedDDLSelectionPath;
    }

    public XMLToObjectSAXTransformer getXMLToObjectSAXTransformer() {
        if (this.xMLToObjectSAXTransformer == null) {
            this.xMLToObjectSAXTransformer = new XMLToObjectSAXTransformer(this.getMetaDataManager());
        }
        return this.xMLToObjectSAXTransformer;
    }

    public static class DesignPartHelper {
        public String type;
        public String id;
        public String parent_id;
        public String name;
        public String main_view_id;
        public boolean top_level_dfd_design;
        public boolean visible = false;
    }

    public static class ObjectHelper {
        public String type;
        public String id;
        public String contID;
        public String refContID;
        public String name;
        public Object object;
        public boolean visible = false;
        public boolean markedGenerate = true;
        public String seq_name;
        public File file;
        public String propertyClassname = null;
        public String propertyParentid = null;
        public String propertySourceid = null;
        public String propertyTargetid = null;
    }

    private class IncludeCommentsAndApplyNameSubstitutionHelper {
        public boolean includeComments;
        public boolean applyNameSubstitution;
        public boolean dropGeneratedObjectsOnly;
        public boolean useDropDependencies;
        public boolean generateDDLInFiles;
        public boolean generateRESTServices;

        private IncludeCommentsAndApplyNameSubstitutionHelper() {
        }
    }
}

