/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.IDReplacer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLToObjectTransformer
extends MDTransformer
implements MDXMLConstants {
    public static boolean processCreatedTime = true;
    public static boolean checkForChanges = false;
    public static boolean checkShouldMerge = false;
    private static StorageDesign sourceStorageDesign;
    private static final Logger LOGGER;
    public static DocumentBuilder DOCUMENT_BUILDER;
    public static boolean XMLEntityExpanded;

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        MDTransformationManager.TrObjects trs = this.getTransformationManager().getTransformersFor(object.getClass());
        XMLToObjectTransformer tr = (XMLToObjectTransformer)trs.getFromObjectTransformer();
        if (tr != null) {
            return tr.transformFromObjectToString(object, excludeProps);
        }
        return null;
    }

    public void transformToObject(Object object, String xml, List excludeProps) {
        StringReader reader = new StringReader(xml);
        InputSource inputSource = new InputSource(reader);
        this.transformToObject(object, inputSource, excludeProps);
        reader.close();
    }

    public void transformToObject(Object object, File file, List excludeProps) throws IOException {
        this.transformToObject(object, file, false, excludeProps);
    }

    public void transformToObject(Object object, File file, boolean processExternals, List excludeProps) throws IOException {
        try (BufferedReader reader = XMLToObjectTransformer.getReader(file);){
            if (reader != null) {
                InputSource inputSource = new InputSource(reader);
                this.transformToObject(object, inputSource, processExternals, excludeProps);
            }
        }
    }

    static BufferedReader getReader(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public void transformToObject(Object object, InputSource inputSource, List excludeProps) {
        this.transformToObject(object, inputSource, false, excludeProps);
    }

    public void transformToObject(Object object, InputSource inputSource, boolean processExternals, List excludeProps) {
        Document doc = null;
        try {
            doc = DOCUMENT_BUILDER.parse(inputSource);
        }
        catch (Exception e) {
            Design.openFailed();
            if (object instanceof StorableObject) {
                StorableObject sto = (StorableObject)object;
                LOGGER.error("Can not parse file for " + sto.getName() + " in file " + sto.getStorageName() + "\n", e);
            } else {
                LOGGER.error("Can not parse file:", e);
            }
            if (object instanceof ModelIDObject) {
                // empty if block
            }
        }
        if (doc != null) {
            this.transformToObject(object, doc, processExternals, excludeProps);
        }
    }

    public void transformToObject(Object object, Document doc, List excludeProps) {
        this.transformToObject(object, doc, false, excludeProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformToObject(Object object, Document doc, boolean processExternals, List excludeProps) {
        Element root = doc.getDocumentElement();
        if (root != null) {
            ModelIDObject obj = null;
            String old = null;
            String newstr = null;
            String changedTime = null;
            if (!processExternals && checkForChanges && object instanceof ModelIDObject && !(obj = (ModelIDObject)object).isDirty()) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    old = this.transformFromObjectToString(object, excludeProps);
                    changedTime = obj.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
            }
            if (object instanceof Domain) {
                this.transformToDomain((Domain)object, root, processExternals, excludeProps);
            } else {
                this.transformToObject(object, root, processExternals, excludeProps);
            }
            if (old != null && obj != null && changedTime != null) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    newstr = this.transformFromObjectToString(object, excludeProps);
                    changedTime = obj.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
                if (old.equals(newstr)) {
                    obj.setChangedTime(changedTime);
                }
            }
        }
    }

    private void transformToDomain(Domain domain, Element rootElement, boolean processExternals, List excludeProps) {
        NodeList list = rootElement.getElementsByTagName("Domain");
        for (int i = 0; i < list.getLength(); ++i) {
            Element item = (Element)list.item(i);
            String domainID = item.getAttribute("id");
            if (!domainID.equalsIgnoreCase(domain.getRemoteObjectID())) continue;
            this.transformToObject((Object)domain, item, processExternals, excludeProps);
            break;
        }
    }

    public void transformToObject(Object object, Element rootElement, boolean processExternals, List excludeProps) {
        boolean process;
        Object physComparatorsMap = null;
        if (checkShouldMerge && object instanceof ModelIDObject && !(process = StorageDesign.shouldMerge((ModelIDObject)object, true))) {
            return;
        }
        ClassDescription cd = this.getClassDescription();
        Map propsMap = this.loadElements(rootElement, excludeProps);
        ArrayList<ClassDescription.PropertyDescription> loggingProps = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> afterCollectionsProcessing = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> collectionDependentProcessing = new ArrayList<ClassDescription.PropertyDescription>();
        List<ClassDescription.PropertyDescription> propsList = cd.getPropertiesList();
        for (ClassDescription.PropertyDescription pd : propsList) {
            if (pd.isExternalProperty && !processExternals) continue;
            if (pd.isLoggingProp) {
                loggingProps.add(pd);
                continue;
            }
            if (pd.isAfterCollectionProcessing) {
                afterCollectionsProcessing.add(pd);
                continue;
            }
            if (pd.beforeCollection != null && !"".equals(pd.beforeCollection) || pd.afterCollection != null && !"".equals(pd.afterCollection)) {
                collectionDependentProcessing.add(pd);
                continue;
            }
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        this.processClassPropertyMap(object, propsMap, cd);
        if (processExternals && cd.isCreateAllExtItemsFirst) {
            this.createAllExtItemsFirst(object, propsMap, rootElement, cd, processExternals);
        }
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            if (cold.isExternalCollection && !processExternals || excludeProps != null && excludeProps.contains(cold.name)) continue;
            if (cold.preProcess != null) {
                this.invokeMethod(object, cold.preProcess);
            }
            this.processBeforeCollection(object, propsMap, rootElement, cold, collectionDependentProcessing, processExternals, excludeProps);
            if (cold.createAllItemsFirst) {
                this.createAllItemsFirst(object, propsMap, rootElement, cold, processExternals);
            }
            this.processCollection(object, propsMap, rootElement, cold, processExternals, excludeProps);
            this.processAfterCollection(object, propsMap, rootElement, cold, collectionDependentProcessing, processExternals, excludeProps);
        }
        for (ClassDescription.PropertyDescription pd : afterCollectionsProcessing) {
            if (pd.isExternalProperty && !processExternals) continue;
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        for (ClassDescription.PropertyDescription pd : loggingProps) {
            this.processProperty(object, propsMap, rootElement, pd, processExternals, excludeProps);
        }
        this.invokeMethod(object, cd.afterInit);
        if (processExternals) {
            this.invokeMethod(object, cd.afterInitExt);
        }
    }

    private void processBeforeCollection(Object container, Map propsMap, Element root, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.beforeCollection == null || cold.name == null || !cold.name.equals(pd.beforeCollection)) continue;
            this.processProperty(container, propsMap, root, pd, processExternals, excludeProps);
        }
    }

    private void processAfterCollection(Object container, Map propsMap, Element root, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.afterCollection == null || cold.name == null || !cold.name.equals(pd.afterCollection)) continue;
            this.processProperty(container, propsMap, root, pd, processExternals, excludeProps);
        }
    }

    private void processClassPropertyMap(Object object, Map propsMap, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            NodeList elems;
            int count;
            PropertyMap pmap = (PropertyMap)object;
            Element element = (Element)propsMap.get("propertyMap");
            pmap.clearProperties();
            if (element != null && (count = (elems = element.getElementsByTagName("property")).getLength()) > 0) {
                for (int i = 0; i < count; ++i) {
                    Element item = (Element)elems.item(i);
                    String name = item.getAttribute("name");
                    if (name == null || "".equals(name)) continue;
                    String value = item.getAttribute("value");
                    pmap.setProperty(StringUtilities.decodeAttributeValue(name), StringUtilities.decodeAttributeValue(value));
                }
            }
        }
    }

    private void processProperty(Object object, Map propsMap, Element root, ClassDescription.PropertyDescription pd, boolean processExternals, List excludeProps) {
        if (pd.isCreatedTimeProp && !processCreatedTime) {
            return;
        }
        String value = null;
        boolean useDefault = false;
        Object node = propsMap.get(pd.xmlName);
        if (node == null && pd.oldXmlName != null) {
            node = propsMap.get(pd.oldXmlName);
        }
        boolean cdata = false;
        if (node != null) {
            if (node instanceof Node && !(node instanceof Element)) {
                value = ((Node)node).getNodeValue();
            } else if (node instanceof Element) {
                Element element = (Element)node;
                if (pd.isRectangle) {
                    this.processRectangle(element, object, pd);
                    return;
                }
                if (pd.isPropertyMap) {
                    this.processPropertyAsPropertyMap(object, element, pd);
                    return;
                }
                if (pd.isMap) {
                    this.processMapProperty(object, element, pd);
                    return;
                }
                if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                    Node textNode = element.getFirstChild();
                    value = element.getTextContent();
                    if (textNode != null && textNode.getNodeType() == 4) {
                        cdata = true;
                    }
                } else if (!pd.isReferred()) {
                    XMLToObjectTransformer tr;
                    MDTransformationManager.TrObjects trs;
                    Object nested = XMLToObjectTransformer.getObjectForProperty(object, pd);
                    if (nested == null && pd.createProperty != null) {
                        nested = this.createObject(object, pd.createProperty);
                    }
                    if (nested != null && (trs = this.getTransformationManager().getTransformersFor(nested.getClass())) != null && trs.getFromObjectTransformer() != null && trs.getFromObjectTransformer() instanceof XMLFromObjTransformer && (tr = (XMLToObjectTransformer)trs.getToObjectTransformer()) != null) {
                        tr.transformToObject(nested, element, processExternals, excludeProps);
                        if (pd.setter != null) {
                            this.setObjectForProperty(object, pd, nested);
                        }
                    }
                    return;
                }
            }
        } else {
            useDefault = true;
        }
        if (useDefault) {
            if (excludeProps != null) {
                if (!excludeProps.contains(pd.name)) {
                    this.setDefaultProperty(object, pd);
                }
            } else {
                this.setDefaultProperty(object, pd);
            }
        } else {
            if (value == null) {
                value = "";
            } else {
                if (!cdata) {
                    value = StringUtilities.decodeAttributeValue(value);
                }
                if (pd.isID || pd.isListOfRefs) {
                    if (object instanceof ModelIDObject) {
                        value = ((ModelIDObject)object).replaceIDsInValue(value);
                    } else if (object instanceof IDReplacer) {
                        value = ((IDReplacer)object).replaceIDsInValue(value);
                    }
                }
            }
            this.setProperty(object, value, pd);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Element pmElement, ClassDescription.PropertyDescription pd) {
        Object obj = XMLToObjectTransformer.getObjectForProperty(object, pd);
        boolean created = false;
        if (obj == null) {
            obj = this.createObject(object, pd.createPMap);
            created = true;
        }
        if (obj instanceof PropertyMap) {
            NodeList elems = pmElement.getElementsByTagName(pd.pmItemName);
            int count = elems.getLength();
            PropertyMap pm = (PropertyMap)obj;
            if (!created) {
                pm.clearProperties();
            }
            for (int i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                String key = item.getAttribute(pd.pmKeyName);
                String value = item.getAttribute(pd.pmValueName);
                if (key == null || value == null || "".equals(key)) continue;
                pm.setProperty(StringUtilities.decodeAttributeValue(key), StringUtilities.decodeAttributeValue(value));
            }
            if (created) {
                this.setObjectForProperty(object, pd, obj);
            }
        }
    }

    private void processMapProperty(Object object, Element pmElement, ClassDescription.PropertyDescription pd) {
        Object obj = XMLToObjectTransformer.getObjectForProperty(object, pd);
        if (obj != null && obj instanceof Map) {
            NodeList elems = pmElement.getElementsByTagName(pd.pmItemName);
            int count = elems.getLength();
            Map map = (Map)obj;
            for (int i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                String key = item.getAttribute("key");
                String value = item.getAttribute("value");
                if (key == null || value == null || "".equals(key)) continue;
                map.put(StringUtilities.decodeAttributeValue(key), StringUtilities.decodeAttributeValue(value));
            }
        }
    }

    private void processCollection(Object container, Map propsMap, Element root, ClassDescription.CollectionDescription cold, boolean processExternals, List excludeProps) {
        Element element = (Element)propsMap.get(cold.xmlName);
        if (element != null) {
            NodeList elems;
            int count;
            if (this.canProcessCollectionItem(cold)) {
                List oldItems = this.getListWithElements(container, cold);
                ArrayList newItems = new ArrayList();
                if (!cold.itemIsRef) {
                    this.processCollectionWithContained(container, element, cold, newItems, oldItems, processExternals, excludeProps);
                } else {
                    this.processCollectionWithRefs(container, element, cold, newItems);
                }
                if (cold.applyList == null) {
                    XMLToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
                } else {
                    XMLToObjectTransformer.applyList(container, cold.applyList, newItems);
                }
            } else if (cold.isMapItem && cold.applyList != null && (count = (elems = element.getElementsByTagName(cold.itemXmlName)).getLength()) > 0) {
                ArrayList list = new ArrayList();
                for (int i = 0; i < count; ++i) {
                    Element item = (Element)elems.item(i);
                    NamedNodeMap nmap = item.getAttributes();
                    int c = nmap.getLength();
                    if (c <= 0) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int k = 0; k < c; ++k) {
                        Node node = nmap.item(k);
                        String name = node.getNodeName();
                        String value = node.getNodeValue();
                        map.put(StringUtilities.decodeAttributeValue(name), StringUtilities.decodeAttributeValue(value));
                    }
                    list.add(map);
                }
                XMLToObjectTransformer.applyList(container, cold.applyList, list);
            }
        } else if (this.canProcessCollectionItem(cold)) {
            List oldItems = this.getListWithElements(container, cold);
            XMLToObjectTransformer.orderAndClearList(container, cold, oldItems, Collections.EMPTY_LIST);
        } else if (cold.isMapItem && cold.applyList != null) {
            XMLToObjectTransformer.applyList(container, cold.applyList, Collections.EMPTY_LIST);
        }
    }

    private void createAllItemsFirst(Object container, Map propsMap, Element root, ClassDescription.CollectionDescription cold, boolean processExternals) {
        Element element = (Element)propsMap.get(cold.xmlName);
        if (element != null && this.canProcessCollectionItem(cold)) {
            List oldItems = this.getListWithElements(container, cold);
            ArrayList newItems = new ArrayList();
            if (!cold.itemIsRef) {
                this.createAllContained(container, element, cold, newItems, oldItems, processExternals);
            }
            if (cold.applyList == null) {
                XMLToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
            } else {
                XMLToObjectTransformer.applyList(container, cold.applyList, newItems);
            }
        }
    }

    private void createAllExtItemsFirst(Object container, Map propsMap, Element root, ClassDescription cd, boolean processExternals) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Element element;
            if (!cold.isExternalCollection || !processExternals || (element = (Element)propsMap.get(cold.xmlName)) == null || !this.canProcessCollectionItem(cold)) continue;
            List oldItems = this.getListWithElements(container, cold);
            ArrayList newItems = new ArrayList();
            if (!cold.itemIsRef) {
                this.createAllContained(container, element, cold, newItems, oldItems, processExternals);
            }
            if (cold.applyList == null) {
                XMLToObjectTransformer.orderAndClearList(container, cold, oldItems, newItems);
                continue;
            }
            XMLToObjectTransformer.applyList(container, cold.applyList, newItems);
        }
    }

    private void createAllContained(Object container, Element element, ClassDescription.CollectionDescription cold, List newItems, List oldItems, boolean processExternals) {
        NodeList elems = element.getElementsByTagName(cold.itemXmlName);
        int count = elems.getLength();
        for (int i = 0; i < count; ++i) {
            Element item = (Element)elems.item(i);
            Object object = this.getOrCreateObject(container, item, cold, oldItems);
            if (object == null) continue;
            if (cold.addItem != null) {
                this.addItem(container, cold.addItem, object);
            }
            newItems.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectionWithContained(Object container, Element element, ClassDescription.CollectionDescription cold, List newItems, List oldItems, boolean processExternals, List excludeProps) {
        XMLToObjectTransformer tr = null;
        NodeList elems = element.getElementsByTagName(cold.itemXmlName);
        int count = elems.getLength();
        for (int i = 0; i < count; ++i) {
            Element item = (Element)elems.item(i);
            Object object = null;
            try {
                object = this.getOrCreateObject(container, item, cold, oldItems);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create object: ", e);
            }
            if (object == null) continue;
            try {
                if (object instanceof StorageDesign) {
                    ((StorageDesign)object).setLoading(true);
                }
                if (tr == null) {
                    MDTransformationManager.TrObjects trs = this.getTransformationManager().getTransformersFor(object.getClass());
                    tr = (XMLToObjectTransformer)trs.getToObjectTransformer();
                }
                if (tr != null) {
                    try {
                        tr.transformToObject(object, item, processExternals, excludeProps);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to transform object: " + object.toString(), e);
                    }
                }
                this.processTopView(object, item);
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                }
                newItems.add(object);
                continue;
            }
            finally {
                if (object instanceof StorageDesign) {
                    ((StorageDesign)object).setLoading(false);
                    ((StorageDesign)object).setOpen(true);
                }
            }
        }
    }

    private void processTopView(Object object, Element item) {
        if (object instanceof TVConnector) {
            this.processPointsCollection(item, object);
        }
    }

    private void processRectangle(Element propElement, Object object, ClassDescription.PropertyDescription pd) {
        String xs = propElement.getAttribute("x");
        String ys = propElement.getAttribute("y");
        String ws = propElement.getAttribute("width");
        String hs = propElement.getAttribute("height");
        int x = 0;
        int y = 0;
        int w = 20;
        int h = 20;
        try {
            x = Integer.valueOf(xs);
            y = Integer.valueOf(ys);
            w = Integer.valueOf(ws);
            h = Integer.valueOf(hs);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
        Rectangle rect = new Rectangle(x, y, w, h);
        this.setObjectForProperty(object, pd, rect);
    }

    private void processPointsCollection(Element element, Object object) {
        if (object instanceof TVConnector) {
            TVConnector tvc = (TVConnector)object;
            Element points = XMLToObjectTransformer.getFirstChildByTagName(element, "points");
            if (points != null) {
                NodeList plist = points.getElementsByTagName("point");
                List list = tvc.getEdgePoints();
                list.clear();
                int plLength = plist.getLength();
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    String px = point.getAttribute("x");
                    String py = point.getAttribute("y");
                    int x = 0;
                    int y = 0;
                    try {
                        x = Integer.valueOf(px);
                        y = Integer.valueOf(py);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Point p = new Point(x, y);
                    list.add(p);
                }
            }
        }
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    private Object getOrCreateObject(Object container, Element item, ClassDescription.CollectionDescription cold, List oldItems) {
        if (cold.isObjectViewItem && container instanceof DesignPartView) {
            return this.getOrCreateTopView((DesignPartView)container, item, cold);
        }
        if (cold.isTVConnectorItem && container instanceof DesignPartView) {
            return this.getOrCreateTVConnector((DesignPartView)container, item, cold);
        }
        if (cold.isPhysicalModelItem && container instanceof RelationalDesign) {
            return this.getOrCreateStorageDesign((RelationalDesign)container, item, cold);
        }
        String id = this.getID(item);
        Object object = null;
        if (id != null) {
            if (cold.getItemByID != null) {
                object = this.getItemByID(container, cold.getItemByID, id);
            } else if (container instanceof DesignObject || container instanceof DesignPart) {
                object = ((ModelIDObject)container).getDesign().getDesignObject(id);
            } else if (container instanceof StorageObject) {
                ModelIDObject sourceStorageObject;
                if (checkShouldMerge && sourceStorageDesign != null && (sourceStorageObject = sourceStorageDesign.getModelIDObject(id)) != null && !sourceStorageObject.shouldBeMerge()) {
                    return null;
                }
                object = ((StorageObject)container).getStorageDesign().getStorageObject(id);
            } else {
                object = container instanceof StorageDesign ? ((StorageDesign)container).getStorageObject(id) : this.getItemByID(oldItems, id, cold);
            }
        }
        if (object == null) {
            if (cold.isProxyitem) {
                if (container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(null, id);
                }
            } else {
                if (cold.getItemByID == null && container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.itemXmlName, id);
                }
                if (object == null) {
                    object = this.createItem(container, cold.createItem);
                    if (object instanceof ModelIDObject && id != null) {
                        ((ModelIDObject)object).setObjectID(id);
                    }
                    return object;
                }
            }
        }
        if (object instanceof TableProxyOracle) {
            ((TableProxyOracle)object).setUser(null);
        }
        if (!checkShouldMerge && object instanceof ModelIDObject && id != null) {
            ((ModelIDObject)object).setObjectID(id);
        }
        return object;
    }

    private Object getOrCreateTopView(DesignPartView dpv, Element item, ClassDescription.CollectionDescription cold) {
        if (cold.isObjectViewItem) {
            String type;
            String oid = StringUtilities.decodeAttributeValue(item.getAttribute("oid"));
            DesignObject object = dpv.getDesignPart().getDesign().getDesignObject(oid);
            if (object == null && "Note".equalsIgnoreCase(type = StringUtilities.decodeAttributeValue(item.getAttribute("otype")))) {
                object = dpv.getDesignPart().createNote();
                object.setObjectID(oid);
            }
            if (object != null) {
                String vid = StringUtilities.decodeAttributeValue(item.getAttribute("vid"));
                String vnum = StringUtilities.decodeAttributeValue(item.getAttribute("vnum"));
                int num = 0;
                try {
                    num = Integer.valueOf(vnum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                TopView cv = object.getTopViewByID(dpv, vid, num);
                if (cv == null) {
                    cv = dpv.createTopViewForGlobal(object);
                }
                if (cv != null) {
                    if (!dpv.getTopviewsList().contains(cv)) {
                        dpv.add(cv);
                    }
                    cv.setViewID(vid);
                }
                return cv;
            }
        }
        return null;
    }

    private Object getOrCreateTVConnector(DesignPartView dpv, Element item, ClassDescription.CollectionDescription cold) {
        if (cold.isTVConnectorItem) {
            String oid = StringUtilities.decodeAttributeValue(item.getAttribute("oid"));
            DesignObject dobj = dpv.getDesignPart().getDesign().getDesignObject(oid);
            if (dobj != null && dobj instanceof ConnectionInterface) {
                ConnectionInterface connector = (ConnectionInterface)((Object)dobj);
                String vid_source = StringUtilities.decodeAttributeValue(item.getAttribute("vid_source"));
                String vid_target = StringUtilities.decodeAttributeValue(item.getAttribute("vid_target"));
                if (connector.getSourceObject() != null && connector.getTargetObject() != null) {
                    TopView tv;
                    TopView ttv;
                    TopView stv;
                    if (!vid_source.equals("") && (stv = connector.getSourceObject().getTopViewByID(dpv, vid_source, 0)) != null) {
                        connector.setSourceTopView(stv);
                    }
                    if (!vid_target.equals("") && (ttv = connector.getTargetObject().getTopViewByID(dpv, vid_target, 0)) != null) {
                        connector.setTargetTopView(ttv);
                    }
                    if ((tv = connector.getViewFor(dpv)) != null && !dpv.getTopviewsList().contains(tv)) {
                        dpv.add(tv);
                    }
                    return tv;
                }
            }
        }
        return null;
    }

    @Override
    Object getItemByID(List oldItems, String id, ClassDescription.CollectionDescription cold) {
        for (Object obj : oldItems) {
            if (obj instanceof ModelIDObject) {
                if (!((ModelIDObject)obj).getObjectID().equals(id)) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    private Object getOrCreateStorageDesign(RelationalDesign rd, Element item, ClassDescription.CollectionDescription cold) {
        Element siteTypeElm;
        Element siteID_Elem = this.getFirstElementByTagName("siteID", item);
        String siteID = siteID_Elem.getTextContent();
        RDBMSSite site = rd.getDesign().getRDBMSSiteSet().getByObjectID(siteID);
        if (site == null && (siteTypeElm = this.getFirstElementByTagName("siteType", item)) != null) {
            String siteType = siteTypeElm.getTextContent();
            Element siteTypeID = this.getFirstElementByTagName("siteID", item);
            String siteOID = siteTypeID.getTextContent();
            Element siteTypeName = this.getFirstElementByTagName("siteName", item);
            String siteName = siteTypeName.getTextContent();
            site = rd.getDesign().getRDBMSSiteSet().createSite(siteName, rd.getDesign());
            int type = 9;
            try {
                type = Integer.parseInt(siteType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteOID);
            site.setPathID(rd.getDesign().getRDBMSSiteSet().nextIndex());
        }
        if (site != null) {
            boolean exists = rd.getStorageDesignFactory().existStorageDesign(site);
            StorageDesign stoDes = rd.getStorageDesign(site);
            if (stoDes != null) {
                stoDes.setTempModel(false);
                if (exists && !rd.getDesign().isNewDesign()) {
                    stoDes.openStorageDesign();
                }
            }
            return stoDes;
        }
        return null;
    }

    private void processCollectionWithRefs(Object container, Element element, ClassDescription.CollectionDescription cold, List newItems) {
        Object obj;
        int i;
        ArrayList<String> idslist = new ArrayList<String>();
        if (cold.listOfRefs) {
            String refs = element.getAttribute(cold.refsXMLName);
            if (refs != null && !"".equals(refs)) {
                String[] ids = refs.split(" ");
                for (i = 0; i < ids.length; ++i) {
                    idslist.add(ids[i]);
                }
            }
        } else {
            NodeList elems = element.getElementsByTagName(cold.itemXmlName);
            int count = elems.getLength();
            for (i = 0; i < count; ++i) {
                Element item = (Element)elems.item(i);
                Node textNode = item.getFirstChild();
                if (textNode == null) continue;
                String value = textNode.getNodeValue();
                idslist.add(value);
            }
        }
        List target = null;
        if (cold.nativeList && cold.addItem == null && (obj = XMLToObjectTransformer.getCollection(container, cold)) instanceof List) {
            target = (List)obj;
        }
        for (String id : idslist) {
            Object object = this.getItemByID(container, cold.getItemByID, id);
            if (object == null && container instanceof ID_ObjectPropertyTranslator && (object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.xmlName, id)) != null) {
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                } else if (cold.nativeList && target != null) {
                    target.add(object);
                }
            }
            if (object == null) continue;
            newItems.add(object);
        }
    }

    private String getID(Element element) {
        String id = element.getAttribute("id");
        if ((id == null || "".equals(id)) && (id = element.getAttribute("objectID")) != null && "".equals(id) && (id = element.getAttribute("IDREF")) != null && "".equals(id)) {
            return null;
        }
        return id;
    }

    private Map loadElements(Element root, List excludeProps) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList nodes = root.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            String tagName = element.getTagName();
            if (excludeProps != null) {
                if (excludeProps.contains(tagName)) continue;
                map.put(tagName, element);
                continue;
            }
            map.put(tagName, element);
        }
        NamedNodeMap nmap = root.getAttributes();
        int c = nmap.getLength();
        if (c > 0) {
            for (int k = 0; k < c; ++k) {
                Node node = nmap.item(k);
                String name = node.getNodeName();
                if (excludeProps != null) {
                    if (excludeProps.contains(name)) continue;
                    map.put(name, node);
                    continue;
                }
                map.put(name, node);
            }
        }
        return map;
    }

    public static void setSourceStorageDesign(StorageDesign storageDesign) {
        sourceStorageDesign = storageDesign;
    }

    static {
        LOGGER = new Logger(XMLToObjectTransformer.class);
        DOCUMENT_BUILDER = null;
        XMLEntityExpanded = true;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = dbf.newDocumentBuilder();
            XMLEntityExpanded = dbf.isExpandEntityReferences();
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
        }
    }
}

