/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;

public class IndexHashPartitionOraclev10g
extends IndexHashPartitionOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private StorageObjectCollection lobitems;

    public IndexHashPartitionOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
        this.lobitems = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getIndexHashPartitionLobItemSet());
        this.lobitems.setParent(this);
        this.lobitems.setName(Messages.getString("IndexHashPartitionOracle.LobStorages"));
        this.lobitems.setClassForParent(IndexHashPartitionOracle.class);
        this.lobitems.setSetMethod("setIndexHashPartition");
        ((StorageDesignOraclev10g)storageDesign).getIndexHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof IndexHashPartitionLobItemOracle) {
                IndexHashPartitionLobItemOracle ls = (IndexHashPartitionLobItemOracle)event.getAffected();
                ls.addObjectListener(this);
                if (ls.getIndexHashPartition() != null && ls.getIndexHashPartition() == this) {
                    ls.setParent(this.lobitems);
                    this.lobitems.add(ls);
                } else {
                    this.lobitems.remove(ls);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof IndexHashPartitionLobItemOracle) {
            IndexHashPartitionLobItemOracle ls = (IndexHashPartitionLobItemOracle)event.getAffected();
            this.lobitems.remove(ls);
            ls.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof IndexHashPartitionLobItemOracle) {
            IndexHashPartitionLobItemOracle ls = (IndexHashPartitionLobItemOracle)event.getAffected();
            if (ls.getIndexHashPartition() != null && ls.getIndexHashPartition() == this) {
                ls.setParent(this.lobitems);
                this.lobitems.add(ls);
            } else {
                this.lobitems.remove(ls);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.lobitems;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.lobitems) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageObjectCollection getLobItems() {
        return this.lobitems;
    }

    public IndexHashPartitionLobItemOracle createLobItem() {
        if (this.lobitems.getStorageObjectSet() != null) {
            return (IndexHashPartitionLobItemOracle)this.lobitems.createElement(null);
        }
        return null;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        IndexHashPartitionOraclev10g indexPartition = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getIndexHashPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                indexPartition = (IndexHashPartitionOraclev10g)storageObject;
            }
        } else {
            indexPartition = (IndexHashPartitionOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexHashPartitionSet().createIndexHashPartition();
        }
        if (indexPartition != null) {
            TableSpaceOraclev10g newTableSpace;
            TableSpaceOraclev10g tableSpace;
            indexPartition.setName(this.getName());
            for (IndexHashPartitionLobItemOraclev10g lobItem : this.getLobItems()) {
                IndexHashPartitionLobItemOraclev10g targetLobItem = (IndexHashPartitionLobItemOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexHashPartitionLobItemSet().getByName(lobItem.getName());
                if (targetLobItem == null) {
                    IndexHashPartitionLobItemOraclev10g newLobItem = (IndexHashPartitionLobItemOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexHashPartitionLobItemSet().createIndexHashPartitionLobItem();
                    newLobItem.setName(lobItem.getName());
                    newLobItem.setRawObject(true);
                    newLobItem.setIndexHashPartition(indexPartition);
                    indexPartition.getLobItems().add(newLobItem);
                    continue;
                }
                targetLobItem.setIndexHashPartition(indexPartition);
                indexPartition.getLobItems().add(targetLobItem);
            }
            if (this.getIndexGlobalPartList() != null) {
                IndexGlobalPartitionsListOraclev10g indexList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPartList().getName());
                if (indexList == null) {
                    IndexGlobalPartitionsListOraclev10g newIndexList = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newIndexList.setName(this.getIndexGlobalPartList().getName());
                    newIndexList.setRawObject(true);
                    indexPartition.setIndexGlobalPartList(newIndexList);
                } else {
                    indexPartition.setIndexGlobalPartList(indexList);
                }
            }
            if (this.getTableSpace() != null) {
                tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(false);
                    indexPartition.setTableSpace(newTableSpace);
                } else {
                    indexPartition.setTableSpace(tableSpace);
                }
            }
            if (this.getOverflowTableSpace() != null) {
                tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getOverflowTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getOverflowTableSpace().getName());
                    newTableSpace.setRawObject(false);
                    indexPartition.setOverflowTableSpace(newTableSpace);
                } else {
                    indexPartition.setOverflowTableSpace(tableSpace);
                }
            }
        }
    }
}

