/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;

public class DiskGroupOraclev10g
extends AbstractStorageObjectOracle
implements StorageObjectListener,
ModelObjectSetListener {
    StorageObjectCollection failGroups;
    private static Set redundancySet = null;
    private String redundancy = REDUNDANCY_STATES[0];
    private static final String[] REDUNDANCY_STATES = new String[]{"NORMAL", "HIGH", "EXTERNAL"};
    public static final String TYPE_NAME = "DiskGroup";

    public DiskGroupOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.failGroups = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getFailGroupSet());
        this.failGroups.setParent(this);
        this.failGroups.setName(Messages.getString("DiskGroupOraclev10g.FailGroup"));
        this.failGroups.setSetMethod("setDiskGroup");
        this.failGroups.setClassForParent(DiskGroupOraclev10g.class);
        ((StorageDesignOraclev10g)storageDesign).getFailGroupSet().addSetListener(this);
    }

    public String getRedundancy() {
        return this.redundancy;
    }

    public void setRedundancy(String value) {
        if (this.checkRedundancyState(value)) {
            this.redundancy = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkRedundancyState(String value) {
        if (redundancySet == null) {
            redundancySet = new HashSet();
            redundancySet.addAll(Arrays.asList(DiskGroupOraclev10g.getRedundancyStates()));
        }
        return redundancySet.contains(value);
    }

    public static String[] getRedundancyStates() {
        return REDUNDANCY_STATES;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DG";
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.failGroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.failGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.failGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.failGroups.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof FailGroupOraclev10g) {
                FailGroupOraclev10g fg = (FailGroupOraclev10g)event.getAffected();
                fg.addObjectListener(this);
                if (fg.getDiskGroup() != null && fg.getDiskGroup() == this) {
                    fg.setParent(this.failGroups);
                    this.failGroups.add(fg);
                } else {
                    this.failGroups.remove(fg);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof FailGroupOraclev10g) {
            FailGroupOraclev10g fg = (FailGroupOraclev10g)event.getAffected();
            this.failGroups.remove(fg);
            fg.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof FailGroupOraclev10g) {
            FailGroupOraclev10g fg = (FailGroupOraclev10g)event.getAffected();
            if (fg.getDiskGroup() != null && fg.getDiskGroup() == this) {
                fg.setParent(this.failGroups);
                this.failGroups.add(fg);
            } else {
                this.failGroups.remove(fg);
            }
        }
    }

    public List getFailGroups() {
        ArrayList list = new ArrayList();
        this.failGroups.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getFailGroupCollection() {
        return this.failGroups;
    }

    public FailGroupOraclev10g createFailGroup() {
        if (this.failGroups.getStorageObjectSet() != null) {
            return (FailGroupOraclev10g)this.failGroups.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DiskGroupOraclev10g diskGroup = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getDiskGroupSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                diskGroup = (DiskGroupOraclev10g)stObject;
            }
        } else {
            diskGroup = ((StorageDesignOraclev10g)targetDesign).getDiskGroupSet().createDiskGroup();
        }
        if (diskGroup != null) {
            diskGroup.setName(this.getName());
            for (FailGroupOraclev10g failGroup : this.getFailGroups()) {
                FailGroupOraclev10g targetFailGroup = (FailGroupOraclev10g)((StorageDesignOraclev10g)targetDesign).getFailGroupSet().getByName(failGroup.getName());
                if (targetFailGroup == null) {
                    FailGroupOraclev10g newFailGroup = ((StorageDesignOraclev10g)targetDesign).getFailGroupSet().createFailGroup();
                    newFailGroup.setName(failGroup.getName());
                    newFailGroup.setDiskGroup(diskGroup);
                    newFailGroup.setRawObject(true);
                    diskGroup.getFailGroups().add(newFailGroup);
                    continue;
                }
                targetFailGroup.setDiskGroup(diskGroup);
                diskGroup.getFailGroups().add(targetFailGroup);
            }
            diskGroup.setRedundancy(this.getRedundancy());
            diskGroup.setComment(this.getComment());
            diskGroup.setRawObject(false);
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        this.failGroups.removeAll();
    }
}

