/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageObjectSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public abstract class TableSpaceSetOracle
extends StorageObjectSet
implements StorageObjectSetOracle {
    private static final Object[] PROTO_ARRAY = new TableSpaceOracle[0];
    private boolean createDefaultTableSpaces = false;

    public TableSpaceOracle createTableSpace() {
        return this.createTableSpace(null);
    }

    public TableSpaceOracle createTableSpace(String id) {
        return (TableSpaceOracle)this.createElement(id);
    }

    @Override
    public String getDefaultNamePrefix() {
        return "TableSpace";
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    public void createDefaultTableSpaceFor(TableProxyOracle tableProxy) {
        TableSpaceOracle tableSpace = this.createTableSpace();
        tableSpace.setDefaultForTable(tableProxy.getObjectID());
        tableProxy.setTableSpace(tableSpace);
        TableSpaceSetOracle.makeDefaultTableSpaceName(tableProxy);
        tableProxy.addObjectListener(tableSpace);
    }

    public static void makeDefaultTableSpaceName(TableProxyOracle tableProxy) {
        TableSpaceOracle tableSpace = tableProxy.getTableSpace();
        if (tableSpace != null && tableSpace.isDefaultFor(tableProxy)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(tableSpace.getIDPrefix()).append(tableProxy.getName());
            tableSpace.setName(buffer.toString());
        }
    }

    public void setCreateDefaultTableSpaces(boolean value) {
        this.createDefaultTableSpaces = value;
    }

    public boolean getCreateDefaultTableSpaces() {
        return this.createDefaultTableSpaces;
    }

    public void changed(StorageObjectSetEvent event) {
        StorageObject sobject;
        if (this.getCreateDefaultTableSpaces() && (sobject = event.getAffectedStorageObject()) instanceof TableProxy && event.isAdded()) {
            TableProxyOracle tableProxy = (TableProxyOracle)sobject;
            this.createDefaultTableSpaceFor(tableProxy);
        }
    }
}

