/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public class TableViewProxy
extends RelationalObjectProxy {
    private boolean checkOption = false;
    private String definition = "";
    public static final String NAME_SUBSTITUTION_TYPE = "View";

    public TableViewProxy(TableView view, StorageDesign storage) {
        super(view, storage);
    }

    public TableViewProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public void setCheckOption(boolean checkOption) {
        this.checkOption = checkOption;
    }

    public boolean getCheckOption() {
        return this.checkOption;
    }

    public void setDefinition(String definition) {
        if (!definition.equals(this.getDefinition())) {
            this.definition = definition;
        }
    }

    public String getDefinitionInPhysicalModel() {
        return this.definition;
    }

    public String getDefinition() {
        if (this.definition.trim().isEmpty()) {
            TableView view = (TableView)this.getObject();
            if (!view.getUserDefined() && !view.getDesign().isLoading()) {
                return view.generateSQL(this.getStorageDesign());
            }
            return view.getUserDefinedSQL();
        }
        return this.definition;
    }

    @Override
    public String getIDPrefix() {
        return "TVP";
    }

    @Override
    public String getObjectTypeName() {
        return NAME_SUBSTITUTION_TYPE;
    }

    public StorageObject getUserSchema() {
        return null;
    }

    public void setUserSchema(String schema) {
    }

    public ModelIDObject getSchemaImplementingObject() {
        if (this.getStorageDesign().isOpen()) {
            SchemaObject schemaObject;
            StorageObject so = this.getUserSchema();
            if (so != null) {
                return so;
            }
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null && (schemaObject = co.getSchemaObject()) != null) {
                return this.getStorageDesign().getUserSchemaSet().getBySchemaObject(schemaObject);
            }
        } else {
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null) {
                return co.getSchemaObject();
            }
        }
        return null;
    }

    public TableViewProxy getSuperView() {
        ContainerObject parentView;
        TableView view = (TableView)this.getObject();
        if (view.getTypeSubstitution() != null && !view.isRoot() && (parentView = view.getTypeSubstitution().getParentContainerObject()) != null) {
            return (TableViewProxy)this.getStorageDesign().getTableViewProxySet().getProxy(parentView.getObjectID());
        }
        return null;
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }
}

