/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public class Owner
extends StorageObject {
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"ARCHIVE", "BINDADD", "BINDAGENT", "BSDS", "CREATEALIAS", "CREATEDBA", "CREATEDBC", "CREATESG", "CREATEMTAB", "DISPLAY", "MONITOR1", "MONITOR2", "RECOVER", "STOPALL", "STOSPACE", "SYSADMIN", "SYSCTRL", "SYSOPR", "TRACE"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    public static final String NAME_SUBSTITUTION_TYPE = "Owner";
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Owner";

    @Override
    public String getIDPrefix() {
        return "Owner";
    }

    @Override
    public String getObjectTypeName() {
        return "Owner";
    }

    private void addSystemPrivileges(String systemPrivileges) {
        if (!this.getSystemPrivilegesSet().contains(systemPrivileges)) {
            this.getSystemPrivilegesSet().add(systemPrivileges);
        }
    }

    private void recreateSystemPrivilegesSet(String privileges) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (st.hasMoreTokens()) {
            String privilege = st.nextToken().trim();
            if (!this.checkPrivileges(privilege)) continue;
            this.getSystemPrivilegesSet().add(privilege);
        }
    }

    public void setSystemPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else if (this.checkPrivileges(privilege)) {
            this.addSystemPrivileges(privilege);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String value) {
        return PRIVILEGESLIST.contains(value);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(Owner.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        StorageObject owner = null;
        StorageObject stObject = (StorageObject)targetDesign.getUserSchemaSet().getByName(this.getName());
        if (stObject != null && stObject instanceof Owner && this.isRawObject()) {
            owner = (Owner)stObject;
        }
        if (owner != null) {
            owner.setName(this.getName());
            ((Owner)owner).recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            ((Owner)owner).setGrantOption(this.getGrantOption());
            owner.setRawObject(false);
        }
    }

    private List getPermissions() {
        ArrayList list = new ArrayList();
        return list;
    }

    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    private List getDBPrivileges() {
        ArrayList list = new ArrayList();
        return list;
    }

    public List getSortedByID_DBPrivileges() {
        List list = this.getDBPrivileges();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    @Override
    public String getNameSubstitutionType() {
        return "Owner";
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

