/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public abstract class IndexProxySet
extends RelationalObjectProxySet
implements ModelObjectSetListener {
    public IndexProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void setDesign(Design design) {
        if (this.getDesign() != null) {
            this.getPhysicalModelObjectSet().removeSetListener(this);
        }
        super.setDesign(design);
        if (design != null) {
            this.getPhysicalModelObjectSet().addSetListener(this);
            this.add((Index[])this.getPhysicalModelObjectSet().toArray());
        }
    }

    protected ModelObjectSet getPhysicalModelObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getGlobalIndexSet();
    }

    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (ind.isPK() || ind.isUnique()) continue;
            this.add(ind);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        Index ind;
        if (event.isAdded()) {
            Index ind2 = (Index)event.getAffected();
            if (!ind2.isPK() && !ind2.isUnique()) {
                this.add(ind2);
                this.fireUpdate();
            }
        } else if (event.isRemoved() && this.containsId((ind = (Index)event.getAffected()).getObjectID())) {
            this.remove((Index)event.getAffected());
            this.fireUpdate();
        }
    }

    public List getIndexList() {
        return this.getObjectList();
    }

    @Override
    public IndexProxy getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            IndexProxy index = (IndexProxy)it.next();
            if (!name.equals(index.getName())) continue;
            return index;
        }
        return null;
    }

    public IndexProxy getByNameAndTableName(String name, String tableName) {
        try {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                IndexProxy index = (IndexProxy)it.next();
                if (!name.equals(index.getName()) || !tableName.equals(index.getTableName())) continue;
                return index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void unregisterFromDesignObjectSet() {
        this.getPhysicalModelObjectSet().removeSetListener(this);
    }
}

