/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;

public class DTRelation
extends AbstractDTObject {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractDTObject[] DT_OBJECTS = new AbstractDTObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractDTObject source;
    private AbstractDTObject destination;

    public DTRelation(DesignPart designPart) {
        super(designPart);
    }

    public void setDTObject(int endPoint, AbstractDTObject dtObject) {
        if (this.DT_OBJECTS[endPoint] == dtObject) {
            return;
        }
        if (this.DT_OBJECTS[endPoint] != null) {
            if (this.DT_OBJECTS[0] != this.DT_OBJECTS[1]) {
                // empty if block
            }
            this.DT_OBJECTS[endPoint].remove(this.CONNECTIONS[endPoint]);
        }
        if (dtObject != null) {
            dtObject.add(this.CONNECTIONS[endPoint]);
        }
        this.DT_OBJECTS[endPoint] = dtObject;
        if (dtObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractDTObject getDTObject(int endPoint) {
        return this.DT_OBJECTS[endPoint];
    }

    public AbstractDTObject getTargetDTObject() {
        return this.getDTObject(1);
    }

    public void setTargetDTObject(AbstractDTObject dtObject) {
        if (this.getTargetDTObject() != dtObject) {
            AbstractDTObject old = this.getTargetDTObject();
            this.setDTObject(1, dtObject);
            if (old == null || old != dtObject) {
                // empty if block
            }
            this.addToAllDPVs();
        }
    }

    public void addToAllDPVs() {
    }

    public AbstractDTObject getSourceDTObject() {
        return this.getDTObject(0);
    }

    public AbstractDTObject getOtherDTObject(AbstractDTObject dtObject) {
        if (dtObject == this.getSourceDTObject()) {
            return this.getTargetDTObject();
        }
        return this.getSourceDTObject();
    }

    public void setSourceDTObject(AbstractDTObject dtObject) {
        if (this.getSourceDTObject() != dtObject) {
            AbstractDTObject old = this.getSourceDTObject();
            this.setDTObject(0, dtObject);
            if (old == null || old != dtObject) {
                // empty if block
            }
            this.addToAllDPVs();
        }
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    public boolean isValid() {
        return this.getDTObject(0) != null && this.getDTObject(1) != null;
    }

    public Connection getConnection(int endPoint) {
        return this.CONNECTIONS[endPoint];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public AbstractDTObject getSource() {
        return this.source;
    }

    public void setSource(AbstractDTObject source) {
        this.source = source;
    }

    public AbstractDTObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractDTObject destination) {
        this.destination = destination;
    }

    @Override
    public String getObjectTypeName() {
        return "DTRelation";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "DTRelation";
    }

    @Override
    public void remove() {
        super.remove();
        this.setDTObject(1, null);
        this.setDTObject(0, null);
        int a = 0;
        ++a;
    }

    public DesignObject getSourceObject() {
        return this.getSourceDTObject();
    }

    public DesignObject getTargetObject() {
        return this.getTargetDTObject();
    }

    public List getAllViews() {
        ArrayList col = new ArrayList();
        return col;
    }

    public DesignObject getObject() {
        return this;
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public DTRelation getDTRelation() {
            return DTRelation.this;
        }

        public abstract AbstractDTObject getDTObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return DTRelation.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean value) {
            this.optionality = value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean value) {
            this.optionality = value == null ? Boolean.FALSE : value;
        }

        public void setNameOn(String name) {
            this.nameOn = name;
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class DpvInfo {
        DpvInfo() {
        }
    }
}

