/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class DTReferenceSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new DTReference[0];

    public DTReferenceSet(DesignPart designPart) {
        super(designPart);
    }

    public DTReference createReference(String oldID) {
        DTReference reference = new DTReference(this.getDesignPart());
        reference.setObjectID(oldID);
        reference.setDesign(this.getDesign());
        reference.setParent(this);
        this.getDesign().addDesignObject(reference);
        this.add(reference);
        return reference;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "DTReference";
    }

    public Collection getRelationsToSource(StructuredType source) {
        ArrayList<DTReference> col = new ArrayList<DTReference>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTReference reference = (DTReference)it.next();
            if (reference.getSourceDTObject() != source) continue;
            col.add(reference);
        }
        return col;
    }

    public Collection getRelationsToTarget(StructuredType target) {
        ArrayList<DTReference> col = new ArrayList<DTReference>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTReference reference = (DTReference)it.next();
            if (reference.getTargetDTObject() != target) continue;
            col.add(reference);
        }
        return col;
    }

    public Collection getRelationsTo(StructuredType st) {
        ArrayList<DTReference> col = new ArrayList<DTReference>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DTReference reference = (DTReference)it.next();
            if (reference.getSourceDTObject() != st && reference.getTargetDTObject() != st) continue;
            col.add(reference);
        }
        return col;
    }
}

