/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class CheckConstraint
extends AbstractConstraint {
    public Object[] getTypes() {
        return Design.getDefaultRDBMSTypeSet().toArray();
    }

    public void add(Object type, String implementation) {
        ConstraintType rdbmsType = (ConstraintType)this.getTypeFor(type);
        if (rdbmsType != null) {
            this.add(rdbmsType, implementation);
        }
    }

    public Object getTypeFor(Object type) {
        ConstraintType object = null;
        if (type instanceof GenericConstraint) {
            object = (GenericConstraint)type;
        } else if (type instanceof RDBMSType) {
            object = (RDBMSType)type;
        } else if (type instanceof Integer) {
            object = Design.getDefaultRDBMSTypeSet().get((Integer)type);
        }
        return object;
    }

    public void add(ConstraintType type, String implementation) {
        this.setProperty(type.getTypeName(), implementation);
    }

    public String getImplementation(Object type) {
        if (type == null) {
            return Messages.getString("CheckConstraint.NoRDBMSTypeChoosen");
        }
        Object objectType = this.getTypeFor(type);
        String string = this.getProperty(((ConstraintType)objectType).getTypeName());
        if (string == null || "".equals(string)) {
            while (((ConstraintType)objectType).getParentType() != null && ((string = this.getProperty(((ConstraintType)(objectType = ((ConstraintType)objectType).getParentType())).getTypeName())) == null || "".equals(string))) {
            }
            if (string == null || "".equals(string)) {
                string = this.getGenericConstraint();
            }
        }
        string = string == null ? "" : string;
        return string;
    }

    public String getImplementationFor(Object type) {
        if (type == null) {
            return null;
        }
        Object objectType = this.getTypeFor(type);
        return this.getProperty(((ConstraintType)objectType).getTypeName());
    }

    @Override
    public String getTypename() {
        return "Check constraint";
    }

    @Override
    public boolean isType(String typeConstant) {
        return "check constraint".equals(typeConstant);
    }

    @Override
    public String getType() {
        return "check constraint";
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getTypes().length; ++i) {
            if (this.getImplementation(this.getTypes()[i]) == null || "".equalsIgnoreCase(this.getImplementation(this.getTypes()[i]).trim())) continue;
            return false;
        }
        return this.getGenericConstraint() == null;
    }

    public String getConstraintFor(Object type) {
        return this.getProperty(((ConstraintType)type).getTypeName());
    }

    public String getGenericConstraint() {
        return this.getProperty("Generic Constraint");
    }

    public String getValueForKey(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public String getKeysAsString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            sb.append(key).append("\n ");
        }
        return sb.toString().trim();
    }

    public String getValuesAsString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this.getProperty(key);
            if (value == null || "".equals(value.trim())) continue;
            sb.append(value.trim()).append("\n ");
        }
        return sb.toString().trim();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = this.getProperty(key);
            if (value == null || "".equals(value.toString().trim())) continue;
            sb.append(value).append("\n type - ").append(key).append("\n ");
        }
        return sb.toString();
    }
}

