/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ColumnComparatorOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class CSSBAlterColumnOraclev11g
extends CSSBAlterColumnOraclev10g {
    @Override
    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (datatype.equalsIgnoreCase("unknown") && columnProxy.isVirtual()) {
            return;
        }
        super.appendDatatype(buffer, datatype, columnProxy, prettyPrint);
    }

    @Override
    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (columnProxy.isVirtual()) {
            this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
            this.appendInvisible(buffer, columnProxy);
        } else {
            this.appendInvisible(buffer, columnProxy);
            this.appendWithDefaultDefinition(buffer, columnProxy);
        }
        this.appendEncrypt(buffer, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBAlterColumnOraclev11g.appendString(buffer, ' ');
            CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "NULL");
        }
    }

    @Override
    protected void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "AS");
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, '(');
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, columnProxy.getColumnExpression());
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, ')');
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, "VIRTUAL");
        if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Organization INDEX", prettyPrint);
        }
        if (tableProxy.getCluster() != null) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Cluster Tables", prettyPrint);
        }
        if ("YES".equalsIgnoreCase(tableProxy.getTemporary())) {
            this.appendError(buffer, "--  ERROR: Virtual columns not supported for Temporary Tables", prettyPrint);
        }
    }

    private void appendError(StringBuffer buffer, String errorText, boolean prettyPrint) {
        CSSBAlterColumnOraclev11g.appendNewLine(buffer, prettyPrint, 0);
        CSSBAlterColumnOraclev11g.appendStringWithSpace(buffer, errorText);
        CSSBAlterColumnOraclev11g.appendNewLine(buffer, prettyPrint, 5);
        this.getStatus().incrementErrors();
    }

    @Override
    public void processPhysicalproperties(StringBuffer oldbuffer, Object object, TableProxyOraclev10g tp, boolean prettyPrint) {
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        if (sourceObj.isModified()) {
            CompareObjectSelection tableSel = (CompareObjectSelection)((CompareObjectSelection)sourceObj.getParent()).getParent();
            Column table = (Column)sourceObj.getObject();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)((RelationalDesign)table.getDesignPart()).getStorageDesign(site);
            if (this.storageDesign instanceof StorageDesignOraclev12c) {
                ColumnProxyOraclev12c stp = null;
                StoragePropertiesComparator pc = sourceObj.getPropertiesComparator().getPhysicalPropertiesComparator();
                PropertiesComparator ccomp = sourceObj.getPropertiesComparator();
                PropertyHolder ph = (PropertyHolder)pc.getPropertyHolderByName(ColumnComparatorOracle.INVISIBLE);
                ColumnProxyOraclev12c ttp = null;
                if (ccomp instanceof ColumnComparator) {
                    ttp = (ColumnProxyOraclev12c)((ColumnComparator)ccomp).getTargetColumnProxy();
                    stp = (ColumnProxyOraclev12c)((ColumnComparator)ccomp).getSourceColumnProxy();
                }
                if (ph.isSelected() && stp != null && ttp != null) {
                    String vis = "VISIBLE";
                    if ("YES".equalsIgnoreCase(stp.getInvisible())) {
                        vis = "INVISIBLE";
                    }
                    CSSBAlterColumnOraclev11g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev11g.appendStringWithSpace(oldbuffer, "ALTER TABLE " + CSSBAlterColumnOraclev11g.getFormattedTableName(tableSel, stp.getStorageDesign()) + " MODIFY ( ");
                    CSSBAlterColumnOraclev11g.appendStringWithSpace(oldbuffer, CSSBAlterColumnOraclev11g.getFormattedSelectedName(sourceObj, this.storageDesign));
                    CSSBAlterColumnOraclev11g.appendStringWithSpace(oldbuffer, vis + " )");
                    CSSBAlterColumnOraclev11g.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBAlterColumnOraclev11g.appendLineFinisher(oldbuffer, prettyPrint);
                }
            }
        }
    }
}

