/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.Filter;

public class FilteredSelection
extends CompareObjectSelection {
    private Filter filter;
    private List filterChilds = new ArrayList();
    private static Integer NO_FILTER_STATUS = -1;

    public FilteredSelection(ModelIDObject object) {
        super(object);
    }

    public FilteredSelection(String name) {
        super(name);
    }

    public FilteredSelection(String name, Filter filter) {
        super(name);
        this.filter = filter;
    }

    @Override
    public int getNumberOfChildren() {
        if (this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) {
            return this.childs.size();
        }
        return this.filterChilds.size();
    }

    @Override
    public ModelObject getChild(int index) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return (ModelObject)this.childs.get(index);
        }
        if (this.filterChilds.size() > 0) {
            return (ModelObject)this.filterChilds.get(index);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(child);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(child);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() == 0;
    }

    public void setFilter(Filter filter) {
        this.filterChilds = new ArrayList();
        this.filter = filter;
        if (filter != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                ModelIdObjectSelection object = (ModelIdObjectSelection)this.childs.get(i);
                if (object.isFiltered(filter.getFilterList()) || object.hasFilteredChilds(filter.getFilterList())) {
                    this.filterChilds.add(object);
                }
                if (object.getObject() == null || !(object instanceof FilteredSelection)) continue;
                ((FilteredSelection)object).setFilter(filter);
            }
        }
    }

    @Override
    protected void propagateSelection() {
        Iterator it = null;
        if (this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) {
            it = this.childs.iterator();
        } else if (this.filterChilds.size() > 0) {
            it = this.filterChilds.iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                ModelIdObjectSelection selob = (ModelIdObjectSelection)it.next();
                selob.setSelected(this.selected);
            }
        }
    }
}

