/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class DesignObjectSet
extends ModelObject
implements ElementSet {
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    protected Map names = new TreeMap();
    protected int count = 1;
    private boolean createNameVariants = true;
    private String name;
    private DesignPart designPart;
    protected static boolean clearAll = false;
    private DesignObject currentRemoved = null;
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;
    protected boolean requireSort = false;
    private NameSpaceController nameSpaceController;
    public static final DesignObjectSet NULL_SET = new NullSet(null);

    public DesignObjectSet(DesignPart designPart) {
        this.designPart = designPart;
    }

    public boolean add(DesignObject object) {
        if (!this.getDesign().isLoading()) {
            String longName;
            if (this.elements.contains(object)) {
                return false;
            }
            DesignObjectSet previous = object.getDesignObjectSet();
            object.setDesignObjectSet(this);
            String name = object.getName().trim();
            String checkName = longName = object.getLongName().trim();
            if (object instanceof ContainerObject) {
                checkName = name;
            }
            if (this.names.containsKey(checkName.toUpperCase())) {
                if (this.getCreateNameVariants()) {
                    int prefixLength = longName.length() - name.length();
                    String newLongName = this.createNameVariant(checkName);
                    String newName = "";
                    newName = object instanceof ContainerObject ? newLongName : newLongName.substring(prefixLength);
                    object.setName(newName);
                    boolean obAdd = this.doAdd(object);
                    return obAdd;
                }
                object.setDesignObjectSet(previous);
                return false;
            }
        } else {
            object.setDesignObjectSet(this);
        }
        return this.doAdd(object);
    }

    public DesignObject[] getProtoArray() {
        return (DesignObject[])this.getProtoTypeArray();
    }

    public boolean containsId(String id) {
        return null != this.getObjectByID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAdd(DesignObject object) {
        DesignObjectSet designObjectSet = this;
        synchronized (designObjectSet) {
            this.elements.add(object);
        }
        if (!this.getDesign().isLoading() && this.requireSort) {
            this.sort();
        }
        this.addToNameMap(object);
        if (this.getNameSpaceController() != null) {
            this.getNameSpaceController().addObject(object);
        }
        SetEvent event = SetEvent.crateAddEvent();
        event.setAffected(object);
        this.fireChange(event);
        return true;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public boolean justAdd(DesignObject object) {
        if (!this.contains(object)) {
            this.elements.add(object);
            this.addToNameMap(object);
            SetEvent event = SetEvent.crateAddEvent();
            event.setAffected(object);
            this.fireChange(event);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToNameMap(DesignObject object) {
        String objectName = object.getLongName();
        if (object instanceof ContainerObject) {
            objectName = object.getName();
        }
        DesignObjectSet designObjectSet = this;
        synchronized (designObjectSet) {
            this.names.put(objectName.toUpperCase(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromNameMap(DesignObject object) {
        if (!clearAll) {
            Object namesKey;
            if (object instanceof ContainerObject) {
                namesKey = object instanceof Table || object instanceof TableView ? object.getLongName() : object.getName();
            } else {
                String schema;
                ContainerObject container;
                namesKey = object.getLongName();
                if (object instanceof Column && (container = ((Column)object).getContainer()) != null && !"".equals(schema = container.getSchema())) {
                    namesKey = schema + "." + (String)namesKey;
                }
            }
            DesignObjectSet designObjectSet = this;
            synchronized (designObjectSet) {
                this.names.remove(((String)namesKey).toUpperCase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DesignObject object) {
        boolean removed = this.elements.remove(object);
        if (object.getDesign().isCleaning() || object.getDesign().isClosing() || removed) {
            this.getDesign().removeDesignObject(object);
            this.removeFromNameMap(object);
            object.setDesignObjectSet(null);
            this.currentRemoved = object;
            if (this.getNameSpaceController() != null) {
                this.getNameSpaceController().removeObject(object);
            }
            SetEvent event = SetEvent.crateRemoveEvent();
            event.setAffected(object);
            try {
                this.fireChange(event);
            }
            finally {
                this.currentRemoved = null;
            }
        }
    }

    public void removeAll() {
        clearAll = true;
        try {
            DesignObject[] elements = (DesignObject[])this.toArray();
            for (int i = elements.length - 1; i >= 0; --i) {
                this.remove(elements[i]);
            }
            this.names.clear();
            this.resetCounter();
        }
        finally {
            clearAll = false;
        }
    }

    public boolean containsName(String name) {
        return this.names.containsKey(name.toUpperCase());
    }

    @Override
    public boolean contains(ModelObject object) {
        return this.elements.contains(object);
    }

    @Override
    public DesignObject getByName(String name) {
        DesignObject obj2 = (DesignObject)this.names.get(name);
        if (obj2 == null && (obj2 = (DesignObject)this.names.get(name.toUpperCase())) == null && name.indexOf(46) == -1) {
            for (DesignObject obj2 : this.elements) {
                if (!name.equalsIgnoreCase(obj2.getName())) continue;
                return obj2;
            }
            return null;
        }
        return obj2;
    }

    public DesignObject getByName(String name, DesignObject excludedObj) {
        DesignObject obj = (DesignObject)this.names.get(name);
        if (obj == null) {
            obj = (DesignObject)this.names.get(name.toUpperCase());
        }
        return obj;
    }

    public DesignObject getBySchemaAndName(String schemaName, String name) {
        for (DesignObject obj : this.elements) {
            if (!obj.getSchema().equalsIgnoreCase(schemaName) || !obj.getName().equalsIgnoreCase(name)) continue;
            return obj;
        }
        return null;
    }

    public DesignObject getByImportedID(String id) {
        for (DesignObject obj : this.elements) {
            if (obj.getImportedId() == null || !id.equalsIgnoreCase(obj.getImportedId())) continue;
            return obj;
        }
        return null;
    }

    public DesignObject getByVeryLongdName(String veryLongName) {
        for (DesignObject obj : this.elements) {
            if (!obj.getVeryLongName().equalsIgnoreCase(veryLongName)) continue;
            return obj;
        }
        return null;
    }

    public DesignObject getByName(String name, boolean caseSensitive) {
        for (DesignObject obj : this.elements) {
            if (!(caseSensitive ? obj.getName().equals(name) : obj.getName().equalsIgnoreCase(name))) continue;
            return obj;
        }
        return null;
    }

    public DesignObject getByLongName(String name) {
        DesignObject obj2 = (DesignObject)this.names.get(name.toUpperCase());
        if (obj2 != null) {
            return obj2;
        }
        for (DesignObject obj2 : this.elements) {
            if (!obj2.getLongName().equalsIgnoreCase(name)) continue;
            return obj2;
        }
        return null;
    }

    public boolean changeName(String oldName, String newName, DesignObject object) {
        return this.changeName(null, oldName, newName, object);
    }

    public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
        if (oldName != null) {
            Object obj1 = this.names.get(oldName.toUpperCase());
            if (obj1 == null || obj1 != null && obj1 == object) {
                Object obj2 = this.names.get(newName.toUpperCase());
                if (obj2 == null || obj2 != null && obj2 == object) {
                    this.doRenaming(oldName, newName, object);
                    return true;
                }
                int k = 0;
                ++k;
            }
        } else {
            Object obj2 = this.names.get(newName.toUpperCase());
            if (obj2 == null || obj2 != null && obj2 == object) {
                this.doRenaming(oldName, newName, object);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRenaming(String oldName, String newName, DesignObject object) {
        if (object.getDesign().isLoading()) {
            Object oname;
            if (oldName != null) {
                oname = oldName.toUpperCase();
                DesignObject dobj = (DesignObject)this.names.get(oname);
                if (dobj != null && dobj != object) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("DesignObjectSet.TwoObjectsWithSameName"), oldName));
                }
                DesignObjectSet designObjectSet = this;
                synchronized (designObjectSet) {
                    this.names.remove(oname);
                }
            }
            oname = this;
            synchronized (oname) {
                this.names.put(newName.toUpperCase(), object);
            }
            if (!this.getDesign().isLoading()) {
                this.refreshContainedObjectsNames(oldName, newName, object);
                this.sort();
            }
        } else if (this.contains(object)) {
            if (oldName != null) {
                String oname = oldName.toUpperCase();
                DesignObject dobj = (DesignObject)this.names.get(oname);
                if (dobj != null && dobj != object) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("DesignObjectSet.TwoObjectsWithSameName"), oldName));
                }
                DesignObjectSet designObjectSet = this;
                synchronized (designObjectSet) {
                    this.names.remove(oname);
                }
            }
            DesignObjectSet designObjectSet = this;
            synchronized (designObjectSet) {
                this.names.put(newName.toUpperCase(), object);
            }
            if (!this.getDesign().isLoading()) {
                this.refreshContainedObjectsNames(oldName, newName, object);
                if (this.requireSort) {
                    this.sort();
                }
                SetEvent.SORT_COLLECTION.setAffected(object);
                this.fireChange(SetEvent.SORT_COLLECTION);
            }
            SetEvent.NAME_CHANGED.setAffected(object);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        String newLongName;
        String oldLongName = oldSchema != null ? (oldSchema.getName() + "." + oldName).toUpperCase() : oldName.toUpperCase();
        if (oldLongName.equals(newLongName = newSchema != null ? (newSchema.getName() + "." + newName).toUpperCase() : newName.toUpperCase())) {
            return true;
        }
        Object obj1 = this.names.get(oldLongName);
        if (obj1 != null) {
            if (obj1 == object) {
                DesignObjectSet designObjectSet = this;
                synchronized (designObjectSet) {
                    this.names.remove(oldLongName);
                }
                Object obj2 = this.names.get(newLongName);
                if (obj2 != null && obj2 != object) {
                    return false;
                }
                DesignObjectSet designObjectSet2 = this;
                synchronized (designObjectSet2) {
                    this.names.put(newLongName.toUpperCase(), object);
                }
            }
            return false;
        }
        Object obj2 = this.names.get(newLongName);
        if (obj2 != null && obj2 != object) {
            return false;
        }
        DesignObjectSet designObjectSet = this;
        synchronized (designObjectSet) {
            this.names.put(newLongName.toUpperCase(), object);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNamesMapStr(String oldSchema, String oldName, String newSchema, String newName, DesignObject object) {
        String newLongName;
        String oldLongName = oldSchema != null && !"".equals(oldSchema) ? (oldSchema + "." + oldName).toUpperCase() : oldName.toUpperCase();
        if (oldLongName.equals(newLongName = newSchema != null && !"".equals(newSchema) ? (newSchema + "." + newName).toUpperCase() : newName.toUpperCase())) {
            return true;
        }
        Object obj1 = this.names.get(oldLongName);
        if (obj1 != null) {
            if (obj1 == object) {
                DesignObjectSet designObjectSet = this;
                synchronized (designObjectSet) {
                    this.names.remove(oldLongName);
                }
                Object obj2 = this.names.get(newLongName);
                if (obj2 != null && obj2 != object) {
                    return false;
                }
                DesignObjectSet designObjectSet2 = this;
                synchronized (designObjectSet2) {
                    this.names.put(newLongName.toUpperCase(), object);
                }
            }
            return false;
        }
        Object obj2 = this.names.get(newLongName);
        if (obj2 != null && obj2 != object) {
            return false;
        }
        DesignObjectSet designObjectSet = this;
        synchronized (designObjectSet) {
            this.names.put(newLongName.toUpperCase(), object);
        }
        return true;
    }

    private void refreshContainedObjectsNames(String oldName, String newName, DesignObject object) {
        boolean notloading;
        boolean bl = notloading = !this.getDesign().isLoading();
        if (object instanceof ContainerWithKeyObject) {
            ContainerWithKeyObject container = (ContainerWithKeyObject)object;
            container.getContainedSet().refreshNames(oldName, newName);
            if (notloading) {
                container.getContainedSet().sort();
            }
            container.getKeySet().refreshNames(oldName, newName);
            if (object instanceof Table && notloading) {
                ((RelationalDesign)object.getDesignPart()).getFKIndexAssociationSet().sort();
            }
        } else if (object instanceof ContainerObject && !(object instanceof KeyObject) && !(object instanceof FKArc)) {
            ContainerObject container = (ContainerObject)object;
            container.getContainedSet().refreshNames(oldName, newName);
        }
        if (object instanceof Index && notloading || !(object instanceof Column) || notloading) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNames(String oldName, String newName) {
        String upperOld = oldName.toUpperCase() + ".";
        int oldLength = upperOld.length() - 1;
        String upperNew = newName.toUpperCase();
        Object[] keys = this.names.keySet().toArray();
        for (int i = keys.length - 1; i >= 0; --i) {
            String key = (String)keys[i];
            if (!key.startsWith(upperOld)) continue;
            Object obj = this.names.get(key);
            String name = key.substring(oldLength);
            DesignObjectSet designObjectSet = this;
            synchronized (designObjectSet) {
                this.names.remove(key);
                this.names.put(upperNew + name, obj);
                continue;
            }
        }
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray(this.getProtoTypeArray());
    }

    protected abstract Object[] getProtoTypeArray();

    protected abstract String getDefaultNamePrefix();

    protected String getSeparator() {
        return "_";
    }

    protected String getVariantSeparator() {
        return "v";
    }

    public Class getElementClass() {
        return this.getProtoTypeArray().getClass().getComponentType();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDefaultNamePrefix();
    }

    @Override
    public boolean setName(String name) {
        boolean result = super.setName(name);
        if (result) {
            this.name = name;
        }
        return result;
    }

    public String createName(DesignObject object) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        while (this.getByName(buffer.toString() + String.valueOf(this.count), object) != null) {
            ++this.count;
        }
        buffer.append(this.count++);
        return buffer.toString();
    }

    public String createName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        while (this.getByName(buffer.toString() + String.valueOf(this.count)) != null) {
            ++this.count;
        }
        buffer.append(this.count++);
        return buffer.toString();
    }

    public String createNameVariant(String name) {
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append(this.getVariantSeparator());
        int length = buffer.length();
        for (int i = 1; i <= this.names.size(); ++i) {
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            if (this.names.containsKey(newName.toUpperCase())) continue;
            return newName;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    public String createNameVariant(String schema, String name) {
        if (schema == null || "".equals(schema)) {
            return this.createNameVariant(name);
        }
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append(this.getVariantSeparator());
        int length = buffer.length();
        for (int i = 1; i <= this.names.size(); ++i) {
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            if (this.names.containsKey((schema + "." + newName).toUpperCase())) continue;
            return newName;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    public void setCreateNameVariants(boolean value) {
        this.createNameVariants = value;
    }

    public boolean getCreateNameVariants() {
        return this.createNameVariants;
    }

    public void addSetListener(SetListener listener) {
        this.listeners.add(listener);
    }

    public void removeSetListener(SetListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChange(SetEvent event) {
        SetListener[] array = this.listeners.toArray(new SetListener[0]);
        for (int i = 0; i < array.length; ++i) {
            if (this.currentRemoved != null) {
                event.setAffected(this.currentRemoved);
            }
            array[i].changed(this, event);
        }
    }

    public boolean isNullSet() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject object) {
        return this.getObjectGeneratedBy(object.getObjectID());
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String generatorID) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ModelIDObject object = (ModelIDObject)it.next();
            if (!generatorID.equals(object.getGeneratorID())) continue;
            it = null;
            return object;
        }
        it = null;
        return null;
    }

    public ModelIDObject getObjectByImportedID(String id) {
        if (id != null) {
            for (DesignObject object : this.elements) {
                if (!id.equals(object.getImportedId())) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public Collection getObjectsGeneratedBy(String generatorId, Collection collection) {
        for (DesignObject object : this.elements) {
            if (!generatorId.equals(object.getGeneratorID())) continue;
            collection.add(object);
        }
        return collection;
    }

    @Override
    public DesignObject getObjectByID(String objectID) {
        if (objectID != null) {
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                DesignObject object = (DesignObject)it.next();
                if (!objectID.equals(object.getObjectID())) continue;
                it = null;
                return object;
            }
            Object var2_2 = null;
        }
        return null;
    }

    public DesignObject getObjectByRemoteObjectID(String remoteID) {
        if (remoteID != null) {
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                DesignObject object = (DesignObject)it.next();
                if (!remoteID.equals(object.getRemoteObjectID())) continue;
                it = null;
                return object;
            }
            Object var2_2 = null;
        }
        return null;
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    public ModelObject getElement(int index) {
        return index < this.elements.size() ? (ModelObject)this.elements.get(index) : null;
    }

    public int getIndexOf(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public int getNumberOfChildren() {
        return this.size();
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.getIndexOf(child);
    }

    @Override
    public ModelObject getChild(int index) {
        return this.getElement(index);
    }

    @Override
    public boolean isLeaf() {
        return this.size() <= 0;
    }

    @Override
    public boolean isObjectCollection() {
        return true;
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void resetCounter() {
        this.count = 1;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }

    public String getSegmentName(DesignObject object) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(object);
        }
        return "";
    }

    public String getSegmentName(String id) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(id);
        }
        return "";
    }

    public void addSegmentEntry(String segment, String id) {
        this.addSegmentEntry(segment, id, false);
    }

    public void addSegmentEntry(String segment, String id, boolean clear) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (clear) {
                this.segManager.removeID(id);
            }
            this.segManager.add(segment, id);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this instanceof NullSet ? Boolean.valueOf(true) : (this.getDesignPart().getStorableSets().contains(this) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return this.containsTopLevelStorableObjects;
    }

    @Override
    public boolean canSort() {
        return !this.getDesign().isLoading();
    }

    public ModelIDObject getByRemoteObjectId(String remoteID) {
        if (remoteID != null && !"".equals(remoteID)) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ModelIDObject object = (ModelIDObject)it.next();
                if (!remoteID.equals(object.getRemoteObjectID())) continue;
                return object;
            }
        }
        return null;
    }

    public NameSpaceController getNameSpaceController() {
        return this.nameSpaceController;
    }

    public void setNameSpaceController(NameSpaceController nameSpaceController) {
        this.nameSpaceController = nameSpaceController;
    }

    public void moveElementTo(DesignObject obj, int position) {
        if (this.elements.size() > position) {
            this.elements.remove(obj);
            try {
                this.elements.add(position, obj);
            }
            catch (Exception e) {
                Logger.error(e);
            }
        } else {
            this.elements.remove(obj);
            this.elements.add(obj);
        }
    }

    private static class NullSet
    extends DesignObjectSet {
        private static final Object[] EMPTY = new Object[0];

        public NullSet(DesignPart designPart) {
            super(designPart);
        }

        @Override
        public boolean add(DesignObject object) {
            return false;
        }

        @Override
        public void remove(DesignObject object) {
        }

        @Override
        protected String getDefaultNamePrefix() {
            return "NULL SET GENERATED";
        }

        @Override
        protected Object[] getProtoTypeArray() {
            return EMPTY;
        }

        @Override
        public void addSetListener(SetListener listener) {
        }

        @Override
        public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
            return true;
        }

        @Override
        public boolean isNullSet() {
            return true;
        }
    }
}

