/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class DesignObject
extends ModelIDObject {
    public static final DesignObject[] PROTOTYPE = new DesignObject[0];
    private DesignPart designPart;
    private String importedID;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    protected boolean noBackgroundColor = false;
    protected boolean noForegroundColor = false;
    private boolean useDefaultColor = true;
    private int lineWidth = 1;
    protected boolean isBeingRemoved;
    protected boolean deprecated;
    protected boolean removed;
    protected boolean backup = false;
    private boolean selected;
    private boolean ordsDropSchema = false;
    private boolean ordsEnable = false;
    private boolean ordsAuth = false;
    private String ordsAlias;
    private boolean useDDLTransformationScript = false;
    private boolean visible = true;
    private List measurements;
    private List documents;
    private List changeRequests;
    private List responsibleParties;
    private boolean copyForIncrementalDDL;
    protected StorageObject physicalProperties;
    private static final Logger LOGGER = new Logger(DesignObject.class);
    protected DesignObjectSet containerSet = DesignObjectSet.NULL_SET;

    public DesignObject(DesignPart designPart) {
        this.designPart = designPart;
        if (designPart != null) {
            this.name = null;
            this.setDesign(designPart.getDesign());
            if (designPart.isLoaded()) {
                this.setDirty(true);
            }
        }
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public String getDesignPartId() {
        return this.getDesignPart().getObjectID();
    }

    public String getImportedId() {
        return this.importedID;
    }

    public void setImportedId(String importedID) {
        this.importedID = importedID;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isORDSDropSchema() {
        return this.ordsDropSchema;
    }

    public void setORDSDropSchema(boolean ordsDropSchema) {
        this.ordsDropSchema = ordsDropSchema;
    }

    public boolean isORDSEnable() {
        return this.ordsEnable;
    }

    public void setORDSEnable(boolean ordsEnable) {
        this.ordsEnable = ordsEnable;
    }

    public boolean isORDSAuth() {
        return this.ordsAuth;
    }

    public void setORDSAuth(boolean ordsAuth) {
        this.ordsAuth = ordsAuth;
    }

    public String getORDSAlias() {
        return this.ordsAlias;
    }

    public String getORDSAliasNotEmpty() {
        if (StringUtilities.isEmpty(this.ordsAlias)) {
            return this.getName().toLowerCase();
        }
        return this.ordsAlias;
    }

    public void setORDSAlias(String ordsAlias) {
        this.ordsAlias = ordsAlias;
    }

    public boolean isUseDDLTransformationScript() {
        return this.useDDLTransformationScript;
    }

    public void setUseDDLTransformationScript(boolean useDDLTransformationScript) {
        this.useDDLTransformationScript = useDDLTransformationScript;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public FontObjectWr createFontObjectWr() {
        return new FontObjectWr();
    }

    public void addFontObjectWrapper(FontObjectWr foWr) {
    }

    public boolean hasProxyToDelete() {
        return false;
    }

    public Measurement createMeasurement() {
        Measurement measurement = new Measurement(this.getDesignPart());
        measurement.setDesign(this.getDesign());
        measurement.setObject(this);
        return measurement;
    }

    public List getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ArrayList();
        }
        return this.measurements;
    }

    public List getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        return this.documents;
    }

    public List getRequests() {
        if (this.changeRequests == null) {
            this.changeRequests = new ArrayList();
        }
        return this.changeRequests;
    }

    public List getResponsibleParties() {
        if (this.responsibleParties == null) {
            this.responsibleParties = new ArrayList();
        }
        return this.responsibleParties;
    }

    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void addObjectListener(ObjectListener listener) {
        if (!this.getListeners().contains(listener)) {
            this.getListeners().add(listener);
        }
    }

    public void removeObjectListener(ObjectListener listener) {
        this.getListeners().remove(listener);
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        Object saveAffected;
        if (this.getDesignPart() != null && this.getDesignPart().isLoaded() && !this.getDesign().isLoading()) {
            this.setDirty(true);
            this.getDesignPart().setObjectListChanged(true);
            this.getChange().setTimeNow();
        }
        if ((saveAffected = event.getAffected()) == null) {
            event.setAffected(this);
        }
        ObjectListener[] listeners = this.getListeners().toArray(new ObjectListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                if (listeners[i] == null) continue;
                listeners[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
        event.setAffected(saveAffected);
    }

    protected void fireChangeNoDirty(ObjectChangeEvent event) {
        Object saveAffected = event.getAffected();
        event.setAffected(this);
        Object[] array = this.getListeners().toArray();
        for (int i = 0; i < array.length; ++i) {
            ObjectListener listener = (ObjectListener)array[i];
            listener.changed(this, event);
        }
        event.setAffected(saveAffected);
    }

    public void fireNameChangedNoDirty() {
        this.fireChangeNoDirty(ObjectChangeEvent.NAME_CHANGED);
    }

    public boolean isContainedObject() {
        return false;
    }

    public Collection getAffectedDPVs() {
        return Collections.EMPTY_SET;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void setDesignObjectSet(DesignObjectSet set) {
        this.containerSet = set;
        if (set == null) {
            this.containerSet = DesignObjectSet.NULL_SET;
        }
    }

    public DesignObjectSet getDesignObjectSet() {
        return this.containerSet;
    }

    public String getSchema() {
        return "";
    }

    public String getVeryLongName() {
        return this.getLongName();
    }

    protected void setIsBeingRemoved(boolean value) {
        this.isBeingRemoved = value;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setShouldEngineer(boolean value) {
        super.setShouldEngineer(value);
    }

    @Override
    public boolean getShouldEngineer() {
        return super.getShouldEngineer();
    }

    public boolean shouldBeEngineered() {
        if (this.getShouldEngineer()) {
            if (this.getDesign().isEngineerGenerated()) {
                return true;
            }
            if ("User generated".equalsIgnoreCase(this.getGeneratorID())) {
                return true;
            }
        }
        return false;
    }

    private static void copySourceStamp(ModelObject source, ModelObject target) {
        if (source != null && target != null) {
            if (!"".equals(source.getSourceConnName()) && "".equals(target.getSourceConnName())) {
                if (target instanceof DesignObject && ((DesignObject)target).isBackup()) {
                    target.setSourceConnName(source.getSourceConnName());
                    target.setSourceObjName(source.getSourceObjName());
                    target.setSourceObjSchema(source.getSourceObjSchema());
                } else if (DesignObject.validTargetStamp(source, target)) {
                    DesignObject.setTargetDesignStamp(source, target);
                    target.setSourceConnName(source.getSourceConnName());
                    target.setSourceObjName(source.getSourceObjName());
                    target.setSourceObjSchema(source.getSourceObjSchema());
                }
            }
            if (!"".equals(source.getSourceDDLFile()) && "".equals(target.getSourceDDLFile())) {
                target.setSourceDDLFile(source.getSourceDDLFile());
            }
        }
    }

    private static boolean validTargetStamp(ModelObject source, ModelObject target) {
        if (source instanceof DesignObject && target instanceof DesignObject ? ((DesignObject)source).getDesignPart().equals(((DesignObject)target).getDesignPart()) : source instanceof StorageObject && target instanceof StorageObject && ((StorageObject)source).getStorageDesign().getPhysicalDesign().equals(((StorageObject)target).getStorageDesign().getPhysicalDesign())) {
            return false;
        }
        Class<?> srcClass = source.getClass();
        String srcIndexState = "";
        if (source instanceof Index) {
            srcIndexState = ((Index)source).getIndexState();
        }
        String srcConnName = source.getSourceConnName();
        String srcObjName = source.getSourceObjName();
        String srcObjSchema = source.getSourceObjSchema();
        RelationalDesign tgtDes = null;
        if (target instanceof DesignObject) {
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (target instanceof StorageObject) {
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        List tgtObjs = tgtDes.getAllImportedObjects();
        for (int i = 0; i < tgtObjs.size(); ++i) {
            ModelObject tgtObj = (ModelObject)tgtObjs.get(i);
            if (!(source instanceof Index && tgtObj instanceof Index ? ((Index)tgtObj).getIndexState().equalsIgnoreCase(srcIndexState) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema) : tgtObj.getClass().equals(srcClass) && tgtObj.getSourceConnName().equalsIgnoreCase(srcConnName) && tgtObj.getSourceObjName().equalsIgnoreCase(srcObjName) && tgtObj.getSourceObjSchema().equalsIgnoreCase(srcObjSchema))) continue;
            return false;
        }
        return true;
    }

    private static void setTargetDesignStamp(ModelObject source, ModelObject target) {
        String srcConnName = source.getSourceConnName();
        RelationalDesign srcDes = null;
        RelationalDesign tgtDes = null;
        if (source instanceof DesignObject && target instanceof DesignObject) {
            srcDes = (RelationalDesign)((DesignObject)source).getDesignPart();
            tgtDes = (RelationalDesign)((DesignObject)target).getDesignPart();
        } else if (source instanceof StorageObject && target instanceof StorageObject) {
            srcDes = ((StorageObject)source).getStorageDesign().getPhysicalDesign();
            tgtDes = ((StorageObject)target).getStorageDesign().getPhysicalDesign();
        }
        DBConnectionStamp stamp = srcDes.getImportConnectionStamp(srcDes.findImportConnectionStamp(srcConnName));
        if (stamp != null) {
            tgtDes.addImportConnectionStamp(stamp);
        }
    }

    public void copy(DesignObject desObject) {
        this.copyDefaults(desObject);
        DesignObject.copySourceStamp(this, desObject);
        desObject.setGeneratorID(this.getGeneratorID());
    }

    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        this.copy(desObject);
    }

    protected void copyFormatOptions(DesignObject desObject) {
    }

    public void copyDefaults(DesignObject desObject) {
        int i;
        desObject.setName(this.getName());
        desObject.setNameHasQuotes(this.getNameHasQuotes());
        desObject.setMarkedGenerate(this.isMarkedGenerate());
        desObject.setComment(this.getComment());
        desObject.setCommentInRDBMS(this.getCommentInRDBMS());
        desObject.setNotes(this.getNotes());
        desObject.setShouldEngineer(this.getShouldEngineer());
        desObject.setDeprecated(this.isDeprecated());
        desObject.setUseDDLTransformationScript(this.isUseDDLTransformationScript());
        desObject.getMeasurements().clear();
        desObject.getRequests().clear();
        desObject.getResponsibleParties().clear();
        desObject.getDocuments().clear();
        for (i = 0; i < this.getMeasurements().size(); ++i) {
        }
        for (i = 0; i < this.getRequests().size(); ++i) {
        }
        for (i = 0; i < this.getResponsibleParties().size(); ++i) {
        }
        for (i = 0; i < this.getDocuments().size(); ++i) {
        }
        this.copyDynamicProperties(desObject);
        this.copyFormatOptions(desObject);
    }

    public boolean isCopyForIncrementalDDL() {
        return this.copyForIncrementalDDL;
    }

    public void setCopyForIncrementalDDL(boolean copyForIncrementalDDL) {
        this.copyForIncrementalDDL = copyForIncrementalDDL;
    }

    @Override
    public String getName() {
        if ((this.name == null || "".equals(this.name)) && this.containerSet != null) {
            this.name = this.containerSet.createName(this);
        }
        return this.name;
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            if (this.getDesignObjectSet() != null) {
                this.getDesignObjectSet().remove(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
            event.setAffected(this);
            this.fireChange(event);
            event.setAffected(null);
            this.setIsBeingRemoved(false);
            this.removed = true;
            RepositoryObject pac = this.getPAC_Element();
            if (pac != null) {
                pac.setDirty(true);
            }
        }
    }

    @Override
    public String getDirectorySegmentName() {
        if ("".equals(this.directorySegmentName)) {
            this.directorySegmentName = this.getDesignObjectSet().getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    @Override
    public String getSegmentedStorageName() {
        if (this.segmentedStorageName == null) {
            String sname = this.getDesignObjectSet().getSegmentName(this);
            if (!"".equals(sname)) {
                String sn = this.getStorageName();
                if (sn != null && !"".equals(sn)) {
                    File file = new File(sn);
                    String fname = file.getName();
                    this.segmentedStorageName = file.getParent() + "/" + sname + "/" + fname;
                }
            } else {
                return super.getSegmentedStorageName();
            }
        }
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName, boolean clear) {
        if (directorySegmentName != null && !"".equals(directorySegmentName)) {
            this.getDesignObjectSet().addSegmentEntry(directorySegmentName, this.getObjectID(), clear);
        }
        this.directorySegmentName = directorySegmentName;
    }

    @Override
    public void setDirectorySegmentName(String directorySegmentName) {
        this.setDirectorySegmentName(directorySegmentName, true);
    }

    public StorageObject getProxyObject() {
        if (this.physicalProperties != null) {
            return this.physicalProperties;
        }
        DesignPart dp = this.getDesignPart();
        if (dp instanceof RelationalDesign) {
            this.physicalProperties = ((RelationalDesign)dp).getStorageDesign().getStorageObject(this.getObjectID());
        } else if (dp instanceof DataTypesDesign) {
            this.physicalProperties = this.getDesign().getRelationalDesign().getStorageDesign().getStorageObject(this.getObjectID());
        }
        return this.physicalProperties;
    }

    public StorageObject getPhysicalProperties() {
        if (this.exposePhysicalProperties()) {
            if (this.physicalProperties != null) {
                return this.physicalProperties;
            }
            DesignPart dp = this.getDesignPart();
            if (dp instanceof RelationalDesign) {
                this.physicalProperties = ((RelationalDesign)dp).getStorageDesign().getStorageObject(this.getObjectID());
            } else if (dp instanceof DataTypesDesign) {
                this.physicalProperties = this.getDesign().getRelationalDesign().getStorageDesign().getStorageObject(this.getObjectID());
            }
            return this.physicalProperties;
        }
        return null;
    }

    public void setPhysicalProperties(StorageObject physicalProperties) {
        this.physicalProperties = physicalProperties;
    }

    protected boolean exposePhysicalProperties() {
        return false;
    }

    public StorageObject getPhysicalPropertiesObject() {
        return this.physicalProperties;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    public void setUseDefaultColor(boolean useDefaultColor) {
        this.useDefaultColor = useDefaultColor;
    }

    public TopView getTopView() {
        return null;
    }

    public TopView getFirstViewForDPV(DesignPartView dpv) {
        return dpv.getFirstViewFor(this);
    }

    public void setTopView(TopView view) {
    }

    public int getViewNumber(TopView tv) {
        return 0;
    }

    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return false;
    }

    @Override
    public void setObjectID(String id) {
        if (id != null && !id.isEmpty()) {
            super.setObjectID(id);
            StorageObject sto = this.getProxyObject();
            if (sto != null) {
                sto.setObjectID(id);
            }
        }
    }

    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc = new TopViewCollection();
        tvc.setDPV(dpv);
        return tvc;
    }

    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        TopViewCollection tvc = this.getViewsForDPV(dpv);
        for (TopView tv : tvc) {
            if (!tv.getViewID().equals(id)) continue;
            return tv;
        }
        int i = 0;
        for (TopView tv : tvc) {
            if (viewnumber == i) {
                tv.setViewNumber(viewnumber);
                return tv;
            }
            ++i;
        }
        return null;
    }

    public boolean getNoBackgroundColor() {
        return this.noBackgroundColor;
    }

    public void setNoBackgroundColor(boolean noBackgroundColor) {
        this.noBackgroundColor = noBackgroundColor;
    }

    public boolean getNoForegroundColor() {
        return this.noForegroundColor;
    }

    public void setNoForegroundColor(boolean noForegroundColor) {
        this.noForegroundColor = noForegroundColor;
    }
}

