/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class ContainerObject
extends MultiShapedDesignObject
implements ObjectListener,
SetListener {
    private String afterAlter;
    private String afterCreate;
    private boolean allowTypeSubstitution = true;
    private StructuredType basedOnStructuredType;
    private String basedOnStructuredTypeLongName;
    private String beforeAlter;
    private String beforeCreate;
    private String schema;
    private String beforeDrop;
    private String endOfScript;
    private SchemaObject schemaObject;
    private boolean shouldGeneratescript = false;
    private TypeSubstitution typeSubstitution;
    private String typeSubstitutionParentID;
    private String typeSubstitutionID;
    private Map localIDs = new TreeMap();
    private List elements = new ArrayList();
    protected List nestedElements = new ArrayList();
    private IDGenerator localIDGenerator;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private Set containerListeners = new HashSet();
    protected List typeSubstitutions = new ArrayList();
    public static final String TYPE_FACT = "Fact";
    public static final String TYPE_DIMENSION = "Dimension";
    public static final String TYPE_CONSOLIDATED = "Consolidated";
    public static final String TYPE_SUMMARY = "Summary";
    public static final String TYPE_TEMPORARY = "Temporary";
    public static final String TYPE_LOGGING = "Logging";
    public static final String TYPE_EXTERNAL = "External";
    private transient List<String> existingTablespaces = null;
    public static Map<String, String> DWH_TO_CLASSIFICATION_TYPES = new HashMap<String, String>();
    public static Map<String, String> CLASSIFICATION_TO_DWH_TYPES;
    private static final Logger LOGGER;

    public ContainerObject(DesignPart designPart) {
        super(designPart);
    }

    public String getAfterAlter() {
        return this.afterAlter;
    }

    public void setAfterAlter(String afterAlter) {
        this.afterAlter = afterAlter;
    }

    public String getAfterCreate() {
        return this.afterCreate;
    }

    public void setAfterCreate(String afterCreate) {
        this.afterCreate = afterCreate;
    }

    public boolean isAllowTypeSubstitution() {
        return this.allowTypeSubstitution;
    }

    public void setAllowTypeSubstitution(boolean allowTypeSubstitution) {
        this.allowTypeSubstitution = allowTypeSubstitution;
    }

    public StructuredType getBasedOnStructuredType() {
        return this.basedOnStructuredType;
    }

    public String getBeforeAlter() {
        return this.beforeAlter;
    }

    public void setBeforeAlter(String beforeAlter) {
        this.beforeAlter = beforeAlter;
    }

    public String getBeforeCreate() {
        return this.beforeCreate;
    }

    public void setBeforeCreate(String beforeCreate) {
        this.beforeCreate = beforeCreate;
    }

    public String getBeforeDrop() {
        return this.beforeDrop;
    }

    public void setBeforeDrop(String beforeDrop) {
        this.beforeDrop = beforeDrop;
    }

    public String getEndOfScript() {
        return this.endOfScript;
    }

    public void setEndOfScript(String endOfScript) {
        this.endOfScript = endOfScript;
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    public boolean getShouldGenerateScript() {
        return this.shouldGeneratescript;
    }

    public void setShouldGenerateScript(boolean shouldGeneratescript) {
        this.shouldGeneratescript = shouldGeneratescript;
    }

    public TypeSubstitution getTypeSubstitution() {
        return this.typeSubstitution;
    }

    public void setTypeSubstitution(TypeSubstitution typeSubstitution) {
        this.typeSubstitution = typeSubstitution;
    }

    public String getTypeSubstitutionParentID() {
        return this.typeSubstitutionParentID;
    }

    public void setTypeSubstitutionParentID(String typeSubstitutionParentID) {
        this.typeSubstitutionParentID = typeSubstitutionParentID;
    }

    public String getTypeSubstitutionID() {
        return this.typeSubstitutionID;
    }

    public void setTypeSubstitutionID(String typeSubstitutionID) {
        this.typeSubstitutionID = typeSubstitutionID;
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else if (this.localIDs.containsKey(id)) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
        }
    }

    public ModelIDObject getLocalObject(String localId) {
        ModelIDObject object = (ModelIDObject)this.localIDs.get(localId);
        if (object == null) {
            object = this.getElementByID(localId);
        }
        return object;
    }

    public void updateLocalObjectId(String oldId, String newId) {
        Object object = this.localIDs.get(oldId);
        if (object != null) {
            this.localIDs.remove(oldId);
            this.localIDs.put(newId, object);
        }
    }

    public void putInLocalIDMap(String id, ModelIDObject co) {
        this.localIDs.put(id, co);
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public ContainedObject[] getElements() {
        return this.toContainedObjectArray(this.elements);
    }

    public ContainedObject getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        for (ContainedObject co : this.nestedElements) {
            if (!localID.equals(co.getObjectID())) continue;
            return co;
        }
        return null;
    }

    public ContainedObject getElementByRemoteObjectID(String remoteID) {
        if (remoteID != null) {
            for (ContainedObject co : this.elements) {
                if (!remoteID.equalsIgnoreCase(co.getRemoteObjectID())) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject[] toContainedObjectArray(Collection collection) {
        return (ContainedObject[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Class getContainedClass() {
        return ContainedObject.class;
    }

    public ContainedObject getElementByName(String name) {
        if (name != null) {
            for (ContainedObject co : this.elements) {
                if (!name.equalsIgnoreCase(co.getName())) continue;
                return co;
            }
            if (name.indexOf(46) > -1) {
                name = name.replaceAll("\"", "");
                for (ContainedObject co : this.nestedElements) {
                    if (!name.equalsIgnoreCase(co.getName())) continue;
                    return co;
                }
            }
        }
        return null;
    }

    public boolean acceptDoubles() {
        return false;
    }

    public boolean contains(ContainedObject element) {
        return this.elements.contains(element);
    }

    @Override
    public String getSchema() {
        if (this.getSchemaObject() != null) {
            return this.getSchemaObject().getName();
        }
        if (this.schema == null) {
            return "";
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() == null && schema != null && !"".equals(schema)) {
            RelationalDesign rd = (RelationalDesign)this.getDesignPart();
            SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(schema);
            if (so == null) {
                so = rd.getSchemaObjectSet().createSchemaObject(null);
                so.setName(schema);
            }
            this.setSchemaObject(so);
        }
    }

    public void add(ContainedObject object) {
        if (object == null || this.isReadOnly()) {
            return;
        }
        if (!this.acceptDoubles() && this.contains(object)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(object.getClass())) {
            Datatype datatype;
            this.assignLocalID(object);
            if (!object.isNested() || this instanceof KeyObject) {
                this.elements.add(object);
            } else {
                this.nestedElements.add(object);
            }
            if (!(this instanceof SubsetCO)) {
                object.setContainer(this);
            }
            object.addObjectListener(this);
            if (!this.isBackup()) {
                this.getDesign().addDesignObject(object);
            }
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(0);
            this.fireChange(this.sharedEvent);
            if (!(this instanceof KeyObject) && object instanceof ContainedObjectWithDomain && (datatype = ((ContainedObjectWithDomain)object).getDataType()) instanceof StructuredType) {
                ((StructuredType)datatype).addObjectListener(this);
                if (!((ContainedObjectWithDomain)object).isReference()) {
                    this.updateStructure();
                }
            }
        } else {
            LOGGER.error("Class: " + String.valueOf(object.getClass()));
            LOGGER.error("Expected: " + String.valueOf(this.getContainedClass()));
            throw new RuntimeException("Wrong class added to container.");
        }
    }

    protected void fireChange(ContainerObjectEvent event) {
        Object[] array = this.containerListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                ((ContainerObjectListener)array[i]).changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("ContainerListener caused exception", e);
            }
        }
    }

    public void addContainerListener(ContainerObjectListener listener) {
        this.containerListeners.add(listener);
    }

    public void removeContainerListener(ContainerObjectListener listener) {
        this.containerListeners.remove(listener);
    }

    public Collection getContainerListeners() {
        return this.containerListeners;
    }

    protected abstract void updateStructure();

    public abstract DesignObjectSet getContainedSet();

    protected abstract void clearStructure();

    public List getAllElementsListGeneratedBy(ModelIDObject object) {
        return this.getAllElementsListGeneratedBy(object.getObjectID());
    }

    public List getAllElementsListGeneratedBy(String generatorID) {
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        for (ContainedObject co : this.getElementsAndNestedElementsCollection()) {
            if (!generatorID.equals(co.getGeneratorID())) continue;
            list.add(co);
        }
        return list;
    }

    public void setBasedOnStructuredType(StructuredType basedOnStructuredType) {
        if (this.basedOnStructuredType != basedOnStructuredType) {
            if (this.basedOnStructuredType != null) {
                this.basedOnStructuredType.removeObjectListener(this);
                this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            }
            if (!this.getDesign().isLoading()) {
                this.clearTypeSubstitutions();
                this.clearStructure();
                this.basedOnStructuredType = basedOnStructuredType;
                if (this.basedOnStructuredType != null) {
                    if (!this.isBackup()) {
                        this.basedOnStructuredType.addObjectListener(this);
                        this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
                    }
                    this.updateStructure();
                }
            } else {
                this.basedOnStructuredType = basedOnStructuredType;
                if (this.basedOnStructuredType != null) {
                    this.basedOnStructuredType.addObjectListener(this);
                    this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
                }
            }
        }
    }

    public String getBasedOnStructuredTypeLongName() {
        StructuredType structuredType = this.getBasedOnStructuredType();
        if (structuredType != null) {
            StructuredTypeProxy stp;
            StructuredTypeProxySet stpSet;
            StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
            if (sd != null && (stpSet = sd.getStructuredTypeProxySet()) != null && (stp = (StructuredTypeProxy)stpSet.getProxy(structuredType.getObjectID())) != null) {
                return stp.getLongName();
            }
            return structuredType.getName();
        }
        return this.basedOnStructuredTypeLongName;
    }

    public String getBasedOnStructuredTypeName() {
        int ind;
        StructuredType structuredType = this.getBasedOnStructuredType();
        if (structuredType != null) {
            return structuredType.getName();
        }
        if (this.basedOnStructuredTypeLongName != null && !this.basedOnStructuredTypeLongName.isEmpty() && (ind = this.basedOnStructuredTypeLongName.indexOf(46)) > -1) {
            String name = this.basedOnStructuredTypeLongName.substring(ind + 1);
            return name;
        }
        return "";
    }

    public void setBasedOnStructuredTypeLongName(String longName) {
        StructuredType structuredType = null;
        if (longName == null || longName.isEmpty()) {
            this.basedOnStructuredTypeLongName = null;
        } else {
            this.basedOnStructuredTypeLongName = longName;
            int ind = longName.indexOf(46);
            if (ind > -1) {
                String name = longName.substring(ind + 1);
                structuredType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name);
            } else {
                structuredType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(longName);
            }
        }
        this.setBasedOnStructuredType(structuredType);
    }

    public boolean isBST() {
        return this.basedOnStructuredType != null || this.basedOnStructuredTypeLongName != null && !this.basedOnStructuredTypeLongName.isEmpty();
    }

    public void clearTypeSubstitution(TypeSubstitution typeSubstitution) {
        if (this.typeSubstitution == typeSubstitution) {
            this.typeSubstitution = null;
            this.typeSubstitutionID = null;
            this.typeSubstitutionParentID = null;
            if (typeSubstitution != null) {
                this.fireChange(ObjectChangeEvent.ROOT_CHANGED);
            }
        }
    }

    private void clearTypeSubstitutions() {
        Object[] subst = this.getSubTypeSubstitutions().toArray();
        for (int i = 0; i < subst.length; ++i) {
            if (!(subst[i] instanceof TypeSubstitution)) continue;
            ((TypeSubstitution)subst[i]).remove();
        }
        if (this.getTypeSubstitution() != null) {
            this.getTypeSubstitution().remove();
        }
    }

    public List getSubTypeSubstitutions() {
        return this.typeSubstitutions;
    }

    public void clearAll() {
        ContainedObject[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            elms[i].remove();
        }
    }

    public Collection getElementsCollection() {
        return this.elements;
    }

    public Collection getElementsCollectionImmutable() {
        return Collections.unmodifiableList(this.elements);
    }

    public boolean containsAll(Collection elements) {
        return this.elements.containsAll(elements);
    }

    public int size() {
        return this.elements.size();
    }

    public Collection getElementsAndNestedElementsCollection() {
        if (this.nestedElements.size() == 0) {
            return this.elements;
        }
        ArrayList combinedList = new ArrayList(this.elements);
        combinedList.addAll(this.nestedElements);
        return combinedList;
    }

    public ContainedObject[] getElementsAndNestedElements() {
        return this.toContainedObjectArray(this.getElementsAndNestedElementsCollection());
    }

    public ContainedObject getElement(int index) {
        return (ContainedObject)this.elements.get(index);
    }

    public ContainedObject getOidElement() {
        if (this.isBST()) {
            for (ContainedObject co : this.getElementsCollection()) {
                if (!co.isOid()) continue;
                return co;
            }
        }
        return null;
    }

    public boolean moveAfter(ContainedObject object, ContainedObject target) {
        if (this.elements.contains(object) && this.elements.contains(target) && !object.equals(target)) {
            this.elements.remove(object);
            int index1 = this.elements.indexOf(target) + 1;
            this.elements.add(index1, object);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(object);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public boolean moveToIndex(ContainedObject object, int index) {
        if (this.elements.contains(object) && this.elements.size() > index && index >= 0) {
            this.elements.remove(object);
            this.elements.add(index, object);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(object);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public int getIndexOf(ContainedObject object) {
        return this.elements.indexOf(object);
    }

    public void remove(ContainedObject object) {
        if (object != null && this.isWriteable()) {
            this.elements.remove(object);
            this.removeNestedCOFor(object);
            this.nestedElements.remove(object);
            if (!(this instanceof SubsetCO)) {
                object.setContainer(null);
            }
            this.localIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(this);
            this.getDesign().removeDesignObject(object);
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(1);
            this.fireChange(this.sharedEvent);
        }
    }

    public void removeNestedCOFor(ContainedObject parent) {
        Object[] nelements = this.nestedElements.toArray();
        for (int i = 0; i < nelements.length; ++i) {
            ContainedObject co = (ContainedObject)nelements[i];
            if (co.getParentObject() != parent) continue;
            this.removeNestedCOFor(co);
            co.remove();
            this.nestedElements.remove(co);
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet && event.isRemoved() && event.getAffected() == this.basedOnStructuredType) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            this.clearTypeSubstitutions();
            this.clearStructure();
            this.basedOnStructuredType = null;
        }
        if (this.schemaObject != null && set instanceof SchemaObjectSet && event.isRemoved() && event.getAffected() == this.schemaObject) {
            this.schemaObject = null;
            set.removeSetListener(this);
            this.setDirty(true);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Datatype coDatatype;
        if (object instanceof StructuredType) {
            this.updateStructure();
        }
        this.sharedEvent.setElement(object);
        this.sharedEvent.setType(6);
        this.fireChange(this.sharedEvent);
        if (object instanceof ContainedObjectWithDomain && (coDatatype = ((ContainedObjectWithDomain)object).getDataType()) instanceof StructuredType) {
            if (ObjectChangeEvent.OBJECT_REMOVED == event) {
                ((StructuredType)coDatatype).removeObjectListener(this);
            } else {
                ((StructuredType)coDatatype).addObjectListener(this);
            }
        }
    }

    public ContainedObject getElementByStructAttributeID(String id) {
        if (id != null && !"".equals(id)) {
            for (ContainedObject co : this.elements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id)) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getElementByStructAttributeID(String id, ContainedObject parent) {
        if (id != null) {
            for (ContainedObject co : this.elements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id) || co.getParentObject() != parent) continue;
                return co;
            }
            for (ContainedObject co : this.nestedElements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id) || co.getParentObject() != parent) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getNestedElementByStructAttributeID(String id) {
        if (id != null) {
            for (ContainedObject co : this.nestedElements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id)) continue;
                return co;
            }
        }
        return null;
    }

    public List getNestedElements() {
        return this.nestedElements;
    }

    protected void removeLocalId(String localID) {
        this.localIDs.remove(localID);
    }

    public boolean isSubstitutable() {
        return this.hasTypeSubstitutionChildren() || this.isAllowTypeSubstitution();
    }

    public boolean hasTypeSubstitutionChildren() {
        return this.getSubTypeSubstitutions().size() > 0;
    }

    public boolean isRoot() {
        if (this.isBST()) {
            if (this.hasTypeSubstitutionChildren()) {
                return this.getTypeSubstitution() == null;
            }
            return this.getTypeSubstitution() == null;
        }
        return false;
    }

    public boolean isPartOfTypeSubstHierarchy() {
        return this.hasTypeSubstitutionChildren() || this.getTypeSubstitution() != null;
    }

    protected int getByteSize(String rdbmsName) {
        if (this.getContainedClass().isAssignableFrom(ContainedObjectWithDomain.class)) {
            int count = 0;
            ContainedObjectWithDomain[] elements = (ContainedObjectWithDomain[])this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                count += elements[i].getDomain().getDataType(rdbmsName).getByteSize();
            }
            return count;
        }
        throw new IllegalStateException("Only ContainerObjects containing ContainedObjectWithDomain elements can calculate bytesizes");
    }

    public ContainedObject[] removeAll() {
        ContainedObject[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            elms[i].remove();
        }
        return elms;
    }

    @Override
    public void remove() {
        if (this.basedOnStructuredType != null) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
        }
        if (this.typeSubstitution != null) {
            this.typeSubstitution.remove();
        }
        Object[] ts_arr = this.typeSubstitutions.toArray();
        for (int i = 0; i < ts_arr.length; ++i) {
            ((TypeSubstitution)ts_arr[i]).remove();
        }
        this.removeAll();
        this.localIDs.clear();
        super.remove();
        this.basedOnStructuredType = null;
    }

    public static String getLongestName(ContainedObject[] elements, boolean expandComplextypes) {
        Object name = "";
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st;
            TypeElement te;
            CollectionType ct;
            Object n = elements[i].getName();
            if (((String)n).length() > ((String)name).length()) {
                name = n;
            }
            if (!expandComplextypes || !(elements[i] instanceof ContainedObjectWithDomain)) continue;
            ContainedObjectWithDomain cod = (ContainedObjectWithDomain)elements[i];
            if (cod.getUse() == 3 && !cod.isReference()) {
                StructuredType st2 = cod.getStructuredType();
                if (st2 == null) continue;
                TypeElement[] tes = st2.getElements();
                n = ContainerObject.getLongestTypeName(tes, 1);
                if (StructuredType.UNIONTYPE.equalsIgnoreCase(st2.getHiveType())) {
                    n = ">" + (String)n;
                }
                if (((String)n).length() <= ((String)name).length()) continue;
                name = n;
                continue;
            }
            if (cod.getUse() != 4 || (ct = cod.getCollectionType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference() || (st = (StructuredType)te.getType()) == null) continue;
            TypeElement[] tes = st.getElements();
            n = ContainerObject.getLongestTypeName(tes, 1);
            if (StructuredType.UNIONTYPE.equalsIgnoreCase(st.getHiveType())) {
                n = ">" + (String)n;
            }
            if (((String)n).length() <= ((String)name).length()) continue;
            name = n;
        }
        return name;
    }

    public static String getLongestTypeName(TypeElement[] elements, int level) {
        Object pref = "";
        for (int i = 0; i < level; ++i) {
            pref = (String)pref + "MMM";
        }
        Object name = "";
        for (int i = 0; i < elements.length; ++i) {
            StructuredType st2;
            TypeElement te;
            CollectionType ct;
            TypeElement elm;
            Object n = (String)pref + elements[i].getName();
            if (((String)n).length() > ((String)name).length()) {
                name = n;
            }
            if ((elm = elements[i]).getType() instanceof StructuredType && !elm.isReference()) {
                StructuredType st22 = (StructuredType)elm.getType();
                if (st22 == null || ((String)(n = ContainerObject.getLongestTypeName(st22.getElements(), level + 1))).length() <= ((String)name).length()) continue;
                name = n;
                continue;
            }
            if (!(elm.getType() instanceof CollectionType) || elm.isReference() || (ct = (CollectionType)elm.getType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference() || ((String)(n = ContainerObject.getLongestTypeName((st2 = (StructuredType)te.getType()).getElements(), level + 1))).length() <= ((String)name).length()) continue;
            name = n;
        }
        return name;
    }

    public List<String> getExistingTablespaces() {
        return this.existingTablespaces;
    }

    public void setExistingTablespaces(List<String> existingTablespaces) {
        this.existingTablespaces = existingTablespaces;
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copySchemaObject((ContainerObject)desObject);
        super.copy(desObject);
    }

    private void copySchemaObject(ContainerObject co) {
        if (this.getDesignPart() == co.getDesignPart()) {
            co.setSchemaObject(this.getSchemaObject());
        } else if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() != null) {
            RelationalDesign rd = (RelationalDesign)co.getDesignPart();
            SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(this.getSchemaObject().getName());
            if (so == null) {
                so = rd.getSchemaObjectSet().createSchemaObject(null);
                so.setName(this.getSchemaObject().getName());
                StorageDesign sd = rd.getStorageDesign();
                if (sd.isOpen()) {
                    StorageObject ob = (StorageObject)sd.getUserSchemaSet().getByName(this.getSchemaObject().getName());
                    if (ob == null) {
                        ob = (StorageObject)sd.getUserSchemaSet().createElement(null);
                    }
                    if (ob != null) {
                        ob.setName(so.getName());
                        ob.setSchemaObject(so);
                    }
                }
            }
            co.setSchemaObject(so);
        }
    }

    static {
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_FACT, "1");
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_DIMENSION, "2");
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_EXTERNAL, "6");
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_SUMMARY, "4");
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_LOGGING, "3");
        DWH_TO_CLASSIFICATION_TYPES.put(TYPE_TEMPORARY, "5");
        CLASSIFICATION_TO_DWH_TYPES = new HashMap<String, String>();
        CLASSIFICATION_TO_DWH_TYPES.put("1", TYPE_FACT);
        CLASSIFICATION_TO_DWH_TYPES.put("2", TYPE_DIMENSION);
        CLASSIFICATION_TO_DWH_TYPES.put("6", TYPE_EXTERNAL);
        CLASSIFICATION_TO_DWH_TYPES.put("4", TYPE_SUMMARY);
        CLASSIFICATION_TO_DWH_TYPES.put("3", TYPE_LOGGING);
        CLASSIFICATION_TO_DWH_TYPES.put("5", TYPE_TEMPORARY);
        LOGGER = new Logger(ContainerObject.class);
    }
}

