/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerChainAll;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class MOH_PLSQL_Dependencies
extends MOHSchedHandler {
    static List<String> dbaList = new ArrayList<String>();
    static Map<String, String> types = new HashMap<String, String>();
    static Map<String, String> codeTypes = new HashMap<String, String>();
    static String depSQL;

    public MOH_PLSQL_Dependencies(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    public String getObjectDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String name, String objectType) {
        HashMap<String, HelpObj> objects = new HashMap<String, HelpObj>();
        this.processObjectDependencies(conn, cw, owner, name, objectType, objects);
        Map<String, HelpObj> notprocessed = MOH_PLSQL_Dependencies.getCodeObjectsWithoutDetails(objects);
        for (HelpObj obj : notprocessed.values()) {
            this.processObjectDependencies(conn, cw, obj.owner, obj.name, obj.type, objects);
        }
        for (HelpObj obj : notprocessed.values()) {
            HelpObj item = (HelpObj)objects.get(obj.getLongName());
            if (item != null) continue;
            objects.put(obj.getLongName(), obj);
        }
        MOH_PLSQL_Dependencies.sortItemsInObjects(objects);
        H h = new H();
        h.items = new ArrayList(objects.values());
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        try {
            String json = ow.writeValueAsString((Object)h);
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            cw.logError("Error in processing PL/SQL object dependencies", e);
            return "{}";
        }
    }

    public String getJobPLSQL_Dependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String jname, String objectType) {
        boolean dba = this.dbmeHandler.hasDbaAccess(conn);
        String vname = dba ? "SYS.DBA_SCHEDULER_JOBS" : "SYS.ALL_SCHEDULER_JOBS";
        String sql = "select j.JOB_TYPE, j.JOB_ACTION,j.PROGRAM_OWNER, j.PROGRAM_NAME from " + vname + " j  where j.owner = ? and j.job_name = ? and (j.JOB_TYPE is null or j.JOB_TYPE in ('STORED_PROCEDURE','PLSQL_BLOCK','PROGRAM'))";
        String job_type = null;
        String job_action = null;
        String program_owner = null;
        String program_name = null;
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            String name = Token.getName(jname);
            ps.setString(1, owner);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    job_type = rs.getString(1);
                    job_action = rs.getString(2);
                    program_owner = rs.getString(3);
                    program_name = rs.getString(4);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cw.logError("Error in processing PL/SQL object dependencies", e);
        }
        if (job_type != null && job_action != null) {
            if ("STORED_PROCEDURE".equals(job_type)) {
                HashSet<String> userSet = new HashSet<String>();
                MOHSchedulerChainAll.getUsers(conn, userSet, dba);
                HelpObj hobj = this.parseAction(owner, job_action, userSet);
                if (hobj.isDefined()) {
                    return this.getObjectDependencies(conn, cw, hobj.owner, hobj.name, hobj.type);
                }
            } else if (job_type != null && "PLSQL_BLOCK".equals(job_type)) {
                return this.getPLSQL_blockDependencies(conn, cw, owner, "Job - " + jname, job_action);
            }
        } else if (program_owner != null && program_name != null) {
            return this.getProgramPLSQL_Dependencies(conn, cw, program_owner, program_name, "PRORAM");
        }
        return "{}";
    }

    public String getProgramPLSQL_Dependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String jname, String objectType) {
        boolean dba = this.dbmeHandler.hasDbaAccess(conn);
        String vname = dba ? "SYS.DBA_SCHEDULER_PROGRAMS" : "SYS.ALL_SCHEDULER_PROGRAMS";
        String sql = "select j.PROGRAM_TYPE, j.PROGRAM_ACTION from " + vname + " j  where j.owner = ? and j.program_name = ?  and j.PROGRAM_TYPE in ('STORED_PROCEDURE','PLSQL_BLOCK')";
        String program_type = null;
        String program_action = null;
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            String name = Token.getName(jname);
            ps.setString(1, owner);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    program_type = rs.getString(1);
                    program_action = rs.getString(2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cw.logError("Error in processing PL/SQL object dependencies", e);
        }
        if (program_type != null && program_action != null) {
            if ("STORED_PROCEDURE".equals(program_type)) {
                HashSet<String> userSet = new HashSet<String>();
                MOHSchedulerChainAll.getUsers(conn, userSet, dba);
                HelpObj hobj = this.parseAction(owner, program_action, userSet);
                if (hobj.isDefined()) {
                    return this.getObjectDependencies(conn, cw, hobj.owner, hobj.name, hobj.type);
                }
            } else if ("PLSQL_BLOCK".equals(program_type)) {
                return this.getPLSQL_blockDependencies(conn, cw, owner, "Job - " + jname, program_action);
            }
        }
        return "{}";
    }

    HelpObj parseAction(String jowner, String action, Set<String> userSet) {
        String owner = jowner;
        HelpObj obj = new HelpObj();
        obj.owner = jowner;
        obj.name = action;
        obj.type = "PROCEDURE";
        if (action.indexOf(46) > 0) {
            String[] parts = action.split("\\x2e");
            if (parts.length == 3) {
                obj.type = "PACKAGE BODY";
            }
            for (int i = 0; i < 2; ++i) {
                String part = parts[i];
                part = part.charAt(0) == '\"' ? Token.getName(part) : part.toUpperCase(Locale.ROOT);
                if (i == 0) {
                    if (userSet.contains(part)) {
                        obj.owner = part;
                        continue;
                    }
                    obj.name = part;
                    obj.type = "PACKAGE BODY";
                    return obj;
                }
                obj.name = part;
            }
        }
        return obj;
    }

    public void processObjectDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String name, String objectType, Map<String, HelpObj> objects) {
        this.processObjectDependencies(conn, cw, owner, name, objectType, objects, null);
    }

    public void processObjectDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String name, String objectType, Map<String, HelpObj> objects, HelpObj root) {
        String type = types.get(objectType.toLowerCase(Locale.ROOT));
        if (type != null) {
            Map<String, HelpObj> nonCode = MOH_PLSQL_Dependencies.getNonCodeObjectsMap(objects);
            try (PreparedStatement ps = conn.prepareStatement(depSQL);){
                ps.setString(1, owner);
                ps.setString(2, name);
                ps.setString(3, type);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        HelpObj existing;
                        String obj = rs.getString(1);
                        String refName = rs.getString(2);
                        String refOwner = rs.getString(3);
                        String refType = rs.getString(4);
                        String refStatus = rs.getString(5);
                        String[] parts = obj.split(" -- ");
                        HelpObj roh = new HelpObj(refOwner, refName, refType, refStatus);
                        if (parts.length != 4) continue;
                        String oh_owner = parts[0];
                        String oh_name = parts[1];
                        String oh_status = parts[2];
                        String oh_type = parts[3];
                        String long_name = oh_owner + "." + oh_name;
                        HelpObj oh = objects.get(long_name);
                        if (oh == null) {
                            if (MOH_PLSQL_Dependencies.isCode(oh_type)) {
                                oh = new HelpObj(oh_owner, oh_name, oh_type, oh_status);
                                objects.put(long_name, oh);
                            } else {
                                oh = nonCode.get(long_name);
                                if (oh == null) {
                                    oh = new HelpObj(oh_owner, oh_name, oh_type, oh_status);
                                    nonCode.put(long_name, oh);
                                }
                            }
                        }
                        if ((existing = objects.get(roh.getLongName())) == null || !existing.hasChild(oh)) {
                            oh.addRefObject(roh);
                        } else {
                            oh.addItemObject(roh);
                        }
                        if (!MOH_PLSQL_Dependencies.isCode(roh.type) || objects.containsKey(roh.getLongName())) continue;
                        objects.put(roh.getLongName(), roh);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cw.logError("Error in processing PL/SQL object dependencies", e);
            }
        }
    }

    static Map<String, HelpObj> getNonCodeObjectsMap(Map<String, HelpObj> objects) {
        HashMap<String, HelpObj> all = new HashMap<String, HelpObj>();
        for (HelpObj obj : objects.values()) {
            if (obj.items == null) continue;
            for (HelpObj item : obj.items) {
                all.put(item.getLongName(), item);
            }
        }
        return all;
    }

    static Map<String, HelpObj> getCodeObjectsWithoutDetails(Map<String, HelpObj> objects) {
        HashMap<String, HelpObj> all = new HashMap<String, HelpObj>();
        for (HelpObj obj : objects.values()) {
            if (obj.codeItems == null && obj.type.equals("PACKAGE")) {
                obj.type = "PACKAGE BODY";
                all.put(obj.getLongName(), obj);
                continue;
            }
            if (obj.codeItems == null) continue;
            for (HelpObj item : obj.codeItems) {
                if (objects.containsKey(item.getLongName()) || all.containsKey(item.getLongName()) || !item.type.equals("PACKAGE")) continue;
                item.type = "PACKAGE BODY";
                all.put(item.getLongName(), item);
            }
        }
        return all;
    }

    public String getPLSQL_blockDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner) {
        try {
            JsonObject jdoc = Json.createReaderFactory(Collections.emptyMap()).createReader(cw.getInputStream()).readObject();
            if (jdoc != null) {
                HashMap<String, HelpObj> objects = new HashMap<String, HelpObj>();
                JsonArray jar = jdoc.getJsonArray("items");
                int i = 1;
                for (JsonValue jval : jar) {
                    String code;
                    if (!(jval instanceof JsonObject)) continue;
                    JsonObject job = (JsonObject)jval;
                    String bowner = job.getString("owner", owner);
                    Object name = job.getString("name", "");
                    if (((String)name).isEmpty()) {
                        name = "PL/SQL block " + i;
                        ++i;
                    }
                    if ((code = job.getString("code", "")).isEmpty()) continue;
                    this.processPLSQL_blockDependencies(conn, cw, bowner, (String)name, code, objects);
                }
                MOH_PLSQL_Dependencies.sortItemsInObjects(objects);
                H h = new H();
                h.items = new ArrayList(objects.values());
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                try {
                    String json = ow.writeValueAsString((Object)h);
                    return json;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    cw.logError("Error in processing PL/SQL object dependencies", e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "{}";
    }

    public String getPLSQL_SchemaDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner) {
        try {
            HashMap<String, HelpObj> objects = new HashMap<String, HelpObj>();
            List<HelpObj> list = this.getPLSQL_ObjectsFromSchema(conn, cw, owner);
            for (HelpObj obj : list) {
                if (objects.containsKey(obj.getLongName())) continue;
                this.processObjectDependencies(conn, cw, obj.owner, obj.name, obj.type, objects);
            }
            MOH_PLSQL_Dependencies.sortItemsInObjects(objects);
            H h = new H();
            h.items = new ArrayList(objects.values());
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            try {
                String json = ow.writeValueAsString((Object)h);
                return json;
            }
            catch (Exception e) {
                e.printStackTrace();
                cw.logError("Error in processing PL/SQL object dependencies", e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "{}";
    }

    List<HelpObj> getPLSQL_ObjectsFromSchema(Connection conn, RequestManager.ContentWrapper cw, String owner) {
        String sql = "select o.OBJECT_NAME, o.OBJECT_TYPE, o.status from all_objects o\r\nwhere o.object_type in ('PACKAGE BODY','PROCEDURE','FUNCTION')\r\nand o.owner = ?";
        ArrayList<HelpObj> res = new ArrayList<HelpObj>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, owner);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(1);
                    String type = rs.getString(2);
                    String status = rs.getString(3);
                    HelpObj ho = new HelpObj(owner, name, type, status);
                    res.add(ho);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cw.logError("Error in processing PL/SQL object dependencies", e);
        }
        return res;
    }

    public String getPLSQL_blockDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String blockName, String plsqlBlock) {
        HashMap<String, HelpObj> objects = new HashMap<String, HelpObj>();
        this.processPLSQL_blockDependencies(conn, cw, owner, blockName, plsqlBlock, objects);
        MOH_PLSQL_Dependencies.sortItemsInObjects(objects);
        H h = new H();
        h.items = new ArrayList(objects.values());
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        try {
            String json = ow.writeValueAsString((Object)h);
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            cw.logError("Error in processing PL/SQL object dependencies", e);
            return "{}";
        }
    }

    public void processPLSQL_blockDependencies(Connection conn, RequestManager.ContentWrapper cw, String owner, String blockName, String plsqlBlock, Map<String, HelpObj> objects) {
        if (plsqlBlock != null && !plsqlBlock.isEmpty()) {
            boolean dba = this.dbmeHandler.hasDbaAccess(conn, dbaList);
            HashSet<String> userSet = new HashSet<String>();
            MOHSchedulerChainAll.getUsers(conn, userSet, dba);
            HashMap<String, MOHSchedulerChainAll.OHelp> nameMap = new HashMap<String, MOHSchedulerChainAll.OHelp>();
            SqlRecognizer r = new SqlRecognizer(plsqlBlock);
            Map refs = r.getObjectReferences();
            ArrayList<MOHSchedulerChainAll.OHelp> helps = new ArrayList<MOHSchedulerChainAll.OHelp>();
            for (String name : refs.values()) {
                MOHSchedulerChainAll.OHelp oh;
                if (name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE") || name.equalsIgnoreCase("SYS_CONTEXT") || nameMap.get((oh = MOHSchedulerChainAll.getOHelp(name, owner, userSet)).getLongName()) != null) continue;
                nameMap.put(oh.getLongName(), oh);
                helps.add(oh);
            }
            if (helps.size() > 0) {
                String name;
                MOHSchedulerChainAll.getObjectType(conn, nameMap, helps, dba);
                List<HelpObj> blockObjects = MOH_PLSQL_Dependencies.transformOHelpList(helps);
                name = blockName;
                if (name == null || name.isEmpty()) {
                    name = "PL/SQL block";
                }
                HelpObj block = new HelpObj(owner, name, "pl_sql_block", "valid");
                ArrayList<HelpObj> list = new ArrayList<HelpObj>();
                for (HelpObj obj : blockObjects) {
                    if (obj.type == null || "SYS".equals(obj.owner)) continue;
                    if (MOH_PLSQL_Dependencies.isCode(obj.type) && !objects.containsKey(obj.getLongName())) {
                        objects.put(obj.getLongName(), obj);
                        list.add(obj);
                    }
                    block.addRefObject(new HelpObj(obj));
                }
                objects.put(block.getLongName(), block);
                for (HelpObj obj : list) {
                    if (!MOH_PLSQL_Dependencies.isCode(obj.type)) continue;
                    this.processObjectDependencies(conn, cw, obj.owner, obj.name, obj.type, objects);
                }
            }
        }
    }

    static void sortItemsInObjects(Map<String, HelpObj> objects) {
        for (HelpObj obj : objects.values()) {
            obj.sortItems();
        }
    }

    static List<HelpObj> transformOHelpList(List<MOHSchedulerChainAll.OHelp> list) {
        ArrayList<HelpObj> res = new ArrayList<HelpObj>();
        for (MOHSchedulerChainAll.OHelp obj : list) {
            res.add(new HelpObj(obj));
        }
        return res;
    }

    static boolean isCode(String type) {
        return codeTypes.get(type.toLowerCase(Locale.ROOT)) != null;
    }

    public static void main(String[] args) {
    }

    @Override
    public List<SchedulerObject> generate(Connection sqlConnection, List<DBObject> selectedObjects) throws Exception {
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        return res;
    }

    static {
        dbaList.add("SYS.DBA_OBJECTS");
        types.put("package", "PACKAGE BODY");
        types.put("package_body", "PACKAGE BODY");
        types.put("package body", "PACKAGE BODY");
        types.put("procedure", "PROCEDURE");
        types.put("function", "FUNCTION");
        types.put("trigger", "TRIGGER");
        types.put("type", "TYPE");
        types.put("sequence", "SEQUENCE");
        types.put("table", "TABLE");
        codeTypes.put("package", "PACKAGE BODY");
        codeTypes.put("package body", "PACKAGE BODY");
        codeTypes.put("procedure", "PROCEDURE");
        codeTypes.put("function", "FUNCTION");
        codeTypes.put("trigger", "TRIGGER");
        depSQL = "SELECT DISTINCT \r\n  (select a.owner ||' -- '||a.object_name || ' -- '||a.status || ' -- '||\r\n  case a.object_type\r\n  when 'PACKAGE BODY' then\r\n   'PACKAGE'\r\n   else\r\n    a.object_type\r\n  end\r\n  from sys.all_objects a where a.object_id = c.object_id) as object,\r\n   b.object_name as REF_NAME, \r\n   b.owner as ref_owner, \r\n   b.object_type ref_TYPE, \r\n   b.status,c.l \r\nFROM \r\n   sys.all_objects b, \r\n   (SELECT object_id, referenced_object_id, level l, rownum ord \r\n    FROM public_dependency \r\n    START WITH OBJECT_ID = (SELECT OBJECT_ID FROM ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME  = ? and object_type = ? ) --and object_type = 'PACKAGE BODY')\r\n    CONNECT BY NOCYCLE   prior referenced_object_id = object_id ) c \r\nWHERE b.object_id = c.referenced_object_id \r\nAND b.owner NOT IN ('SYS', 'SYSTEM') \r\nAND b.object_name not in ('DUAL','SYS_STUB_FOR_PURITY_ANALYSIS','STANDARD','JSON_OBJECT_T','JSON_ELEMENT_T','DUAL','ODCIVARCHAR2LIST', 'JSON_ARRAY_T')\r\nand b.object_type in ('TABLE','VIEW','PACKAGE','PROCEDURE','FUNCTION', 'SEQUENCE', 'TRIGGER', 'TYPE') order by l";
    }

    public static class HelpObj {
        String owner;
        String name;
        String type;
        String status = "";
        List<HelpObj> items;
        List<HelpObj> codeItems;
        volatile Set<String> used = new HashSet<String>();

        HelpObj() {
        }

        HelpObj(String owner, String name, String type, String status) {
            this.owner = owner;
            this.name = name;
            this.type = type;
            this.status = status;
        }

        HelpObj(HelpObj obj) {
            this.owner = obj.owner;
            this.name = obj.name;
            this.type = obj.type;
            this.status = obj.status;
        }

        HelpObj(MOHSchedulerChainAll.OHelp obj) {
            this.owner = obj.owner;
            this.name = obj.name;
            this.type = obj.type;
            this.status = obj.status;
        }

        public String toString() {
            return this.getLongName();
        }

        String getLongName() {
            Object res = this.owner;
            if (res == null || ((String)res).isEmpty()) {
                return this.name;
            }
            res = (String)res + "." + this.name;
            return res;
        }

        void sortItems() {
            if (this.items != null) {
                Collections.sort(this.items, Comparator.comparing(HelpObj::getLongName));
            }
        }

        boolean isDefined() {
            return this.owner != null && this.name != null && this.type != null;
        }

        void addRefObject(HelpObj obj) {
            if (!this.used.contains(obj.getLongName())) {
                if (MOH_PLSQL_Dependencies.isCode(obj.type)) {
                    if (!this.getLongName().equals(obj.getLongName())) {
                        if (this.codeItems == null) {
                            this.codeItems = new ArrayList<HelpObj>();
                        }
                        this.codeItems.add(obj);
                    }
                } else {
                    if (this.items == null) {
                        this.items = new ArrayList<HelpObj>();
                    }
                    this.items.add(obj);
                }
                this.used.add(obj.getLongName());
            }
        }

        void addItemObject(HelpObj obj) {
            if (!this.used.contains(obj.getLongName())) {
                if (this.items == null) {
                    this.items = new ArrayList<HelpObj>();
                }
                this.items.add(obj);
            }
        }

        void addRefObject(HelpObj obj, Map<String, HelpObj> objects, HelpObj root) {
            if (!this.used.contains(obj.getLongName())) {
                if (MOH_PLSQL_Dependencies.isCode(obj.type)) {
                    if (!this.getLongName().equals(obj.getLongName())) {
                        if (this.codeItems == null) {
                            this.codeItems = new ArrayList<HelpObj>();
                        }
                        this.codeItems.add(obj);
                    }
                } else {
                    if (this.items == null) {
                        this.items = new ArrayList<HelpObj>();
                    }
                    this.items.add(obj);
                }
                this.used.add(obj.getLongName());
            }
        }

        boolean isReachable(HelpObj start, HelpObj end, Map<String, HelpObj> objects) {
            return start.hasChild(end);
        }

        boolean hasChild(HelpObj end) {
            if (this.used != null && this.used.contains(end.getLongName())) {
                return true;
            }
            if (this.codeItems != null) {
                for (HelpObj obj : this.codeItems) {
                    boolean res = obj.hasChild(end);
                    if (!res) continue;
                    return true;
                }
            }
            return false;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public List<HelpObj> getItems() {
            return this.items;
        }

        public void setItems(List<HelpObj> items) {
            this.items = items;
        }

        public List<HelpObj> getCodeItems() {
            return this.codeItems;
        }

        public void setCodeItems(List<HelpObj> codeItems) {
            this.codeItems = codeItems;
        }
    }

    class H {
        List<HelpObj> items;

        H() {
        }

        public List<HelpObj> getItems() {
            return this.items;
        }

        public void setItems(List<HelpObj> items) {
            this.items = items;
        }
    }
}

