/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerChain;
import oracle.dbtools.crest.model.scheduling.SchedulerChainRule;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerStep;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerChain
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_CHAIN";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_CHAINS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_CHAINS";
    public static final String DBA_STEPS_TABLE = "SYS.DBA_SCHEDULER_CHAIN_STEPS";
    public static final String ALL_STEPS_TABLE = "SYS.ALL_SCHEDULER_CHAIN_STEPS";
    public static final String DBA_RULES_TABLE = "SYS.DBA_SCHEDULER_CHAIN_RULES";
    public static final String ALL_RULES_TABLE = "SYS.ALL_SCHEDULER_CHAIN_RULES";

    public MOHSchedulerChain(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        String steps_sql = this.getStepsSQL(dba);
        String rules_sql = this.getRulesSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        PreparedStatement statement_s = null;
        PreparedStatement statement_r = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerChain chain = new SchedulerChain();
                ArrayList<String> list = new ArrayList<String>(chain.getPropsList());
                list.add("NUMBER_OF_RULES");
                list.add("NUMBER_OF_STEPS");
                for (String prop : list) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    chain.setProperty(prop, value);
                }
                rs.close();
                res.add(chain);
                if (chain.getNumberOfStepsProperty() > 0) {
                    if (statement_s == null) {
                        statement_s = conn.prepareStatement(steps_sql);
                    }
                    this.processSteps(conn, statement_s, chain, dbo);
                }
                if (chain.getNumberOfRulesProperty() <= 0) continue;
                if (statement_r == null) {
                    statement_r = conn.prepareStatement(rules_sql);
                }
                this.processRules(conn, statement_r, chain, dbo);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_s, statement_r});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_s, statement_r});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_s, statement_r});
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSteps(Connection conn, PreparedStatement statement, SchedulerChain chain, DBObject dbo) {
        ResultSet rs = null;
        try {
            statement.setString(1, dbo.getSchema());
            statement.setString(2, dbo.getName());
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    SchedulerStep step = new SchedulerStep();
                    for (String prop : step.getPropsList()) {
                        String value = null;
                        try {
                            value = rs.getString(prop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("propname - " + prop);
                        }
                        step.setProperty(prop, value);
                    }
                    chain.addStep(step);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRules(Connection conn, PreparedStatement statement, SchedulerChain chain, DBObject dbo) {
        ResultSet rs = null;
        try {
            statement.setString(1, dbo.getSchema());
            statement.setString(2, dbo.getName());
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    SchedulerChainRule rule = new SchedulerChainRule();
                    for (String prop : rule.getPropsList()) {
                        String value = null;
                        try {
                            value = rs.getString(prop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("propname - " + prop);
                        }
                        rule.setProperty(prop, value);
                    }
                    chain.addRule(rule);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
        }
    }

    String getSQL(boolean dba) {
        String sql = "select OWNER ,\r\nCHAIN_NAME ,\r\nENABLED ,\r\nEVALUATION_INTERVAL ,\r\nUSER_RULE_SET ,\r\nCOMMENTS,  \r\nNUMBER_OF_RULES ,\r\nNUMBER_OF_STEPS\r\n from " + (dba ? DBA_TABLE : ALL_TABLE) + " \n where owner = ? and CHAIN_NAME = ?";
        return sql;
    }

    String getStepsSQL(boolean dba) {
        String sql = "select\nOWNER,\r\nCHAIN_NAME,\r\nSTEP_NAME,\r\nPROGRAM_OWNER,\r\nPROGRAM_NAME,\r\nEVENT_SCHEDULE_OWNER,\r\nEVENT_SCHEDULE_NAME,\r\nEVENT_QUEUE_OWNER,\r\nEVENT_QUEUE_NAME,\r\nEVENT_QUEUE_AGENT,\r\nEVENT_CONDITION,\r\nCREDENTIAL_OWNER,\r\nCREDENTIAL_NAME,\r\nDESTINATION,\r\nSKIP,\r\nPAUSE,\r\nPAUSE_BEFORE,\r\nRESTART_ON_RECOVERY,\r\nRESTART_ON_FAILURE,\r\nSTEP_TYPE,\r\nTIMEOUT\r\n from " + (dba ? DBA_STEPS_TABLE : ALL_STEPS_TABLE) + "  \n where owner = ? and CHAIN_NAME = ? \n";
        return sql;
    }

    String getRulesSQL(boolean dba) {
        String sql = "select\nOWNER,\r\nCHAIN_NAME,\r\nRULE_OWNER,\r\nRULE_NAME,\r\nCONDITION,\r\nACTION,\r\nCOMMENTS\r\n from " + (dba ? DBA_RULES_TABLE : ALL_RULES_TABLE) + "  \n where owner = ? and CHAIN_NAME = ? \n";
        return sql;
    }
}

