/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.scheduling.SchedulerDDLMaker;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulingSchemaDDL {
    public static void main(String[] args) {
    }

    public static String getSchemaDDL(Connection conn, RequestManager.ContentWrapper cw, String owner) {
        SchemaOptions so = SchedulingSchemaDDL.getSchemaOptions(cw);
        List<SchedulerObject> objects = SchedulingSchemaDDL.getSchedulerObjects(conn, owner, so);
        SchedulerDDLMaker ddlc = new SchedulerDDLMaker();
        ddlc.generateDDLContent(objects);
        String res = ddlc.getContent();
        return res;
    }

    private static SchemaOptions getSchemaOptions(RequestManager.ContentWrapper cw) {
        try {
            JsonObject jo = Json.createReader((InputStream)cw.getInputStream()).readObject();
            SchemaOptions so = new SchemaOptions();
            so.jobs = jo.getBoolean("jobs", true);
            so.job_classes = jo.getBoolean("job_classes", true);
            so.programs = jo.getBoolean("programs", true);
            so.chains = jo.getBoolean("chains", true);
            so.schedules = jo.getBoolean("schedules", true);
            so.file_watchers = jo.getBoolean("file_watchers", true);
            so.windows = jo.getBoolean("windows", true);
            so.window_groups = jo.getBoolean("window_groups", true);
            return so;
        }
        catch (Throwable e) {
            cw.logError("Error in Parse schema scheduling options", e);
            return new SchemaOptions();
        }
    }

    public static String getSchemaDDL(Connection conn, String owner) {
        List<SchedulerObject> objects = SchedulingSchemaDDL.getSchedulerObjects(conn, owner);
        SchedulerDDLMaker ddlc = new SchedulerDDLMaker();
        ddlc.generateDDLContent(objects);
        String res = ddlc.getContent();
        return res;
    }

    public static List<SchedulerObject> getSchedulerObjects(Connection conn, String owner) {
        SchemaOptions so = new SchemaOptions();
        return SchedulingSchemaDDL.getSchedulerObjects(conn, owner, so);
    }

    public static List<SchedulerObject> getSchedulerObjects(Connection conn, String owner, SchemaOptions so) {
        DBMExtractionHandlerScheduling eh = new DBMExtractionHandlerScheduling(conn);
        boolean dba = eh.hasDbaAccess(conn);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (so.schedules) {
            list.addAll(SchedulingSchemaDDL.getListOfSchedObjets(conn, owner, dba ? "SYS.DBA_SCHEDULER_SCHEDULES" : "SYS.ALL_SCHEDULER_SCHEDULES", "SCHEDULE_NAME", "SCHEDULER_SCHEDULE"));
        }
        if (so.windows || so.window_groups) {
            list.addAll(SchedulingSchemaDDL.getUsedWindowsAndWindowsGroups(conn, owner, dba));
        }
        if (so.job_classes) {
            list.addAll(SchedulingSchemaDDL.getUsedJobClasses(conn, owner, dba));
        }
        if (so.file_watchers) {
            list.addAll(SchedulingSchemaDDL.getListOfSchedObjets(conn, owner, dba ? "SYS.DBA_SCHEDULER_FILE_WATCHERS" : "SYS.ALL_SCHEDULER_FILE_WATCHERS", "FILE_WATCHER_NAME", "SCHEDULER_FILE_WATCHER"));
        }
        if (so.programs) {
            list.addAll(SchedulingSchemaDDL.getListOfSchedObjets(conn, owner, dba ? "SYS.DBA_SCHEDULER_PROGRAMS" : "SYS.ALL_SCHEDULER_PROGRAMS", "PROGRAM_NAME", "SCHEDULER_PROGRAM"));
        }
        if (so.chains) {
            list.addAll(SchedulingSchemaDDL.getListOfSchedObjets(conn, owner, dba ? "SYS.DBA_SCHEDULER_CHAINS" : "SYS.ALL_SCHEDULER_CHAINS", "CHAIN_NAME", "SCHEDULER_CHAIN"));
        }
        if (so.jobs) {
            list.addAll(SchedulingSchemaDDL.getListOfSchedObjets(conn, owner, dba ? "SYS.DBA_SCHEDULER_JOBS" : "SYS.ALL_SCHEDULER_JOBS", "JOB_NAME", "SCHEDULER_JOB"));
        }
        List<SchedulerObject> res = eh.generateObjects(conn, list);
        return res;
    }

    public static List<DBObject> getListOfSchedObjets(Connection conn, String owner, String view_name, String name_column, String object_type) {
        String sql = "select " + name_column + " from " + view_name + " where owner = ?";
        if (owner == null) {
            sql = "select " + name_column + " from " + view_name;
        }
        ArrayList<DBObject> res = new ArrayList<DBObject>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (owner != null) {
                ps.setString(1, owner);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    while (rs.next()) {
                        String name = rs.getString(1);
                        DBObject dbo = new DBObject(true, name, object_type, owner);
                        res.add(dbo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static List<DBObject> getUsedWindowsAndWindowsGroups(Connection conn, String owner, boolean dba) {
        PreparedStatement ps;
        String view_name = dba ? "SYS.DBA_SCHEDULER_JOBS" : "SYS.ALL_SCHEDULER_JOBS";
        String sql = "select SCHEDULE_OWNER, SCHEDULE_NAME, SCHEDULE_TYPE from " + view_name + "\n where owner = ?  \n and SCHEDULE_TYPE in ('WINDOW','WINDOW_GROUP') \n order by SCHEDULE_TYPE";
        ArrayList<DBObject> res = new ArrayList<DBObject>();
        ArrayList<String> groups = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>();
        try {
            ps = conn.prepareStatement(sql);
            try {
                if (owner != null) {
                    ps.setString(1, owner);
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (rs != null) {
                        while (rs.next()) {
                            String object_type;
                            String sowner = rs.getString(1);
                            String sname = rs.getString(2);
                            String stype = rs.getString(3);
                            String string = object_type = "WINDOW".equalsIgnoreCase(stype) ? "SCHEDULER_WINDOW" : "SCHEDULER_WINDOW_GROUP";
                            if ("WINDOW_GROUP".equalsIgnoreCase(stype)) {
                                groups.add(sname);
                            } else {
                                names.add(sname);
                            }
                            DBObject dbo = new DBObject(true, sname, object_type, sowner);
                            res.add(dbo);
                        }
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (groups.size() > 0) {
            view_name = dba ? "SYS.DBA_SCHEDULER_GROUP_MEMBERS" : "SYS.ALL_SCHEDULER_GROUP_MEMBERS";
            sql = "select member_name from " + view_name + " where group_name = ?";
            try {
                ps = conn.prepareStatement(sql);
                try {
                    for (String group : groups) {
                        ps.setString(1, group);
                        ResultSet rs = ps.executeQuery();
                        try {
                            if (rs == null) continue;
                            while (rs.next()) {
                                String sname = rs.getString(1);
                                String[] parts = sname.split("\\x2E");
                                String name = "";
                                name = parts.length == 2 ? parts[1] : parts[0];
                                if (names.contains(name = Token.getName(name))) continue;
                                String object_type = "SCHEDULER_WINDOW";
                                names.add(name);
                                DBObject dbo = new DBObject(true, name, object_type, "SYS");
                                res.add(dbo);
                            }
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static List<DBObject> getUsedJobClasses(Connection conn, String owner, boolean dba) {
        String view_name = dba ? "SYS.DBA_SCHEDULER_JOBS" : "SYS.ALL_SCHEDULER_JOBS";
        String sql = "select job_class from " + view_name + "\n where owner = ?  \n order by 1";
        ArrayList<DBObject> res = new ArrayList<DBObject>();
        HashSet<String> names = new HashSet<String>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (owner != null) {
                ps.setString(1, owner);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    while (rs.next()) {
                        String sname = rs.getString(1);
                        if ("DEFAULT_JOB_CLASS".equalsIgnoreCase(sname) || names.contains(sname)) continue;
                        names.add(sname);
                        DBObject dbo = new DBObject(true, sname, "SCHEDULER_JOB_CLASS", "SYS");
                        res.add(dbo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static class SchemaOptions {
        boolean jobs = true;
        boolean job_classes = true;
        boolean windows = true;
        boolean window_groups = true;
        boolean chains = true;
        boolean programs = true;
        boolean schedules = true;
        boolean file_watchers = true;
    }
}

