/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;

public class SSBClusterOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ClusterOraclev10g cluster = (ClusterOraclev10g)object;
        this.storageDesign = cluster.getStorageDesign();
        this.appendPrompt(buffer, cluster, "CLUSTER");
        this.appendComment(oldbuffer, cluster);
        SSBClusterOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBClusterOraclev10g.appendStringWithSpace(buffer, "CLUSTER");
        SSBClusterOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
        advancedComment = buffer.toString();
        if (this.hasNoColumns(cluster)) {
            SSBClusterOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid Cluster " + cluster.getName() + " with no columns");
            SSBClusterOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.incrementErrors();
        } else {
            this.appendColumns(buffer, cluster, prettyPrint);
            this.appendAttributes(buffer, cluster.getSegment(), prettyPrint);
            this.appendSize(buffer, cluster, prettyPrint);
            this.appendTableSpace(buffer, cluster, prettyPrint);
            this.appendIndex(buffer, cluster, prettyPrint);
            this.appendParallel(buffer, cluster, prettyPrint);
            this.appendRowDependencies(buffer, cluster, prettyPrint);
            this.appendCache(buffer, cluster, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBClusterOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.incrementCreateCluster();
        }
    }

    private void appendRowDependencies(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getRowDependency())) {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ClusterOraclev10g && ((ClusterOraclev10g)object).isMarkedGenerate();
    }

    private boolean hasNoColumns(ClusterOraclev10g cluster) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        return columnSet.isEmpty();
    }

    private void appendColumns(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        Object[] columnList = columnSet.toArray();
        Arrays.sort(columnList, new ColumnComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < columnList.length; ++i) {
            sortedList.add(columnList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            ClusterColumnOracle column = (ClusterColumnOracle)setIt.next();
            if (column.getCluster() == null || !column.getCluster().equals(cluster)) continue;
            if (first) {
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBClusterOraclev10g.appendString(buffer, ',');
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBClusterOraclev10g.appendStringWithSpace(buffer, ' ');
            }
            SSBClusterOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            String dataType = column.getDataType();
            if (dataType.startsWith("TIMESTAMP")) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "TIMESTAMP");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("6");
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (dataType.indexOf("WITH") <= -1) continue;
                SSBClusterOraclev10g.appendStringWithSpace(buffer, dataType.substring(10));
                continue;
            }
            if (dataType.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "INTERVAL YEAR");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                }
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "TO MONTH");
                continue;
            }
            if (dataType.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "INTERVAL DAY");
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                }
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "TO SECOND");
                if (column.getScale() > 0) {
                    buffer.append('(').append(column.getScale());
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("6");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBClusterOraclev10g.appendStringWithSpace(buffer, dataType);
            if (dataType.indexOf("CHAR") > -1) {
                if (!column.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    buffer.append('(').append(column.getLengthPrecision());
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!dataType.equals("CHAR") && !dataType.equals("NCHAR") || !this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("1");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (column.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
            buffer.append('(').append(column.getLengthPrecision());
            if (column.getScale() != 0) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, ',');
                buffer.append(column.getScale());
            }
            SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (!first) {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendAttributes(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctUsedInDDL()) {
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "PCTUSED");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getPCTUsed());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 1) {
                    SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBClusterOraclev10g.appendStringWithSpace(buffer, "2");
                }
            }
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBClusterOraclev10g.appendStringWithSpace(buffer, '(');
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                props = true;
            }
            if (props) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendSize(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        int size = cluster.getSize();
        if (size > 0) {
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBClusterOraclev10g.appendStringWithSpace(buffer, size);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, cluster.getMeasureUnit());
        }
    }

    private void appendTableSpace(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        SegmentOracle segment;
        TableSpaceOracle tableSpace = cluster.getTableSpace();
        if (tableSpace == null && (segment = cluster.getSegment()) != null && segment.isMarkedGenerate()) {
            tableSpace = segment.getTableSpace();
        }
        if (tableSpace != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBClusterOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendIndex(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(cluster.getIndexed())) {
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "INDEX");
        } else if (cluster.getHashKeys() >= 2) {
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if ("YES".equalsIgnoreCase(cluster.getSingleTable())) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "SINGLE");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "TABLE");
            }
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "HASHKEYS");
            SSBClusterOraclev10g.appendStringWithSpace(buffer, cluster.getHashKeys());
            if (!"".equalsIgnoreCase(cluster.getHashExpression())) {
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "HASH");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, "IS");
                SSBClusterOraclev10g.appendStringWithSpace(buffer, cluster.getHashExpression());
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "INDEX");
        }
    }

    private void appendParallel(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getParallel())) {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendCache(StringBuffer buffer, ClusterOraclev10g cluster, boolean prettyPrint) {
        SSBClusterOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(cluster.getCache())) {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "CACHE");
        } else {
            SSBClusterOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
        }
    }

    static class ColumnComparator
    implements Comparator {
        ColumnComparator() {
        }

        public int compare(Object one, Object two) {
            if (((ClusterColumnOracle)one).getPosition() > ((ClusterColumnOracle)two).getPosition()) {
                return 1;
            }
            if (((ClusterColumnOracle)one).getPosition() < ((ClusterColumnOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

