/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.ocidbmetrics.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.ocidbmetrics.CDBMetrics;
import oracle.jdbc.pool.OracleDataSource;

public class OCIDBMetricsExample {
    public static void main(String[] args) throws SQLException, IOException, InterruptedException {
        String connString = "jdbc:oracle:thin:@localhost:1521/orcl";
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(connString);
        ods.setUser("sys as sysdba");
        ods.setPassword("oracle");
        ods.setRoleName("SYSDBA");
        Connection conn = ods.getConnection();
        List<String> tabs = OCIDBMetricsExample.enumnerateTableRequired(conn);
        System.out.println("Unique List of Tables Needed for CDB Collections");
        for (String tab : tabs) {
            System.out.println("\"" + tab + "\",");
        }
    }

    private static List<String> enumnerateTableRequired(Connection conn) throws IOException {
        DBUtil util = DBUtil.getInstance(conn);
        ArrayList<String> allTables = new ArrayList<String>();
        CDBMetrics cdbMetrics = new CDBMetrics();
        for (String name : cdbMetrics.getFiles()) {
            Path f = Paths.get("/Users/klrice/dev/bitbucket/iod-telemetry/etc/base_oracle/" + name, new String[0]);
            String sql = Files.readString(f);
            List<String> tables = SqlRecognizer.getAllTables(sql);
            for (String obj : tables) {
                if (obj.equals("v$metric_history") || obj.equals("(")) continue;
                obj = obj.toUpperCase(Locale.ROOT);
                Object existStatement = null;
                Object rset = null;
                boolean exists = util.execute("select count(1) from " + obj);
                if (exists && !allTables.contains(obj)) {
                    allTables.add(obj);
                }
                if (exists) continue;
                System.out.println("No Access to : " + obj);
            }
        }
        allTables.sort(Comparator.naturalOrder());
        return allTables;
    }
}

