/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ansi.utils.AnsiColorListPrinter;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.HistoryService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.IListPrinter;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.fusesource.jansi.Ansi;

@Restricted(level=Restricted.Level.R4)
public class RepeatSQLBufferCmd
extends CommandListener
implements IHelp {
    private static Logger LOGGER = Logger.getLogger(RepeatSQLBufferCmd.class.getName());
    public static final String ANSI_CLS = "\u001b[2J";
    public static final String ANSI_HOME = "\u001b[H";
    public static final String ANSI_BOLD = "\u001b[1m";
    public static final String ANSI_AT55 = "\u001b[10;10H";
    public static final String ANSI_REVERSEON = "\u001b[7m";
    public static final String ANSI_NORMAL = "\u001b[0m";
    public static final String ANSI_WHITEONBLUE = "\u001b[37;44m";
    public static final IListPrinter _listPrinter = new AnsiColorListPrinter();

    @Override
    public String getCommand() {
        return "REPEAT";
    }

    @Override
    public String getHelp() {
        return Messages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (RepeatSQLBufferCmd.matches("repeat", cmd.getSql())) {
            if (ctx.getProperty("REPEAT_COMMAND") != null) {
                ctx.write(Messages.getString("RepeatSQLBufferCmd.NO_NESTED"));
                return true;
            }
            if (ctx.getSQLPlusBuffer().getBufferSafe().isEmpty()) {
                ctx.write(Messages.getString("RepeatSQLBufferCmd.12"));
                return true;
            }
            try {
                ctx.putProperty("REPEAT_COMMAND", Boolean.TRUE);
                if (ctx.getSqlError() != 0 && this.isConnectionInterrupted(conn)) {
                    ctx.write(Messages.getString("RepeatSQLBufferCmd.CONNECTION_FAILED"));
                }
                if (Ansi.isEnabled()) {
                    this.printTop(conn, ctx, cmd);
                } else {
                    ctx.write(Messages.getString("RepeatSQLBufferCmd.9"));
                }
            }
            catch (SQLException | ConnectionShutdownException e) {
                ctx.write(e.getMessage());
            }
            finally {
                ctx.removeProperty("REPEAT_COMMAND");
            }
            return true;
        }
        return false;
    }

    private void printTop(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) throws SQLException {
        String[] parts = cmd.getSQLOrig().split(" ");
        double sleep = 1.0;
        int num = -1;
        try {
            num = Integer.parseInt(parts[1]);
            sleep = Double.parseDouble(parts[2]);
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(Messages.getString("RepeatSQLBufferCmd.USAGE"), this.getCommand(), Integer.MAX_VALUE));
            return;
        }
        if (num < 0 || sleep < 0.0 || sleep > 120.0) {
            ctx.write(MessageFormat.format(Messages.getString("RepeatSQLBufferCmd.USAGE"), this.getCommand(), Integer.MAX_VALUE));
            return;
        }
        if (conn == null || this.isConnectionInterrupted(conn)) {
            ctx.writeln(Messages.getString("RepeatSQLBufferCmd.CONNECTION_FAILED"));
            return;
        }
        String nextCmd = null;
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        if (ctx.getTopLevel()) {
            HistoryService historyService = consoleService.getHistoryService();
            int index = historyService.last() - 1;
            for (int check = historyService.size(); check > 1 && nextCmd == null; --check) {
                String next = historyService.get(index);
                if (!next.toLowerCase().startsWith("repeat")) {
                    nextCmd = next;
                }
                --index;
            }
        } else if (ctx.getProperty("LAST_RUN_CMD") != null) {
            nextCmd = (String)ctx.getProperty("LAST_RUN_CMD");
        }
        String sql = nextCmd;
        ScriptParser sp = new ScriptParser(sql);
        sp.parse();
        ISQLCommand[] stmts = sp.getSqlStatements();
        boolean isSQL = false;
        DecimalFormat df = new DecimalFormat("##");
        for (int i = 1; i < num + 1 && !ctx.isInterrupted(); ++i) {
            try {
                if (ctx.getSqlError() != 0 && this.isConnectionInterrupted(conn)) {
                    ctx.write(Messages.getString("RepeatSQLBufferCmd.CONNECTION_FAILED"));
                    return;
                }
                ctx.write(ANSI_CLS);
                ctx.write(ANSI_HOME);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
                String now = formatter.format(LocalTime.now());
                String header = MessageFormat.format(Messages.getString("RepeatSQLBufferCmd.16"), i, num, now, sleep);
                if (stmts.length == 1 && stmts[0].getStmtType() == SQLCommand.StmtType.G_C_SQL) {
                    Substitution sub = new Substitution(ctx);
                    try {
                        sub.replaceSubstitution(stmts[0]);
                    }
                    catch (Substitution.SubstitutionException substitutionException) {
                        // empty catch block
                    }
                    DBUtil dbUtil = DBUtil.getInstance(conn);
                    Map<String, Bind> binds = this.getBinds(stmts[0], ctx);
                    List<List<?>> rows = dbUtil.executeReturnListofList(stmts[0].getSql(), binds);
                    _listPrinter.printListofList(ctx, header, rows);
                } else {
                    ctx.write(header);
                    ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
                    sqlcl.setStmt(sql);
                    sqlcl.run();
                }
                if (i == num) continue;
                try {
                    Thread.sleep(Math.round(sleep * 1000.0));
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (Exception e) {
                ctx.write("SQL Error occurred: " + e.getMessage() + "\n");
            }
        }
    }

    private Map<String, Bind> getBinds(ISQLCommand cmd, ScriptRunnerContext ctx) {
        Iterator<Object> it = cmd.getBinds().iterator();
        HashMap<String, Bind> binds = new HashMap<String, Bind>();
        Map<String, Bind> externalBinds = ctx.getVarMap();
        while (it.hasNext()) {
            Object name = it.next();
            if (!externalBinds.containsKey(name)) continue;
            binds.put((String)name, externalBinds.get(name));
        }
        if (binds.size() > 0) {
            return binds;
        }
        return null;
    }

    private boolean isConnectionInterrupted(Connection conn) {
        try {
            return conn == null || conn.isClosed() || !conn.isValid(5);
        }
        catch (SQLException e) {
            return true;
        }
    }
}

