/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.core.connections.storage.StorageMigrator;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.extension.SQLCLServices;
import oracle.dbtools.net.commands.NetCommands;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.secret.SecretCommand;
import oracle.dbtools.plusplus.util.DefaultLoggerWrapper;
import oracle.dbtools.raptor.ansi.utils.AnsiColorListPrinter;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.StatusBarService;
import oracle.dbtools.raptor.format.ANSIConsoleFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.FormatterServices;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPlusProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.newscriptrunner.commands.Info;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.SetExitCommit;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLogin;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowRegistry;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleClearScreen;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.ValidatorServiceLoader;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliHelper;
import oracle.dbtools.raptor.scriptrunner.cmdline.SQLCliOptions;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.EditCommand;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Messages;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.SetColorCommand;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliMessageHandler;
import oracle.dbtools.raptor.scriptrunner.commands.HelpCmd;
import oracle.dbtools.raptor.scriptrunner.commands.HistoryCommand;
import oracle.dbtools.raptor.scriptrunner.commands.InfoCmd;
import oracle.dbtools.raptor.scriptrunner.commands.NLSLANGListener;
import oracle.dbtools.raptor.scriptrunner.commands.OraDebug;
import oracle.dbtools.raptor.scriptrunner.commands.OraPKICommand;
import oracle.dbtools.raptor.scriptrunner.commands.PromptCmd;
import oracle.dbtools.raptor.scriptrunner.commands.RepeatSQLBufferCmd;
import oracle.dbtools.raptor.scriptrunner.commands.SODACmd;
import oracle.dbtools.raptor.scriptrunner.commands.Set121LongIdentifier;
import oracle.dbtools.raptor.scriptrunner.commands.SetClearScreen;
import oracle.dbtools.raptor.scriptrunner.commands.SetCodescan;
import oracle.dbtools.raptor.scriptrunner.commands.SetEditFile;
import oracle.dbtools.raptor.scriptrunner.commands.SetEditor;
import oracle.dbtools.raptor.scriptrunner.commands.SetEmbedded;
import oracle.dbtools.raptor.scriptrunner.commands.SetEncoding;
import oracle.dbtools.raptor.scriptrunner.commands.SetHighlighting;
import oracle.dbtools.raptor.scriptrunner.commands.SetHistory;
import oracle.dbtools.raptor.scriptrunner.commands.SetSQLPlusCompatability;
import oracle.dbtools.raptor.scriptrunner.commands.SetSQLPrompt;
import oracle.dbtools.raptor.scriptrunner.commands.SetStatusBar;
import oracle.dbtools.raptor.scriptrunner.commands.SetTime;
import oracle.dbtools.raptor.scriptrunner.commands.SetWallet;
import oracle.dbtools.raptor.scriptrunner.commands.ShowDrivers;
import oracle.dbtools.raptor.scriptrunner.commands.ShowEncoding;
import oracle.dbtools.raptor.scriptrunner.commands.ShowExtensions;
import oracle.dbtools.raptor.scriptrunner.commands.ShowKeyMap;
import oracle.dbtools.raptor.scriptrunner.commands.ShowVersion;
import oracle.dbtools.raptor.scriptrunner.commands.Shutdown;
import oracle.dbtools.raptor.scriptrunner.commands.SshTunnelCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Startup;
import oracle.dbtools.raptor.scriptrunner.commands.editor.AppendCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.ChangeCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.DelCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.GetCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.InputCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.ListCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Pwd;
import oracle.dbtools.raptor.scriptrunner.commands.editor.SaveCommand;
import oracle.dbtools.raptor.scriptrunner.commands.editor.SetSuffix;
import oracle.dbtools.raptor.scriptrunner.commands.editor.StoreCommand;
import oracle.dbtools.raptor.scriptrunner.commands.ocidbmetrics.OCIMetricsCommand;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTCommand;
import oracle.dbtools.raptor.utils.BasicExceptionHandler;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.versions.CheckForUpdates;
import oracle.dbtools.versions.SQLclVersion;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiRenderer;

public class SqlCli
implements Closeable {
    private static boolean _isCmdLine = false;
    private static boolean logging = false;
    public static String productName = "SQLcl";
    private Buffer _buffer;
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    private ScriptExecutor _runner;
    private ConsoleService.Command command;
    private ConsoleService consoleService;
    private boolean processed;
    private boolean startupComplete;

    public SqlCli(ConsoleService.Builder consoleServiceBuilder, String[] args) {
        this(new ScriptRunnerContext(), consoleServiceBuilder, args);
    }

    public SqlCli(ScriptRunnerContext context, ConsoleService.Builder consoleServiceBuilder, String[] args) {
        block5: {
            this.processed = false;
            SQLCliOptions.setArgs(args);
            this._buffer = new Buffer();
            SQLCliOptions.processOptions(context, args);
            this.processOptions(context);
            this.setScriptRunnerContext(context);
            this.consoleService = consoleServiceBuilder.name(productName).scriptRunnerContext(this._ctx).sqlclBuffer(this._buffer).build();
            this._ctx.putProperty("script.runner.jline", this.consoleService);
            if (System.getProperty("java.util.logging.config.file") != null) break block5;
            System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %4$-6s %2$s %5$s%6$s%n");
            StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter(){

                @Override
                public synchronized String format(LogRecord record) {
                    return Thread.currentThread().toString() + " " + super.format(record);
                }
            }){

                @Override
                public synchronized void publish(LogRecord record) {
                    super.publish(record);
                    this.flush();
                }
            };
            Logger.getGlobal().addHandler(handler);
            Logger.getLogger("org.apache.http").addHandler(handler);
            Logger.getLogger("com.oracle.pic.commons").addHandler(handler);
            boolean optlCheck = SQLCliOptions.options.contains("-verbose");
            if (System.getProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure") == null) {
                System.setProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure", "false");
            }
            if (!optlCheck) {
                logging = true;
                Enumeration<String> list = LogManager.getLogManager().getLoggerNames();
                while (list.hasMoreElements()) {
                    Logger.getLogger(list.nextElement()).setLevel(Level.SEVERE);
                }
            } else {
                logging = false;
                Enumeration<String> list = LogManager.getLogManager().getLoggerNames();
                while (list.hasMoreElements()) {
                    Logger.getLogger(list.nextElement()).setLevel(Level.INFO);
                }
            }
        }
    }

    private static void handleCloseDown(SqlCli cli) {
        try {
            cli.consoleService.close();
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        Connection current = cli.getScriptRunnerContext().getCurrentConnection();
        try {
            if (cli.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
                cli.getScriptRunnerContext().stopSpool();
            }
            if (current != null && !current.isClosed()) {
                if (cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") == null || cli.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.FALSE)) {
                    SQLPLUSUtil.disconnectMessage(current, cli.getScriptRunnerContext(), cli.getScriptRunnerContext().getOutputStream());
                }
                current.close();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    private static void handleExit(SqlCli cli) {
        Integer exitInt = (Integer)cli.getScriptRunnerContext().getProperty("script.runner.exit_int");
        cli.getScriptRunnerContext().closeContext();
        if (exitInt != null && exitInt > 0) {
            System.exit(exitInt);
        }
        System.exit(0);
    }

    private static void log(Level level, String message) {
        if (logging) {
            Logger l = Logger.getLogger("oracle.dbtools");
            l.setLevel(Level.parse("SEVERE"));
            l.log(level, message);
        }
    }

    private static void log(Level level, String message, Exception thrown) {
        if (logging) {
            Logger l = Logger.getLogger("oracle.dbtools");
            l.setLevel(Level.parse("SEVERE"));
            l.log(level, message, thrown);
        }
    }

    private static void setTerminalConstraints(SqlCli cli) {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            String val;
            byte[] buf;
            Process p2;
            try {
                p2 = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput cols 2> /dev/tty"});
                buf = new byte[200];
                p2.getInputStream().read(buf);
                val = new String(buf).trim();
                int cols = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setlinesize", cols);
            }
            catch (IOException | NumberFormatException p2) {
                // empty catch block
            }
            try {
                p2 = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "tput lines 2> /dev/tty"});
                buf = new byte[200];
                p2.getInputStream().read(buf);
                val = new String(buf).trim();
                int lines = Integer.parseInt(val);
                cli.getScriptRunnerContext();
                cli.getScriptRunnerContext().putProperty("script.runner.setpagesize", lines);
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public static boolean isCmdLine() {
        return _isCmdLine;
    }

    public static void main(String[] args) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException("args is specified as null");
        }
        for (int a = 0; a < args.length; ++a) {
            if (args[a] != null) continue;
            throw new IllegalArgumentException("arg #" + a + " is null");
        }
        try {
            _isCmdLine = true;
            AnsiConsole.systemInstall();
            if (System.getenv("STARTUP_SQLCL") != null && !System.getenv("STARTUP_SQLCL").equals("")) {
                System.setProperty("user.dir", System.getenv("STARTUP_SQLCL"));
            }
            try (SqlCli cli = new SqlCli(ConsoleService.builder(), args);){
                cli.runSqlcl();
                SqlCli.handleCloseDown(cli);
                SqlCli.handleExit(cli);
            }
        }
        catch (FileNotFoundException fnfe) {
            SqlCli.log(Level.SEVERE, fnfe.getMessage());
        }
        catch (Exception e) {
            SqlCli.log(Level.SEVERE, e.getMessage(), e);
            ExceptionHandler.handleException(e);
        }
    }

    private void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread("cleanup"){

            @Override
            public void run() {
                SqlCli.this.consoleService.getHistoryService().saveHistory();
                Aliases.getInstance().save();
            }
        });
    }

    private void banner() {
        String version = SQLclVersion.getSQLclShortVersion();
        String banner = Messages.getString("SqlCli.18");
        banner = MessageFormat.format(banner, productName, version, SQLclVersion.getSQLclState(), SQLCliHelper.getBannerTime());
        this.getScriptRunnerContext().write("\n" + banner + "\n");
        banner = Messages.getString("SqlCli.19");
        banner = MessageFormat.format(banner, SQLCliHelper.getBannerYear());
        this.getScriptRunnerContext().write("\n" + banner + "\n");
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ICommandHistory createCommandHistory() {
        return new ICommandHistory(){

            @Override
            public void allowFailures(boolean value) {
                SqlCli.this.consoleService.getHistoryService().setSelectFails(value);
            }

            @Override
            public void saveCommand(ISQLCommand cmd) {
                if (!(SqlCli.this.command == null || (cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_RUN) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SLASH) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DEL_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CHANGE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SAVE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_STORE) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_GET) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_LIST) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_APPEND) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_EDIT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_FORMAT) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_COMMENT_PLUS) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_HISTORY) || cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DOC_PLUS)) && !cmd.getSQLOrig().trim().toLowerCase().startsWith("repeat") || cmd.getdepth() != 0)) {
                    String modifiedLine = (String)SqlCli.this._ctx.getProperty("sqlcl.history.modified.line");
                    try {
                        SqlCli.this.command.onComplete(modifiedLine, cmd.getTiming(), !cmd.isFail());
                    }
                    finally {
                        SqlCli.this._ctx.getProperties().remove("sqlcl.history.modified.line");
                    }
                }
            }

            @Override
            public boolean isDisabled() {
                return SqlCli.this.consoleService.getHistoryService().isDisabled();
            }

            @Override
            public void setDisabled(boolean newValue) {
                SqlCli.this.consoleService.getHistoryService().setDisabled(newValue);
            }
        };
    }

    private IConsoleReader createConsoleReader() {
        return new IConsoleClearScreen(){

            @Override
            public void doClearScreen(String position) throws IOException {
                ConsoleService.ClearScreenPosition clearScreenPosition = null;
                if (position.equals("top")) {
                    clearScreenPosition = ConsoleService.ClearScreenPosition.TOP;
                } else if (position.equals("bottom")) {
                    clearScreenPosition = ConsoleService.ClearScreenPosition.BOTTOM;
                }
                SqlCli.this.consoleService.clearScreen(clearScreenPosition);
            }

            @Override
            public void forceRedraw(boolean draw) {
            }

            @Override
            public int getHeight() {
                return SqlCli.this.consoleService.getHeight();
            }

            @Override
            public int getWidth() {
                return SqlCli.this.consoleService.getWidth();
            }

            @Override
            public void pauseReader(boolean pause) {
                SqlCli.this.consoleService.pause(pause);
            }

            @Override
            public void setPrompt(String prompt) {
            }

            @Override
            public void setRedit(boolean on) {
            }
        };
    }

    private String getFirstLineOfFile(String inputFile, ScriptRunnerContext context) {
        try {
            BufferedReader getLoginFile = inputFile.indexOf(46) != -1 && inputFile.lastIndexOf(46) > 0 ? new BufferedReader(new FileReader(new File(inputFile))) : (context.getProperty("script.runner.file.suffix") != null ? new BufferedReader(new FileReader(new File(inputFile + "." + String.valueOf(context.getProperty("script.runner.file.suffix"))))) : new BufferedReader(new FileReader(new File(inputFile))));
            String connectLine = getLoginFile.readLine();
            String patterns = "(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+";
            Pattern pattern = Pattern.compile("(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+", 2);
            Matcher matcher = pattern.matcher(connectLine.trim());
            if (matcher.matches()) {
                context.putProperty("SQLCLI_IGNORE_FIRST_LINE", true);
                context.putProperty("script.runner.threetimes", Boolean.FALSE);
                return connectLine.trim();
            }
        }
        catch (IOException e) {
            SqlCli.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    private String getLoginFile(ScriptRunnerContext context) {
        return ShowLogin.firstOrNull(ShowLogin.getLocations(context, "login.sql", true));
    }

    private boolean getPrependDirectory(String inputFile) {
        return !inputFile.startsWith("/") && !inputFile.startsWith("\\") && (System.getProperty("os.name").startsWith("Windows") ? inputFile.length() <= 3 || (inputFile.charAt(1) != ':' || inputFile.charAt(2) != '/' && inputFile.charAt(2) != '\\') && (inputFile.charAt(0) != '/' || inputFile.charAt(2) != ':' || inputFile.charAt(3) != '/') : !inputFile.startsWith("/") && !inputFile.startsWith("\\"));
    }

    private String getStartupFile(ScriptRunnerContext context) {
        return ShowLogin.firstOrNull(ShowLogin.getLocations(context, "startup.sql", true));
    }

    /*
     * WARNING - void declaration
     */
    private String getTheCompleteFilename(String inputFile, String pathGiven) {
        String file = inputFile;
        boolean prependDirectory = this.getPrependDirectory(inputFile);
        if (pathGiven != null && prependDirectory) {
            for (String string : pathGiven.split(File.pathSeparator)) {
                void var8_15;
                void var8_12;
                if (string == null) continue;
                if (string.endsWith("/") || string.endsWith("\\")) {
                    String string2 = string + inputFile;
                } else {
                    String string3 = string + File.separator + inputFile;
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    String string4 = var8_12.replace("/", "\\");
                } else {
                    String string5 = var8_12.replace("\\", "/");
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), var8_15));
                if (!new File((String)var8_15).exists() || !new File((String)var8_15).canRead()) continue;
                file = var8_15;
                break;
            }
        } else {
            file = inputFile;
        }
        return file;
    }

    private void gotoOrChangeLine(String lineNumber) throws IOException {
        try {
            Integer.parseInt(lineNumber.split("\\s+")[0]);
        }
        catch (NumberFormatException e) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SqlCli.39"), lineNumber));
            this.processed = true;
            this.getScriptRunnerContext().getOutputStream().flush();
            return;
        }
        if (this._buffer.getBufferSafe().size() > 0) {
            Object cmd = "";
            int gotoLineNumber = 0;
            StringTokenizer st = new StringTokenizer(lineNumber);
            if (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    gotoLineNumber = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    gotoLineNumber = -1;
                }
            }
            if (st.hasMoreTokens()) {
                while (st.hasMoreTokens()) {
                    cmd = (String)cmd + st.nextToken() + " ";
                }
            }
            if (((String)cmd).trim().endsWith(";")) {
                cmd = ((String)cmd).trim().substring(0, ((String)cmd).trim().length() - 1);
            }
            if (gotoLineNumber >= 0) {
                if (((String)cmd).length() > 0) {
                    if (gotoLineNumber == 0) {
                        this._buffer.getBufferSafe().addAtIndex(0, (String)cmd);
                    } else if (gotoLineNumber > this._buffer.getBufferSafe().linesInBuffer()) {
                        this._buffer.getBufferSafe().add((String)cmd);
                    } else {
                        this._buffer.getBufferSafe().replace(gotoLineNumber, (String)cmd);
                    }
                } else {
                    this.getScriptRunnerContext().write("\n" + this._buffer.getBufferSafe().setCurrentLine(gotoLineNumber));
                }
            }
        } else {
            this.getScriptRunnerContext().write("\n" + Messages.getString("SqlCli.15"));
        }
        this.processed = true;
        this.getScriptRunnerContext().getOutputStream().flush();
    }

    private void handleScriptOption(ScriptRunnerContext context) throws Exception {
        if (SQLCliOptions.options.contains("-script")) {
            String script = SQLCliOptions.properties.getProperty("-script").replace("\\n", "\n");
            ScriptExecutor executor = new ScriptExecutor(script, this._conn);
            executor.setScriptRunnerContext(context);
            executor.setOut(context.getOutputStream());
            executor.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void handleAtFiles(ScriptRunnerContext context) throws Exception {
        boolean runFile = true;
        if (SQLCliOptions.getFileName() != null && SQLCliOptions.getFileName().length() > 0) {
            String inputFile;
            ArrayList<String> parserArgs = SQLCliOptions.getFileArguments();
            if (parserArgs != null) {
                for (int argCount = 0; argCount < parserArgs.size(); ++argCount) {
                    Map<String, String> m = context.getMap();
                    String preArg = parserArgs.get(argCount);
                    if ((preArg.startsWith("'") && preArg.endsWith("'") || preArg.startsWith("\"") && preArg.endsWith("\"")) && preArg.length() > 1) {
                        preArg = preArg.substring(1, preArg.length() - 1);
                    }
                    m.put(Integer.toString(argCount + 1), preArg);
                }
            }
            String toRun = null;
            String pathGiven = null;
            if (SQLPLUSUtil.getSqlpathProvider() != null) {
                pathGiven = SQLPLUSUtil.getSqlpathProvider().getSQLPATHsetting();
            }
            if (!(SQLCliOptions.startsWithHttpOrFtp(inputFile = SQLCliOptions.getFileName()) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile))) {
                boolean prependDirectory = this.getPrependDirectory(inputFile);
                toRun = this.getTheCompleteFilename(inputFile, pathGiven);
                if (pathGiven != null && prependDirectory) {
                    for (String string : pathGiven.split(File.pathSeparator)) {
                        void var11_20;
                        void var11_17;
                        if (string == null) continue;
                        if (string.endsWith("/") || string.endsWith("\\")) {
                            String string2 = string + inputFile;
                        } else {
                            String string3 = string + File.separator + inputFile;
                        }
                        if (System.getProperty("os.name").startsWith("Windows")) {
                            String string4 = var11_17.replace("/", "\\");
                        } else {
                            String string5 = var11_17.replace("\\", "/");
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), var11_20));
                        if (!new File((String)var11_20).exists() || !new File((String)var11_20).canRead()) continue;
                        toRun = var11_20;
                        break;
                    }
                }
            }
            if (toRun == null) {
                toRun = SQLCliOptions.getFileName();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageFormat.format(Messages.getString("SqlCli.FILECHECK"), toRun));
            }
            if (SQLCliOptions.startsWithHttpOrFtp(inputFile) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile)) {
                URLConnection u = new URL(inputFile.replaceAll("\\\\", "/")).openConnection();
                this._runner = new ScriptExecutor(u.getInputStream(), this._conn);
            } else if (new File(toRun).exists() && new File(toRun).canRead()) {
                this._runner = new ScriptExecutor(new FileInputStream(toRun), this._conn);
            } else {
                runFile = false;
                context.write(MessageFormat.format("SP2-0310: unable to open file \"{0}\"\n", toRun));
                this._runner = new ScriptExecutor(this._conn);
                this._runner.setScriptRunnerContext(context);
            }
            if (runFile) {
                this._runner.setScriptRunnerContext(context);
                SQLPLUSUtil.setExecutorPath(this._runner, inputFile, context);
                try {
                    this.runFile(this._runner, "runner", context, inputFile);
                }
                finally {
                    context.setSourceRef("");
                }
            }
        } else {
            this._runner = new ScriptExecutor(this._conn);
            this._runner.setScriptRunnerContext(context);
        }
        context.putProperty("runner", this._runner);
    }

    private void handleBanner() {
        if (!(SQLCliOptions.isOptionUsed("-silent") ^ SQLCliOptions.isOptionUsed("-x"))) {
            this.banner();
        }
    }

    private void handleEditions(ScriptExecutor runner) {
        if (SQLCliOptions.getEdition() != null) {
            String sql = MessageFormat.format("alter session set edition={0}", SQLCliOptions.getEdition());
            runner.setStmt(sql);
            runner.run();
        }
    }

    private void handleExitInAtFiles() {
        if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) {
            SqlCli.handleCloseDown(this);
            SqlCli.handleExit(this);
        }
    }

    private void handleHelp() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/oracle/dbtools/raptor/scriptrunner/cmdline/help/help1.txt");
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    this.getScriptRunnerContext().write(line + "\n");
                }
                this.getScriptRunnerContext().getOutputStream().flush();
            }
        }
        catch (IOException e) {
            SqlCli.log(Level.SEVERE, e.getMessage());
        }
    }

    private void handleInterrupt() {
        if (this.startupComplete) {
            if (this._runner != null) {
                this._runner.interrupt();
            }
        } else {
            System.exit(-1);
        }
    }

    private void handleDefaultOCIProfiles(ScriptRunnerContext context) {
        String COMMAND = "oci profile DEFAULT";
        ScriptExecutor executor = new ScriptExecutor(COMMAND, null);
        executor.setScriptRunnerContext(context);
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        BufferedOutputStream bos = new BufferedOutputStream(os);
        try {
            executor.setOut(bos);
            executor.run();
            executor.getScriptRunnerContext().setOutputStreamWrapper(new BufferedOutputStream(System.out));
        }
        catch (Exception re) {
            Logger.getLogger(SqlCli.class.getName()).log(Level.FINE, "No OCI Config setup:\n  {0}", re.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLoginSql(ScriptRunnerContext context) {
        String connectOptions;
        context.putProperty("DBConfig.GLOGIN_FILE", null);
        if (context.getRestrictedLevel().getLevel() <= 3) {
            PropertyValues propertyValues = context.getService(ConnectionContext.class).getContextPropertyValues();
            connectOptions = propertyValues.loadFromArgs(SQLCliOptions.getCommandLineArgs());
            if (connectOptions == null) {
                SqlCli.handleCloseDown(this);
                System.exit(1);
            }
        } else {
            connectOptions = "";
        }
        if (!SQLCliOptions.isOptionUsed("/nolog")) {
            context.setSQLPlusCmdLineLogin();
            Object connectS = SQLCliOptions.getConnectString();
            if (connectS == null) {
                if (SQLCliOptions.getConnectString() == null && SQLCliOptions.getFileName() != null && SQLCliOptions.getFileName().length() > 0) {
                    String file;
                    String inputFile;
                    context.putProperty("script.runner.sqlplus.logon", Boolean.TRUE);
                    String pathGiven = null;
                    if (SQLPLUSUtil.getSqlpathProvider() != null) {
                        pathGiven = SQLPLUSUtil.getSqlpathProvider().getSQLPATHsetting();
                    }
                    if (!(SQLCliOptions.startsWithHttpOrFtp(inputFile = SQLCliOptions.getFileName()) && SQLCliOptions.haveIBytes(inputFile) || SQLCliOptions.haveIBytesRaw(inputFile) || !new File(file = this.getTheCompleteFilename(inputFile, pathGiven)).exists() || !new File(file).canRead())) {
                        connectS = this.getFirstLineOfFile(file, context);
                    }
                } else {
                    connectS = "";
                }
            }
            if (SQLCliOptions.getAsRole() != null && !SQLCliOptions.getAsRole().equals("")) {
                connectS = (String)connectS + " as " + SQLCliOptions.getAsRole();
            } else if (SQLCliOptions.isAsSysBackup()) {
                connectS = (String)connectS + " as sysbackup";
            }
            connectS = connectOptions.isEmpty() ? "connect " + (String)connectS + "\n" : "connect " + connectOptions + " " + Objects.requireNonNullElse(connectS, "") + "\n";
            context.putProperty("DBConfig.GLOGIN", true);
            context.putProperty("script.runner.sqlplus.nolog", Boolean.TRUE);
            ScriptExecutor runner = new ScriptExecutor((String)connectS, null);
            context.putProperty("runner", runner);
            runner.setScriptRunnerContext(context);
            try {
                runner.getScriptRunnerContext().putProperty("sqlcl.script.ininitialconnect", true);
                Boolean logon = (Boolean)context.getProperty("script.runner.sqlplus.logon");
                runner.getScriptRunnerContext().putProperty("script.runner.threetimes", false);
                runner.getScriptRunnerContext().putProperty("script.runner.commandlineconnect", Boolean.TRUE);
                runner.getScriptRunnerContext().setEscape(false);
                runner.getScriptRunnerContext().setSubstitutionOn(false);
                runner.setOut(new BufferedOutputStream(System.out));
                runner.run();
            }
            finally {
                runner.getScriptRunnerContext().putProperty("script.runner.threetimes", false);
                runner.getScriptRunnerContext().putProperty("sqlcl.script.ininitialconnect", false);
            }
            if (runner.getScriptRunnerContext().getCurrentConnection() != null) {
                this._conn = runner.getScriptRunnerContext().getCurrentConnection();
                context = runner.getScriptRunnerContext();
                context.setBaseConnection(this._conn);
                context.setCloseConnection(false);
                this.handleEditions(runner);
            } else {
                SqlCli.handleCloseDown(this);
                System.exit(1);
            }
        } else {
            String loginFile;
            File f;
            String glogin = ShowLogin.firstOrNull(ShowLogin.getLocations(context, "glogin.sql", false));
            if (glogin != null && (f = new File(glogin)).exists()) {
                try {
                    this._runner = new ScriptExecutor(new FileInputStream(glogin), this._conn);
                    context.putProperty("runner", this._runner);
                    context.putProperty("sqlcli.glogin.sql", Boolean.TRUE);
                    this.runFile(this._runner, "glogin", context, glogin);
                    context.putProperty("sqlcli.glogin.sql", Boolean.FALSE);
                    this._conn = this._runner.getScriptRunnerContext().getCurrentConnection();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if ((loginFile = this.getLoginFile(context)) != null) {
                try {
                    this._runner = new ScriptExecutor(new FileInputStream(loginFile), this._conn);
                    context.putProperty("runner", this._runner);
                    context.putProperty("sqlcli.login.sql", Boolean.TRUE);
                    this.runFile(this._runner, "glogin", context, loginFile);
                    context.putProperty("sqlcli.login.sql", Boolean.FALSE);
                    this._conn = this._runner.getScriptRunnerContext().getCurrentConnection();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private void handleStartupSQL(ScriptRunnerContext context) {
        String startupFile = this.getStartupFile(context);
        if (startupFile != null) {
            try {
                this._runner = new ScriptExecutor(new FileInputStream(startupFile), this._conn);
                context.putProperty("runner", this._runner);
                this.runFile(this._runner, "startup", context, startupFile);
                this._conn = this._runner.getScriptRunnerContext().getCurrentConnection();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private void handleUpdates() {
        if (SQLCliOptions.isOptionUsed("-noupdates")) {
            return;
        }
        StringBuilder updateString = new StringBuilder();
        CheckForUpdates cfu = CheckForUpdates.getLastUpdateCheck();
        if (cfu != null) {
            if (SQLclVersion.getSQLclOracleVersion().limit(3).compareTo(cfu.getLatestOracleVersion()) < 0 && cfu.getBroadcastMessage() != null && cfu.getBroadcastMessage().length() > 0 && cfu.isMessageShowable(new Date())) {
                updateString.append("\t").append(cfu.getBroadcastMessage()).append("\n\n");
            }
            if (SQLclVersion.getSQLclOracleVersion().limit(3).compareTo(cfu.getLatestOracleVersion()) < 0) {
                String version = MessageFormat.format(Messages.getString("SqlCli.13"), cfu.getLatestVersion());
                updateString.append("\n").append(version).append("\n\n");
            }
            if (updateString.length() > 0) {
                this.getScriptRunnerContext().write(updateString.toString());
            }
        }
        Thread t = new Thread("Checkforupdates"){

            @Override
            public void run() {
                try {
                    CheckForUpdates cfu = CheckForUpdates.check();
                    cfu.save();
                }
                catch (UncheckedIOException ex) {
                    Logger.getLogger(SqlCli.class.getName()).log(Level.WARNING, "Unable to check for updates. Please verify your network connection:\n  {0}", ex.getLocalizedMessage());
                }
                catch (Exception ex) {
                    Logger.getLogger(SqlCli.class.getName()).log(Level.WARNING, "Unable to check for updates", ex);
                }
            }
        };
        t.start();
    }

    private void handleVersion() {
        String banner = Messages.getString("SqlCli.Version");
        banner = MessageFormat.format(banner, productName, SQLclVersion.getSQLclVersion(), SQLclVersion.getSQLclState(), SQLclVersion.getSQLclBuildVersion());
        this.getScriptRunnerContext().write(banner + "\n");
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initSqlcl() throws Exception {
        this.consoleService.setInterruptHandler(() -> this.handleInterrupt());
        this.addShutdownHooks();
        ExceptionHandler.setHandler(new BasicExceptionHandler());
        MessageHandler.setHandler(new SQLCliMessageHandler());
        FormatRegistry.setLineTerminator(System.getProperty("line.separator"));
        SQLCliHelper.setDefaultScriptRunnerProperies();
        ResultSetFormatter.setMaxLines(Integer.MAX_VALUE);
        this._ctx.runWithStoredContext(() -> {
            CommandRegistry.addListener(SetEditFile.class, SQLCommand.StmtSubType.G_S_SET_EDITFILE);
            CommandRegistry.addListener(HistoryCommand.class, SQLCommand.StmtSubType.G_S_HISTORY);
            CommandRegistry.addListener(GetCommand.class, SQLCommand.StmtSubType.G_S_GET);
            CommandRegistry.addListener(SaveCommand.class, SQLCommand.StmtSubType.G_S_SAVE);
            CommandRegistry.addListener(StoreCommand.class, SQLCommand.StmtSubType.G_S_STORE);
            CommandRegistry.addListener(ListCommand.class, SQLCommand.StmtSubType.G_S_LIST);
            CommandRegistry.addListener(AppendCommand.class, SQLCommand.StmtSubType.G_S_APPEND);
            CommandRegistry.addListener(ChangeCommand.class, SQLCommand.StmtSubType.G_S_CHANGE);
            CommandRegistry.addListener(DelCommand.class, SQLCommand.StmtSubType.G_S_DEL_PLUS);
            CommandRegistry.addListener(SetEmbedded.class, SQLCommand.StmtSubType.G_S_SET_EMBEDDED);
            CommandRegistry.addListener(SetSuffix.class, SQLCommand.StmtSubType.G_S_SET_SUFFIX);
            CommandRegistry.addListener(SetTime.class, SQLCommand.StmtSubType.G_S_SET_TIME);
            CommandRegistry.addListener(SetClearScreen.class, SQLCommand.StmtSubType.G_S_SET_CLEARSCREEN);
            CommandRegistry.addListener(SetEncoding.class, SQLCommand.StmtSubType.G_S_SET_ENCODING);
            CommandRegistry.addListener(EditCommand.class, SQLCommand.StmtSubType.G_S_EDIT);
            CommandRegistry.addListener(InputCommand.class, SQLCommand.StmtSubType.G_S_INPUT);
            CommandRegistry.addListener(SshTunnelCommand.class, SQLCommand.StmtSubType.G_S_SSHTUNNEL);
            CommandRegistry.addListener(Startup.class, SQLCommand.StmtSubType.G_S_STARTUP);
            CommandRegistry.addListener(Shutdown.class, SQLCommand.StmtSubType.G_S_SHUTDOWN);
            CommandRegistry.addListener(SetColorCommand.class, SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
            CommandRegistry.addListener(SetSQLPlusCompatability.class, SQLCommand.StmtSubType.G_S_SET_SQLCOMPATABILITY);
            CommandRegistry.addListener(SetCodescan.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addListener(SetHistory.class, SQLCommand.StmtSubType.G_S_SET_HISTORY);
            CommandRegistry.addListener(SetHighlighting.class, SQLCommand.StmtSubType.G_S_SET_HIGHLIGHTING);
            CommandRegistry.addListener(SetStatusBar.class, SQLCommand.StmtSubType.G_S_SET_STATUSBAR);
            CommandRegistry.addListener(SetEditor.class, SQLCommand.StmtSubType.G_S_SET_EDITOR);
            CommandRegistry.addListener(ShowKeyMap.class, SQLCommand.StmtSubType.G_S_KEYMAP);
            CommandRegistry.addListener(OraDebug.class, SQLCommand.StmtSubType.G_S_ORADEBUG);
            CommandRegistry.addForAllStmtsListener(SetSQLPrompt.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(RepeatSQLBufferCmd.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(RESTCommand.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(Pwd.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addListener(SetExitCommit.class, SQLCommand.StmtSubType.G_S_SET_EXITCOMMIT);
            CommandRegistry.addListener(Set121LongIdentifier.class, SQLCommand.StmtSubType.G_S_SET_IGNORE_SETTING_MODE);
            CommandRegistry.addListener(ShowVersion.class, SQLCommand.StmtSubType.G_S_VERSION);
            CommandRegistry.addListener(ShowDrivers.class, SQLCommand.StmtSubType.G_S_DRIVERS);
            CommandRegistry.addForAllStmtsListener(NLSLANGListener.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(SetWallet.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(ConnectionStoreCommand.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(SecretCommand.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            CommandRegistry.addForAllStmtsListener(OCIMetricsCommand.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
            ShowRegistry.register(ShowEncoding.class);
            ShowRegistry.register(ShowExtensions.class);
            NetCommands.registerCommands();
            SQLCLServices.getInstance().registerServices();
            FormatterServices.getInstance().registerFormatterServices();
        });
        ValidatorServiceLoader.getInstance().registerServices();
        this.setupJLineInCommon();
        SQLPLUSUtil.setProductName(productName);
        this.consoleService.setBellStyle(ConsoleService.BellStyle.OFF);
        this.getScriptRunnerContext().getProperties().put("sqlcl.ihistorycommand", this.createCommandHistory());
        this.consoleService.setEventExpansionDisabled(true);
        StatusBarService statusBar = this.consoleService.getStatusBarService();
        statusBar.setDefaultComponents(Arrays.asList("editmode", "linecol", "username", "dbid"));
        statusBar.setToDefault();
        statusBar.setEnabled(false);
        if (!SQLCliOptions.isBadOption() && SQLCliOptions.isOptionUsed("-proxy") && !SQLCliOptions.isOptionUsed("-cloudconfig")) {
            SQLCliOptions.setBadOption("-proxy");
        }
        if (SQLCliOptions.isBadOption()) {
            if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
                this.getScriptRunnerContext().write(SQLCliOptions.getBadOption() + "\n");
            }
            this.getScriptRunnerContext().setExited(true);
            this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
            this.handleHelp();
            SqlCli.handleExit(this);
        }
        this.reconcileParameterNames();
        if (SQLCliOptions.isOptionUsed("-version")) {
            this.handleVersion();
            SqlCli.handleExit(this);
        } else if (SQLCliOptions.isOptionUsed("-help")) {
            this.handleVersion();
            this.handleHelp();
            SqlCli.handleExit(this);
        } else {
            if (!SQLCliOptions.isOptionUsed("-silent")) {
                try {
                    this.handleBanner();
                    this.handleUpdates();
                    this.getScriptRunnerContext().getOutputStream().flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.getScriptRunnerContext().setSQLPlusConsoleReader(this.createConsoleReader());
            if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
                SqlCli.setTerminalConstraints(this);
            }
            SQLPLUSUtil.setSqlpathProvider(new SQLPlusProviderForSQLPATH());
            this.getScriptRunnerContext().putProperty("script.runner.oraclehomemainthread", TNSHelper.getOracleHome());
            this.getScriptRunnerContext().putProperty("script.runner.sqlpathprovidermainthread", SQLPLUSUtil.getSqlpathProvider().getSQLPATHsetting());
            this.handleDefaultOCIProfiles(this.getScriptRunnerContext());
            this.handleMigrateConnections(this.getScriptRunnerContext());
            this.handleLoginSql(this.getScriptRunnerContext());
            this.handleScriptOption(this.getScriptRunnerContext());
            this.handleAtFiles(this.getScriptRunnerContext());
            this.handleExitInAtFiles();
            this.handleStartupSQL(this.getScriptRunnerContext());
            try {
                this.getScriptRunnerContext().getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.getScriptRunnerContext().removeProperty("SQLCLI_IGNORE_FIRST_LINE");
        this.consoleService.setBellStyle(ConsoleService.BellStyle.AUDIBLE);
    }

    private void handleMigrateConnections(ScriptRunnerContext ctx) {
        if (SQLCliOptions.isOptionUsed("-migrateconns") && PlatformUtils.isWindows()) {
            String userHomeProperty;
            DefaultLoggerWrapper wrapper = DefaultLoggerWrapper.logger(this.getClass());
            Path oldRoot = null;
            if (PlatformUtils.isWindows() && (userHomeProperty = System.getProperty("user.home")) != null) {
                oldRoot = Path.of(userHomeProperty, new String[0]);
            }
            MessageLogger logger = MessageLogger.builder().interactiveLogger(ctx::writeln).errorLogger((MessageLogger.ErrorLogger)wrapper).traceLogger((MessageLogger.TraceLogger)wrapper).build();
            StorageMigrator.migrateConnections((Path)oldRoot, (MessageLogger)logger);
        }
    }

    private void reconcileParameterNames() {
        Set<String> showNames = ShowRegistry.getShowNames();
        ConnectorTypeCache connectorCache = this._ctx.getService(ConnectorTypeCache.class);
        StringBuilder sb = new StringBuilder();
        for (Property<?> property : connectorCache.getProperties()) {
            if (property.getSetType() == SetType.NONE || !showNames.contains(property.getName())) continue;
            sb.append("  ").append(property.getName()).append('\n');
        }
        if (sb.length() > 0) {
            throw new IllegalStateException("The following settable connector properties duplicate SHOW variable names:-\n" + sb.toString());
        }
    }

    private Boolean processLine(String line) {
        line = line.replaceAll("\\xA0+", "");
        this._ctx.getProperties().remove("sqlcl.history.modified.line");
        if (this._runner == null) {
            this._runner = new ScriptExecutor(this._ctx.getCurrentConnection());
            this._runner.setScriptRunnerContext(this._ctx);
        }
        if (this._ctx.getCurrentConnection() != null) {
            this._runner.setConn(this._ctx.getCurrentConnection());
        }
        this._buffer.stopEditing();
        this._runner.setInterrupted(false);
        this._runner.setStmt(line);
        this._runner.run();
        return true;
    }

    private void processOptions(ScriptRunnerContext context) {
        SQLCliHelper.initCliScriptRunnerContext(context);
        context = SQLCliOptions.populateContextWithOptions(context);
        context.setSQLPlusBuffer(this._buffer);
        context.putProperty("sqlcl.clear.screen", "top");
        context.setOutputStreamWrapper(new BufferedOutputStream(System.out));
        if (System.getenv("SQLPLUS_CLASSIC") != null) {
            context.putProperty("sqlplus.classic.mode", Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFile(ScriptExecutor runner, String name, ScriptRunnerContext context, String inputFile) {
        context.putProperty(name, runner);
        context.setTopLevel(false);
        ArrayList scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
        scrArrayList.add(inputFile);
        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
        this._runner.setScriptRunnerContext(context);
        try {
            this._runner.run();
        }
        finally {
            this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
            scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
            if (!scrArrayList.isEmpty()) {
                scrArrayList.remove(scrArrayList.size() - 1);
            }
            this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
            if (!scrArrayList.isEmpty()) {
                SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
            } else {
                SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), SQLPLUSUtil.getProductName(), 0);
            }
        }
        context.setTopLevel(true);
    }

    private void setupJLineInCommon() {
        CommandRegistry.addListener(HelpCmd.class, SQLCommand.StmtSubType.G_S_HELP);
        CommandRegistry.removeListener(SQLCommand.StmtSubType.G_S_PROMPT);
        CommandRegistry.addListener(PromptCmd.class, SQLCommand.StmtSubType.G_S_PROMPT);
        CommandRegistry.addForAllStmtsListener(InfoCmd.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        CommandRegistry.addForAllStmtsListener(SODACmd.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        CommandRegistry.addForAllStmtsListener(OraPKICommand.class, SQLCommand.StmtSubType.G_S_FORALLSTMTS_STMTSUBTYPE);
        ANSIConsoleFormatter.setListPrinter(new AnsiColorListPrinter());
        Info.setListPrinter(new AnsiColorListPrinter());
    }

    protected ScriptRunnerContext getScriptRunnerContext() {
        return this._ctx;
    }

    private void setScriptRunnerContext(ScriptRunnerContext newContext) {
        this._ctx = newContext;
        this._ctx.setSQLPlusBuffer(this._buffer);
        String store = "";
        try {
            store = AnsiRenderer.render((String)this._ctx.getPrompt());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "AnsiRenderer.render(ctx.getPrompt())" + e.getLocalizedMessage());
            store = this._ctx.getPrompt();
        }
        this._ctx.setBasePrompt(store);
    }

    @Override
    public void close() throws IOException {
        this.consoleService.close();
    }

    public void runSqlcl() throws Exception {
        this.initSqlcl();
        String leftOver = "";
        Pattern pattern = Pattern.compile("^(-?\\d+.*)");
        if (!this.consoleService.interactive()) {
            String pipedText = this.consoleService.readPiped();
            if (pipedText.trim().length() > 0) {
                this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.TRUE);
                this.processLine(pipedText);
                this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.FALSE);
            }
        } else {
            String incompleteLine = null;
            this.startupComplete = true;
            while ((this.command = this.consoleService.readCommand(this._ctx.getBasePrompt(), incompleteLine)) != null) {
                SQLCommand incompleteCmd;
                incompleteLine = null;
                String currentLine = this.command.completedLine();
                if (currentLine != null && !currentLine.equals("")) {
                    if (this._buffer.getBuffer().trim().replaceFirst(";", "").length() == 0) {
                        this.processLine("l");
                    } else if (this._buffer.size() == 1 && pattern.matcher(currentLine).matches()) {
                        this.gotoOrChangeLine(currentLine);
                    } else {
                        String s;
                        String line = this._buffer.getBuffer();
                        if (line != null) {
                            this._buffer.startEditing(false);
                        }
                        if ((s = this._buffer.getBuffer()).startsWith("*")) {
                            this.processLine(s + ";\n");
                        } else {
                            Iterator<ISQLCommand> m_parser = SqlParserProvider.getScriptParserIterator(this.getScriptRunnerContext(), new StringReader(s));
                            int commandCount = 0;
                            while ((commandCount <= 0 || !leftOver.equals("")) && m_parser.hasNext()) {
                                ISQLCommand icmd = m_parser.next();
                                Object runWith = icmd.getSQLOrig();
                                ++commandCount;
                                s = s.replaceAll("\\\\r\\\\n", "\n");
                                if (icmd.getSQLOrig().replaceAll("\\\\r\\\\n", "\n").trim().length() <= s.length()) {
                                    leftOver = StringUtils.rtrim(StringUtils.rtrim(s).substring(icmd.getSQLOrig().replaceAll("\\\\r\\\\n", "\n").length()));
                                }
                                if (icmd.getStatementTerminator() != null && !icmd.getStatementTerminator().equals("")) {
                                    String termTrim = icmd.getStatementTerminator().trim();
                                    if (leftOver.startsWith(termTrim)) {
                                        leftOver = leftOver.length() == 1 || leftOver.length() == 0 ? "" : leftOver.substring(1).trim();
                                    }
                                    if (!termTrim.equals("") && !((String)runWith).trim().endsWith(termTrim)) {
                                        if (termTrim.equals("/")) {
                                            runWith = (String)runWith + "\n/\n";
                                        } else if (termTrim.equals(";")) {
                                            runWith = (String)runWith + ";\n";
                                        }
                                    }
                                }
                                this.processLine((String)runWith);
                                if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) break;
                                icmd = null;
                                String terminator = this.getScriptRunnerContext().getProperty("script.runner.sqlcl.sql.terminator").toString();
                                if (icmd != null && icmd.getProperty("terminator") != null) {
                                    terminator = (String)icmd.getProperty("terminator");
                                }
                                Boolean classic = this.getScriptRunnerContext() != null && this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString());
                                if (icmd == null || !icmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL) || !s.trim().endsWith(terminator) || icmd.getStmtSubType() == null || icmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH || !classic.booleanValue()) continue;
                                this.processLine(icmd.getSQLOrig());
                            }
                        }
                    }
                }
                if (this.getScriptRunnerContext().getProperty("script.runner.exit_int") != null) break;
                if (this._buffer.getCurrentLine() <= -1 || this._buffer.getCurrentLine() >= this._buffer.size() && !this._buffer.isEditing()) {
                    if (this._buffer.getCurrentLine() == this._buffer.size() && this._buffer.getLine(this._buffer.getCurrentLine()).trim().equals("") || this.processed) {
                        this._buffer.stopEditing();
                        this._buffer.clear();
                        this.processed = false;
                    } else if (!this._buffer.isEditing()) {
                        this._buffer.clear();
                    }
                }
                if ((incompleteCmd = (SQLCommand)this.getScriptRunnerContext().getProperty("incomplete")) == null) continue;
                incompleteLine = incompleteCmd.getModifiedSQL();
                this.getScriptRunnerContext().removeProperty("incomplete");
            }
        }
    }

    public void usage() {
        this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SqlCli.3"), "-verbose"));
        try {
            this.getScriptRunnerContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

