/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.console.Formatter;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.HistoryService;
import oracle.dbtools.raptor.console.impl.HistoryLogs;
import oracle.dbtools.raptor.console.impl.SqlclHighlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.ReaderUtils;
import org.jline.utils.Log;

public class SqlclHistory
implements History,
HistoryService {
    public static final String HISTORY_MAX_FAILED_SIZE = "history-max-failed-size";
    public static final String DEFAULT_HISTORY_IGNORE = "default-history-ignore";
    public static final String HISTORY_SELECT_FAILS = "history-select-fails";
    public static final String HISTORY_SELECT_LAST_N_DAYS = "history-select-last_n_days";
    public static final String DEFAULT_FILTER = "show, history, connect, conn, conne, connec, clear, secret";
    private SqlclHighlighter highlighter;
    private HistoryLogs historyLogs = new HistoryLogs();
    private LineReader reader;
    private final ArrayList<HistoryItemImpl> items;
    private final List<HistoryItem> unmodifiableItems;
    private int failedCount = 0;
    private int offset = 0;
    private int curIndex = 0;
    private HistoryItem pendingItem = null;
    private Map<String, HistoryFileData> historyFiles = new HashMap<String, HistoryFileData>();
    private boolean removeDuplicates = false;
    private Path lastUsedHistoryFilePath;
    private String lastCompiledFilter;
    private Pattern filterPattern;

    public SqlclHistory() {
        this.items = new ArrayList();
        this.unmodifiableItems = Collections.unmodifiableList(this.items);
    }

    public SqlclHistory reader(LineReaderImpl reader) {
        this.reader = reader;
        this.items.ensureCapacity(this.getMaxItemCount());
        try {
            this.load();
        }
        catch (IOException | IllegalArgumentException e) {
            Log.warn((Object[])new Object[]{"Failed to load history", e});
        }
        return this;
    }

    public SqlclHistory highlighter(SqlclHighlighter highlighter) {
        this.highlighter = highlighter;
        return this;
    }

    public void addAudit(UUID itemUuid, long durationMillis, boolean successful) {
        this.addAudit(itemUuid, null, durationMillis, successful);
    }

    public void addAudit(UUID itemUuid, String modifiedLine, long durationMillis, boolean successful) {
        Objects.requireNonNull(itemUuid);
        int index = this.findIndex(itemUuid);
        if (index >= 0) {
            HistoryItemImpl item = this.items.get(index - this.offset);
            if (modifiedLine != null) {
                item.line = modifiedLine;
            }
            if (item.status == HistoryItem.Status.PENDING) {
                item.setRunAudit(durationMillis, successful);
                if (!successful) {
                    ++this.failedCount;
                }
                this.pendingItem = null;
                this.maybeResize();
                this.saveIfIncremental();
            }
        }
    }

    public HistoryItem getPendingItem() {
        return this.pendingItem;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            History.Entry e = (History.Entry)listIterator.next();
            sb.append(e.toString()).append("\n");
        }
        return sb.toString();
    }

    public void attach(LineReader reader) {
        if (this.reader != reader) {
            Log.warn((Object[])new Object[]{"unable to attach sqlcl history to alternative reader"});
        }
    }

    @Override
    public boolean loadHistory() {
        try {
            this.load();
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"unable to load log file", ex});
            return false;
        }
        return true;
    }

    public void load() throws IOException {
        Path path = this.getHistoryFilePath();
        this.migrate(path);
        this.internalClear();
        this.internalRead(path, false);
    }

    public void read(Path file, boolean incremental) throws IOException {
        Path path = file != null ? file : this.getHistoryFilePath();
        this.internalRead(path, incremental);
    }

    @Override
    public boolean saveHistory() {
        try {
            this.save();
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"unable to save log file", ex});
            return false;
        }
        return true;
    }

    public void save() throws IOException {
        Path path = this.getHistoryFilePath();
        this.internalWrite(path, this.getLastLoaded(path));
    }

    public void write(Path file, boolean incremental) throws IOException {
        Path path;
        Path path2 = path = file != null ? file : this.getHistoryFilePath();
        if (Files.exists(path, new LinkOption[0])) {
            path.toFile().delete();
        }
        this.internalWrite(path, incremental ? this.getLastLoaded(path) : 0);
    }

    public void append(Path file, boolean incremental) throws IOException {
        this.internalWrite(file != null ? file : this.getHistoryFilePath(), incremental ? this.getLastLoaded(file) : 0);
    }

    public void add(Instant time, String line) {
        int index;
        line = SqlRecognizer.reductPwd(line);
        line = SqlRecognizer.reductBTPwd(line);
        Objects.requireNonNull(time);
        Objects.requireNonNull(line);
        this.pendingItem = null;
        if (this.isDisabled()) {
            return;
        }
        if (ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_IGNORE_SPACE) && line.startsWith(" ")) {
            return;
        }
        if (this.isReduceBlanks()) {
            line = line.trim();
        }
        if (this.isFiltered(line)) {
            return;
        }
        this.honourRemoveDuplicates();
        int numberOfOccurances = 1;
        if (this.removeDuplicates && (index = this.findFirstIndex(line)) >= 0) {
            numberOfOccurances = 1 + this.getItem(index).getNumberOfOccurances();
            this.removeItemAt(index - this.offset);
        }
        HistoryItemImpl item = this.createNewHistoryItem(this.offset + this.items.size(), time, line, numberOfOccurances);
        this.items.add(item);
        this.pendingItem = item;
        this.maybeResize();
    }

    @Override
    public boolean purgeHistory() {
        try {
            this.purge();
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"unable to purge log file", ex});
            return false;
        }
        return true;
    }

    public void purge() throws IOException {
        this.internalClear();
        Path path = this.getHistoryFilePath();
        Log.trace((Object[])new Object[]{"Purging history from: ", path});
        Files.deleteIfExists(path);
    }

    @Override
    public boolean removeItem(int index) {
        int relIndex = index - this.offset;
        if (relIndex >= this.items.size() || relIndex < 0) {
            throw new IllegalArgumentException("IndexOutOfBounds: Index:" + relIndex + ", Size:" + this.items.size());
        }
        final HistoryItem item = this.items.get(relIndex);
        if (item.status() == HistoryItem.Status.PENDING) {
            return false;
        }
        List<1> logRows = Collections.singletonList(new HistoryLogs.LogRow(){

            @Override
            public UUID uuid() {
                return item.uuid();
            }

            @Override
            public long timeMillis() {
                return item.time().toEpochMilli();
            }

            @Override
            public long durationMillis() {
                return item.getDurationMillis();
            }

            @Override
            public HistoryLogs.LogRowStatus status() {
                return HistoryLogs.LogRowStatus.REMOVED;
            }

            @Override
            public String line() {
                return item.line();
            }
        });
        try {
            this.historyLogs.write(this.getHistoryFilePath(), logRows.iterator());
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"error writing log row", ex});
            return false;
        }
        this.removeItemAt(relIndex);
        return true;
    }

    @Override
    public String get(int index) {
        return this.getItem(index).line();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int index() {
        return this.offset + this.curIndex;
    }

    @Override
    public int first() {
        return this.offset;
    }

    @Override
    public int last() {
        return this.offset + this.items.size() - 1;
    }

    public ListIterator<History.Entry> iterator(int index) {
        return this.items.listIterator(index - this.offset);
    }

    public Spliterator<History.Entry> spliterator() {
        return this.items.spliterator();
    }

    public void resetIndex() {
        if (this.curIndex > this.items.size()) {
            this.curIndex = this.items.size();
        }
    }

    public boolean moveToLast() {
        int lastEntry = this.size() - 1;
        if (lastEntry >= 0 && lastEntry != this.curIndex) {
            this.curIndex = this.size() - 1;
            return true;
        }
        return false;
    }

    public boolean moveTo(int index) {
        int relIndex = index - this.offset;
        if (relIndex >= 0 && relIndex < this.size()) {
            this.curIndex = relIndex;
            return true;
        }
        return false;
    }

    public boolean moveToFirst() {
        if (this.size() > 0 && this.curIndex != 0) {
            this.curIndex = 0;
            return true;
        }
        return false;
    }

    public void moveToEnd() {
        this.curIndex = this.size();
    }

    public String current() {
        if (this.curIndex >= this.size()) {
            return "";
        }
        return this.items.get(this.curIndex).line();
    }

    public boolean previous() {
        if (this.curIndex <= 0) {
            return false;
        }
        --this.curIndex;
        return true;
    }

    public boolean next() {
        if (this.curIndex >= this.size()) {
            return false;
        }
        ++this.curIndex;
        return true;
    }

    @Override
    public Path getHistoryFilePath() {
        String appData;
        Path path = null;
        String file = ReaderUtils.getString((LineReader)this.reader, (String)"history-file", null);
        if (file instanceof Path) {
            path = (Path)((Object)file);
        } else if (file instanceof File) {
            path = ((File)((Object)file)).toPath();
        } else if (file != null) {
            path = Paths.get(file.toString(), new String[0]);
        } else if (PlatformUtils.isWindows() && (appData = System.getenv("APPDATA")) != null) {
            path = Paths.get(appData, "sqlcl", "history.log");
        }
        if (path == null) {
            path = Paths.get(System.getProperty("user.home"), ".sqlcl", "history.log");
        }
        if (!Files.isDirectory(path.getParent(), new LinkOption[0])) {
            path = Paths.get("history.log", new String[0]);
        }
        if (!path.equals(this.lastUsedHistoryFilePath) && this.isIncremental()) {
            try {
                this.internalWrite(path, this.getLastLoaded(path));
                this.lastUsedHistoryFilePath = path;
            }
            catch (IOException e) {
                Log.warn((Object[])new Object[]{"Failed to save history", e});
            }
        }
        return path;
    }

    @Override
    public void setHistoryFilePath(Path newValue) {
        this.reader.setVariable("history-file", (Object)newValue);
    }

    @Override
    public boolean isDisabled() {
        return ReaderUtils.getBoolean((LineReader)this.reader, (String)"disable-history", (boolean)false);
    }

    @Override
    public void setDisabled(boolean newValue) {
        this.reader.setVariable("disable-history", (Object)newValue);
    }

    @Override
    public boolean isReduceBlanks() {
        return ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_REDUCE_BLANKS);
    }

    @Override
    public void setReduceBlanks(boolean newValue) {
        if (newValue) {
            this.reader.setOpt(LineReader.Option.HISTORY_REDUCE_BLANKS);
        } else {
            this.reader.unsetOpt(LineReader.Option.HISTORY_REDUCE_BLANKS);
        }
    }

    @Override
    public boolean isIncremental() {
        return ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_INCREMENTAL);
    }

    @Override
    public void setIncremental(boolean newValue) {
        if (newValue) {
            this.reader.setOpt(LineReader.Option.HISTORY_INCREMENTAL);
        } else {
            this.reader.unsetOpt(LineReader.Option.HISTORY_INCREMENTAL);
        }
        this.honourSettings();
    }

    @Override
    public boolean isRemoveDuplicates() {
        return ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_IGNORE_DUPS);
    }

    @Override
    public void setRemoveDuplicates(boolean newValue) {
        if (newValue) {
            this.reader.setOpt(LineReader.Option.HISTORY_IGNORE_DUPS);
        } else {
            this.reader.unsetOpt(LineReader.Option.HISTORY_IGNORE_DUPS);
        }
        this.honourSettings();
    }

    @Override
    public int getMaxItemCount() {
        return ReaderUtils.getInt((LineReader)this.reader, (String)"history-size", (int)500);
    }

    @Override
    public void setMaxItemCount(int newValue) {
        this.reader.setVariable("history-size", (Object)newValue);
        this.honourSettings();
    }

    @Override
    public int getMaxFailedItemCount() {
        return ReaderUtils.getInt((LineReader)this.reader, (String)HISTORY_MAX_FAILED_SIZE, (int)50);
    }

    @Override
    public void setMaxFailedItemCount(int newValue) {
        this.reader.setVariable(HISTORY_MAX_FAILED_SIZE, (Object)newValue);
        this.honourSettings();
    }

    @Override
    public int getMaxFileItemCount() {
        return ReaderUtils.getInt((LineReader)this.reader, (String)"history-file-size", (int)10000);
    }

    @Override
    public void setMaxFileItemCount(int newValue) {
        this.reader.setVariable("history-file-size", (Object)newValue);
        this.honourSettings();
    }

    @Override
    public String getFilter() {
        return ReaderUtils.getString((LineReader)this.reader, (String)"history-ignore", (String)DEFAULT_FILTER);
    }

    @Override
    public void setFilter(String newValue) {
        this.reader.setVariable("history-ignore", (Object)newValue);
    }

    @Override
    public String getDefaultFilter() {
        return ReaderUtils.getString((LineReader)this.reader, (String)DEFAULT_HISTORY_IGNORE, (String)DEFAULT_FILTER);
    }

    @Override
    public void setDefaultFilter(String newValue) {
        this.reader.setVariable(DEFAULT_HISTORY_IGNORE, (Object)newValue);
    }

    @Override
    public void setSelectFails(boolean newValue) {
        this.reader.setVariable(HISTORY_SELECT_FAILS, (Object)newValue);
    }

    @Override
    public boolean isSelectFails() {
        return ReaderUtils.getBoolean((LineReader)this.reader, (String)HISTORY_SELECT_FAILS, (boolean)false);
    }

    @Override
    public void setSelectLastNDays(int newValue) {
        this.reader.setVariable(HISTORY_SELECT_LAST_N_DAYS, (Object)newValue);
    }

    @Override
    public int getSelectLastNDays() {
        return ReaderUtils.getInt((LineReader)this.reader, (String)HISTORY_SELECT_LAST_N_DAYS, (int)-1);
    }

    @Override
    public void honourSettings() {
        this.saveIfIncremental();
        this.maybeResize();
    }

    @Override
    public boolean honourFileSettings() {
        return this.honourFileSettings(null);
    }

    @Override
    public boolean honourFileSettings(Path file) {
        Path path = file != null ? file : this.getHistoryFilePath();
        try {
            this.trimHistory(path, this.getMaxFileItemCount());
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"unable to trim log file", ex});
            return false;
        }
        return true;
    }

    @Override
    public List<HistoryItem> getItems() {
        return this.unmodifiableItems;
    }

    @Override
    public HistoryItem getItem(int index) {
        int relIndex = index - this.offset;
        if (relIndex >= this.items.size() || relIndex < 0) {
            throw new IllegalArgumentException("IndexOutOfBounds: Index:" + relIndex + ", Size:" + this.items.size());
        }
        return this.items.get(relIndex);
    }

    @Override
    public int findFirstIndex(String line) {
        line = line.trim();
        for (int relIndex = this.items.size() - 1; relIndex >= 0; --relIndex) {
            HistoryItem item = this.items.get(relIndex);
            if (!item.line().trim().equals(line)) continue;
            return relIndex + this.offset;
        }
        return -1;
    }

    @Override
    public int findIndex(int itemIndex) {
        for (int relIndex = this.items.size() - 1; relIndex >= 0; --relIndex) {
            HistoryItemImpl item = this.items.get(relIndex);
            if (item.index() != itemIndex) continue;
            return relIndex + this.offset;
        }
        return -1;
    }

    @Override
    public int findIndex(UUID uuid) {
        for (int relIndex = this.items.size() - 1; relIndex >= 0; --relIndex) {
            HistoryItemImpl item = this.items.get(relIndex);
            if (item.uuid() != uuid) continue;
            return relIndex + this.offset;
        }
        return -1;
    }

    @Override
    public void clearCurrentSessionFlags() {
        for (HistoryItemImpl item : this.items) {
            item.setCurrentSession(false);
        }
    }

    @Override
    public void resetFilter() {
        this.setFilter(this.getDefaultFilter());
    }

    @Override
    public List<String> getMultiline(int index) {
        return this.getItem(index).getMultiline();
    }

    @Override
    public String formatHistory(Formatter formatter) {
        StringBuilder buffer = new StringBuilder();
        int terminalWidth = this.reader.getTerminal().getWidth();
        Formatter.Context context = this.createFormatterContext(buffer, terminalWidth);
        ArrayList<HistoryItem> filteredItems = new ArrayList<HistoryItem>(this.items.size());
        for (HistoryItem historyItem : this.items) {
            if (!formatter.filter(context, historyItem)) continue;
            filteredItems.add(historyItem);
            formatter.prepare(context, historyItem);
        }
        int[] index = new int[]{1};
        formatter.writeHeader(context);
        for (HistoryItem item : filteredItems) {
            formatter.writeRow(context, index[0], item);
            index[0] = index[0] + 1;
        }
        formatter.writeFooter(context);
        return buffer.toString();
    }

    @Override
    public List<HistoryItem> selectItems(BiPredicate<HistoryService, HistoryItem> predicate) {
        return this.items.stream().filter(item -> predicate.test(this, (HistoryItem)item)).collect(Collectors.toList());
    }

    private void migrate(Path path) throws IOException {
        try {
            this.historyLogs.migrate(path);
        }
        catch (IOException ex) {
            Log.debug((Object[])new Object[]{"Failed to migrate history", ex});
            throw ex;
        }
    }

    private void saveIfIncremental() {
        if (this.isIncremental()) {
            try {
                this.save();
            }
            catch (IOException e) {
                Log.warn((Object[])new Object[]{"Failed to save history", e});
            }
        }
    }

    private void internalRead(Path path, boolean incremental) throws IOException {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Log.trace((Object[])new Object[]{"Reading history from: ", path});
                boolean timestamped = ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_TIMESTAMPED);
                HashSet<UUID> excludedUuids = new HashSet<UUID>();
                for (HistoryItemImpl item : this.items) {
                    if (!item.isCurrentSession()) continue;
                    excludedUuids.add(item.uuid());
                }
                int[] rowCount = new int[]{0};
                this.historyLogs.read(path, logRow -> {
                    rowCount[0] = rowCount[0] + 1;
                    this.addLoadedHistoryItem(logRow, excludedUuids, incremental, timestamped);
                });
                this.maybeResize();
                this.setHistoryFileData(path, new HistoryFileData(this.items.size(), rowCount[0]));
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            Log.debug((Object[])new Object[]{"Failed to read history; clearing", ex});
            this.internalClear();
            throw ex;
        }
    }

    private void internalWrite(Path path, int from) throws IOException {
        if (path != null) {
            Log.trace((Object[])new Object[]{"Writing history to: ", path});
            Path parent = path.toAbsolutePath().getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                FileUtils.createSecureDirectories(path, false);
            }
            this.historyLogs.write(path, this.createLogRowIterator(this.items.subList(from, this.items.size())));
            this.incEntriesInFile(path, this.items.size() - from);
            int max = this.getMaxFileItemCount();
            if (this.getEntriesInFile(path) > max + max / 4) {
                this.trimHistory(path, max);
            }
        }
        this.setLastLoaded(path, this.items.size());
    }

    private void trimHistory(Path path, int max) throws IOException {
        Log.trace((Object[])new Object[]{"Trimming history path: ", path});
        ArrayList<HistoryItemImpl> allItems = new ArrayList<HistoryItemImpl>();
        boolean timestamped = ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_TIMESTAMPED);
        HashSet excludedUuids = new HashSet();
        this.historyLogs.read(path, logRow -> this.addHistoryItemTo(allItems, logRow, excludedUuids, timestamped));
        this.removeDuplicates(allItems, relIndex -> allItems.remove((int)relIndex));
        while (allItems.size() > max) {
            allItems.remove(0);
        }
        Path temp = Files.createTempFile(path.toAbsolutePath().getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        this.historyLogs.write(temp, this.createLogRowIterator(allItems));
        Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        if (this.isLineReaderHistory(path)) {
            this.reconcileSessionFlags(allItems);
            this.internalClear();
            this.offset = ((HistoryItemImpl)allItems.get(0)).index();
            this.items.addAll(allItems);
            this.maybeResize();
            this.setHistoryFileData(path, new HistoryFileData(this.items.size(), this.items.size()));
        } else {
            this.setEntriesInFile(path, allItems.size());
        }
    }

    private void reconcileSessionFlags(List<HistoryItemImpl> allItems) {
        HashSet<UUID> sessionUuids = new HashSet<UUID>();
        for (HistoryItemImpl item : this.items) {
            if (!item.isCurrentSession()) continue;
            sessionUuids.add(item.uuid());
        }
        for (HistoryItemImpl item : allItems) {
            if (!sessionUuids.contains(item.uuid())) continue;
            item.setCurrentSession(true);
        }
    }

    private void internalClear() {
        this.offset = 0;
        this.curIndex = 0;
        this.historyFiles = new HashMap<String, HistoryFileData>();
        this.items.clear();
    }

    private Iterator<HistoryLogs.LogRow> createLogRowIterator(List<HistoryItemImpl> items) {
        final boolean timestamped = ReaderUtils.isSet((LineReader)this.reader, (LineReader.Option)LineReader.Option.HISTORY_TIMESTAMPED);
        List filteredItems = items.stream().filter(item -> item.status() != HistoryItem.Status.PENDING).collect(Collectors.toList());
        final Iterator filteredItemIterator = filteredItems.iterator();
        return new Iterator<HistoryLogs.LogRow>(){

            @Override
            public boolean hasNext() {
                return filteredItemIterator.hasNext();
            }

            @Override
            public HistoryLogs.LogRow next() {
                final HistoryItem item = (HistoryItem)filteredItemIterator.next();
                return new HistoryLogs.LogRow(){

                    @Override
                    public long timeMillis() {
                        return timestamped ? item.time().toEpochMilli() : -1L;
                    }

                    @Override
                    public String line() {
                        return item.line();
                    }

                    @Override
                    public UUID uuid() {
                        return item.uuid();
                    }

                    @Override
                    public long durationMillis() {
                        return item.getDurationMillis();
                    }

                    @Override
                    public HistoryLogs.LogRowStatus status() {
                        return item.status() == HistoryItem.Status.SUCCESS ? HistoryLogs.LogRowStatus.SUCCEEDED : HistoryLogs.LogRowStatus.FAILED;
                    }
                };
            }
        };
    }

    private boolean isFiltered(String line) {
        String newFilter = this.getFilter();
        if (!newFilter.equals(this.lastCompiledFilter)) {
            this.filterPattern = this.compileFilter(newFilter);
            this.lastCompiledFilter = newFilter;
        }
        return this.filterPattern != null ? this.filterPattern.matcher(line).matches() : false;
    }

    private Pattern compileFilter(String filter) {
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < filter.length(); ++i) {
            char ch = filter.charAt(i);
            switch (ch) {
                case '\\': {
                    ch = filter.charAt(++i);
                    sb.append(ch);
                    continue block5;
                }
                case ',': 
                case ':': {
                    sb.append("($|\\s*-\\s*.*|\\s+.*)|");
                    while (i < filter.length() - 1 && filter.charAt(i + 1) == ' ') {
                        ++i;
                    }
                    continue block5;
                }
                case '*': {
                    sb.append('.').append('*');
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("($|\\s*-\\s*.*|\\s+.*)");
        String regex = sb.toString();
        return Pattern.compile(regex, 2);
    }

    private void maybeResize() {
        this.honourRemoveDuplicates();
        int relIndex = 0;
        while (this.failedCount > this.getMaxFailedItemCount() && relIndex < this.items.size()) {
            HistoryItemImpl item = this.items.get(relIndex);
            if (item.status() == HistoryItem.Status.ERROR) {
                this.removeItemAt(relIndex);
                --this.failedCount;
                continue;
            }
            ++relIndex;
        }
        while (this.size() > this.getMaxItemCount()) {
            this.removeItemAt(0);
        }
        this.curIndex = this.size();
    }

    private void honourRemoveDuplicates() {
        boolean newRemoveDuplicates = this.isRemoveDuplicates();
        if (newRemoveDuplicates != this.removeDuplicates) {
            this.removeDuplicates = newRemoveDuplicates;
            if (newRemoveDuplicates) {
                this.removeDuplicates(this.items, relIndex -> this.removeItemAt((int)relIndex));
            }
        }
    }

    private void removeDuplicates(List<? extends HistoryItem> from, Consumer<Integer> remover) {
        for (int index = 0; index < from.size(); ++index) {
            int reverseIndex = from.size() - index - 1;
            String line = from.get(reverseIndex--).line().trim();
            while (reverseIndex >= 0) {
                String l = from.get(reverseIndex).line();
                if (line.equals(l.trim())) {
                    remover.accept(reverseIndex);
                }
                --reverseIndex;
            }
        }
    }

    private void addLoadedHistoryItem(HistoryLogs.LogRow logRow, Set<UUID> excludedUuids, boolean checkDuplicates, boolean timestamped) {
        UUID uuid = logRow.uuid();
        if (excludedUuids.contains(uuid)) {
            return;
        }
        if (logRow.status() == HistoryLogs.LogRowStatus.REMOVED) {
            excludedUuids.add(logRow.uuid());
            return;
        }
        String line = logRow.line();
        if (checkDuplicates) {
            String trimmedLine = line.trim();
            for (HistoryItemImpl item : this.items) {
                if (!item.line().trim().equals(trimmedLine)) continue;
                return;
            }
        }
        Instant time = timestamped ? (logRow.timeMillis() >= 0L ? Instant.ofEpochMilli(logRow.timeMillis()) : Instant.now()) : null;
        HistoryItemImpl item = this.createLoadedHistoryItem(this.offset + this.items.size(), time, line, uuid, logRow.durationMillis(), logRow.status() == HistoryLogs.LogRowStatus.SUCCEEDED);
        this.items.add(item);
        excludedUuids.add(uuid);
    }

    private void addHistoryItemTo(List<HistoryItemImpl> toItems, HistoryLogs.LogRow logRow, Set<UUID> excludedUuids, boolean timestamped) {
        if (logRow.status() == HistoryLogs.LogRowStatus.REMOVED) {
            excludedUuids.add(logRow.uuid());
            return;
        }
        Instant time = timestamped ? (logRow.timeMillis() >= 0L ? Instant.ofEpochMilli(logRow.timeMillis()) : Instant.now()) : null;
        HistoryItemImpl item = this.createLoadedHistoryItem(this.offset + this.items.size(), time, logRow.line(), logRow.uuid(), logRow.durationMillis(), logRow.status() == HistoryLogs.LogRowStatus.SUCCEEDED);
        toItems.add(item);
    }

    private void removeItemAt(int relIndex) {
        this.items.remove(relIndex);
        ++this.offset;
        this.historyFiles.values().forEach(hfd -> {
            if (hfd.getLastLoaded() >= relIndex) {
                hfd.decLastLoaded();
            }
        });
    }

    private Formatter.Context createFormatterContext(final StringBuilder buffer, final int terminalWidth) {
        return new Formatter.Context(){

            @Override
            public void append(String text) {
                buffer.append(text);
            }

            @Override
            public void append(char text) {
                buffer.append(text);
            }

            @Override
            public int getTerminalWidth() {
                return terminalWidth;
            }

            @Override
            public int length() {
                return buffer.length();
            }

            @Override
            public char charAt(int index) {
                return buffer.charAt(index);
            }

            @Override
            public boolean isSelectFailsDefault() {
                return SqlclHistory.this.isSelectFails();
            }

            @Override
            public String highlightText(String text) {
                return SqlclHistory.this.highlighter.highlightText(text);
            }
        };
    }

    private boolean isLineReaderHistory(Path path) throws IOException {
        return Files.isSameFile(this.getHistoryFilePath(), path);
    }

    private void setLastLoaded(Path path, int lastloaded) {
        this.getHistoryFileData(path).setLastLoaded(lastloaded);
    }

    private void setEntriesInFile(Path path, int entriesInFile) {
        this.getHistoryFileData(path).setEntriesInFile(entriesInFile);
    }

    private void incEntriesInFile(Path path, int amount) {
        this.getHistoryFileData(path).incEntriesInFile(amount);
    }

    private int getLastLoaded(Path path) {
        return this.getHistoryFileData(path).getLastLoaded();
    }

    private int getEntriesInFile(Path path) {
        return this.getHistoryFileData(path).getEntriesInFile();
    }

    private HistoryFileData getHistoryFileData(Path path) {
        String key = this.doHistoryFileDataKey(path);
        if (!this.historyFiles.containsKey(key)) {
            this.historyFiles.put(key, new HistoryFileData());
        }
        return this.historyFiles.get(key);
    }

    private void setHistoryFileData(Path path, HistoryFileData historyFileData) {
        this.historyFiles.put(this.doHistoryFileDataKey(path), historyFileData);
    }

    private String doHistoryFileDataKey(Path path) {
        return path != null ? path.toAbsolutePath().toString() : null;
    }

    private HistoryItemImpl createNewHistoryItem(int index, Instant time, String line, int numberOfOccurances) {
        return new HistoryItemImpl(index, time, line, UUID.randomUUID(), numberOfOccurances, -1L, HistoryItem.Status.PENDING, true);
    }

    private HistoryItemImpl createLoadedHistoryItem(int index, Instant time, String line, UUID uuid, long durationMillis, boolean successful) {
        return new HistoryItemImpl(index, time, line, uuid, 1, durationMillis, successful ? HistoryItem.Status.SUCCESS : HistoryItem.Status.ERROR, false);
    }

    private class HistoryItemImpl
    implements HistoryItem,
    History.Entry {
        private final int index;
        private final Instant time;
        private final UUID uuid;
        private final int numberOfOccurances;
        private String line;
        private long durationMillis;
        private HistoryItem.Status status;
        private boolean currentSession;

        private HistoryItemImpl(int index, Instant time, String line, UUID uuid, int numberOfOccurances, long durationMillis, HistoryItem.Status status, boolean currentSession) {
            this.index = index;
            this.time = time;
            this.line = line;
            this.uuid = uuid;
            this.numberOfOccurances = numberOfOccurances;
            this.durationMillis = durationMillis;
            this.status = status;
            this.currentSession = currentSession;
        }

        private void setCurrentSession(boolean currentSession) {
            this.currentSession = currentSession;
        }

        private void setRunAudit(long durationMillis, boolean successful) {
            this.durationMillis = durationMillis;
            this.status = successful ? HistoryItem.Status.SUCCESS : HistoryItem.Status.ERROR;
        }

        public String toString() {
            return String.format("%d: %s", this.index, this.line);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Instant time() {
            return this.time;
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public UUID uuid() {
            return this.uuid;
        }

        @Override
        public HistoryItem.Status status() {
            return this.status;
        }

        @Override
        public long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        public int getNumberOfOccurances() {
            return this.numberOfOccurances;
        }

        @Override
        public boolean isCurrentSession() {
            return this.currentSession;
        }
    }

    private class HistoryFileData {
        private int lastLoaded = 0;
        private int entriesInFile = 0;

        private HistoryFileData() {
        }

        private HistoryFileData(int lastLoaded, int entriesInFile) {
            this.lastLoaded = lastLoaded;
            this.entriesInFile = entriesInFile;
        }

        private int getLastLoaded() {
            return this.lastLoaded;
        }

        private void setLastLoaded(int lastLoaded) {
            this.lastLoaded = lastLoaded;
        }

        private void decLastLoaded() {
            --this.lastLoaded;
            if (this.lastLoaded < 0) {
                this.lastLoaded = 0;
            }
        }

        private int getEntriesInFile() {
            return this.entriesInFile;
        }

        private void setEntriesInFile(int entriesInFile) {
            this.entriesInFile = entriesInFile;
        }

        private void incEntriesInFile(int amount) {
            this.entriesInFile += amount;
        }
    }
}

