/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.File;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class SqlclFileNameCompleter
implements Completer {
    private final ScriptRunnerContext _ctx;
    private final Completer jlineCompleter = new Completers.FileNameCompleter();

    SqlclFileNameCompleter(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public void complete(LineReader reader, ParsedLine pl, List<Candidate> list) {
        List words = pl.words();
        if (!words.isEmpty()) {
            String firstWord;
            switch (firstWord = ((String)words.get(0)).trim().toLowerCase()) {
                case "@": 
                case "!": 
                case "@@": {
                    if (pl.wordIndex() == 0) {
                        list.add(new Candidate(firstWord));
                        break;
                    }
                    this.invokeCompleter(reader, pl, list);
                    break;
                }
                case "start": 
                case "host": 
                case "load": 
                case "cd": 
                case "get": 
                case "save": 
                case "store": {
                    this.invokeCompleter(reader, pl, list);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCompleter(LineReader reader, ParsedLine pl, List<Candidate> list) {
        boolean setUserDir;
        String userDir = System.getProperty("user.dir");
        String cdPath = this.getCdPath();
        boolean bl = setUserDir = cdPath != null && !cdPath.equals(userDir);
        if (setUserDir) {
            System.setProperty("user.dir", cdPath);
        }
        try {
            this.jlineCompleter.complete(reader, pl, list);
        }
        finally {
            if (setUserDir) {
                System.setProperty("user.dir", userDir);
            }
        }
    }

    private String getCdPath() {
        String[] pathArray;
        String cdPath = null;
        Object pathProperty = this._ctx.getProperty("script.runner.cd_command");
        if (pathProperty != null && (pathArray = pathProperty.toString().split(File.pathSeparator)).length > 0) {
            cdPath = pathArray[0];
        }
        return cdPath;
    }
}

