/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import oracle.dbtools.raptor.console.impl.KeyMapHelp;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.LineReader;
import org.jline.reader.Reference;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;

public class KeyMapSupplier {
    private final LineReader reader;
    private final Map<String, String> specialKeyTranslations = new HashMap<String, String>();
    private final Set<String> undocumentedTags = new HashSet<String>();
    private final Set<String> ignoredKeyTranslations = new HashSet<String>();

    public KeyMapSupplier(LineReader reader) {
        this.reader = reader;
        this.defineSpecialKeySequences();
        this.defineUndocumentedTags();
    }

    public void supply(String keyMapName, Consumer<KeyMapEntry> consumer) {
        KeyMap keyMap = (KeyMap)this.reader.getKeyMaps().get(keyMapName);
        Map boundKeys = keyMap.getBoundKeys();
        for (String keySequence : boundKeys.keySet()) {
            Binding binding = (Binding)boundKeys.get(keySequence);
            String translatedKeySequence = this.translateKeySequence(keySequence);
            if (this.ignoredKeyTranslations.contains(translatedKeySequence)) continue;
            Object tag = null;
            if (binding instanceof Reference) {
                Reference reference = (Reference)binding;
                if (!"self-insert".equals(reference.name()) && !"cl-null-widget".equals(reference.name())) {
                    tag = reference.name();
                }
            } else {
                tag = "key_" + translatedKeySequence;
            }
            if (tag == null || this.undocumentedTags.contains(tag)) continue;
            String doc = KeyMapHelp.getString((String)tag);
            consumer.accept(this.createKeyMapEntry(keySequence.getBytes(), translatedKeySequence, (String)tag, doc));
        }
    }

    private String translateKeySequence(String keySequence) {
        String specialKey = this.specialKeyTranslations.get(keySequence);
        if (specialKey != null) {
            return specialKey;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keySequence.length(); ++i) {
            char key = keySequence.charAt(i);
            char code = key;
            if (code == ' ') {
                sb.append("<SP>");
                continue;
            }
            if (code == '\u001b') {
                sb.append("<ESC>");
                continue;
            }
            if (code == '\u007f') {
                sb.append("<DEL>");
                continue;
            }
            if (code < ' ') {
                sb.append("^").append((char)(64 + code));
                continue;
            }
            sb.append(key);
        }
        return sb.toString();
    }

    private void defineSpecialKeySequences() {
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_up), "<UP>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_down), "<DOWN>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_left), "<LEFT>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_right), "<RIGHT>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_home), "<HOME>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_end), "<END>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_dc), "<DC>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_dl), "<DL>");
        this.addSpecialKeySequence(this.key(InfoCmp.Capability.key_ic), "<IC>");
        this.addSpecialKeySequence(KeyMap.translate((String)"^[[1;5C"), "^<LEFT>");
        this.addSpecialKeySequence(KeyMap.translate((String)"^[[1;5D"), "^<RIGHT>");
        this.addSpecialKeySequence(KeyMap.alt((String)this.key(InfoCmp.Capability.key_right)), "<ESC><RIGHT>");
        this.addSpecialKeySequence(KeyMap.alt((String)this.key(InfoCmp.Capability.key_left)), "<ESC><LEFT>");
        this.ignoredKeyTranslations.add("<ESC>[3;5~");
    }

    private String key(InfoCmp.Capability capability) {
        return KeyMap.key((Terminal)this.reader.getTerminal(), (InfoCmp.Capability)capability);
    }

    private void addSpecialKeySequence(String keySequence, String keyName) {
        if (keySequence != null) {
            this.specialKeyTranslations.put(keySequence, keyName);
        }
    }

    private void defineUndocumentedTags() {
        this.undocumentedTags.add("insert-close-paren");
        this.undocumentedTags.add("insert-close-square");
        this.undocumentedTags.add("insert-close-curly");
        this.undocumentedTags.add("accept-line");
        this.undocumentedTags.add("accept-and-hold");
        this.undocumentedTags.add("accept-line-and-down-history");
        this.undocumentedTags.add("do-lowercase-version");
        this.undocumentedTags.add("edit-and-execute-command");
        this.undocumentedTags.add("infer-next-history");
        this.undocumentedTags.add("terminal-focus-in");
        this.undocumentedTags.add("terminal-focus-out");
        this.undocumentedTags.add("history-incremental-search-backward");
        this.undocumentedTags.add("history-incremental-search-forward");
        this.undocumentedTags.add("history-search-backward");
        this.undocumentedTags.add("history-search-forward");
        this.undocumentedTags.add("vi-history-search-backward");
        this.undocumentedTags.add("vi-history-search-forward");
        this.undocumentedTags.add("vi-repeat-search");
        this.undocumentedTags.add("vi-rev-repeat-search");
        this.undocumentedTags.add("vi-fetch-history");
        this.undocumentedTags.add("character-search");
        this.undocumentedTags.add("character-search-backward");
        this.undocumentedTags.add("begin-paste");
        this.undocumentedTags.add("self-insert-unmeta");
        this.undocumentedTags.add("reverse-menu-complete");
        this.undocumentedTags.add("put-replace-selection");
        this.undocumentedTags.add("vi-replace");
        this.undocumentedTags.add("vi-substitute");
        this.undocumentedTags.add("vi-goto-column");
        this.undocumentedTags.add("vi-insert-comment");
        this.undocumentedTags.add("vi-digit-or-beginning-of-line");
        this.undocumentedTags.add("vi-repeat-change");
        this.undocumentedTags.add("vi-oper-swap-case");
        this.undocumentedTags.add("beginning-of-history");
        this.undocumentedTags.add("end-of-history");
        this.undocumentedTags.add("key_<ESC>OP");
        this.undocumentedTags.add("key_<ESC>OQ");
        this.undocumentedTags.add("key_<ESC>OR");
        this.undocumentedTags.add("key_<ESC>OS");
        this.undocumentedTags.add("key_<ESC>OE");
        this.undocumentedTags.add("key_<ESC>OM");
        this.undocumentedTags.add("<MOUSE>");
        this.undocumentedTags.add("cl-collect-garbage");
        this.undocumentedTags.add("cl-end-paste");
        Stream.of(InfoCmp.Capability.values()).filter(c -> c.name().startsWith("key_")).map(this::key).forEach(k -> {
            if (k != null && !this.specialKeyTranslations.containsKey(k) && k.startsWith(new String(new byte[]{27, 91}))) {
                this.undocumentedTags.add("key_" + this.translateKeySequence((String)k));
            }
        });
    }

    private KeyMapEntry createKeyMapEntry(final byte[] keySequence, final String translatedKeySequence, final String tag, final String doc) {
        return new KeyMapEntry(){

            @Override
            public byte[] getKeySequence() {
                return keySequence;
            }

            @Override
            public String getTranslatedKeySeq() {
                return translatedKeySequence;
            }

            @Override
            public String getTag() {
                return tag;
            }

            @Override
            public String getDoc() {
                return doc;
            }
        };
    }

    public static interface KeyMapEntry {
        public byte[] getKeySequence();

        public String getTranslatedKeySeq();

        public String getTag();

        public String getDoc();
    }
}

