/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.save;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.util.ConnectionManagementUtil;
import oracle.dbtools.db.ConnectionSaveHandler;
import oracle.dbtools.plusplus.connections.db.ConnectionDetailDisplay;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.DatabaseProviderImporter;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.save.DatabaseProviderFactory;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;

public final class SharedConnectionSaveHandler
implements ConnectionSaveHandler {
    private final ScriptRunnerContext ctx;
    private final String name;
    private final boolean replace;
    private final boolean savePwd;
    private final ExistingConnections existingConnections;
    private final Refresher refresher;
    private final ConnectorType connectorType;

    public static ConnectionSaveHandler createPersistor(ScriptRunnerContext ctx, ExistingConnections existingConnections, PropertyValues props, ConnectorType connectorType, Refresher refreshAction) {
        String name = ConnectionSaveHandler.getName(props);
        ConnectionSaveHandler persistor = name == null ? ConnectionSaveHandler.createDefaultHandler(props) : new SharedConnectionSaveHandler(ctx, name, ConnectionSaveHandler.replace(props), ConnectionSaveHandler.savePwd(props), existingConnections, connectorType, refreshAction);
        return persistor;
    }

    private SharedConnectionSaveHandler(ScriptRunnerContext ctx, String name, boolean replace, boolean savePwd, ExistingConnections existingConnections, ConnectorType connectorType, Refresher refresher) {
        this.ctx = ctx;
        this.name = name;
        this.replace = replace;
        this.savePwd = savePwd;
        this.connectorType = connectorType;
        this.existingConnections = existingConnections;
        this.refresher = refresher;
    }

    private DatabaseProvider createConnectionDefinition(PropertyValues props) {
        DatabaseProvider definition = null;
        DatabaseProviderFactory factory = DatabaseProviderFactory.getDefinitionFactory(this.ctx, this.connectorType);
        if (factory != null) {
            definition = factory.createDatabaseProvider(this.name, this.savePwd, props);
        }
        return definition;
    }

    @Override
    public void validateProperties(PropertyValues props, Map<ConnectionProperty, String> connectionProperties) {
        Collection<String> existingNames;
        this.refresher.refresh();
        if (!DatabaseProviderFactory.hasFactory(this.connectorType)) {
            connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_UNSUPPORTED_TYPE", this.connectorType.getName()));
            return;
        }
        if (!ConnectionManagementUtil.instance().validateConnectionName((CharSequence)this.name)) {
            connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_INVALID_NAME", this.name));
        }
        if (!this.replace && (existingNames = this.existingConnections.existingConnections()).contains(this.name)) {
            connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_EXISTING_CONNECTION", this.name));
        }
    }

    @Override
    public void saveConnectionDetails(PropertyValues props, Connection conn) {
        DatabaseProvider definition = this.createConnectionDefinition(props);
        if (definition == null) {
            this.ctx.writeln(ConnectionStoreResources.getString("ERROR_SAVING_CONNECTION"));
            return;
        }
        CommandContext cmdCtx = CommandContext.of(this.ctx, SharedConnectionSaveHandler.class);
        DatabaseProviderImporter importer = DatabaseProviderImporter.createImporter(cmdCtx);
        ImportedConnectionResult importResult = importer.importConnection(definition, this.name);
        if (importResult.getResult() == ImportedConnectionResult.ResultState.SUCCESS) {
            this.refresher.refresh();
            ConnectionDetailDisplay.instance().displayConnectionDetails(cmdCtx, definition.getName());
        } else {
            cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("ERROR_SAVING_CONNECTION"));
            cmdCtx.getMessageLogger().logUserMessage(importResult.getResultMessage());
        }
    }

    public static interface ExistingConnections {
        public Collection<String> existingConnections();
    }

    public static interface Refresher {
        public void refresh();
    }
}

