/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.save;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class ConnectConverterFactory
implements ConnectionsConverterFactory {
    static final String CONNECT_TYPE = "Internal.connect";

    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && CONNECT_TYPE.equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return new ConnectSaveConverter(provider, logging);
    }

    private static class ConnectSaveConverter
    extends BaseOracleConverter {
        private ConnectSaveConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
        }

        @Override
        protected String processConnectionSpec() {
            this.addDBToolsProperty("type", "ORACLE_DATABASE");
            String spec = this.definition.getProperty("customUrl");
            if (spec != null) {
                this.addDBToolsProperty("connectionString", spec);
            }
            return spec;
        }
    }
}

