/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class BequeathConverterFactory
implements ConnectionsConverterFactory {
    static final String BEQUEATH_CONNECT_STRING = "(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=beq)))";

    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "BEQUEATH".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return new BequeathConverter(provider, logging);
    }

    private static class BequeathConverter
    extends BaseOracleConverter {
        BequeathConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
        }

        @Override
        protected String processConnectionSpec() {
            this.addDBToolsProperty("type", "ORACLE_DATABASE");
            String spec = BequeathConverterFactory.BEQUEATH_CONNECT_STRING;
            this.addDBToolsProperty("connectionString", spec);
            return spec;
        }
    }
}

